/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.extractors;

import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.TestBean;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.mvel.extractors.BaseClassFieldExtractorsTest;
import org.junit.Before;
import org.junit.Test;

public class IntClassFieldExtractorTest
extends BaseClassFieldExtractorsTest {
    private static final int VALUE = 4;
    InternalReadAccessor reader;
    TestBean bean = new TestBean();

    @Before
    public void setUp() throws Exception {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        this.reader = store.getReader(TestBean.class, "intAttr");
    }

    @Override
    @Test
    public void testGetBooleanValue() {
        try {
            this.reader.getBooleanValue(null, (Object)this.bean);
            Assertions.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testGetByteValue() {
        Assertions.assertThat((byte)this.reader.getByteValue(null, (Object)this.bean)).isEqualTo((byte)4);
    }

    @Override
    @Test
    public void testGetCharValue() {
        try {
            this.reader.getCharValue(null, (Object)this.bean);
            Assertions.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testGetDoubleValue() {
        Assertions.assertThat((double)this.reader.getDoubleValue(null, (Object)this.bean)).isCloseTo(4.0, Assertions.within((Double)0.01));
    }

    @Override
    @Test
    public void testGetFloatValue() {
        Assertions.assertThat((float)this.reader.getFloatValue(null, (Object)this.bean)).isCloseTo(4.0f, Assertions.within((Float)Float.valueOf(0.01f)));
    }

    @Override
    @Test
    public void testGetIntValue() {
        Assertions.assertThat((int)this.reader.getIntValue(null, (Object)this.bean)).isEqualTo(4);
    }

    @Override
    @Test
    public void testGetLongValue() {
        Assertions.assertThat((long)this.reader.getLongValue(null, (Object)this.bean)).isEqualTo(4L);
    }

    @Override
    @Test
    public void testGetShortValue() {
        Assertions.assertThat((short)this.reader.getShortValue(null, (Object)this.bean)).isEqualTo((short)4);
    }

    @Override
    @Test
    public void testGetValue() {
        Assertions.assertThat((int)((Number)this.reader.getValue(null, (Object)this.bean)).intValue()).isEqualTo(4);
    }

    @Override
    @Test
    public void testIsNullValue() {
        Assertions.assertThat((boolean)this.reader.isNullValue(null, (Object)this.bean)).isFalse();
    }
}

