/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.mvel.compiler.Triangle;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class EnumTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EnumTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testEnums() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Enums.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(4)).isTrue();
        Assertions.assertThat((boolean)list.contains(5.976E24)).isTrue();
        Assertions.assertThat((boolean)list.contains("Mercury")).isTrue();
        ksession.dispose();
    }

    @Test
    public void testEnumsWithCompositeBuildingProcess() throws Exception {
        String drl = "package org.test; declare enum DaysOfWeek     SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY;\nend\ndeclare Test   field: DaysOfWeek end";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.test; declare enum DaysOfWeek     SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY;\nend\ndeclare Test   field: DaysOfWeek end"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testQueryEnum() {
        String str = "package org.kie.test;\n\ndeclare enum Ennumm\n  ONE, TWO;\nend\n\ndeclare Bean\n  fld : Ennumm\nend\n\nquery seeWhat( Ennumm $e, Bean $b )\n  $b := Bean( $e == Ennumm.ONE )\nend\n\nrule rool\nwhen\nthen\n  insert( new Bean( Ennumm.ONE ) );\nend\n\n\nrule rool2\nwhen\n  seeWhat( $ex, $bx ; )\nthen\n  System.out.println( $bx );\nend";
        String str2 = "package org.drools.mvel.compiler.test2; \ndeclare Naeb \n   fld : String \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.kie.test;\n\ndeclare enum Ennumm\n  ONE, TWO;\nend\n\ndeclare Bean\n  fld : Ennumm\nend\n\nquery seeWhat( Ennumm $e, Bean $b )\n  $b := Bean( $e == Ennumm.ONE )\nend\n\nrule rool\nwhen\nthen\n  insert( new Bean( Ennumm.ONE ) );\nend\n\n\nrule rool2\nwhen\n  seeWhat( $ex, $bx ; )\nthen\n  System.out.println( $bx );\nend"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder);
        Collection kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler.test2; \ndeclare Naeb \n   fld : String \nend \n"}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testInnerEnum() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools.mvel.compiler\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Triangle( type == Triangle.Type.UNCLASSIFIED )\n");
        rule.append("then\n");
        rule.append("end\n");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule.toString()});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Triangle());
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        ksession.dispose();
    }
}

