/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.core.ClockType;
import org.drools.core.impl.InternalKieContainer;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.io.Resource;
import org.kie.api.management.GenericKieSessionMonitoringMXBean;
import org.kie.api.management.KieContainerMonitorMXBean;
import org.kie.api.management.KieSessionMonitoringMXBean;
import org.kie.api.management.StatelessKieSessionMonitoringMXBean;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class MBeansMonitoringTest {
    public static final Logger LOG = LoggerFactory.getLogger(MBeansMonitoringTest.class);
    public static final String KSESSION1 = "KSession1";
    public static final String KBASE1 = "KBase1";
    private static final String KBASE2 = "KBase2";
    private static final String KSESSION2 = "KSession2";
    private String mbeansprop;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MBeansMonitoringTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Before
    public void setUp() throws Exception {
        ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
        ((KieServicesImpl)KieServices.Factory.get()).nullAllContainerIds();
        this.mbeansprop = System.getProperty("kie.mbeans");
        System.setProperty("kie.mbeans", "enabled");
    }

    @After
    public void tearDown() throws Exception {
        ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
        ((KieServicesImpl)KieServices.Factory.get()).nullAllContainerIds();
        if (this.mbeansprop != null) {
            System.setProperty("kie.mbeans", this.mbeansprop);
        } else {
            System.setProperty("kie.mbeans", MBeansOption.DISABLED.toString());
        }
    }

    @Test
    public void testKieClasspathMBeans() throws Exception {
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        KieServices ks = KieServices.Factory.get();
        KieContainer kc = ks.getKieClasspathContainer("myID");
        KieContainerMonitorMXBean c1Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID"), KieContainerMonitorMXBean.class);
        KieBase kb = kc.getKieBase("org.kie.monitoring.kbase1");
        KieSession statefulKieSession = kc.newKieSession("org.kie.monitoring.kbase1.ksession1");
        StatelessKieSession statelessKieSession = kc.newStatelessKieSession("org.kie.monitoring.kbase1.ksession2");
        KieSessionMonitoringMXBean statefulKieSessionMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), KieSessionMonitoringMXBean.class);
        StatelessKieSessionMonitoringMXBean statelessKieSessionMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), StatelessKieSessionMonitoringMXBean.class);
        Assertions.assertThat((String)c1Monitor.getContainerId()).isEqualTo("myID");
        Assertions.assertThat((boolean)c1Monitor.getConfiguredReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID)).isTrue();
        Assertions.assertThat((boolean)c1Monitor.getResolvedReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID)).isTrue();
        Assertions.assertThat((String)statefulKieSessionMonitor.getKieSessionName()).isEqualTo("org.kie.monitoring.kbase1.ksession1");
        Assertions.assertThat((String)statefulKieSessionMonitor.getKieBaseId()).isEqualTo("org.kie.monitoring.kbase1");
        Assertions.assertThat((String)statelessKieSessionMonitor.getKieSessionName()).isEqualTo("org.kie.monitoring.kbase1.ksession1");
        Assertions.assertThat((String)statelessKieSessionMonitor.getKieBaseId()).isEqualTo("org.kie.monitoring.kbase1");
        KieContainer kc2 = ks.newKieClasspathContainer("myID2");
        KieContainerMonitorMXBean c2Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID2"), KieContainerMonitorMXBean.class);
        KieBase kb2 = kc2.getKieBase("org.kie.monitoring.kbase1");
        KieSession statefulKieSession2 = kc2.newKieSession("org.kie.monitoring.kbase1.ksession1");
        StatelessKieSession statelessKieSession2 = kc2.newStatelessKieSession("org.kie.monitoring.kbase1.ksession2");
        KieSessionMonitoringMXBean statefulKieSessionMonitor2 = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID2", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), KieSessionMonitoringMXBean.class);
        StatelessKieSessionMonitoringMXBean statelessKieSessionMonitor2 = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID2", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), StatelessKieSessionMonitoringMXBean.class);
        Assertions.assertThat((String)c2Monitor.getContainerId()).isEqualTo("myID2");
        Assertions.assertThat((boolean)c2Monitor.getConfiguredReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID)).isTrue();
        Assertions.assertThat((boolean)c2Monitor.getResolvedReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID)).isTrue();
        Assertions.assertThat((String)statefulKieSessionMonitor2.getKieSessionName()).isEqualTo("org.kie.monitoring.kbase1.ksession1");
        Assertions.assertThat((String)statefulKieSessionMonitor2.getKieBaseId()).isEqualTo("org.kie.monitoring.kbase1");
        Assertions.assertThat((String)statelessKieSessionMonitor2.getKieSessionName()).isEqualTo("org.kie.monitoring.kbase1.ksession1");
        Assertions.assertThat((String)statelessKieSessionMonitor2.getKieBaseId()).isEqualTo("org.kie.monitoring.kbase1");
        kc.dispose();
        kc2.dispose();
    }

    @Test
    public void testEventOffset() throws Exception {
        String drl = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\ndeclare StockTick\n    @role(event)\n    @expires(10s)\nend\nrule X\nwhen\n    StockTick()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(KBASE1).setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel(KSESSION1).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        ReleaseId releaseId1 = ks.newReleaseId("org.kie.test", "mbeans", "1.0.0");
        Resource drlResource1 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource1.setSourcePath("src/main/resources/rule1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)kproj, (Resource[])new Resource[]{drlResource1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kiebase = kc.getKieBase(KBASE1);
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        ObjectName kbOn = DroolsManagementAgent.createObjectNameFor((InternalKnowledgeBase)((InternalKnowledgeBase)kiebase));
        mbserver.invoke(kbOn, "startInternalMBeans", new Object[0], new String[0]);
        Object expOffset = mbserver.getAttribute(new ObjectName(kbOn + ",group=EntryPoints,EntryPoint=DEFAULT,ObjectType=org.drools.mvel.compiler.StockTick"), "ExpirationOffset");
        Assertions.assertThat((long)((Number)expOffset).longValue()).isEqualTo(10001L);
        kc.dispose();
    }

    @Test
    public void testContainerMBeans() throws Exception {
        String drl = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\ndeclare StockTick\n    @role(event)\n    @expires(10s)\nend\nrule X\nwhen\n    StockTick()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(KBASE1).setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksessionModel1 = kieBaseModel1.newKieSessionModel(KSESSION1).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        ReleaseId releaseId1 = ks.newReleaseId("org.kie.test", "mbeans", "1.0.0");
        Resource drlResource1 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource1.setSourcePath("src/main/resources/rule1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)kproj, (Resource[])new Resource[]{drlResource1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kiebase = kc.getKieBase(KBASE1);
        kc.newKieSession(KSESSION1);
        kiebase.newKieSession();
        String kc1ID = ((InternalKieContainer)kc).getContainerId();
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        LOG.debug("{}", mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(kc1ID) + ",*"), null));
        ReleaseId verRelease = ks.newReleaseId("org.kie.test", "mbeans", "RELEASE");
        KieContainer kc2 = ks.newKieContainer("Matteo", verRelease);
        kc2.newKieSession(KSESSION1);
        KieContainerMonitorMXBean c1Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)kc1ID), KieContainerMonitorMXBean.class);
        Assertions.assertThat((String)c1Monitor.getConfiguredReleaseIdStr()).isEqualTo(releaseId1.toExternalForm());
        Assertions.assertThat((String)c1Monitor.getResolvedReleaseIdStr()).isEqualTo(releaseId1.toExternalForm());
        Assertions.assertThat((boolean)c1Monitor.getConfiguredReleaseId().sameGAVof(releaseId1)).isTrue();
        Assertions.assertThat((boolean)c1Monitor.getResolvedReleaseId().sameGAVof(releaseId1)).isTrue();
        Assertions.assertThat((String)c1Monitor.getConfiguredReleaseId().getVersion()).isEqualTo(releaseId1.getVersion());
        Assertions.assertThat((String)c1Monitor.getResolvedReleaseId().getVersion()).isEqualTo(releaseId1.getVersion());
        KieContainerMonitorMXBean c2Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"Matteo"), KieContainerMonitorMXBean.class);
        Assertions.assertThat((String)c2Monitor.getConfiguredReleaseIdStr()).isEqualTo(verRelease.toExternalForm());
        Assertions.assertThat((String)c2Monitor.getResolvedReleaseIdStr()).isEqualTo(releaseId1.toExternalForm());
        Assertions.assertThat((boolean)c2Monitor.getConfiguredReleaseId().sameGAVof(verRelease)).isTrue();
        Assertions.assertThat((boolean)c2Monitor.getResolvedReleaseId().sameGAVof(releaseId1)).isTrue();
        Assertions.assertThat((String)c2Monitor.getConfiguredReleaseId().getVersion()).isEqualTo(verRelease.getVersion());
        Assertions.assertThat((String)c2Monitor.getResolvedReleaseId().getVersion()).isEqualTo(releaseId1.getVersion());
        Assertions.assertThat((int)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(kc1ID) + ",*"), null).size()).isEqualTo(3);
        kc.dispose();
        Assertions.assertThat((int)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(kc1ID) + ",*"), null).size()).isEqualTo(0);
        Assertions.assertThat((int)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote("Matteo") + ",*"), null).size()).isEqualTo(3);
        kc.dispose();
        kc2.dispose();
    }

    @Test
    public void testAggregatedAndDispose() throws Exception {
        String drl = "package org.drools.mvel.integrationtests\nrule ND\nwhen\n    String() \n    not ( Double() ) \nthen\n    // do nothing. \nend\nrule ND2\nsalience 1\nwhen\n    $s : String() \n    not ( Double() ) \nthen\n    try { Thread.sleep(10); } catch (Exception e) { }\n    insert( new Double(0) );\n    retract( $s );\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(KBASE1).setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksessionModel1 = kieBaseModel1.newKieSessionModel(KSESSION1).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBaseModel kieBaseModel2 = kproj.newKieBaseModel(KBASE2).setDefault(false);
        KieSessionModel ksessionModel2 = kieBaseModel2.newKieSessionModel(KSESSION2).setDefault(true).setType(KieSessionModel.KieSessionType.STATELESS);
        ReleaseId releaseId1 = ks.newReleaseId("org.kie.test", "mbeans", "1.0.0");
        Resource drlResource1 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource1.setSourcePath("src/main/resources/rule1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)kproj, (Resource[])new Resource[]{drlResource1});
        String containerId = "myContainerId";
        KieContainer kc = ks.newKieContainer(containerId, releaseId1);
        KieBase kiebase = kc.getKieBase(KBASE1);
        KieSessionConfiguration sessionConf = ks.newKieSessionConfiguration();
        sessionConf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieSession ksession = kc.newKieSession(KSESSION1, sessionConf);
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        KieSessionMonitoringMXBean aggrMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)containerId, (String)KBASE1, (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)KSESSION1), KieSessionMonitoringMXBean.class);
        long tft = 0L;
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 0L, 0L, 0L);
        this.checkTotalFactCount(aggrMonitor, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        Assertions.assertThat((Object)aggrMonitor.getStatsForRule("ND")).isNull();
        Assertions.assertThat((Object)aggrMonitor.getStatsForRule("ND2")).isNull();
        Assertions.assertThat((boolean)aggrMonitor.getStatsByRule().containsKey("ND")).isFalse();
        Assertions.assertThat((boolean)aggrMonitor.getStatsByRule().containsKey("ND2")).isFalse();
        ksession.insert((Object)"Ciao");
        ksession.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 2L, 1L, 1L);
        this.checkTotalFactCount(aggrMonitor, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        ksession.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 2L, 1L, 1L);
        this.checkTotalFactCount(aggrMonitor, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        LOG.debug("---");
        KieSession ksession2 = kc.newKieSession(KSESSION1, sessionConf);
        ksession2.insert((Object)"Ciao");
        ksession2.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 4L, 2L, 2L);
        this.checkTotalFactCount(aggrMonitor, 2);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 2);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 2L, 2L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 2L, 0L, 2L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 2L, 2L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 2L, 0L, 2L);
        ksession.dispose();
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkTotalFactCount(aggrMonitor, 1);
        ksession2.dispose();
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 0);
        this.checkTotalFactCount(aggrMonitor, 0);
        LOG.debug("--- NOW for the STATELESS ---");
        tft = 0L;
        StatelessKieSession stateless = kc.newStatelessKieSession(KSESSION2, sessionConf);
        StatelessKieSessionMonitoringMXBean aggrMonitor2 = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)containerId, (String)KBASE2, (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATELESS, (String)KSESSION2), StatelessKieSessionMonitoringMXBean.class);
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 0L, 0L, 0L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 0, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 0);
        Assertions.assertThat((Object)aggrMonitor2.getStatsForRule("ND")).isNull();
        Assertions.assertThat((Object)aggrMonitor2.getStatsForRule("ND2")).isNull();
        Assertions.assertThat((boolean)aggrMonitor2.getStatsByRule().containsKey("ND")).isFalse();
        Assertions.assertThat((boolean)aggrMonitor2.getStatsByRule().containsKey("ND2")).isFalse();
        stateless.execute((Object)"Ciao");
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2L, 1L, 1L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 2, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 1);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 1L, 1L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 1L, 0L, 1L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 1L, 1L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 1L, 0L, 1L);
        stateless.execute((Object)"Ciao");
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 4L, 2L, 2L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 4, 2);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 2L, 2L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 2L, 0L, 2L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 2L, 2L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 2L, 0L, 2L);
        StatelessKieSession stateless2 = kc.newStatelessKieSession(KSESSION2, sessionConf);
        LOG.debug(stateless + " " + stateless2);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2);
        stateless2.execute((Object)"Ciao");
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 6L, 3L, 3L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 6, 3);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 3);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 3L, 3L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 3L, 0L, 3L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 3L, 3L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 3L, 0L, 3L);
        KieContainer kc2 = ks.newKieContainer("kc2", releaseId1);
        Assertions.assertThat((int)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId) + ",*"), null).size()).isEqualTo(5);
        kc.dispose();
        Assertions.assertThat((int)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId) + ",*"), null).size()).isEqualTo(0);
        Assertions.assertThat((int)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote("kc2") + ",*"), null).size()).isEqualTo(1);
        kc2.dispose();
    }

    private void checkStatsByRule(GenericKieSessionMonitoringMXBean mb, String ruleName, long mCreated, long mCancelled, long mFired) {
        Assertions.assertThat((long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesCreated()).isEqualTo(mCreated);
        Assertions.assertThat((long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesCancelled()).isEqualTo(mCancelled);
        Assertions.assertThat((long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesFired()).isEqualTo(mFired);
    }

    private void checkStatsForRule(GenericKieSessionMonitoringMXBean mb, String ruleName, long mCreated, long mCancelled, long mFired) {
        Assertions.assertThat((long)mb.getStatsForRule(ruleName).getMatchesCreated()).isEqualTo(mCreated);
        Assertions.assertThat((long)mb.getStatsForRule(ruleName).getMatchesCancelled()).isEqualTo(mCancelled);
        Assertions.assertThat((long)mb.getStatsForRule(ruleName).getMatchesFired()).isEqualTo(mFired);
    }

    private void print(GenericKieSessionMonitoringMXBean mb) {
        LOG.debug("total match created  : {}", (Object)mb.getTotalMatchesCreated());
        LOG.debug("total match cancelled: {}", (Object)mb.getTotalMatchesCancelled());
        LOG.debug("total match fired    : {}", (Object)mb.getTotalMatchesFired());
        if (mb instanceof StatelessKieSessionMonitoringMXBean) {
            StatelessKieSessionMonitoringMXBean c = (StatelessKieSessionMonitoringMXBean)mb;
            LOG.debug("inserted and deleted : +{} -{}", (Object)c.getTotalObjectsInserted(), (Object)c.getTotalObjectsDeleted());
        } else if (mb instanceof KieSessionMonitoringMXBean) {
            KieSessionMonitoringMXBean c = (KieSessionMonitoringMXBean)mb;
            LOG.debug("total tact count     : {}", (Object)c.getTotalFactCount());
        }
        LOG.debug("{} ms .", (Object)mb.getTotalFiringTime());
    }

    private long checkTotalFiringTimeGEQ(GenericKieSessionMonitoringMXBean mb, long amount) {
        Assertions.assertThat((mb.getTotalFiringTime() >= amount ? 1 : 0) != 0).isTrue();
        return mb.getTotalFiringTime();
    }

    private void checkTotalSessions(GenericKieSessionMonitoringMXBean mb, int totalSessions) {
        Assertions.assertThat((long)mb.getTotalSessions()).isEqualTo((long)totalSessions);
    }

    private void checkTotalFactCount(KieSessionMonitoringMXBean mb, int factCount) {
        Assertions.assertThat((long)mb.getTotalFactCount()).isEqualTo((long)factCount);
    }

    private void checkRuleRuntimeTotals(StatelessKieSessionMonitoringMXBean mb, int inserted, int deleted) {
        Assertions.assertThat((long)mb.getTotalObjectsInserted()).isEqualTo((long)inserted);
        Assertions.assertThat((long)mb.getTotalObjectsDeleted()).isEqualTo((long)deleted);
    }

    private void checkAgendaTotals(GenericKieSessionMonitoringMXBean mb, long mCreated, long mCancelled, long mFired) {
        Assertions.assertThat((long)mb.getTotalMatchesCreated()).isEqualTo(mCreated);
        Assertions.assertThat((long)mb.getTotalMatchesCancelled()).isEqualTo(mCancelled);
        Assertions.assertThat((long)mb.getTotalMatchesFired()).isEqualTo(mFired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadKjarFromClasspath() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.getClass().getResource("/kie-project-simple-1.0.0.jar")});
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        try {
            KieServices ks = KieServices.Factory.get();
            KieRepository kieRepository = ks.getRepository();
            ReleaseId releaseId = ks.newReleaseId("org.test", "kie-project-simple", "1.0.0");
            KieModule kieModule = kieRepository.getKieModule(releaseId);
            Assertions.assertThat((Object)kieModule).isNotNull();
            Assertions.assertThat((Comparable)kieModule.getReleaseId()).isEqualTo((Object)releaseId);
            KieContainer kc = ks.newKieContainer("myID", releaseId);
            KieContainerMonitorMXBean c1Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID"), KieContainerMonitorMXBean.class);
            Assertions.assertThat((boolean)c1Monitor.getConfiguredReleaseId().sameGAVof(releaseId)).isTrue();
            Assertions.assertThat((boolean)c1Monitor.getResolvedReleaseId().sameGAVof(releaseId)).isTrue();
            kc.dispose();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

