/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Bar;
import org.drools.mvel.compiler.Foo;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MatchTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MatchTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testGetObjectsOnePattern() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  Foo(id == \"Lotus Elise\")\nthen\n  list.addAll(kcontext.getMatch().getObjects());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kieCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kieCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains(lotusElise)).isTrue();
        ksession.dispose();
    }

    @Test
    public void testGetObjectsTwoPatterns() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b : Bar(id == \"minivan\")\n  Foo(bar == $b)\nthen\n  list.addAll(kcontext.getMatch().getObjects());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kieCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kieCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(miniVanType)).isTrue();
        Assertions.assertThat((boolean)list.contains(kieCarnival)).isTrue();
        Assertions.assertThat((boolean)list.contains(renaultEspace)).isTrue();
        ksession.dispose();
    }

    @Test
    public void testGetObjectsAccumulateWithNoMatchingFacts() {
        String drl = "global java.util.List list\nrule R when\n  accumulate(\n    Object(false);\n    $total : count()\n  )\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(0L)).isTrue();
        ksession.dispose();
    }

    @Test
    public void testGetObjectsExists() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b : Bar(id == \"roadster\")\n  exists Foo(bar == $b)\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kiaCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kiaCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(roadsterType)).isTrue();
        Assertions.assertThat((boolean)list.contains(bmwZ4)).isTrue();
        Assertions.assertThat((boolean)list.contains(lotusElise)).isTrue();
        Assertions.assertThat((boolean)list.contains(mazdaMx5)).isTrue();
        Assertions.assertThat((boolean)list.contains(miniVanType)).isFalse();
        Assertions.assertThat((boolean)list.contains(kiaCarnival)).isFalse();
        Assertions.assertThat((boolean)list.contains(renaultEspace)).isFalse();
        ksession.dispose();
    }

    @Test
    public void testObjectsDeepOnNestedAccumulate() {
        String drl = "package testpkg;\nglobal java.util.List list;\nrule fairAssignmentCountPerTeam\n    when\n        accumulate(\n            $s : String()\n            and accumulate(\n                Number(this != null);\n                $count : count()\n            );\n            $result : average($count)\n        )\n    then\n        list.addAll( ((org.drools.core.spi.Activation) kcontext.getMatch()).getObjectsDeep() );end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)0.0);
    }

    @Test
    public void testObjectsDeepOnAccumulateWithoutReverse() {
        String rule = "package testpkg;\nimport " + CloudComputer.class.getCanonicalName() + "\n;import " + CloudProcess.class.getCanonicalName() + "\n;global java.util.List list\nrule requiredCpuPowerTotal when\n        $computer : CloudComputer($cpuPower : cpuPower)\n        accumulate(\n            CloudProcess(\n                computer == $computer,\n                $requiredCpuPower : requiredCpuPower);\n            $requiredCpuPowerTotal : max($requiredCpuPower);\n            (Integer) $requiredCpuPowerTotal > $cpuPower\n        )\n    then\n        list.addAll(((org.drools.core.spi.Activation) kcontext.getMatch()).getObjectsDeep());end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        CloudProcess proc = new CloudProcess();
        proc.setRequiredCpuPower(5);
        CloudComputer comp = new CloudComputer();
        proc.setComputer(comp);
        kieSession.insert((Object)proc);
        kieSession.insert((Object)comp);
        kieSession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(comp)).isTrue();
        Assertions.assertThat((boolean)list.contains(5)).isTrue();
        kieSession.dispose();
    }

    @Test
    public void testGetObjectsAccumulate() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b : Bar(id == \"roadster\")\n  accumulate(\n    $f : Foo(bar == $b);\n    $t : count($f)\n  )\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kieCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kieCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(roadsterType)).isTrue();
        Assertions.assertThat((boolean)list.contains(bmwZ4)).isTrue();
        Assertions.assertThat((boolean)list.contains(lotusElise)).isTrue();
        Assertions.assertThat((boolean)list.contains(mazdaMx5)).isTrue();
        ksession.dispose();
    }

    @Test
    public void testGetObjectsAccumulateWithNestedExists() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b1 : Bar(id == \"roadster\")\n  accumulate(\n    $b2 : Bar(this != $b1) and exists Foo(bar == $b2);\n    $t : count($b2)\n  )\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kiaCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kiaCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(roadsterType)).isTrue();
        Assertions.assertThat((boolean)list.contains(bmwZ4)).isFalse();
        Assertions.assertThat((boolean)list.contains(lotusElise)).isFalse();
        Assertions.assertThat((boolean)list.contains(mazdaMx5)).isFalse();
        Assertions.assertThat((boolean)list.contains(miniVanType)).isTrue();
        Assertions.assertThat((boolean)list.contains(kiaCarnival)).isTrue();
        Assertions.assertThat((boolean)list.contains(renaultEspace)).isTrue();
        ksession.dispose();
    }

    public static class CloudProcess {
        private int requiredCpuPower;
        private CloudComputer computer;

        public void setRequiredCpuPower(int requiredCpuPower) {
            this.requiredCpuPower = requiredCpuPower;
        }

        public int getRequiredCpuPower() {
            return this.requiredCpuPower;
        }

        public void setComputer(CloudComputer computer) {
            this.computer = computer;
        }

        public CloudComputer getComputer() {
            return this.computer;
        }
    }

    public static class CloudComputer {
        public int getCpuPower() {
            return 0;
        }
    }
}

