/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;

@RunWith(value=Parameterized.class)
public class Query3Test {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieBase knowledgeBase;

    public Query3Test(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void setUp() throws Exception {
        String text = "";
        text = text + "package org.drools.integrationtests\n";
        text = text + "import " + Bar.class.getCanonicalName() + "\n";
        text = text + "import " + Foo.class.getCanonicalName() + "\n";
        text = text + "import " + Foo2.class.getCanonicalName() + "\n";
        text = text + "query \"testDifferent\"\n";
        text = text + "    foo : Foo();\n";
        text = text + "    bar : Bar(id == foo.id)\n";
        text = text + "end\n";
        text = text + "query \"testSame\"\n";
        text = text + "    foo : Foo();\n";
        text = text + "    foo2 : Foo(id == foo.id);\n";
        text = text + "end\n";
        text = text + "query \"testExtends\"\n";
        text = text + "    foo : Foo();\n";
        text = text + "    foo2 : Foo2(id == foo.id);\n";
        text = text + "end\n";
        this.knowledgeBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{text});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIt(Object o1, Object o2, String query, int expected, boolean doUpdate, boolean doRetract) {
        KieSession knowledgeSession = this.knowledgeBase.newKieSession();
        try {
            knowledgeSession.insert(o1);
            FactHandle handle2 = knowledgeSession.insert(o2);
            if (doUpdate) {
                knowledgeSession.update(handle2, o2);
            } else if (doRetract) {
                knowledgeSession.retract(handle2);
                handle2 = knowledgeSession.insert(o2);
            }
            QueryResults queryResults = knowledgeSession.getQueryResults(query, new Object[0]);
            Assertions.assertThat((int)queryResults.size()).isEqualTo(expected);
        }
        finally {
            knowledgeSession.dispose();
        }
    }

    @Test
    public void testDifferent() {
        Foo foo = new Foo();
        foo.setId("x");
        Bar bar = new Bar();
        bar.setId("x");
        this.doIt(foo, bar, "testDifferent", 1, false, false);
    }

    @Test
    public void testDifferentWithUpdate() {
        Foo foo = new Foo();
        foo.setId("x");
        Bar bar = new Bar();
        bar.setId("x");
        this.doIt(foo, bar, "testDifferent", 1, true, false);
    }

    @Test
    public void testSame() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo foo2 = new Foo();
        foo2.setId("x");
        this.doIt(foo, foo2, "testSame", 4, false, false);
    }

    @Test
    public void testSameWithUpdate() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo foo2 = new Foo();
        foo2.setId("x");
        this.doIt(foo, foo2, "testSame", 4, true, false);
    }

    @Test
    public void testExtends() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo2 foo2 = new Foo2();
        foo2.setId("x");
        this.doIt(foo, foo2, "testExtends", 2, false, false);
    }

    @Test
    public void testExtendsWithUpdate() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo2 foo2 = new Foo2();
        foo2.setId("x");
        this.doIt(foo, foo2, "testExtends", 2, true, false);
    }

    @Test
    public void testExtendsWithRetract() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo2 foo2 = new Foo2();
        foo2.setId("x");
        this.doIt(foo, foo2, "testExtends", 2, false, true);
    }

    public static class Foo2
    extends Foo {
    }

    public static class Foo {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Bar {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

