/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.mvel.integrationtests.phreak.A;
import org.drools.mvel.integrationtests.phreak.B;
import org.drools.mvel.integrationtests.phreak.BetaNodeBuilder;
import org.drools.mvel.integrationtests.phreak.Pair;
import org.drools.mvel.integrationtests.phreak.Scenario;
import org.drools.mvel.integrationtests.phreak.StagedBuilder;
import org.junit.Test;

public class ScenarioTest {
    BuildContext buildContext;
    JoinNode joinNode;
    JoinNode sinkNode;
    InternalWorkingMemory wm;
    BetaMemory bm;
    SegmentMemory smem;
    BetaMemory bm0;
    SegmentMemory smem0;
    A a0 = A.a((Integer)0);
    A a1 = A.a((Integer)1);
    A a2 = A.a((Integer)2);
    A a3 = A.a((Integer)3);
    A a4 = A.a((Integer)4);
    B b0 = B.b((Object)0);
    B b1 = B.b((Object)1);
    B b2 = B.b((Object)2);
    B b3 = B.b((Object)3);
    B b4 = B.b((Object)4);

    public void setupJoinNode() {
        this.buildContext = this.createContext();
        this.joinNode = (JoinNode)BetaNodeBuilder.create(181, this.buildContext).setLeftType(A.class).setBinding("object", "$object").setRightType(B.class).setConstraint("object", "!=", "$object").build();
        this.sinkNode = (JoinNode)BetaNodeBuilder.create(181, this.buildContext).build();
        this.joinNode.addTupleSink((LeftTupleSink)this.sinkNode);
        this.wm = (StatefulKnowledgeSessionImpl)this.buildContext.getKnowledgeBase().newKieSession();
        this.bm = (BetaMemory)this.wm.getNodeMemory((MemoryFactory)this.joinNode);
        this.bm0 = (BetaMemory)this.wm.getNodeMemory((MemoryFactory)this.sinkNode);
        this.smem = new SegmentMemory((LeftTupleNode)this.joinNode);
        this.bm.setSegmentMemory(this.smem);
        this.smem0 = new SegmentMemory((LeftTupleNode)this.sinkNode);
        this.bm0.setSegmentMemory(this.smem0);
        this.smem.add(this.smem0);
    }

    @Test
    public void testEmptyResultInsert() {
        this.setupJoinNode();
        try {
            ((StagedBuilder)this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().insert(new Object[0])).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert existed")).isTrue();
        }
    }

    @Test
    public void testMissingResultInsert() {
        this.setupJoinNode();
        try {
            ((StagedBuilder)this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().insert(Pair.t(this.a0, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Insert excpected more")).isTrue();
        }
    }

    @Test
    public void testIncorrectResultInsert() {
        this.setupJoinNode();
        try {
            ((StagedBuilder)this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().insert(Pair.t(this.a0, this.b0))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert 0")).isTrue();
        }
    }

    @Test
    public void testEmptyResultDelete() {
        this.setupJoinNode();
        this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().run();
        ((StagedBuilder)this.test().left().delete(this.a0).result().delete(new Object[0])).run();
    }

    @Test
    public void testMissingResultDelete() {
        this.setupJoinNode();
        this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().run();
        ((StagedBuilder)this.test().left().delete(this.a0, this.a1).result().delete(new Object[0])).run();
    }

    @Test
    public void testIncorrecResultDelete() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().run();
            ((StagedBuilder)this.test().left().delete(this.a0, this.a1).result().delete(Pair.t(this.a0, this.b0))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("delete 0")).isTrue();
        }
    }

    @Test
    public void testEmptyResultUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().run();
            ((StagedBuilder)this.test().left().update(this.a0).result().insert(new Object[0])).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert existed")).isTrue();
        }
    }

    @Test
    public void testMissingResultUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().run();
            ((StagedBuilder)this.test().left().update(this.a0, this.a1).result().insert(Pair.t(this.a0, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Insert excpected more")).isTrue();
        }
    }

    @Test
    public void testIncorrectResultUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).result().run();
            ((StagedBuilder)this.test().left().update(this.a0, this.a1).result().insert(Pair.t(this.a0, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Insert excpected more")).isTrue();
        }
    }

    @Test
    public void testEmptyLeftMemory() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).result().left(new Object[0]).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("LeftTuple memory size did not match")).isTrue();
        }
    }

    @Test
    public void testMissingLeftMemory() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).result().left(this.a1).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("LeftTuple memory size did not match")).isTrue();
        }
    }

    @Test
    public void testIncorrectLeftMemory() {
        this.setupJoinNode();
        try {
            this.wm.insert((Object)this.a2);
            this.test().left().insert(this.a0, this.a1).result().left(this.a1, this.a2).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Could not find LeftTuple")).isTrue();
        }
    }

    @Test
    public void testTooMuchLeftMemory() {
        this.setupJoinNode();
        try {
            this.wm.insert((Object)this.a2);
            this.test().left().insert(this.a0, this.a1).result().left(this.a1, this.a0, this.a2).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Could not find LeftTuple")).isTrue();
        }
    }

    @Test
    public void testEmptyRightMemory() {
        this.setupJoinNode();
        try {
            this.test().right().insert(this.b0, this.b1).result().right(new Object[0]).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("RightTuple memory size did not match")).isTrue();
        }
    }

    @Test
    public void testMissingRightMemory() {
        this.setupJoinNode();
        try {
            this.test().right().insert(this.b0, this.b1).result().right(this.b1).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("RightTuple memory size did not match")).isTrue();
        }
    }

    @Test
    public void testIncorrectRightMemory() {
        this.setupJoinNode();
        try {
            this.wm.insert((Object)this.b2);
            this.test().right().insert(this.b0, this.b1).result().right(this.b1, this.b2).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Could not find RightTuple")).isTrue();
        }
    }

    @Test
    public void testTooMuchRightMemory() {
        this.setupJoinNode();
        try {
            this.wm.insert((Object)this.b2);
            this.test().right().insert(this.b0, this.b1).result().right(this.b1, this.b0, this.b2).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Could not find RightTuple")).isTrue();
        }
    }

    @Test
    public void testEmptyPreStagedInsert() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().insert(this.a3).preStaged(this.smem0).insert(new Object[0])).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert existed")).isTrue();
        }
    }

    @Test
    public void testMissingPreStagedInsert() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().insert(this.a3).preStaged(this.smem0).insert(Pair.t(this.a0, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            System.out.println(((Throwable)((Object)e)).getMessage());
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Insert excpected more")).isTrue();
        }
    }

    @Test
    public void testIncorrectPreStagedInsert() {
        this.setupJoinNode();
        try {
            this.wm.insert((Object)this.b2);
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().insert(this.a3).preStaged(this.smem0).insert(Pair.t(this.a1, this.b2))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert 0")).isTrue();
        }
    }

    @Test
    public void testTooMuchPreStagedInsert() {
        this.setupJoinNode();
        try {
            this.wm.insert((Object)this.b2);
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().insert(this.a3).preStaged(this.smem0).insert(Pair.t(this.a1, this.b2), Pair.t(this.a1, this.b0), Pair.t(this.a0, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            System.out.println(((Throwable)((Object)e)).getMessage());
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert 2")).isTrue();
        }
    }

    @Test
    public void testEmptyPreStagedDelete() {
        this.setupJoinNode();
        this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).run();
        this.test().left().delete(this.a0).run();
        ((StagedBuilder)this.test().left().delete(this.a1).preStaged(this.smem0).delete(new Object[0])).run();
    }

    @Test
    public void testMissingPreStagedDelete() {
        this.setupJoinNode();
        this.test().left().insert(this.a0, this.a1, this.a2, this.a3).right().insert(this.b0, this.b1).run();
        this.test().left().delete(this.a0, this.a1).run();
        ((StagedBuilder)this.test().left().delete(this.a2).preStaged(this.smem0).delete(new Object[0])).run();
    }

    @Test
    public void testIncorrectPreStagedDelete() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1, this.a2, this.a3).right().insert(this.b0, this.b1).run();
            this.test().left().delete(this.a0, this.a1).run();
            ((StagedBuilder)this.test().left().delete(this.a2).preStaged(this.smem0).delete(Pair.t(this.a1, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("delete 0")).isTrue();
        }
    }

    @Test
    public void testEmptyPreStagedUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).run();
            this.test().left().update(this.a0).run();
            ((StagedBuilder)this.test().left().update(this.a1).preStaged(this.smem0).insert(new Object[0])).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert existed")).isTrue();
        }
    }

    @Test
    public void testMissingPreStagedUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1, this.a2).right().insert(this.b0, this.b1).run();
            this.test().left().update(this.a0, this.a1).run();
            ((StagedBuilder)this.test().left().update(this.a2).preStaged(this.smem0).insert(Pair.t(this.a0, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Insert excpected more")).isTrue();
        }
    }

    @Test
    public void testIncorrectPreStagedUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1, this.a2).right().insert(this.b0, this.b1).run();
            this.test().left().update(this.a0, this.a1).run();
            ((StagedBuilder)this.test().left().update(this.a2).preStaged(this.smem0).update(Pair.t(this.a1, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("update 0")).isTrue();
        }
    }

    @Test
    public void testEmptyPostStagedInsert() {
        this.setupJoinNode();
        try {
            ((StagedBuilder)this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).postStaged(this.smem0).insert(new Object[0])).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert existed")).isTrue();
        }
    }

    @Test
    public void testMissingPostStagedDelete() {
        this.setupJoinNode();
        this.test().left().insert(this.a0, this.a1, this.a2).right().insert(this.b0, this.b1).run();
        ((StagedBuilder)this.test().left().delete(this.a0, this.a1).postStaged(this.smem0).delete(new Object[0])).run();
    }

    @Test
    public void testIncorrectPostStagedDelete() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1, this.a2).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().delete(this.a0, this.a1).postStaged(this.smem0).delete(Pair.t(this.a1, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("delete 0")).isTrue();
        }
    }

    @Test
    public void testEmptyPostStagedUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().update(this.a0).postStaged(this.smem0).insert(new Object[0])).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("insert existed")).isTrue();
        }
    }

    @Test
    public void testMissingPostStagedUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1, this.a2).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().update(this.a0, this.a1).postStaged(this.smem0).insert(Pair.t(this.a2, this.b0))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("Insert excpected more")).isTrue();
        }
    }

    @Test
    public void testIncorrectPostStagedUpdate() {
        this.setupJoinNode();
        try {
            this.test().left().insert(this.a0, this.a1, this.a2).right().insert(this.b0, this.b1).run();
            ((StagedBuilder)this.test().left().update(this.a0, this.a1).postStaged(this.smem0).update(Pair.t(this.a1, this.b1))).run();
            Assertions.fail((String)"Should not reach here");
        }
        catch (AssertionError e) {
            Assertions.assertThat((boolean)((Throwable)((Object)e)).getMessage().contains("update 0")).isTrue();
        }
    }

    private Scenario test() {
        return this.test(PhreakJoinNode.class, this.joinNode, (LeftTupleSink)this.sinkNode, this.bm, this.wm);
    }

    private Scenario test(Class phreakNode, JoinNode joinNode, LeftTupleSink sinkNode, BetaMemory bm, InternalWorkingMemory wm) {
        return new Scenario(phreakNode, (BetaNode)joinNode, sinkNode, bm, wm);
    }

    public BuildContext createContext() {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        KnowledgeBaseImpl rbase = new KnowledgeBaseImpl("ID", conf);
        BuildContext buildContext = new BuildContext((InternalKnowledgeBase)rbase);
        RuleImpl rule = new RuleImpl("rule1").setPackage("org.pkg1");
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.pkg1");
        pkg.getDialectRuntimeRegistry().setDialectData("java", (DialectRuntimeData)new JavaDialectRuntimeData());
        pkg.addRule(rule);
        buildContext.setRule(rule);
        return buildContext;
    }
}

