/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class CustomOperatorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CustomOperatorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomOperatorUsingCollections() {
        String drl = "import " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    $alice : Person(name == \"Alice\")\n    $bob : Person(name == \"Bob\", addresses supersetOf $alice.addresses)\nthen\nend\n";
        System.setProperty("drools.evaluator.supersetOf", SupersetOfEvaluatorDefinition.class.getName());
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"custom-operator-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            try {
                Person alice = new Person("Alice", 30);
                alice.addAddress(new Address("Large Street", "BigTown", "12345"));
                Person bob = new Person("Bob", 30);
                bob.addAddress(new Address("Large Street", "BigTown", "12345"));
                bob.addAddress(new Address("Long Street", "SmallTown", "54321"));
                ksession.insert((Object)alice);
                ksession.insert((Object)bob);
                Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            System.clearProperty("drools.evaluator.supersetOf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomOperatorOnKieModule() {
        String drl = "import " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    $alice : Person(name == \"Alice\")\n    $bob : Person(name == \"Bob\", addresses supersetOf $alice.addresses)\nthen\nend\n";
        System.setProperty("drools.evaluator.supersetOf", SupersetOfEvaluatorDefinition.class.getName());
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"custom-operator-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            try {
                Person alice = new Person("Alice", 30);
                alice.addAddress(new Address("Large Street", "BigTown", "12345"));
                Person bob = new Person("Bob", 30);
                bob.addAddress(new Address("Large Street", "BigTown", "12345"));
                bob.addAddress(new Address("Long Street", "SmallTown", "54321"));
                ksession.insert((Object)alice);
                ksession.insert((Object)bob);
                Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            System.clearProperty("drools.evaluator.supersetOf");
        }
    }

    public static class SupersetOfEvaluator
    extends BaseEvaluator {
        public SupersetOfEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? SupersetOfEvaluatorDefinition.NOT_SUPERSET_OF : SupersetOfEvaluatorDefinition.SUPERSET_OF);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle factHandle, FieldValue value) {
            Object objectValue = extractor.getValue(reteEvaluator, (Object)factHandle);
            return this.evaluateAll((Collection)value.getValue(), (Collection)objectValue);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor ira, InternalFactHandle left, InternalReadAccessor ira1, InternalFactHandle right) {
            return this.evaluateAll((Collection)left.getObject(), (Collection)right.getObject());
        }

        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object valRight = context.extractor.getValue(reteEvaluator, right.getObject());
            return this.evaluateAll((Collection)((VariableRestriction.ObjectVariableContextEntry)context).left, (Collection)valRight);
        }

        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object varLeft = context.declaration.getExtractor().getValue(reteEvaluator, (Object)left);
            return this.evaluateAll((Collection)varLeft, (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateAll(Collection leftCollection, Collection rightCollection) {
            return rightCollection.containsAll(leftCollection);
        }
    }

    public static class SupersetOfEvaluatorDefinition
    implements EvaluatorDefinition {
        public static final Operator SUPERSET_OF = Operator.addOperatorToRegistry((String)"supersetOf", (boolean)false);
        public static final Operator NOT_SUPERSET_OF = Operator.addOperatorToRegistry((String)"supersetOf", (boolean)true);
        private static final String[] SUPPORTED_IDS = new String[]{SUPERSET_OF.getOperatorString()};
        private Evaluator[] evaluator;

        public String[] getEvaluatorIds() {
            return SUPPORTED_IDS;
        }

        public boolean isNegatable() {
            return true;
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
            return new SupersetOfEvaluator(type, isNegated);
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
            return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
        }

        public boolean supportsType(ValueType vt) {
            return true;
        }

        public EvaluatorDefinition.Target getTarget() {
            return EvaluatorDefinition.Target.FACT;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.evaluator = (Evaluator[])in.readObject();
        }
    }
}

