/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooFactHandleFactory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.index.AlphaRangeIndex;
import org.drools.mvel.ConstraintTestUtil;
import org.drools.mvel.MockBetaNode;
import org.drools.mvel.model.Cheese;
import org.drools.mvel.model.MockObjectSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompositeObjectSinkAdapterTest {
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private CompositeObjectSinkAdapter ad;
    private InternalReadAccessor extractor;
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private final boolean useLambdaConstraint;

    public CompositeObjectSinkAdapterTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Parameterized.Parameters(name="useLambdaConstraint={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase);
        this.buildContext.setRule(new RuleImpl("test"));
        this.ad = new CompositeObjectSinkAdapter();
    }

    @Test
    public void testAddBeta() {
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.sinksAre(new ObjectSink[]{beta});
        this.otherSinksAre(new ObjectSink[]{beta});
        this.hashableSinksAreEmpty();
        this.hashedFieldIndexesAreEmpty();
        this.hashedSinkMapIsEmpty();
    }

    @Test
    public void testAddBetaRemoveBeta() {
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.ad.removeObjectSink((ObjectSink)beta);
        this.sinksAreEmpty();
        this.otherSinksAreEmpty();
    }

    @Test
    public void testAddOneAlphaNotHashable() {
        AlphaNode al = this.createAlphaNode((AlphaNodeFieldConstraint)new PredicateConstraint(null, null));
        this.ad.addObjectSink((ObjectSink)al);
        this.sinksAre(new ObjectSink[]{al});
        this.otherSinksAre(new ObjectSink[]{al});
    }

    @Test
    public void testAddOneAlphaNotHashableRemoveOneAlpha() {
        AlphaNode al = this.createAlphaNode((AlphaNodeFieldConstraint)new PredicateConstraint(null, null));
        this.ad.addObjectSink((ObjectSink)al);
        this.ad.removeObjectSink((ObjectSink)al);
        this.sinksAreEmpty();
        this.otherSinksAreEmpty();
    }

    @Test
    public void testAddOneAlpha() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        this.sinksAre(new ObjectSink[]{al});
        this.otherSinksAreEmpty();
        this.hashedFieldIndexesAre(this.extractor.getIndex());
        this.hashableSinksAre(new ObjectSink[]{al});
    }

    @Test
    public void testAddOneAlphaRemoveOneAlpha() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        this.ad.removeObjectSink((ObjectSink)al);
        this.otherSinksAreEmpty();
        this.hashableSinksAreEmpty();
    }

    @Test
    public void testAddTwoAlphas() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        this.sinksAre(new ObjectSink[]{al, al2});
        this.otherSinksAreEmpty();
        this.hashableSinksAre(new ObjectSink[]{al, al2});
    }

    @Test
    public void testAddTwoAlphasAddOneBeta() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.otherSinksAre(new ObjectSink[]{beta});
        this.hashableSinksAre(new ObjectSink[]{al, al2});
    }

    @Test
    public void testAddTwoAlphasAddOneBetaRemoveOneBeta() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.ad.removeObjectSink((ObjectSink)beta);
        this.otherSinksAreEmpty();
        this.hashableSinksAre(new ObjectSink[]{al, al2});
    }

    @Test
    public void testAddThreeAlphas() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseTypeEqualsTo("stinky"));
        this.ad.addObjectSink((ObjectSink)al3);
        this.hashableSinksAreEmpty();
        this.hashedSinkMapIs(al, al2, al3);
    }

    @Test
    public void testAddThreeAlphasRemoveOneAlpha() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseTypeEqualsTo("stinky"));
        this.ad.addObjectSink((ObjectSink)al3);
        this.ad.removeObjectSink((ObjectSink)al2);
        this.hashableSinksAre(new ObjectSink[]{al, al3});
        this.hashedSinkMapIsEmpty();
    }

    @Test
    public void testTripleAlphaCharacterConstraint() {
        this.extractor = this.store.getReader(Cheese.class, "charType");
        AlphaNode al = this.createAlphaNode(this.cheeseCharTypeEqualsTo(65));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseCharTypeEqualsTo(66));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseCharTypeEqualsTo(67));
        this.ad.addObjectSink((ObjectSink)al3);
        Assert.assertSame((Object)al2, this.ad.getHashedSinkMap().get(this.keyForCheeseCharType('B')));
        Assert.assertNull(this.ad.getHashedSinkMap().get(this.keyForCheeseCharType('X')));
    }

    @Test
    public void testTripleAlphaObjectCharacterConstraint() {
        this.extractor = this.store.getReader(Cheese.class, "charObjectType");
        AlphaNode al = this.createAlphaNode(this.cheeseCharObjectTypeEqualsTo(65));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseCharObjectTypeEqualsTo(66));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseCharObjectTypeEqualsTo(67));
        this.ad.addObjectSink((ObjectSink)al3);
        Assert.assertSame((Object)al2, this.ad.getHashedSinkMap().get(this.keyForCheeseCharObjectType('B')));
        Assert.assertNull(this.ad.getHashedSinkMap().get(this.keyForCheeseCharObjectType('X')));
    }

    @Test
    public void testAddOneAlphaForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        this.sinksAre(new ObjectSink[]{al1});
        this.otherSinksAreEmpty();
        Assert.assertNotNull((Object)this.ad.getRangeIndexedFieldIndexes());
        this.rangeIndexableSinksAre(new ObjectSink[]{al1});
    }

    @Test
    public void testTwoAlphasForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)this.ad.getRangeIndexMap());
        this.rangeIndexableSinksAre(new ObjectSink[]{al1, al2});
    }

    @Test
    public void testThreeAlphasForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)this.ad.getRangeIndexMap());
        this.rangeIndexableSinksIsEmpty(new ObjectSink[0]);
    }

    @Test
    public void testAddThreeAlphasRemoveOneAlphaForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        this.ad.removeObjectSink((ObjectSink)al2);
        this.rangeIndexableSinksAre(new ObjectSink[]{al1, al3});
        Assert.assertNull((Object)this.ad.getRangeIndexMap());
    }

    @Test
    public void testAddThreeAlphasVerifyRangeQuery() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        CompositeObjectSinkAdapter.FieldIndex fieldIndex = (CompositeObjectSinkAdapter.FieldIndex)this.ad.getRangeIndexedFieldIndexes().get(0);
        Cheese cheese = new Cheese();
        cheese.setPrice(25);
        Collection matchingAlphaNodes = ((AlphaRangeIndex)this.ad.getRangeIndexMap().get(fieldIndex)).getMatchingAlphaNodes((Object)cheese);
        Assert.assertEquals((long)2L, (long)matchingAlphaNodes.size());
        Assert.assertTrue((boolean)matchingAlphaNodes.contains(al1));
        Assert.assertTrue((boolean)matchingAlphaNodes.contains(al2));
        cheese.setPrice(5);
        matchingAlphaNodes = ((AlphaRangeIndex)this.ad.getRangeIndexMap().get(fieldIndex)).getMatchingAlphaNodes((Object)cheese);
        Assert.assertTrue((boolean)matchingAlphaNodes.isEmpty());
    }

    @Test(expected=IllegalStateException.class)
    public void testRangeIndexConflictKey() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        AlphaNode al4 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al4);
    }

    @Test
    public void testPropagationWithNullValue() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al1 = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("brie"));
        AlphaNode al3 = this.createAlphaNode(this.cheeseTypeEqualsTo("muzzarela"));
        this.ad.addObjectSink((ObjectSink)al1);
        this.ad.addObjectSink((ObjectSink)al2);
        this.ad.addObjectSink((ObjectSink)al3);
        InternalFactHandle handle = new ReteooFactHandleFactory().newFactHandle((Object)new Cheese(), null, null, (WorkingMemoryEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        try {
            this.ad.propagateAssertObject(handle, null, null);
        }
        catch (RuntimeException e) {
            Assert.fail((String)("Not supposed to throw any exception: " + e.getMessage()));
        }
    }

    private AlphaNodeFieldConstraint cheeseTypeEqualsTo(String value) {
        return ConstraintTestUtil.createCheeseTypeEqualsConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNodeFieldConstraint cheeseCharTypeEqualsTo(int value) {
        return ConstraintTestUtil.createCheeseCharTypeEqualsConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNodeFieldConstraint cheeseCharObjectTypeEqualsTo(int value) {
        return ConstraintTestUtil.createCheeseCharObjectTypeEqualsConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNodeFieldConstraint cheesePriceGreaterThan(int value) {
        return ConstraintTestUtil.createCheesePriceGreaterConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNode createAlphaNode(AlphaNodeFieldConstraint lit) {
        return new AlphaNode(this.buildContext.getNextNodeId(), lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextNodeId()), this.buildContext);
    }

    private MockBetaNode createBetaNode() {
        return new MockBetaNode(this.buildContext.getNextNodeId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
    }

    private CompositeObjectSinkAdapter.HashKey keyForCheeseCharType(char c) {
        Cheese cheese = new Cheese();
        cheese.setCharType(c);
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(this.extractor.getIndex(), (Object)cheese, this.extractor);
        return hashKey;
    }

    private CompositeObjectSinkAdapter.HashKey keyForCheeseCharObjectType(char c) {
        Cheese cheese = new Cheese();
        cheese.setCharObjectType(Character.valueOf(c));
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(this.extractor.getIndex(), (Object)cheese, this.extractor);
        return hashKey;
    }

    private void sinksAre(ObjectSink ... objectSinks) {
        Assert.assertEquals((long)objectSinks.length, (long)this.ad.getSinks().length);
        for (int i = 0; i < objectSinks.length; ++i) {
            Assert.assertEquals((Object)objectSinks[i], (Object)this.ad.getSinks()[i]);
        }
    }

    private void sinksAreEmpty() {
        Assert.assertEquals((long)0L, (long)this.ad.getSinks().length);
    }

    private void otherSinksAre(ObjectSink ... objectSinks) {
        Assert.assertEquals((long)objectSinks.length, (long)this.ad.getOtherSinks().size());
        for (int i = 0; i < objectSinks.length; ++i) {
            Assert.assertEquals((Object)objectSinks[i], this.ad.getOtherSinks().get(i));
        }
    }

    private void otherSinksAreEmpty() {
        Assert.assertNull((Object)this.ad.getOtherSinks());
    }

    private void hashableSinksAre(ObjectSink ... objectSinks) {
        Assert.assertEquals((long)objectSinks.length, (long)this.ad.getHashableSinks().size());
        for (int i = 0; i < objectSinks.length; ++i) {
            Assert.assertTrue((boolean)this.ad.getHashableSinks().contains(objectSinks[i]));
        }
    }

    private void rangeIndexableSinksAre(ObjectSink ... rangeIndexableSinks) {
        Assert.assertEquals((long)rangeIndexableSinks.length, (long)this.ad.getRangeIndexableSinks().size());
        for (int i = 0; i < rangeIndexableSinks.length; ++i) {
            Assert.assertTrue((boolean)this.ad.getRangeIndexableSinks().contains(rangeIndexableSinks[i]));
        }
    }

    private void rangeIndexableSinksIsEmpty(ObjectSink ... rangeIndexableSinks) {
        Assert.assertNull((Object)this.ad.getRangeIndexableSinks());
    }

    private void hashedFieldIndexesAre(Integer ... fieldIndexes) {
        Assert.assertEquals((long)fieldIndexes.length, (long)this.ad.getHashedFieldIndexes().size());
        List<Integer> hashedFieldIndexes = Arrays.asList(fieldIndexes);
        for (int i = 0; i < fieldIndexes.length; ++i) {
            Assert.assertTrue((boolean)hashedFieldIndexes.contains(((CompositeObjectSinkAdapter.FieldIndex)this.ad.getHashedFieldIndexes().get(i)).getIndex()));
        }
    }

    private void hashedFieldIndexesAreEmpty() {
        Assert.assertNull((Object)this.ad.getHashedFieldIndexes());
    }

    private void hashableSinksAreEmpty() {
        Assert.assertNull((Object)this.ad.getHashableSinks());
    }

    private void hashedSinkMapIs(AlphaNode ... nodes) {
        Assert.assertEquals((long)nodes.length, (long)this.ad.getHashedSinkMap().size());
        for (int i = 0; i < nodes.length; ++i) {
            Assert.assertTrue((boolean)this.ad.getHashedSinkMap().containsValue(nodes[i]));
        }
    }

    private void hashedSinkMapIsEmpty() {
        Assert.assertNull((Object)this.ad.getHashedSinkMap());
    }
}

