/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class SimpleBatchExecutionTest {
    private KieSession ksession;
    protected static final String ruleString = "package org.kie.api.persistence \nglobal String globalCheeseCountry\n\nrule 'EmptyRule' \n    when\n    then\nend\n";
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SimpleBatchExecutionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void createKSession() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{ruleString});
        this.ksession = kbase.newKieSession();
    }

    @After
    public void disposeKSession() throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testInsertObjectCommand() throws Exception {
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)expected_1, (String)"out_1"));
        commands.add(CommandFactory.newInsert((Object)expected_2, (String)"out_2"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Object fact_1 = result.getValue("out_1");
        Assert.assertNotNull((Object)fact_1);
        Object fact_2 = result.getValue("out_2");
        Assert.assertNotNull((Object)fact_2);
        this.ksession.fireAllRules();
        Object[] expectedArr = new Object[]{expected_1, expected_2};
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expectedArr));
        Collection factList = this.ksession.getObjects();
        Assert.assertTrue((String)("Expected " + expectedList.size() + " objects but retrieved " + factList.size()), (factList.size() == expectedList.size() ? 1 : 0) != 0);
        for (Object fact : factList) {
            if (!expectedList.contains(fact)) continue;
            expectedList.remove(fact);
        }
        Assert.assertTrue((String)"Retrieved object list did not contain expected objects.", (boolean)expectedList.isEmpty());
    }

    @Test
    public void testInsertElementsCommand() throws Exception {
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        Object[] expectedArr = new Object[]{expected_1, expected_2};
        List<Object> factCollection = Arrays.asList(expectedArr);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsertElements(factCollection, (String)"out_list", (boolean)true, null));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Collection outList = (Collection)result.getValue("out_list");
        Assert.assertNotNull((Object)outList);
        this.ksession.fireAllRules();
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expectedArr));
        Collection factList = this.ksession.getObjects();
        Assert.assertTrue((String)("Expected " + expectedList.size() + " objects but retrieved " + factList.size()), (factList.size() == expectedList.size() ? 1 : 0) != 0);
        for (Object fact : factList) {
            if (!expectedList.contains(fact)) continue;
            expectedList.remove(fact);
        }
        Assert.assertTrue((String)"Retrieved object list did not contain expected objects.", (boolean)expectedList.isEmpty());
    }

    @Test
    public void testSetGlobalCommand() throws Exception {
        this.ksession.insert((Object)new Integer(5));
        this.ksession.insert((Object)new Integer(7));
        this.ksession.fireAllRules();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newSetGlobal((String)"globalCheeseCountry", (Object)"France", (boolean)true));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Assert.assertNotNull((Object)result);
        Object global = result.getValue("globalCheeseCountry");
        Assert.assertNotNull((Object)global);
        Assert.assertEquals((Object)"France", (Object)global);
    }

    @Test
    public void testGetGlobalCommand() throws Exception {
        this.ksession.insert((Object)new Integer(5));
        this.ksession.insert((Object)new Integer(7));
        this.ksession.fireAllRules();
        this.ksession.setGlobal("globalCheeseCountry", (Object)"France");
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newGetGlobal((String)"globalCheeseCountry", (String)"cheeseCountry"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Assert.assertNotNull((String)"GetGlobalCommand result is null!", (Object)result);
        Object global = result.getValue("cheeseCountry");
        Assert.assertNotNull((String)"Retrieved global fact is null!", (Object)global);
        Assert.assertEquals((String)"Retrieved global is not equal to 'France'.", (Object)"France", (Object)global);
    }

    @Test
    public void testGetObjectCommand() throws Exception {
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        FactHandle handle_1 = this.ksession.insert((Object)expected_1);
        FactHandle handle_2 = this.ksession.insert((Object)expected_2);
        this.ksession.fireAllRules();
        Object fact = this.ksession.getObject(handle_1);
        Assert.assertNotNull((Object)fact);
        Assert.assertEquals((Object)expected_1, (Object)fact);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newGetObject((FactHandle)handle_1, (String)"out_1"));
        commands.add(CommandFactory.newGetObject((FactHandle)handle_2, (String)"out_2"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Assert.assertNotNull((String)"GetObjectCommand result is null!", (Object)result);
        Assert.assertEquals((Object)expected_1, (Object)result.getValue("out_1"));
        Assert.assertEquals((Object)expected_2, (Object)result.getValue("out_2"));
    }

    @Test
    public void testGetObjectsCommand() throws Exception {
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        FactHandle handle_1 = this.ksession.insert((Object)expected_1);
        FactHandle handle_2 = this.ksession.insert((Object)expected_2);
        this.ksession.fireAllRules();
        Object object = this.ksession.getObject(handle_1);
        Assert.assertNotNull((Object)object);
        Assert.assertEquals((Object)expected_1, (Object)object);
        object = this.ksession.getObject(handle_2);
        Assert.assertNotNull((Object)object);
        Assert.assertEquals((Object)expected_2, (Object)object);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newGetObjects((String)"out_list"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Assert.assertNotNull((String)"GetObjectsCommand result is null!", (Object)result);
        List objectList = (List)result.getValue("out_list");
        Assert.assertTrue((String)"Retrieved object list is null or empty!", (objectList != null && !objectList.isEmpty() ? 1 : 0) != 0);
        Collection factList = this.ksession.getObjects();
        Object[] expectedArr = new Object[]{expected_1, expected_2};
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expectedArr));
        Assert.assertTrue((String)("Expected " + expectedList.size() + " objects but retrieved " + factList.size()), (factList.size() == expectedList.size() ? 1 : 0) != 0);
        for (Object fact : factList) {
            if (!expectedList.contains(fact)) continue;
            expectedList.remove(fact);
        }
        Assert.assertTrue((String)"Retrieved object list did not contain expected objects.", (boolean)expectedList.isEmpty());
    }
}

