/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class VarargsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public VarargsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testStrStartsWith() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"varargs.drl"});
        KieSession ksession = kbase.newKieSession();
        Invoker inv = new Invoker();
        ksession.setGlobal("invoker", (Object)inv);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertTrue((boolean)inv.isI1());
        Assert.assertTrue((boolean)inv.isI2());
        Assert.assertTrue((boolean)inv.isI3());
    }

    @Test
    public void testVarargs() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"varargs2.drl"});
        KieSession ksession = kbase.newKieSession();
        MySet mySet = new MySet("one", "two");
        ksession.insert((Object)mySet);
        int fired = ksession.fireAllRules(20);
        Assert.assertEquals((long)5L, (long)fired);
        Assert.assertTrue((boolean)mySet.contains("one"));
        Assert.assertTrue((boolean)mySet.contains("two"));
        Assert.assertTrue((boolean)mySet.contains("three"));
        Assert.assertTrue((boolean)mySet.contains("four"));
        Assert.assertTrue((boolean)mySet.contains("z"));
        mySet = (MySet)ksession.getGlobal("set");
        Assert.assertTrue((boolean)mySet.contains("x"));
        Assert.assertTrue((boolean)mySet.contains("y"));
        Assert.assertTrue((boolean)mySet.contains("three"));
        Assert.assertTrue((boolean)mySet.contains("four"));
        Assert.assertTrue((boolean)mySet.contains("z"));
    }

    @PropertyReactive
    public static class MySet {
        private boolean processed;
        Set<String> set = new HashSet<String>();

        public MySet(String ... strings) {
            this.add(strings);
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        @Modifies(value={"processed"})
        public void add(String ... strings) {
            for (String s : strings) {
                this.set.add(s);
            }
        }

        public boolean contains(String s) {
            return this.set.contains(s);
        }

        public Set<String> getSet() {
            return this.set;
        }

        public String toString() {
            return this.set.toString();
        }
    }

    public static class B
    implements A {
        private int value;

        public B() {
        }

        public B(int value) {
            this.value = value;
        }

        public B(String value) {
            this.value = Integer.parseInt(value);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return other != null && other instanceof B && this.value == ((B)other).value;
        }
    }

    public static interface A {
        public int getValue();
    }

    public static class Invoker {
        private boolean i1;
        private boolean i2;
        private boolean i3;

        public void invoke(String s1, int num, String ... strings) {
            if (num != strings.length) {
                throw new RuntimeException("Expected num: " + num + ", got: " + strings.length);
            }
            this.i1 = true;
        }

        public void invoke(String s1, int num, A ... as) {
            if (num != as.length) {
                throw new RuntimeException("Expected num: " + num + ", got: " + as.length);
            }
            this.i2 = true;
        }

        public void invoke(int total, A ... as) {
            int sum = 0;
            for (A a : as) {
                sum += a.getValue();
            }
            if (total != sum) {
                throw new RuntimeException("Expected total: " + total);
            }
            this.i3 = true;
        }

        public boolean isI1() {
            return this.i1;
        }

        public void setI1(boolean i1) {
            this.i1 = i1;
        }

        public boolean isI2() {
            return this.i2;
        }

        public void setI2(boolean i2) {
            this.i2 = i2;
        }

        public boolean isI3() {
            return this.i3;
        }

        public void setI3(boolean i3) {
            this.i3 = i3;
        }
    }
}

