/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.mvel.integrationtests.phreak.ReteTesterHelper;

public class BetaNodeBuilder {
    BuildContext buildContext;
    int nodeType;
    Class leftType = Object.class;
    Class rightType = Object.class;
    String leftFieldName;
    String leftVariableName;
    String constraintFieldName;
    String constraintOperator;
    String constraintVariableName;

    public BetaNodeBuilder(int nodeType, BuildContext buildContext) {
        this.nodeType = nodeType;
        this.buildContext = buildContext;
    }

    public static BetaNodeBuilder create(int nodeType, BuildContext buildContext) {
        return new BetaNodeBuilder(nodeType, buildContext);
    }

    public BetaNodeBuilder setLeftType(Class type) {
        this.leftType = type;
        return this;
    }

    public BetaNodeBuilder setRightType(Class type) {
        this.rightType = type;
        return this;
    }

    public BetaNodeBuilder setBinding(String leftFieldName, String leftVariableName) {
        this.leftFieldName = leftFieldName;
        this.leftVariableName = leftVariableName;
        return this;
    }

    public BetaNodeBuilder setConstraint(String constraintFieldName, String constraintOperator, String constraintVariableName) {
        this.constraintFieldName = constraintFieldName;
        this.constraintOperator = constraintOperator;
        this.constraintVariableName = constraintVariableName;
        return this;
    }

    public BetaNode build() {
        NodeFactory nFactory = this.buildContext.getComponentFactory().getNodeFactoryService();
        EntryPointNode epn = (EntryPointNode)this.buildContext.getKnowledgeBase().getRete().getEntryPointNodes().values().iterator().next();
        ObjectTypeNode otn = nFactory.buildObjectTypeNode(this.buildContext.getNextNodeId(), epn, (ObjectType)new ClassObjectType(this.leftType), this.buildContext);
        LeftInputAdapterNode leftInput = nFactory.buildLeftInputAdapterNode(this.buildContext.getNextNodeId(), (ObjectSource)otn, this.buildContext, false);
        ObjectTypeNode rightInput = nFactory.buildObjectTypeNode(this.buildContext.getNextNodeId(), epn, (ObjectType)new ClassObjectType(this.rightType), this.buildContext);
        ReteTesterHelper reteTesterHelper = new ReteTesterHelper();
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(this.leftType));
        EmptyBetaConstraints betaConstraints = null;
        if (this.constraintFieldName != null) {
            ClassFieldAccessorStore store = reteTesterHelper.getStore();
            ClassFieldReader extractor = store.getReader(this.leftType, this.leftFieldName);
            Declaration declr = new Declaration(this.leftVariableName, (InternalReadAccessor)extractor, pattern);
            betaConstraints = new SingleBetaConstraints(reteTesterHelper.getBoundVariableConstraint(this.rightType, this.constraintFieldName, declr, this.constraintOperator), this.buildContext.getKnowledgeBase().getConfiguration());
        } else {
            betaConstraints = new EmptyBetaConstraints();
        }
        switch (this.nodeType) {
            case 181: {
                return new JoinNode(0, (LeftTupleSource)leftInput, (ObjectSource)rightInput, (BetaConstraints)betaConstraints, this.buildContext);
            }
            case 191: {
                return new NotNode(0, (LeftTupleSource)leftInput, (ObjectSource)rightInput, (BetaConstraints)betaConstraints, this.buildContext);
            }
            case 201: {
                return new ExistsNode(0, (LeftTupleSource)leftInput, (ObjectSource)rightInput, (BetaConstraints)betaConstraints, this.buildContext);
            }
        }
        throw new IllegalStateException("Unable to build Node");
    }
}

