/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.TupleValueExtractor;
import org.drools.core.test.model.Cheese;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RightTupleIndexHashTableTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testSingleEntry() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(0L, (Object)cheddar);
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertNull((Object)map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)cheddarHandle1, null, true)));
        Cheese stilton1 = new Cheese("stilton", 35);
        RightTupleImpl stiltonRighTuple = new RightTupleImpl((InternalFactHandle)new DefaultFactHandle(1L, (Object)stilton1), null);
        map.add((Tuple)stiltonRighTuple);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((long)1L, (long)this.tablePopulationSize((AbstractHashTable)map));
        Cheese stilton2 = new Cheese("stilton", 80);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(2L, (Object)stilton2);
        Tuple tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle2, null, true));
        Assert.assertSame((Object)stiltonRighTuple.getFactHandle(), (Object)tuple.getFactHandle());
        Assert.assertNull((Object)tuple.getNext());
    }

    @Test
    public void testTwoDifferentEntries() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assert.assertEquals((long)0L, (long)map.size());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle stiltonHandle1 = new DefaultFactHandle(1L, (Object)stilton1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)stiltonHandle1, null));
        Cheese cheddar1 = new Cheese("cheddar", 35);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(2L, (Object)cheddar1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)cheddarHandle1, null));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)2L, (long)this.tablePopulationSize((AbstractHashTable)map));
        Cheese stilton2 = new Cheese("stilton", 77);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(2L, (Object)stilton2);
        Tuple tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle2, null, true));
        Assert.assertSame((Object)stiltonHandle1, (Object)tuple.getFactHandle());
        Assert.assertNull((Object)tuple.getNext());
        Cheese cheddar2 = new Cheese("cheddar", 5);
        DefaultFactHandle cheddarHandle2 = new DefaultFactHandle(2L, (Object)cheddar2);
        tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)cheddarHandle2, null, true));
        Assert.assertSame((Object)cheddarHandle1, (Object)tuple.getFactHandle());
        Assert.assertNull((Object)tuple.getNext());
    }

    @Test
    public void testTwoEqualEntries() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assert.assertEquals((long)0L, (long)map.size());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle stiltonHandle1 = new DefaultFactHandle(1L, (Object)stilton1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)stiltonHandle1, null));
        Cheese cheddar1 = new Cheese("cheddar", 35);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(2L, (Object)cheddar1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)cheddarHandle1, null));
        Cheese stilton2 = new Cheese("stilton", 81);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(3L, (Object)stilton2);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)stiltonHandle2, null));
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)2L, (long)this.tablePopulationSize((AbstractHashTable)map));
        Cheese stilton3 = new Cheese("stilton", 89);
        DefaultFactHandle stiltonHandle3 = new DefaultFactHandle(4L, (Object)stilton2);
        Tuple tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle3, null, true));
        Assert.assertSame((Object)stiltonHandle1, (Object)tuple.getFactHandle());
        Assert.assertSame((Object)stiltonHandle2, (Object)((RightTuple)tuple.getNext()).getFactHandle());
    }

    @Test
    public void testTwoDifferentEntriesSameHashCode() throws Exception {
        ClassFieldReader extractor = this.store.getReader(TestClass.class, "object");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(TestClass.class));
        Declaration declaration = new Declaration("theObject", (InternalReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        TestClass c1 = new TestClass(0, new TestClass(20, "stilton"));
        DefaultFactHandle ch1 = new DefaultFactHandle(1L, (Object)c1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)ch1, null));
        TestClass c2 = new TestClass(0, new TestClass(20, "cheddar"));
        DefaultFactHandle ch2 = new DefaultFactHandle(2L, (Object)c2);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)ch2, null));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)1L, (long)this.tablePopulationSize((AbstractHashTable)map));
        Entry[] entries = this.getEntries((AbstractHashTable)map);
        Assert.assertEquals((long)1L, (long)entries.length);
        TupleList list = (TupleList)entries[0];
        Assert.assertSame((Object)ch2, (Object)list.getFirst().getFactHandle());
        Assert.assertNull((Object)list.getFirst().getNext());
        Assert.assertSame((Object)ch1, (Object)list.getNext().getFirst().getFactHandle());
        Assert.assertNull((Object)list.getNext().getFirst().getNext());
        Assert.assertNull((Object)list.getNext().getNext());
    }

    @Test
    public void testRemove() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assert.assertEquals((long)0L, (long)map.size());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle stiltonHandle1 = new DefaultFactHandle(1L, (Object)stilton1);
        RightTupleImpl stiltonRightTuple1 = new RightTupleImpl((InternalFactHandle)stiltonHandle1, null);
        map.add((Tuple)stiltonRightTuple1);
        Cheese cheddar1 = new Cheese("cheddar", 35);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(2L, (Object)cheddar1);
        RightTupleImpl cheddarRightTuple1 = new RightTupleImpl((InternalFactHandle)cheddarHandle1, null);
        map.add((Tuple)cheddarRightTuple1);
        Cheese stilton2 = new Cheese("stilton", 81);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(3L, (Object)stilton2);
        RightTupleImpl stiltonRightTuple2 = new RightTupleImpl((InternalFactHandle)stiltonHandle2, null);
        map.add((Tuple)stiltonRightTuple2);
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)2L, (long)this.tablePopulationSize((AbstractHashTable)map));
        map.remove((Tuple)cheddarRightTuple1);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)1L, (long)this.tablePopulationSize((AbstractHashTable)map));
        map.remove((Tuple)stiltonRightTuple2);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((long)1L, (long)this.tablePopulationSize((AbstractHashTable)map));
        map.remove((Tuple)stiltonRightTuple1);
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertEquals((long)0L, (long)this.tablePopulationSize((AbstractHashTable)map));
    }

    @Test
    public void testResize() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(16, 0.75f, new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assert.assertEquals((long)0L, (long)map.size());
        Cheese stilton1 = new Cheese("stilton", 35);
        map.add((Tuple)this.newRightTuple(1, stilton1));
        Cheese stilton2 = new Cheese("stilton", 81);
        map.add((Tuple)this.newRightTuple(2, stilton2));
        Cheese cheddar1 = new Cheese("cheddar", 35);
        map.add((Tuple)this.newRightTuple(3, cheddar1));
        Cheese cheddar2 = new Cheese("cheddar", 38);
        map.add((Tuple)this.newRightTuple(4, cheddar2));
        Cheese brie = new Cheese("brie", 293);
        map.add((Tuple)this.newRightTuple(5, brie));
        Cheese mozerella = new Cheese("mozerella", 15);
        map.add((Tuple)this.newRightTuple(6, mozerella));
        Cheese dolcelatte = new Cheese("dolcelatte", 284);
        map.add((Tuple)this.newRightTuple(7, dolcelatte));
        Cheese camembert1 = new Cheese("camembert", 924);
        map.add((Tuple)this.newRightTuple(8, camembert1));
        Cheese camembert2 = new Cheese("camembert", 765);
        map.add((Tuple)this.newRightTuple(9, camembert2));
        Cheese redLeicestor = new Cheese("red leicestor", 23);
        map.add((Tuple)this.newRightTuple(10, redLeicestor));
        Cheese wensleydale = new Cheese("wensleydale", 20);
        map.add((Tuple)this.newRightTuple(11, wensleydale));
        Cheese edam = new Cheese("edam", 12);
        map.add((Tuple)this.newRightTuple(12, edam));
        Cheese goude1 = new Cheese("goude", 93);
        map.add((Tuple)this.newRightTuple(13, goude1));
        Cheese goude2 = new Cheese("goude", 88);
        map.add((Tuple)this.newRightTuple(14, goude2));
        Cheese gruyere = new Cheese("gruyere", 82);
        map.add((Tuple)this.newRightTuple(15, gruyere));
        Cheese emmental = new Cheese("emmental", 98);
        map.add((Tuple)this.newRightTuple(16, emmental));
        Assert.assertEquals((long)16L, (long)map.size());
        Entry[] table = map.getTable();
        Assert.assertEquals((long)16L, (long)table.length);
        Cheese feta = new Cheese("feta", 48);
        map.add((Tuple)this.newRightTuple(2, feta));
        Assert.assertEquals((long)17L, (long)map.size());
        table = map.getTable();
        Assert.assertEquals((long)32L, (long)table.length);
        Cheese haloumi = new Cheese("haloumi", 48);
        map.add((Tuple)this.newRightTuple(2, haloumi));
        Cheese chevre = new Cheese("chevre", 48);
        map.add((Tuple)this.newRightTuple(2, chevre));
    }

    private RightTuple newRightTuple(int id, Object object) {
        return new RightTupleImpl((InternalFactHandle)new DefaultFactHandle((long)id, object), null);
    }

    private int tablePopulationSize(AbstractHashTable map) throws Exception {
        Field field = AbstractHashTable.class.getDeclaredField("table");
        field.setAccessible(true);
        Entry[] array = (Entry[])field.get(map);
        int size = 0;
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (array[i] == null) continue;
            ++size;
        }
        return size;
    }

    private Entry[] getEntries(AbstractHashTable map) throws Exception {
        Field field = AbstractHashTable.class.getDeclaredField("table");
        field.setAccessible(true);
        ArrayList<Entry> list = new ArrayList<Entry>();
        Entry[] array = (Entry[])field.get(map);
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (array[i] == null) continue;
            list.add(array[i]);
        }
        return list.toArray(new Entry[list.size()]);
    }

    @Test
    public void testEmptyIterator() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Cheese stilton = new Cheese("stilton", 55);
        DefaultFactHandle stiltonHandle = new DefaultFactHandle(2L, (Object)stilton);
        Assert.assertNull((Object)map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle, null, true)));
    }

    public static class TestClass {
        private int hashCode;
        private Object object;

        public TestClass() {
        }

        public TestClass(int hashCode, Object object) {
            this.hashCode = hashCode;
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public void setHashCode(int hashCode) {
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return !(this.object == null ? other.object != null : !this.object.equals(other.object));
        }
    }
}

