/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.drools.kiesession.agenda.DefaultAgenda;
import org.drools.testcoverage.common.model.Alarm;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class TimerAndCalendarWithRealTimeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession;
    private KieBase kbase;

    public TimerAndCalendarWithRealTimeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @After
    public void after() throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test(timeout=15000L)
    public void testDuration() throws Exception {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule delayed\n    duration 100\n    when\n        cheese : Cheese( )\n    then\n        list.add( cheese );\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        this.ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        this.ksession.insert((Object)brie);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        this.awaitUntilRulesThatFiredAre(1);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testDurationWithNoLoop() throws Exception {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule delayed\n    timer 100\n    no-loop true\n    when\n        cheese : Cheese( )\n    then\n        list.add( cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        this.ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        this.ksession.insert((Object)brie);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        this.awaitUntilRulesThatFiredAre(1);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testFireRuleAfterDuration() throws Exception {
        String drl = "package org.drools.compiler.test;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule delayed\n    duration 100\n    when\n        cheese : Cheese( $type:type == \"brie\" )\n    then\n        list.add( cheese );\n        insert(new Cheese(\"stilton\", 42));\n        delete(cheese);\nend\n\nrule after_delayed\n    when\n        cheese : Cheese( $type:type == \"stilton\" )\n    then\n        list.add( cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        this.ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        this.ksession.insert((Object)brie);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        this.awaitUntilRulesThatFiredAre(1);
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testTimerWithNot() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_Timer_With_Not.drl"});
        this.ksession = kbase.newKieSession();
        this.awaitUntilRulesThatFiredAre(2);
        Assert.assertEquals((long)2L, (long)this.ksession.getFactCount());
    }

    @Test(timeout=10000L)
    public void testTimerRemoval() {
        String drl = "package org.drools.compiler.test\nimport " + TimeUnit.class.getName() + "\nglobal java.util.List list \nrule TimerRule \n   timer (int:100 50) \nwhen \nthen \n        //forces it to pause until main thread is ready\n        list.add(list.size()); \n end";
        this.kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        this.ksession = this.kbase.newKieSession();
        List list = Collections.synchronizedList(new ArrayList());
        this.ksession.setGlobal("list", list);
        this.ksession.fireAllRules();
        Awaitility.await().until(this.agendaIsNotEmpty());
        this.ksession.fireAllRules();
        Awaitility.await().until(list::size, Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        this.kbase.removeRule("org.drools.compiler.test", "TimerRule");
        this.ksession.fireAllRules();
        Awaitility.await().until(this.ruleIsRemoved());
    }

    @Test
    public void testIntervalRuleInsertion() throws Exception {
        String drl = "package org.simple\nglobal java.util.List list\nimport " + Alarm.class.getCanonicalName() + "\nrule \"Interval Alarm\"\ntimer(int: 1s 1s)\nwhen     not Alarm()\nthen\n    insert(new Alarm());\n    list.add(\"fired\"); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_REALTIME.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        this.ksession = kbase.newKieSession(kieSessionConfiguration, null);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        this.ksession.fireAllRules();
        long start = System.currentTimeMillis();
        Awaitility.await().until(list::size, Matchers.equalTo((Object)1));
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 1000L ? 1 : 0) != 0);
    }

    @Ignore(value="DROOLS-6479 - Fixing timing issues")
    @Test(timeout=10000L)
    public void testHaltWithTimer() throws Exception {
        String drl = "// fire once, for a String, create an Integer, halt!\nrule x\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"halt\" )\nthen\n    insert( new Integer(1) );\n    drools.halt();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"// fire once, for a String, create an Integer, halt!\nrule x\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"halt\" )\nthen\n    insert( new Integer(1) );\n    drools.halt();\nend"});
        this.ksession = kbase.newKieSession();
        new Thread(() -> ((KieSession)this.ksession).fireUntilHalt()).start();
        this.ksession.insert((Object)"halt");
        Thread.sleep(2000L);
        Assert.assertEquals((long)2L, (long)this.ksession.getFactCount());
    }

    @Ignore(value="DROOLS-6479 - Fixing timing issues")
    @Test(timeout=10000L)
    public void testHaltAfterSomeTimeThenRestart() throws Exception {
        String drl = "package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\ntimer(int:0 100)\nwhen  \nthen \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\nrule Hi \nsalience 10 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( 5 ); \nend \n\nrule Lo \nsalience -5 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( -5 ); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\ntimer(int:0 100)\nwhen  \nthen \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\nrule Hi \nsalience 10 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( 5 ); \nend \n\nrule Lo \nsalience -5 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( -5 ); \nend \n"});
        this.ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        new Thread(() -> ((KieSession)this.ksession).fireUntilHalt()).start();
        Thread.sleep(250L);
        Assert.assertEquals(Arrays.asList(0, 0, 0), list);
        this.ksession.insert((Object)"halt");
        this.ksession.insert((Object)"trigger");
        Thread.sleep(300L);
        Assert.assertEquals(Arrays.asList(0, 0, 0), list);
        new Thread(() -> ((KieSession)this.ksession).fireUntilHalt()).start();
        Thread.sleep(200L);
        Assert.assertEquals(Arrays.asList(0, 0, 0, 5, 0, -5, 0, 0), list);
    }

    @Ignore(value="DROOLS-6479 - Fixing timing issues")
    @Test(timeout=10000L)
    public void testHaltAfterSomeTimeThenRestartButNoLongerHolding() throws Exception {
        String drl = "package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\n   timer(int:0 200)\nwhen  \n  eval(true)  String( this == \"trigger\" )then \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\n   timer(int:0 200)\nwhen  \n  eval(true)  String( this == \"trigger\" )then \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\n"});
        this.ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        FactHandle handle = this.ksession.insert((Object)"trigger");
        new Thread(() -> ((KieSession)this.ksession).fireUntilHalt()).start();
        Thread.sleep(350L);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals(Arrays.asList(0, 0), list);
        this.ksession.insert((Object)"halt");
        Thread.sleep(200L);
        this.ksession.delete(handle);
        Assert.assertEquals((long)2L, (long)list.size());
        new Thread(() -> ((KieSession)this.ksession).fireUntilHalt()).start();
        Thread.sleep(200L);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals(Arrays.asList(0, 0), list);
    }

    private void awaitUntilRulesThatFiredAre(int rulesToFire) throws InterruptedException {
        for (int count = 0; count < rulesToFire; count += this.ksession.fireAllRules()) {
            Thread.sleep(10L);
        }
    }

    private Callable<Boolean> ruleIsRemoved() {
        return () -> this.kbase.getRule("org.drools.compiler.test", "TimerRule") == null;
    }

    private Callable<Boolean> agendaIsNotEmpty() {
        return () -> !((DefaultAgenda)this.ksession.getAgenda()).getPropagationList().isEmpty();
    }
}

