/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.beliefsystem.defeasible;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.core.BeliefSystemType;
import org.drools.core.ClassObjectFilter;
import org.drools.core.SessionConfiguration;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.core.beliefsystem.defeasible.DefeasibleBeliefSet;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.util.ObjectHashMap;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class DefeasibilityTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DefeasibilityTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KieSession getSessionFromString(String drlString) {
        KieBase kBase;
        try {
            System.setProperty("drools.negatable", "on");
            KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
            kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{drlString});
        }
        finally {
            System.setProperty("drools.negatable", "off");
        }
        KieSessionConfiguration ksConf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ((SessionConfiguration)ksConf).setBeliefSystemType(BeliefSystemType.DEFEASIBLE);
        KieSession kSession = kBase.newKieSession(ksConf, null);
        return kSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KieSession getSession(String ruleFile) {
        KieBase kBase;
        try {
            System.setProperty("drools.negatable", "on");
            KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
            kBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{ruleFile});
        }
        finally {
            System.setProperty("drools.negatable", "off");
        }
        KieSessionConfiguration ksConf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ((SessionConfiguration)ksConf).setBeliefSystemType(BeliefSystemType.DEFEASIBLE);
        KieSession kSession = kBase.newKieSession(ksConf, null);
        return kSession;
    }

    private void checkStatus(EqualityKey key, int support, DefeasibilityStatus status) {
        Assert.assertEquals((long)2L, (long)key.getStatus());
        BeliefSet set = key.getBeliefSet();
        Assert.assertTrue((boolean)(set instanceof DefeasibleBeliefSet));
        DefeasibleBeliefSet dfs = (DefeasibleBeliefSet)set;
        Assert.assertEquals((long)support, (long)dfs.size());
        Assert.assertEquals((Object)status, (Object)dfs.getStatus());
    }

    @Test(timeout=10000L)
    public void testStrictEntailment() {
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/strict.drl");
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Ctype = kSession.getKieBase().getFactType("org.drools.defeasible", "C");
        FactType Dtype = kSession.getKieBase().getFactType("org.drools.defeasible", "D");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key = (EqualityKey)entry.getValue();
            Class<?> factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Ctype.getFactClass()) {
                this.checkStatus(key, 2, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            if (factClass == Dtype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        Assert.assertEquals((long)5L, (long)kSession.getObjects().size());
    }

    @Test(timeout=10000L)
    public void testDefeasibleEntailmentWithStrictOverride() {
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/strictOverride.drl");
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Ctype = kSession.getKieBase().getFactType("org.drools.defeasible", "C");
        FactType Xtype = kSession.getKieBase().getFactType("org.drools.defeasible", "X");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key = (EqualityKey)entry.getValue();
            Class<?> factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Ctype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            if (factClass == Xtype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        Assert.assertEquals((long)5L, (long)kSession.getObjects().size());
    }

    @Test(timeout=10000L)
    public void defeasibleEntailmentMultiActivation() {
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/defeat.drl");
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Xtype = kSession.getKieBase().getFactType("org.drools.defeasible", "X");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key = (EqualityKey)entry.getValue();
            Class<?> factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Xtype.getFactClass()) {
                this.checkStatus(key, 3, DefeasibilityStatus.UNDECIDABLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        Assert.assertEquals((long)3L, (long)kSession.getObjects().size());
    }

    @Test(timeout=10000L)
    public void testDefeaterNeutrality() {
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/defeaterOnly.drl");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Xtype = kSession.getKieBase().getFactType("org.drools.defeasible", "X");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key = (EqualityKey)entry.getValue();
            Class<?> factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Xtype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFEATEDLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        for (Object o : kSession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)1L, (long)kSession.getFactCount());
    }

    @Test(timeout=10000L)
    public void testMultipleDefeats() {
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/multiDefeat.drl");
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Xtype = kSession.getKieBase().getFactType("org.drools.defeasible", "X");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key = (EqualityKey)entry.getValue();
            Class<?> factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Xtype.getFactClass()) {
                this.checkStatus(key, 2, DefeasibilityStatus.DEFEATEDLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        for (Object o : kSession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)2L, (long)kSession.getObjects().size());
        kSession.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testRemoveDefiniteJustifier() {
        Class<?> factClass;
        EqualityKey key;
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/strictRetract.drl");
        FactHandle h = kSession.insert((Object)"go");
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Ctype = kSession.getKieBase().getFactType("org.drools.defeasible", "C");
        FactType Atype = kSession.getKieBase().getFactType("org.drools.defeasible", "A");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            key = (EqualityKey)entry.getValue();
            factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Ctype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            if (factClass == Atype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        kSession.retract(h);
        kSession.fireAllRules();
        keys = tms.getEqualityKeyMap();
        iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            key = (EqualityKey)entry.getValue();
            factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Ctype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFEASIBLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
    }

    @Test(timeout=10000L)
    public void testRemoveDefeasibleJustifier() {
        Class<?> factClass;
        EqualityKey key;
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/defeaterRetract.drl");
        FactHandle h = kSession.insert((Object)"go");
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Ctype = kSession.getKieBase().getFactType("org.drools.defeasible", "C");
        FactType Atype = kSession.getKieBase().getFactType("org.drools.defeasible", "A");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            key = (EqualityKey)entry.getValue();
            factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Ctype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            if (factClass == Atype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        kSession.retract(h);
        kSession.fireAllRules();
        keys = tms.getEqualityKeyMap();
        iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            key = (EqualityKey)entry.getValue();
            factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Ctype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFINITELY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
    }

    @Test(timeout=10000L)
    @Ignore
    public void testRemoveDefeasibleEntailmentMultiActivationWithDefeat() {
        Class<?> factClass;
        Object key;
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/defeatDefeaterRetract.drl");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Xtype = kSession.getKieBase().getFactType("org.drools.defeasible", "X");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key2 = (EqualityKey)entry.getValue();
            Class<?> factClass2 = key2.getFactHandle().getObject().getClass();
            if (factClass2 == Xtype.getFactClass()) {
                this.checkStatus(key2, 1, DefeasibilityStatus.DEFEATEDLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass2));
        }
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Stage1"));
        Assert.assertEquals((long)3L, (long)kSession.getObjects().size());
        for (Object o : kSession.getObjects()) {
            System.out.println(o);
        }
        FactHandle h = kSession.insert((Object)"go");
        kSession.fireAllRules();
        keys = tms.getEqualityKeyMap();
        iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            key = (EqualityKey)entry.getValue();
            factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Xtype.getFactClass()) {
                this.checkStatus((EqualityKey)key, 3, DefeasibilityStatus.DEFEASIBLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        for (Object o : kSession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)5L, (long)kSession.getObjects().size());
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Stage1"));
        Assert.assertTrue((boolean)list.contains("Stage2"));
        kSession.retract(h);
        kSession.fireAllRules();
        for (Object o : kSession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)3L, (long)kSession.getObjects().size());
        keys = tms.getEqualityKeyMap();
        iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            key = (EqualityKey)entry.getValue();
            factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Xtype.getFactClass()) {
                this.checkStatus((EqualityKey)key, 1, DefeasibilityStatus.DEFEATEDLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
    }

    @Test(timeout=10000L)
    public void testDefeaterPositiveVsNegative() {
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/defeatersPosNeg.drl");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Xtype = kSession.getKieBase().getFactType("org.drools.defeasible", "X");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key = (EqualityKey)entry.getValue();
            Object fact = key.getFactHandle().getObject();
            Class<?> factClass = fact.getClass();
            if (factClass == Xtype.getFactClass()) {
                Integer val = (Integer)Xtype.get(fact, "id");
                switch (val) {
                    case -1: {
                        this.checkStatus(key, 2, DefeasibilityStatus.UNDECIDABLY);
                        break;
                    }
                    case 3: {
                        this.checkStatus(key, 1, DefeasibilityStatus.DEFEATEDLY);
                        break;
                    }
                    case -35: {
                        this.checkStatus(key, 3, DefeasibilityStatus.UNDECIDABLY);
                        break;
                    }
                    case 44: {
                        this.checkStatus(key, 2, DefeasibilityStatus.DEFEASIBLY);
                        break;
                    }
                    default: {
                        Assert.fail((String)"Unrecognized fact");
                        break;
                    }
                }
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(-44));
        Assert.assertTrue((!list.contains(-35) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)kSession.getFactCount());
        Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
    }

    @Test(timeout=10000L)
    public void testDefeatOutcomePosNeg() {
        ObjectHashMap.ObjectEntry entry;
        KieSession kSession = this.getSession("org/drools/mvel/compiler/beliefsystem/defeasible/negDefeatPos.drl");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)kSession.getEntryPoint("DEFAULT")).getTruthMaintenanceSystem();
        FactType Xtype = kSession.getKieBase().getFactType("org.drools.defeasible", "X");
        ObjectHashMap keys = tms.getEqualityKeyMap();
        org.drools.core.util.Iterator iter = keys.iterator();
        while ((entry = (ObjectHashMap.ObjectEntry)iter.next()) != null) {
            EqualityKey key = (EqualityKey)entry.getValue();
            Class<?> factClass = key.getFactHandle().getObject().getClass();
            if (factClass == Xtype.getFactClass()) {
                this.checkStatus(key, 1, DefeasibilityStatus.DEFEASIBLY);
                continue;
            }
            Assert.fail((String)("Unrecognized object has been logically justified : " + factClass));
        }
        Assert.assertEquals((long)2L, (long)kSession.getObjects().size());
        Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("-1"));
    }

    @Test(timeout=10000L)
    public void testPrimeJustificationWithEqualityMode() {
        String droolsSource = "package org.drools.tms.test; \ndeclare Bar end \ndeclare Holder x : Bar end \nrule Init \nwhen \nthen \n   insert( new Holder( new Bar() ) ); \nend \nrule Justify \nwhen \n $s : Integer() \n $h : Holder( $b : x ) \nthen \n insertLogical( $b ); \nend \nrule React \nwhen \n $b : Bar(  ) \nthen \n System.out.println( $b );  \nend \n";
        KieSession session = this.getSessionFromString(droolsSource);
        FactHandle handle1 = session.insert((Object)10);
        FactHandle handle2 = session.insert((Object)20);
        Assert.assertEquals((long)4L, (long)session.fireAllRules());
        session.delete(handle1);
        Assert.assertEquals((long)0L, (long)session.fireAllRules());
    }

    @Test(timeout=10000L)
    public void testWMStatusOnNegativeDefeat() {
        String droolsSource = "package org.drools.tms.test; global java.util.List posList;global java.util.List negList;declare Bar value : int @key end rule Top @Defeasible @Defeats( 'Sub' ) when    $i : Integer( this < 10 ) then    insertLogical( new Bar( $i ) ); end rule Sub @Defeasible when    $i : Integer() then    insertLogical( new Bar( $i ), $i > 10 ? 'pos' : 'neg' ); end rule Sup @Defeasible @Defeats( 'Sub' ) when    $i : Integer( this > 10 ) then    insertLogical( new Bar( $i ), 'neg' ); end rule React_Pos when    $b : Bar() then    posList.add( $b );    System.out.println( ' ++++ ' + $b ); end rule React_Neg when    $b : Bar( _.neg )then    negList.add( $b );    System.out.println( ' ---- ' + $b ); end ";
        KieSession session = this.getSessionFromString(droolsSource);
        ArrayList posList = new ArrayList();
        ArrayList negList = new ArrayList();
        session.setGlobal("posList", posList);
        session.setGlobal("negList", negList);
        session.insert((Object)20);
        session.insert((Object)5);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)posList.size());
        Assert.assertEquals((long)1L, (long)negList.size());
        Object posBar = posList.get(0);
        InternalFactHandle posHandle = (InternalFactHandle)session.getFactHandle(posBar);
        DefeasibleBeliefSet dbs = (DefeasibleBeliefSet)posHandle.getEqualityKey().getBeliefSet();
        Assert.assertEquals((long)1L, (long)dbs.size());
        Assert.assertFalse((boolean)dbs.isNegated());
        Assert.assertTrue((boolean)dbs.isDecided());
        Assert.assertTrue((boolean)dbs.isPositive());
        Assert.assertSame((Object)posHandle, (Object)dbs.getFactHandle());
        Assert.assertFalse((boolean)posHandle.isNegated());
        Assert.assertTrue((boolean)dbs.isDefeasiblyPosProveable());
        Assert.assertTrue((boolean)session.getObjects().contains(posBar));
        Object negBar = negList.get(0);
        InternalFactHandle negHandle = (InternalFactHandle)this.getNegativeHandles(session).get(0);
        dbs = (DefeasibleBeliefSet)negHandle.getEqualityKey().getBeliefSet();
        Assert.assertEquals((long)1L, (long)dbs.size());
        Assert.assertFalse((boolean)dbs.isPositive());
        Assert.assertTrue((boolean)dbs.isDecided());
        Assert.assertTrue((boolean)dbs.isNegated());
        Assert.assertSame((Object)negHandle, (Object)dbs.getFactHandle());
        Assert.assertTrue((boolean)negHandle.isNegated());
        Assert.assertTrue((boolean)dbs.isDefeasiblyNegProveable());
        Assert.assertTrue((boolean)session.getObjects().contains(negBar));
    }

    @Test
    public void testSelfDefeatWithRebuttal() {
        String droolsSource = "package org.drools.tms.test; global java.util.List posList;global java.util.List negList;declare Bar value : int @key end rule Create @Defeasible when    $i : Integer() then    System.out.println( 'Create Bar ' + $i );    bolster( new Bar( $i ) ); end rule Defeater @Direct @Defeasible @Defeats( 'Create' ) when    $b1 : Bar( $val1 : value )    $b2 : Bar( $val2 : value > $val1, value - $val1 < 15 ) then    System.out.println( $b2 + ' defeats ' + $b1 );    bolster( new Bar( $val1 ), 'neg' ); end rule ReactP salience 100 when    $b : Bar() then    posList.add( $b );    System.out.println( ' ++++ ' + $b ); end rule ReactN salience 100 when    $b : Bar( _.neg )  then    negList.add( $b );    System.out.println( ' ---- ' + $b ); end ";
        KieSession session = this.getSessionFromString(droolsSource);
        ArrayList posList = new ArrayList();
        ArrayList negList = new ArrayList();
        session.setGlobal("posList", posList);
        session.setGlobal("negList", negList);
        session.insert((Object)10);
        session.insert((Object)30);
        session.insert((Object)20);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)posList.size());
        Assert.assertEquals((long)1L, (long)negList.size());
    }

    @Test
    public void testDefeatersAndDefeasibles() {
        String droolsSource = "package org.drools.tms.test; global java.util.List posList;declare Bar value : int @key end rule B @Defeater @Defeats( 'C' ) when    $i : Integer() then    insertLogical( new Bar( $i ) ); end rule C @Defeasible when    $i : Integer() then    insertLogical( new Bar( $i ) ); end rule React when    $b : Bar() then    posList.add( $b );    System.out.println( ' ++++ ' + $b ); end ";
        KieSession session = this.getSessionFromString(droolsSource);
        ArrayList posList = new ArrayList();
        session.setGlobal("posList", posList);
        session.insert((Object)10);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)posList.size());
    }

    @Test(timeout=10000L)
    public void testManyDefeasibles() {
        String drl = "package org.drools.defeasible; declare Fact      fact: String @key end  rule init      when      then          insert( new Fact( 'one' ) );          insert( new Fact( 'two' ) );          insert( new Fact( 'two' ) ); end  rule rule1      @Defeasible      enabled true      when          Fact( \"one\"; )      then          System.out.println(\"one causes wibble\");          insertLogical( new Fact( \"wibble\") ); end  rule rule2      @Defeasible      when          Fact( \"two\"; )      then          System.out.println(\"two causes wibble\");          insertLogical( new Fact( \"wibble\") ); end  rule rule3      @Defeater      @Defeats( \"rule2\" )      when          Fact( \"two\"; )      then          System.out.println(\"two negates wibble\");          insertLogical( new Fact( \"wibble\"), \"neg\" ); end";
        KieSession session = this.getSessionFromString(drl);
        session.fireAllRules();
        FactType factType = session.getKieBase().getFactType("org.drools.defeasible", "Fact");
        for (Object o : session.getObjects((ObjectFilter)new ClassObjectFilter(factType.getFactClass()))) {
            if (!"wibble".equals(factType.get(o, "fact"))) continue;
            InternalFactHandle handle = (InternalFactHandle)session.getFactHandle(o);
            DefeasibleBeliefSet dbs = (DefeasibleBeliefSet)handle.getEqualityKey().getBeliefSet();
            Assert.assertEquals((long)3L, (long)dbs.size());
            Assert.assertTrue((boolean)dbs.isConflicting());
        }
    }

    @Test(timeout=10000L)
    public void testRetractNegativeDefeaters() {
        String drl = "declare Foo end rule Def   @Defeater when   String() then   insertLogical( new Foo(), 'neg' ); end ";
        KieSession session = this.getSessionFromString(drl);
        FactHandle h = session.insert((Object)"foo");
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)session.getObjects().size());
        session.delete(h);
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)session.getObjects().size());
    }

    public List getNegativeObjects(KieSession kSession) {
        ArrayList list = new ArrayList();
        Iterator it = ((StatefulKnowledgeSessionImpl)kSession).getObjectStore().iterateNegObjects(null);
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public List getNegativeHandles(KieSession kSession) {
        ArrayList list = new ArrayList();
        Iterator it = ((StatefulKnowledgeSessionImpl)kSession).getObjectStore().iterateNegFactHandles(null);
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }
}

