/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.common;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.common.TerminalNodeIterator;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.Iterator;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;

@RunWith(value=Parameterized.class)
public class TerminalNodeIteratorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TerminalNodeIteratorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testTerminalNodeListener() {
        String str = "package org.kie.test \n\nrule rule1 when\nthen\nend\nrule rule2 when\nthen\nend\nrule rule3 when\n    Object()then\nend\nrule rule4 when\n    Object()then\nend\nrule rule5 when\n    Object() or\n    Object()\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ArrayList<String> nodes = new ArrayList<String>();
        Iterator it = TerminalNodeIterator.iterator((KieBase)kbase);
        TerminalNode node = (TerminalNode)it.next();
        while (node != null) {
            nodes.add(((RuleTerminalNode)node).getRule().getName());
            node = (TerminalNode)it.next();
        }
        Assert.assertEquals((long)6L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains("rule1"));
        Assert.assertTrue((boolean)nodes.contains("rule2"));
        Assert.assertTrue((boolean)nodes.contains("rule3"));
        Assert.assertTrue((boolean)nodes.contains("rule4"));
        Assert.assertTrue((boolean)nodes.contains("rule5"));
        int first = nodes.indexOf("rule5");
        int second = nodes.lastIndexOf("rule5");
        Assert.assertTrue((first != second ? 1 : 0) != 0);
    }
}

