/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.builder.impl;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.io.internal.InternalResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.wiring.api.ResourceProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.ReleaseIdComparator;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.util.maven.support.DependencyFilter;
import org.kie.util.maven.support.PomModel;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class KieModuleRepoTest {
    private KieRepositoryImpl.KieModuleRepo kieModuleRepo;
    private int maxSizeGaCacheOrig;
    private int maxSizeGaVersionsCacheOrig;
    private Field maxSizeGaCacheField;
    private Field maxSizeGaVersionsCacheField;

    @Before
    public void before() throws Exception {
        this.kieModuleRepo = new KieRepositoryImpl.KieModuleRepo();
        this.maxSizeGaCacheOrig = KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE;
        this.maxSizeGaVersionsCacheOrig = KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE;
        this.maxSizeGaCacheField = KieRepositoryImpl.KieModuleRepo.class.getDeclaredField("MAX_SIZE_GA_CACHE");
        this.maxSizeGaVersionsCacheField = KieRepositoryImpl.KieModuleRepo.class.getDeclaredField("MAX_SIZE_GA_VERSIONS_CACHE");
    }

    @After
    public void after() throws Exception {
        KieModuleRepoTest.setCacheSize(this.maxSizeGaCacheField, null, this.maxSizeGaCacheOrig);
        KieModuleRepoTest.setCacheSize(this.maxSizeGaVersionsCacheField, null, this.maxSizeGaVersionsCacheOrig);
    }

    protected static void waitFor(CyclicBarrier barrier) {
        String threadName = Thread.currentThread().getName();
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Thread '" + threadName + "' was interrupted while waiting for the other threads!"));
        }
        catch (BrokenBarrierException e) {
            Assert.fail((String)("Thread '" + threadName + "' barrier was broken while waiting for the other threads!"));
        }
    }

    private static KieContainerImpl createMockKieContainer(ReleaseId projectReleaseId, KieRepositoryImpl.KieModuleRepo kieModuleRepo) throws Exception {
        InternalKieModule mockKieProjectKieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
        ResourceProvider mockKieProjectKieModuleResourceProvider = (ResourceProvider)Mockito.mock(ResourceProvider.class);
        Mockito.when((Object)mockKieProjectKieModule.createResourceProvider()).thenReturn((Object)mockKieProjectKieModuleResourceProvider);
        KieModuleKieProject kieProject = new KieModuleKieProject(mockKieProjectKieModule);
        KieModuleKieProject mockKieProject = (KieModuleKieProject)Mockito.spy((Object)kieProject);
        ((KieModuleKieProject)Mockito.doNothing().when((Object)mockKieProject)).init();
        ((KieModuleKieProject)Mockito.doReturn((Object)projectReleaseId).when((Object)mockKieProject)).getGAV();
        ((KieModuleKieProject)Mockito.doReturn(new HashMap()).when((Object)mockKieProject)).updateToModule((InternalKieModule)ArgumentMatchers.any(InternalKieModule.class));
        KieRepositoryImpl kieRepository = new KieRepositoryImpl();
        Field kieModuleRepoField = KieRepositoryImpl.class.getDeclaredField("kieModuleRepo");
        kieModuleRepoField.setAccessible(true);
        kieModuleRepoField.set(kieRepository, kieModuleRepo);
        kieModuleRepoField.setAccessible(false);
        KieContainerImpl kieContainerImpl = new KieContainerImpl((KieProject)mockKieProject, (KieRepository)kieRepository);
        return kieContainerImpl;
    }

    private static int countKieModules(Map<String, NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule>> kieModulesCache) {
        int numKieModules = 0;
        for (NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule> map : kieModulesCache.values()) {
            numKieModules += map.size();
        }
        return numKieModules;
    }

    private static void setCacheSize(Field field, Object fieldObject, Object newValue) throws Exception {
        field.setAccessible(true);
        field.set(null, newValue);
        field.set(fieldObject, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testDeployTwoArtifactVersionsSameTime() throws Exception {
        String groupId = "org";
        String artifactId = "one";
        String firstVersion = "1.0";
        String secondVersion = "1.0-NEW-FEATURE";
        CyclicBarrier storeOperationBarrier = new CyclicBarrier(2);
        CyclicBarrier threadsFinishedBarrier = new CyclicBarrier(3);
        Thread firstThread = new Thread(this.getStoreArtifactRunnable(this.kieModuleRepo, "org", "one", "1.0", storeOperationBarrier, threadsFinishedBarrier));
        Thread secondThread = new Thread(this.getStoreArtifactRunnable(this.kieModuleRepo, "org", "one", "1.0-NEW-FEATURE", storeOperationBarrier, threadsFinishedBarrier));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            firstThread.setName("normal");
            executor.submit(firstThread);
            secondThread.setName("newFeature");
            executor.submit(secondThread);
            KieModuleRepoTest.waitFor(threadsFinishedBarrier);
        }
        finally {
            executor.shutdownNow();
        }
        String ga = "org:one";
        Map artifactMap = (Map)this.kieModuleRepo.kieModules.get("org:one");
        ReleaseIdComparator.ComparableVersion normalVersion = new ReleaseIdComparator.ComparableVersion("1.0");
        KieModule normalKieModule = (KieModule)artifactMap.get(normalVersion);
        ReleaseIdComparator.ComparableVersion newFeatureVersion = new ReleaseIdComparator.ComparableVersion("1.0-NEW-FEATURE");
        KieModule newFeatureKieModule = (KieModule)artifactMap.get(newFeatureVersion);
        Assert.assertNotNull((String)"Race condition occurred: normal KieModule disappeared from KieModuleRepo!", (Object)normalKieModule);
        Assert.assertNotNull((String)"Race condition occurred: new feature KieModule disappeared from KieModuleRepo!", (Object)newFeatureKieModule);
    }

    public Runnable getStoreArtifactRunnable(KieRepositoryImpl.KieModuleRepo kieModuleRepo, String groupId, String artifactId, String version, CyclicBarrier storeOperationBarrier, CyclicBarrier threadsFinishedBarrier) {
        return () -> {
            ReleaseIdImpl firstReleaseId = new ReleaseIdImpl(groupId, artifactId, version);
            KieModule firstKieModule = (KieModule)Mockito.mock(KieModule.class);
            Mockito.when((Object)firstKieModule.getReleaseId()).thenReturn((Object)firstReleaseId);
            KieModuleRepoTest.waitFor(storeOperationBarrier);
            kieModuleRepo.store(firstKieModule);
            KieModuleRepoTest.waitFor(threadsFinishedBarrier);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void removeStoreArtifactMapTest() throws Exception {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("org", "redeploy", "2.0");
        InternalKieModule originalKieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
        Mockito.when((Object)originalKieModule.getReleaseId()).thenReturn((Object)releaseId);
        Mockito.when((Object)originalKieModule.getCreationTimestamp()).thenReturn((Object)0L);
        InternalKieModule redeployKieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
        Mockito.when((Object)redeployKieModule.getReleaseId()).thenReturn((Object)releaseId);
        Mockito.when((Object)redeployKieModule.getCreationTimestamp()).thenReturn((Object)1L);
        this.kieModuleRepo.store((KieModule)originalKieModule);
        CyclicBarrier storeRemoveOperationBarrier = new CyclicBarrier(2);
        CyclicBarrier operationsSerializationBarrier = new CyclicBarrier(2);
        CyclicBarrier threadsFinishedBarrier = new CyclicBarrier(3);
        Runnable removeRunnable = () -> {
            KieModuleRepoTest.waitFor(storeRemoveOperationBarrier);
            this.kieModuleRepo.remove((ReleaseId)releaseId);
            KieModuleRepoTest.waitFor(operationsSerializationBarrier);
            KieModuleRepoTest.waitFor(threadsFinishedBarrier);
        };
        Runnable redeployRunnable = () -> {
            KieModuleRepoTest.waitFor(storeRemoveOperationBarrier);
            KieModuleRepoTest.waitFor(operationsSerializationBarrier);
            this.kieModuleRepo.store((KieModule)redeployKieModule);
            KieModuleRepoTest.waitFor(threadsFinishedBarrier);
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            executor.submit(removeRunnable);
            executor.submit(redeployRunnable);
            KieModuleRepoTest.waitFor(threadsFinishedBarrier);
        }
        finally {
            executor.shutdownNow();
        }
        String ga = releaseId.getGroupId() + ":" + releaseId.getArtifactId();
        Map artifactMap = (Map)this.kieModuleRepo.kieModules.get(ga);
        Assert.assertNotNull((String)("Artifact Map for GA '" + ga + "' not in KieModuleRepo!"), (Object)artifactMap);
        KieModule redeployedKieModule = (KieModule)artifactMap.get(new ReleaseIdComparator.ComparableVersion(releaseId.getVersion()));
        Assert.assertNotNull((String)"Redeployed module has disappeared from KieModuleRepo!", (Object)redeployedKieModule);
        Assert.assertEquals((String)"Original module retrieved instead of redeployed module!", (long)1L, (long)redeployKieModule.getCreationTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void newerVersionDeployOverwritesTest() throws Exception {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("org", "deployTwiceAfterUpdateDependency", "1.0");
        InternalKieModuleStub originalOldKieModule = new InternalKieModuleStub();
        ReleaseIdImpl dependentReleaseid = new ReleaseIdImpl("org", "deployTwiceAfterUpdate", "1.0");
        KieContainerImpl kieContainer = KieModuleRepoTest.createMockKieContainer((ReleaseId)dependentReleaseid, this.kieModuleRepo);
        this.kieModuleRepo.store((KieModule)originalOldKieModule);
        kieContainer.updateDependencyToVersion((ReleaseId)releaseId, (ReleaseId)releaseId);
        InternalKieModule newKieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
        Mockito.when((Object)newKieModule.getReleaseId()).thenReturn((Object)releaseId);
        Mockito.when((Object)newKieModule.getCreationTimestamp()).thenReturn((Object)10L);
        CyclicBarrier storeOperationBarrier = new CyclicBarrier(2);
        CyclicBarrier storeSerializationBarrier = new CyclicBarrier(2);
        CyclicBarrier threadsFinishedBarrier = new CyclicBarrier(3);
        Runnable deployRunnable = () -> {
            KieModuleRepoTest.waitFor(storeOperationBarrier);
            if (Thread.currentThread().getName().equals("two")) {
                KieModuleRepoTest.waitFor(storeSerializationBarrier);
            }
            this.kieModuleRepo.store((KieModule)newKieModule);
            if (Thread.currentThread().getName().equals("one")) {
                KieModuleRepoTest.waitFor(storeSerializationBarrier);
            }
            KieModuleRepoTest.waitFor(threadsFinishedBarrier);
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Thread deployThread = new Thread(deployRunnable);
            deployThread.setName("one");
            executor.submit(deployThread);
            Thread secondDeployThread = new Thread(deployRunnable);
            secondDeployThread.setName("two");
            executor.submit(secondDeployThread);
            KieModuleRepoTest.waitFor(threadsFinishedBarrier);
        }
        finally {
            executor.shutdownNow();
        }
        KieModule oldKieModule = (KieModule)this.kieModuleRepo.oldKieModules.get(releaseId);
        long oldKieModuleTimeStamp = ((InternalKieModule)oldKieModule).getCreationTimestamp();
        long originalKieModuleTimestamp = originalOldKieModule.getCreationTimestamp();
        Assert.assertEquals((String)"The old kie module in the repo is not the originally deployed module!", (long)originalKieModuleTimestamp, (long)oldKieModuleTimeStamp);
    }

    @Test
    public void storingNewProjectsCausesOldProjectEvictionFromKieModuleRepoTest() throws Exception {
        int i;
        KieModuleRepoTest.setCacheSize(this.maxSizeGaCacheField, null, 3);
        KieModuleRepoTest.setCacheSize(this.maxSizeGaVersionsCacheField, null, 2);
        ReleaseIdImpl[] releaseIds = new ReleaseIdImpl[7];
        for (i = 0; i < releaseIds.length; ++i) {
            String artifactId = Character.toString((char)(65 + i));
            releaseIds[i] = new ReleaseIdImpl("org", artifactId, "1.0");
        }
        for (i = 0; i < releaseIds.length; ++i) {
            InternalKieModule kieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
            Mockito.when((Object)kieModule.getReleaseId()).thenReturn((Object)releaseIds[i]);
            Mockito.when((Object)kieModule.getCreationTimestamp()).thenReturn((Object)10L);
            this.kieModuleRepo.store((KieModule)kieModule);
            this.kieModuleRepo.store((KieModule)kieModule);
        }
        int numKieModules = KieModuleRepoTest.countKieModules(this.kieModuleRepo.kieModules);
        Assert.assertEquals((String)("KieModuleRepo cache should not grow past " + KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE + ": "), (long)KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE, (long)numKieModules);
        int oldKieModulesSize = this.kieModuleRepo.oldKieModules.size();
        int max = KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE * KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE;
        Assert.assertTrue((String)("KieModuleRepot old KieModules map is not limited in it's growth: " + oldKieModulesSize + " > " + max), (oldKieModulesSize <= max ? 1 : 0) != 0);
    }

    @Test
    public void storingNewProjectVersionsCausesOldVersionEvictionFromKieModuleRepoTest() throws Exception {
        int i;
        KieModuleRepoTest.setCacheSize(this.maxSizeGaCacheField, null, 2);
        KieModuleRepoTest.setCacheSize(this.maxSizeGaVersionsCacheField, null, 3);
        ReleaseIdImpl[] releaseIds = new ReleaseIdImpl[7];
        for (i = 0; i < releaseIds.length; ++i) {
            releaseIds[i] = new ReleaseIdImpl("org", "test", "1." + i);
        }
        for (i = 0; i < releaseIds.length; ++i) {
            InternalKieModule kieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
            Mockito.when((Object)kieModule.getReleaseId()).thenReturn((Object)releaseIds[i]);
            Mockito.when((Object)kieModule.getCreationTimestamp()).thenReturn((Object)10L);
            this.kieModuleRepo.store((KieModule)kieModule);
            this.kieModuleRepo.store((KieModule)kieModule);
        }
        int numKieModules = KieModuleRepoTest.countKieModules(this.kieModuleRepo.kieModules);
        Assert.assertEquals((String)("KieModuleRepo cache should not grow past " + KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE + ": "), (long)KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE, (long)numKieModules);
        int oldKieModulesSize = this.kieModuleRepo.oldKieModules.size();
        int maxOldKieModules = KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE * KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE;
        Assert.assertTrue((String)("KieModuleRepo old KieModules map is not limited in it's growth: " + oldKieModulesSize + " > " + maxOldKieModules), (oldKieModulesSize <= maxOldKieModules ? 1 : 0) != 0);
        for (int o = 0; o < 2; ++o) {
            for (int i2 = 0; i2 < releaseIds.length; ++i2) {
                InternalKieModule kieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
                Mockito.when((Object)kieModule.getReleaseId()).thenReturn((Object)releaseIds[i2]);
                Mockito.when((Object)kieModule.getCreationTimestamp()).thenReturn((Object)10L);
                this.kieModuleRepo.store((KieModule)kieModule);
            }
        }
        numKieModules = KieModuleRepoTest.countKieModules(this.kieModuleRepo.kieModules);
        Assert.assertEquals((String)("KieModuleRepo cache should not grow past " + KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE + ": "), (long)KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE, (long)numKieModules);
        oldKieModulesSize = this.kieModuleRepo.oldKieModules.size();
        Assert.assertTrue((String)("KieModuleRepo old KieModules map is not limited in it's growth: " + oldKieModulesSize + " > " + maxOldKieModules), (oldKieModulesSize <= maxOldKieModules ? 1 : 0) != 0);
    }

    @Test
    public void testOldKieModulesLRUCache() throws Exception {
        int i;
        KieModuleRepoTest.setCacheSize(this.maxSizeGaCacheField, null, 2);
        KieModuleRepoTest.setCacheSize(this.maxSizeGaVersionsCacheField, null, 4);
        ReleaseIdImpl[] releaseIds = new ReleaseIdImpl[9];
        for (i = 0; i < releaseIds.length; ++i) {
            String artifactId = Character.toString((char)(65 + i / 2));
            releaseIds[i] = new ReleaseIdImpl("org", artifactId, "1." + i);
        }
        for (i = 0; i < releaseIds.length; ++i) {
            InternalKieModule kieModule = (InternalKieModule)Mockito.mock(InternalKieModule.class);
            Mockito.when((Object)kieModule.getReleaseId()).thenReturn((Object)releaseIds[i]);
            Mockito.when((Object)kieModule.getCreationTimestamp()).thenReturn((Object)10L);
            this.kieModuleRepo.store((KieModule)kieModule);
            this.kieModuleRepo.store((KieModule)kieModule);
        }
        int maxSameGAModules = 0;
        int maxGAs = 0;
        for (Map artifactMap : this.kieModuleRepo.kieModules.values()) {
            ++maxGAs;
            if (artifactMap.size() <= maxSameGAModules) continue;
            maxSameGAModules = artifactMap.size();
        }
        Assert.assertTrue((String)("The maximum of artifacts per GA should not grow past " + KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE + ": " + KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE + " < " + maxSameGAModules), (KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE >= maxSameGAModules ? 1 : 0) != 0);
        Assert.assertTrue((String)("The number of GAs not grow past " + KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE + ": " + KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE + " > " + maxGAs), (KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE >= maxGAs ? 1 : 0) != 0);
        int oldKieModulesSize = this.kieModuleRepo.oldKieModules.size();
        int maxOldKieModules = KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_CACHE * KieRepositoryImpl.KieModuleRepo.MAX_SIZE_GA_VERSIONS_CACHE;
        Assert.assertTrue((String)("KieModuleRepo old KieModules map is not limited in it's growth: " + oldKieModulesSize + " > " + maxOldKieModules), (oldKieModulesSize <= maxOldKieModules ? 1 : 0) != 0);
    }

    private static class InternalKieModuleStub
    implements InternalKieModule {
        private InternalKieModuleStub() {
        }

        public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
            throw new UnsupportedOperationException();
        }

        public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
            throw new UnsupportedOperationException();
        }

        public InternalKnowledgePackage getPackage(String packageName) {
            throw new UnsupportedOperationException();
        }

        public Collection<KiePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
            throw new UnsupportedOperationException();
        }

        public void cacheResultsForKieBase(String kieBaseName, Results results) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Results> getKnowledgeResultsCache() {
            throw new UnsupportedOperationException();
        }

        public KieModuleModel getKieModuleModel() {
            return null;
        }

        public byte[] getBytes() {
            throw new UnsupportedOperationException();
        }

        public boolean hasResource(String fileName) {
            throw new UnsupportedOperationException();
        }

        public InternalResource getResource(String fileName) {
            throw new UnsupportedOperationException();
        }

        public ResourceConfiguration getResourceConfiguration(String fileName) {
            throw new UnsupportedOperationException();
        }

        public Map<ReleaseId, InternalKieModule> getKieDependencies() {
            throw new UnsupportedOperationException();
        }

        public void addKieDependency(InternalKieModule dependency) {
            throw new UnsupportedOperationException();
        }

        public Collection<ReleaseId> getJarDependencies(DependencyFilter filter) {
            throw new UnsupportedOperationException();
        }

        public Collection<ReleaseId> getUnresolvedDependencies() {
            throw new UnsupportedOperationException();
        }

        public void setUnresolvedDependencies(Collection<ReleaseId> unresolvedDependencies) {
            throw new UnsupportedOperationException();
        }

        public boolean isAvailable(String pResourceName) {
            throw new UnsupportedOperationException();
        }

        public byte[] getBytes(String pResourceName) {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getFileNames() {
            return Collections.emptyList();
        }

        public File getFile() {
            throw new UnsupportedOperationException();
        }

        public ResourceProvider createResourceProvider() {
            throw new UnsupportedOperationException();
        }

        public Map<String, byte[]> getClassesMap() {
            throw new UnsupportedOperationException();
        }

        public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName) {
            throw new UnsupportedOperationException();
        }

        public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName, ResourceChangeSet rcs) {
            throw new UnsupportedOperationException();
        }

        public long getCreationTimestamp() {
            return 0L;
        }

        public InputStream getPomAsStream() {
            throw new UnsupportedOperationException();
        }

        public PomModel getPomModel() {
            throw new UnsupportedOperationException();
        }

        public KnowledgeBuilderConfiguration createBuilderConfiguration(KieBaseModel kBaseModel, ClassLoader classLoader) {
            throw new UnsupportedOperationException();
        }

        public InternalKnowledgeBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, BuildContext buildContext, KieBaseConfiguration conf) {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getModuleClassLoader() {
            return null;
        }

        public ReleaseId getReleaseId() {
            return new ReleaseIdImpl("org", "deployTwiceAfterUpdateDependency", "1.0");
        }
    }
}

