/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.lang.DescrDumper;
import org.drools.compiler.lang.DumperContext;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.core.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.core.base.evaluators.SetEvaluatorsDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DescrDumperTest {
    private DescrDumper dumper;

    @Before
    public void setUp() throws Exception {
        new SetEvaluatorsDefinition();
        new MatchesEvaluatorsDefinition();
        this.dumper = new DescrDumper();
    }

    @Test
    public void testDump() throws Exception {
        String input = "price > 10 && < 20 || == $val || == 30";
        String expected = "( price > 10 && price < 20 || price == $val || price == 30 )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpMatches() throws Exception {
        String input = "type.toString matches \"something\\swith\\tsingle escapes\"";
        String expected = "type.toString ~= \"something\\swith\\tsingle escapes\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpMatches2() throws Exception {
        String input = "type.toString matches 'something\\swith\\tsingle escapes'";
        String expected = "type.toString ~= \"something\\swith\\tsingle escapes\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpMatches3() throws Exception {
        String input = "this[\"content\"] matches \"hello ;=\"";
        String expected = "this[\"content\"] ~= \"hello ;=\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpContains() throws Exception {
        String input = "list contains \"b\"";
        String expected = "list contains \"b\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpContains2() throws Exception {
        String input = "list not contains \"b\"";
        String expected = "!( list contains \"b\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpExcludes() throws Exception {
        String input = "list excludes \"b\"";
        String expected = "!( list contains \"b\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpExcludes2() throws Exception {
        String input = "list not excludes \"b\"";
        String expected = "list contains \"b\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    @Ignore
    public void testDumpWithDateAttr() throws Exception {
        String input = "son.birthDate == \"01-jan-2000\"";
        String expected = "son.birthDate == org.drools.util.DateUtils.parseDate( \"01-jan-2000\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpComplex() throws Exception {
        String input = "a ( > 60 && < 70 ) || ( > 50 && < 55 ) && a3 == \"black\" || a == 40 && a3 == \"pink\" || a == 12 && a3 == \"yellow\" || a3 == \"blue\"";
        String expected = "( ( a > 60 && a < 70 || a > 50 && a < 55 ) && a3 == \"black\" || a == 40 && a3 == \"pink\" || a == 12 && a3 == \"yellow\" || a3 == \"blue\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpBindings() throws Exception {
        String input = "$x : property > value";
        String expected = "property > value";
        ConstraintConnectiveDescr descr = this.parse(input);
        DumperContext ctx = new DumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assert.assertEquals((Object)expected, (Object)result);
        Assert.assertEquals((long)1L, (long)ctx.getBindings().size());
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"property", (Object)bind.getExpression());
    }

    @Test
    public void testDumpBindings2() throws Exception {
        String input = "( $a : a > $b : b[10].prop || 10 != 20 ) && $x : someMethod(10) == 20";
        String expected = "( a > b[10].prop || 10 != 20 ) && someMethod(10) == 20";
        ConstraintConnectiveDescr descr = this.parse(input);
        DumperContext ctx = new DumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assert.assertEquals((Object)expected, (Object)result);
        Assert.assertEquals((long)3L, (long)ctx.getBindings().size());
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assert.assertEquals((Object)"$a", (Object)bind.getVariable());
        Assert.assertEquals((Object)"a", (Object)bind.getExpression());
        bind = (BindingDescr)ctx.getBindings().get(1);
        Assert.assertEquals((Object)"$b", (Object)bind.getVariable());
        Assert.assertEquals((Object)"b[10].prop", (Object)bind.getExpression());
        bind = (BindingDescr)ctx.getBindings().get(2);
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"someMethod(10)", (Object)bind.getExpression());
    }

    @Test
    public void testDumpBindings3() throws Exception {
        String input = "( $a : a > $b : b[10].prop || 10 != 20 ) && $x : someMethod(10)";
        String expected = "( a > b[10].prop || 10 != 20 )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpBindings4() throws Exception {
        String input = "( $a : a > $b : b[10].prop || $x : someMethod(10) ) && 10 != 20";
        String expected = "( a > b[10].prop ) && 10 != 20";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpBindingsWithRestriction() throws Exception {
        String input = "$x : age > 10 && < 20 || > 30";
        String expected = "( age > 10 && age < 20 || age > 30 )";
        ConstraintConnectiveDescr descr = this.parse(input);
        DumperContext ctx = new DumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assert.assertEquals((Object)expected, (Object)result);
        Assert.assertEquals((long)1L, (long)ctx.getBindings().size());
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"age", (Object)bind.getExpression());
    }

    @Test
    public void testDumpBindingsComplexOp() throws Exception {
        String input = "$x : age in (10, 20, $someVal)";
        String expected = "( age == 10 || age == 20 || age == $someVal )";
        ConstraintConnectiveDescr descr = this.parse(input);
        DumperContext ctx = new DumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assert.assertEquals((Object)expected, (Object)result);
        Assert.assertEquals((long)1L, (long)ctx.getBindings().size());
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"age", (Object)bind.getExpression());
    }

    @Test
    public void testDumpBindingsComplexOp2() throws Exception {
        String input = "$x : age not in (10, 20, $someVal)";
        String expected = "age != 10 && age != 20 && age != $someVal";
        ConstraintConnectiveDescr descr = this.parse(input);
        DumperContext ctx = new DumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assert.assertEquals((Object)expected, (Object)result);
        Assert.assertEquals((long)1L, (long)ctx.getBindings().size());
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"age", (Object)bind.getExpression());
    }

    @Test
    public void testProcessInlineCast() throws Exception {
        String expr = "field1#Class.field2";
        String expectedInstanceof = "field1 instanceof Class";
        String expectedcasted = "((Class)field1).field2";
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        ConstraintConnectiveDescr ccd = new ConstraintConnectiveDescr();
        ccd.addDescr((BaseDescr)atomicExpr);
        String[] instanceofAndCastedExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assert.assertEquals((long)2L, (long)ccd.getDescrs().size());
        Assert.assertEquals((Object)expectedInstanceof, (Object)((BaseDescr)ccd.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)expectedcasted, (Object)atomicExpr.getRewrittenExpression());
        expr = "field1#Class1.field2#Class2.field3";
        String expectedInstanceof1 = "field1 instanceof Class1";
        String expectedInstanceof2 = "((Class1)field1).field2 instanceof Class2";
        expectedcasted = "((Class2)((Class1)field1).field2).field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        instanceofAndCastedExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assert.assertEquals((Object)expectedInstanceof1, (Object)((BaseDescr)ccd.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)expectedInstanceof2, (Object)((BaseDescr)ccd.getDescrs().get(1)).toString());
        Assert.assertEquals((Object)expectedcasted, (Object)instanceofAndCastedExpr[1]);
        Assert.assertEquals((Object)expectedcasted, (Object)atomicExpr.getRewrittenExpression());
    }

    @Test
    public void testProcessNullSafeDereferencing() throws Exception {
        String expr = "field1!.field2";
        String expectedNullCheck = "field1 != null";
        String expectedExpr = "field1.field2";
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        ConstraintConnectiveDescr ccd = new ConstraintConnectiveDescr();
        String[] nullCheckAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assert.assertEquals((Object)expectedNullCheck, (Object)((BaseDescr)ccd.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)expectedExpr, (Object)nullCheckAndExpr[1]);
        Assert.assertEquals((Object)expectedExpr, (Object)atomicExpr.getRewrittenExpression());
        expr = "field1!.field2!.field3";
        String expectedNullCheck1 = "field1 != null";
        String expectedNullCheck2 = "field1.field2 != null";
        expectedExpr = "field1.field2.field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        nullCheckAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assert.assertEquals((Object)expectedNullCheck1, (Object)((BaseDescr)ccd.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)expectedNullCheck2, (Object)((BaseDescr)ccd.getDescrs().get(1)).toString());
        Assert.assertEquals((Object)expectedExpr, (Object)nullCheckAndExpr[1]);
        Assert.assertEquals((Object)expectedExpr, (Object)atomicExpr.getRewrittenExpression());
    }

    @Test
    public void testProcessImplicitConstraints() throws Exception {
        String expr = "field1#Class!.field2";
        String expectedConstraints = "field1 instanceof Class";
        String expectedExpr = "((Class)field1).field2";
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        ConstraintConnectiveDescr ccd = new ConstraintConnectiveDescr();
        String[] constraintsAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assert.assertEquals((Object)expectedConstraints, (Object)((BaseDescr)ccd.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)expectedExpr, (Object)constraintsAndExpr[1]);
        Assert.assertEquals((Object)expectedExpr, (Object)atomicExpr.getRewrittenExpression());
        expr = "field1!.field2#Class.field3";
        String expectedConstraints1 = "field1 != null";
        String expectedConstraints2 = "field1.field2 instanceof Class";
        expectedExpr = "((Class)field1.field2).field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        constraintsAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assert.assertEquals((Object)expectedConstraints1, (Object)((BaseDescr)ccd.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)expectedConstraints2, (Object)((BaseDescr)ccd.getDescrs().get(1)).toString());
        Assert.assertEquals((Object)expectedExpr, (Object)constraintsAndExpr[1]);
        Assert.assertEquals((Object)expectedExpr, (Object)atomicExpr.getRewrittenExpression());
        expr = "field1#Class.field2!.field3";
        expectedConstraints1 = "field1 instanceof Class";
        expectedConstraints2 = "((Class)field1).field2 != null";
        expectedExpr = "((Class)field1).field2.field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        constraintsAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assert.assertEquals((Object)expectedConstraints1, (Object)((BaseDescr)ccd.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)expectedConstraints2, (Object)((BaseDescr)ccd.getDescrs().get(1)).toString());
        Assert.assertEquals((Object)expectedExpr, (Object)constraintsAndExpr[1]);
        Assert.assertEquals((Object)expectedExpr, (Object)atomicExpr.getRewrittenExpression());
    }

    public ConstraintConnectiveDescr parse(String constraint) {
        DrlExprParser parser = new DrlExprParser(LanguageLevelOption.DRL6);
        ConstraintConnectiveDescr result = parser.parse(constraint);
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        return result;
    }
}

