/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.extractors;

import java.util.Vector;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.test.model.Address;
import org.drools.core.test.model.Person;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.extractors.MVELObjectClassFieldReader;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MVELClassFieldExtractorTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    MVELObjectClassFieldReader extractor;
    private final Person[] person = new Person[2];
    private final Address[] business = new Address[2];
    private final Address[] home = new Address[2];

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.extractor = (MVELObjectClassFieldReader)this.store.getMVELReader(Person.class.getPackage().getName(), Person.class.getName(), "addresses['home'].street", true, String.class);
        MVELDialectRuntimeData data = new MVELDialectRuntimeData();
        data.addImport(Person.class.getSimpleName(), Person.class);
        data.onAdd(null, (ClassLoader)ProjectClassLoader.createProjectClassLoader());
        this.extractor.compile(data);
        this.person[0] = new Person("bob", 30);
        this.business[0] = new Address("Business Street", "999", null);
        this.home[0] = new Address("Home Street", "555", "55555555");
        this.person[0].getAddresses().put("business", this.business[0]);
        this.person[0].getAddresses().put("home", this.home[0]);
        this.person[1] = new Person("mark", 35);
        this.business[1] = new Address("Another Business Street", "999", null);
        this.home[1] = new Address("Another Home Street", "555", "55555555");
        this.person[1].getAddresses().put("business", this.business[1]);
        this.person[1].getAddresses().put("home", this.home[1]);
    }

    @Test
    public void testGetBooleanValue() {
        try {
            this.extractor.getBooleanValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetByteValue() {
        try {
            this.extractor.getByteValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetCharValue() {
        try {
            this.extractor.getCharValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetDoubleValue() {
        try {
            this.extractor.getDoubleValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetFloatValue() {
        try {
            this.extractor.getFloatValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetIntValue() {
        try {
            this.extractor.getIntValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetLongValue() {
        try {
            this.extractor.getLongValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetShortValue() {
        try {
            this.extractor.getShortValue(null, (Object)this.person[0]);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetValue() {
        try {
            Assert.assertEquals((Object)this.home[0].getStreet(), (Object)this.extractor.getValue(null, (Object)this.person[0]));
            Assert.assertTrue((boolean)(this.extractor.getValue(null, (Object)this.person[0]) instanceof String));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Test
    public void testIsNullValue() {
        try {
            Assert.assertFalse((boolean)this.extractor.isNullValue(null, (Object)this.person[0]));
            MVELObjectClassFieldReader nullExtractor = (MVELObjectClassFieldReader)this.store.getMVELReader(Person.class.getPackage().getName(), Person.class.getName(), "addresses['business'].phone", true, String.class);
            MVELDialectRuntimeData data = new MVELDialectRuntimeData();
            data.addImport(Person.class.getSimpleName(), Person.class);
            data.onAdd(null, (ClassLoader)ProjectClassLoader.createProjectClassLoader());
            nullExtractor.compile(data);
            Assert.assertTrue((boolean)nullExtractor.isNullValue(null, (Object)this.person[0]));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Test
    public void testMultithreads() {
        int THREAD_COUNT = 30;
        try {
            final Vector errors = new Vector();
            Thread[] t = new Thread[30];
            for (int j = 0; j < 10; ++j) {
                int i;
                for (i = 0; i < t.length; ++i) {
                    final int ID = i;
                    t[i] = new Thread(){

                        @Override
                        public void run() {
                            try {
                                int ITERATIONS = 300;
                                for (int k = 0; k < 300; ++k) {
                                    String value = (String)MVELClassFieldExtractorTest.this.extractor.getValue(null, (Object)MVELClassFieldExtractorTest.this.person[ID % 2]);
                                    if (MVELClassFieldExtractorTest.this.home[ID % 2].getStreet().equals(value)) continue;
                                    errors.add("THREAD(" + ID + "): Wrong value at iteration " + k + ". Value='" + value + "'\n");
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                errors.add(ex);
                            }
                        }
                    };
                    t[i].start();
                }
                for (i = 0; i < t.length; ++i) {
                    t[i].join();
                }
            }
            if (!errors.isEmpty()) {
                Assert.fail((String)(" Errors occured during execution\n" + errors.toString()));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception running test: " + e.getMessage()));
        }
    }
}

