/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MergePackageTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MergePackageTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMergingDifferentPackages2() throws Exception {
        try {
            Collection kpkgs1 = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuleNameClashes1.drl"}).getKiePackages();
            KiePackage kpkg1 = kpkgs1.stream().filter(pkg -> pkg.getName().equals("org.drools.package1")).findFirst().get();
            Assert.assertEquals((long)1L, (long)kpkg1.getRules().size());
            Collection kpkgs2 = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuleNameClashes2.drl"}).getKiePackages();
            KiePackage kpkg2 = kpkgs2.stream().filter(pkg -> pkg.getName().equals("org.drools.package2")).findFirst().get();
            Assert.assertEquals((long)1L, (long)kpkg2.getRules().size());
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
            kbase.addPackages(kpkgs1);
            kbase.addPackages(kpkgs2);
            KieSession ksession = kbase.newKieSession();
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.insert((Object)new Cheese("stilton", 10));
            ksession.insert((Object)new Cheese("brie", 5));
            ksession.fireAllRules();
            Assert.assertEquals((String)((Object)results).toString(), (long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains("p1.r1"));
            Assert.assertTrue((boolean)results.contains("p2.r1"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testMergePackageWithSameRuleNames() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MergePackageWithSameRuleNames1.drl"});
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MergePackageWithSameRuleNames2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"rule1 for the package2", results.get(0));
    }

    @Test
    public void testMergingDifferentPackages() throws Exception {
        try {
            Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuleNameClashes1.drl", "test_RuleNameClashes2.drl"}).getKiePackages();
            Assert.assertEquals((long)3L, (long)kpkgs.size());
            for (KiePackage kpkg : kpkgs) {
                if (!kpkg.getName().equals("org.drools.package1")) continue;
                Assert.assertEquals((Object)"rule 1", (Object)((Rule)kpkg.getRules().iterator().next()).getName());
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }
}

