/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.Rete;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class PassiveQueryTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PassiveQueryTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testPassiveQuery() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( $i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession.insert((Object)2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testPassiveQueryNoDataDriven() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( $i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testPassiveQueryDataDriven() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R @Propagation(IMMEDIATE) when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( $i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testReactiveQueryDataDriven() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R @Propagation(IMMEDIATE) when\n    $i : Integer()\n    Q( $i; )\nthen\n    list.add( $i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testPassiveQueryDataDrivenWithBeta() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R @Propagation(IMMEDIATE) when\n    $i : Integer()\n    $j : Integer( this == $i+1 )\n    ?Q( $j; )\nthen\n    list.add( $j );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testPassiveQueryNodeSharing() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R1 @Propagation(IMMEDIATE) when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( \"R1\" );\nend\nrule R2 when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( \"R2\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"R2", list.get(0));
    }

    @Test
    public void testPassiveQueryNodeSharing2() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R1a @Propagation(IMMEDIATE) when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( \"R1a\" );\nend\nrule R1b @Propagation(IMMEDIATE) when\n    Long( $i : intValue )\n    ?Q( $i; )\nthen\n    list.add( \"R1b\" );\nend\nrule R2a when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( \"R2a\" );\nend\nrule R2b when\n    Long( $i : intValue )\n    ?Q( $i; )\nthen\n    list.add( \"R2b\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)1L);
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("R2a", "R2b")));
    }

    @Test
    public void testPassiveQueryUsingSegmentPropagator() throws Exception {
        String str = "global java.util.List list\nquery Q (Integer i)\n    String( this == i.toString() )\nend\nrule R1a @Propagation(IMMEDIATE) when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( \"R1a\" );\nend\nrule R1b @Propagation(IMMEDIATE) when\n    $i : Integer()\n    ?Q( $i; )\n    Long( intValue == $i )\nthen\n    list.add( \"R1b\" );\nend\nrule R2 when\n    $i : Integer()\n    ?Q( $i; )\nthen\n    list.add( \"R2\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1L);
        FactHandle fh = ksession.insert((Object)1);
        ksession.insert((Object)"1");
        Rete rete = ((RuleBase)kbase).getRete();
        LeftInputAdapterNode lia = null;
        for (ObjectTypeNode otn : rete.getObjectTypeNodes()) {
            if (Integer.class != otn.getObjectType().getValueType().getClassType()) continue;
            lia = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
            break;
        }
        LeftTupleSink[] sinks = lia.getSinkPropagator().getSinks();
        QueryElementNode q1 = (QueryElementNode)sinks[0];
        QueryElementNode q2 = (QueryElementNode)sinks[1];
        InternalWorkingMemory wm = (InternalWorkingMemory)ksession;
        wm.flushPropagations();
        Memory memory1 = wm.getNodeMemory((MemoryFactory)q1);
        Assert.assertTrue((boolean)memory1.getSegmentMemory().getStagedLeftTuples().isEmpty());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"R2", list.get(0));
        list.clear();
        ksession.delete(fh);
        ksession.insert((Object)1);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }
}

