/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.ConstraintTestUtil;
import org.drools.mvel.model.Cheese;
import org.drools.mvel.model.MockObjectSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class AlphaNodeTest
extends DroolsTestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private final boolean useLambdaConstraint;

    public AlphaNodeTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Parameterized.Parameters(name="useLambdaConstraint={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testLiteralConstraintAssertObjectWithoutMemory() throws Exception {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext((RuleBase)kBase, Collections.emptyList());
        buildContext.setRule(new RuleImpl("test"));
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        RuleImpl rule = new RuleImpl("test-rule");
        PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        PropagationContext context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextNodeId());
        AlphaNodeFieldConstraint constraint = ConstraintTestUtil.createCheeseTypeEqualsConstraint(this.store, "cheddar", this.useLambdaConstraint);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextNodeId(), constraint, (ObjectSource)source, buildContext);
        MockObjectSink sink = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink);
        Cheese cheddar = new Cheese("cheddar", 5);
        DefaultFactHandle f0 = (DefaultFactHandle)ksession.insert((Object)cheddar);
        this.assertLength(0, sink.getAsserted());
        alphaNode.assertObject((InternalFactHandle)f0, context, (ReteEvaluator)ksession);
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
        Object[] list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)ksession.getObject((FactHandle)((DefaultFactHandle)list[0])));
        Cheese stilton = new Cheese("stilton", 6);
        DefaultFactHandle f1 = new DefaultFactHandle(1L, (Object)stilton);
        alphaNode.assertObject((InternalFactHandle)f1, context, (ReteEvaluator)ksession);
        this.assertLength(1, sink.getAsserted());
        list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)ksession.getObject((FactHandle)((DefaultFactHandle)list[0])));
    }

    @Test
    public void testReturnValueConstraintAssertObject() throws Exception {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext((RuleBase)kBase, Collections.emptyList());
        buildContext.setRule(new RuleImpl("test"));
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        RuleImpl rule = new RuleImpl("test-rule");
        PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        PropagationContext context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextNodeId());
        AlphaNodeFieldConstraint constraint = ConstraintTestUtil.createCheeseTypeEqualsConstraint(this.store, "cheddar", this.useLambdaConstraint);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextNodeId(), constraint, (ObjectSource)source, buildContext);
        MockObjectSink sink = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink);
        Cheese cheddar = new Cheese("cheddar", 5);
        DefaultFactHandle f0 = (DefaultFactHandle)ksession.insert((Object)cheddar);
        this.assertLength(0, sink.getAsserted());
        alphaNode.assertObject((InternalFactHandle)f0, context, (ReteEvaluator)ksession);
        this.assertLength(1, sink.getAsserted());
        Object[] list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)ksession.getObject((FactHandle)((DefaultFactHandle)list[0])));
        Cheese stilton = new Cheese("stilton", 6);
        f0.setObject((Object)stilton);
        sink.getAsserted().clear();
        alphaNode.assertObject((InternalFactHandle)f0, context, (ReteEvaluator)ksession);
        this.assertLength(0, sink.getAsserted());
    }

    @Test
    public void testUpdateSinkWithoutMemory() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext((RuleBase)kBase, Collections.emptyList());
        buildContext.setRule(new RuleImpl("test"));
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        RuleImpl rule = new RuleImpl("test-rule");
        PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        PropagationContext context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextNodeId());
        AlphaNodeFieldConstraint constraint = ConstraintTestUtil.createCheeseTypeEqualsConstraint(this.store, "cheddar", this.useLambdaConstraint);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextNodeId(), constraint, (ObjectSource)source, buildContext);
        alphaNode.attach(buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink1);
        Cheese cheese = new Cheese("cheddar", 0);
        DefaultFactHandle handle1 = new DefaultFactHandle(1L, (Object)cheese);
        source.addFact((InternalFactHandle)handle1);
        alphaNode.assertObject((InternalFactHandle)handle1, context, (ReteEvaluator)ksession);
        Cheese stilton = new Cheese("stilton", 10);
        DefaultFactHandle handle2 = new DefaultFactHandle(2L, (Object)stilton);
        source.addFact((InternalFactHandle)handle2);
        alphaNode.assertObject((InternalFactHandle)handle2, context, (ReteEvaluator)ksession);
        this.assertLength(1, sink1.getAsserted());
        MockObjectSink sink2 = new MockObjectSink();
        alphaNode.updateSink((ObjectSink)sink2, context, (InternalWorkingMemory)ksession);
        this.assertLength(1, sink1.getAsserted());
        this.assertLength(1, sink2.getAsserted());
        Assert.assertEquals((long)1L, (long)source.getUdated());
    }
}

