/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.util.Entry;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.model.Index;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate2;
import org.drools.model.index.BetaIndexImpl;
import org.drools.modelcompiler.util.EvaluationUtil;
import org.drools.mvel.LambdaConstraintTestUtil;
import org.drools.mvel.MVELConstraintTestUtil;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class BaseTupleIndexHashTableIteratorTest {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();
    protected boolean useLambdaConstraint;

    @Parameterized.Parameters(name="useLambdaConstraint={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    protected static BetaNodeFieldConstraint createFooThisEqualsDBetaConstraint(boolean useLambdaConstraint) {
        if (useLambdaConstraint) {
            return BaseTupleIndexHashTableIteratorTest.createFooThisEqualsDBetaConstraintWithLambdaConstraint();
        }
        return BaseTupleIndexHashTableIteratorTest.createFooThisEqualsDBetaConstraintWithMvelConstraint();
    }

    private static BetaNodeFieldConstraint createFooThisEqualsDBetaConstraintWithLambdaConstraint() {
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Foo.class));
        Pattern varPattern = new Pattern(1, (ObjectType)new ClassObjectType(Foo.class));
        Predicate2.Impl predicate = new Predicate2.Impl((Predicate2 & Serializable)(_this, d) -> EvaluationUtil.areNullSafeEquals((Object)_this, (Object)d));
        BetaIndexImpl index = new BetaIndexImpl(Foo.class, Index.ConstraintType.EQUAL, 1, (Function1 & Serializable)_this -> _this, (Function1 & Serializable)d -> d, Foo.class);
        return LambdaConstraintTestUtil.createLambdaConstraint2(Foo.class, Foo.class, pattern, varPattern, "d", predicate, index);
    }

    private static BetaNodeFieldConstraint createFooThisEqualsDBetaConstraintWithMvelConstraint() {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(Foo.class, "this");
        Declaration declaration = new Declaration("d", (InternalReadAccessor)extractor, new Pattern(0, (ObjectType)new ClassObjectType(Foo.class)));
        String expression = "this " + Operator.BuiltInOperator.EQUAL.getOperator().getOperatorString() + " d";
        return new MVELConstraintTestUtil(expression, declaration, (InternalReadAccessor)extractor);
    }

    protected List createTableIndexListForAssertion(TupleIndexHashTable hashTable) {
        Entry[] table = hashTable.getTable();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == null) continue;
            ArrayList<Integer> entries = new ArrayList<Integer>();
            entries.add(i);
            for (Entry entry = table[i]; entry != null; entry = entry.getNext()) {
                entries.add((Integer)entry);
            }
            list.add(entries.toArray());
        }
        return list;
    }

    protected void assertTableIndex(List list, int index, int expectedTableIndex, int expectedSizeOfEntries) {
        Object[] entries = (Object[])list.get(index);
        Assert.assertEquals((Object)expectedTableIndex, (Object)entries[0]);
        Assert.assertEquals((long)expectedSizeOfEntries, (long)entries.length);
    }

    public static class Foo {
        private String val;
        private int hashCode;

        public Foo(String val, int hashCode) {
            this.val = val;
            this.hashCode = hashCode;
        }

        public String getVal() {
            return this.val;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Foo other = (Foo)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            return !(this.val == null ? other.val != null : !this.val.equals(other.val));
        }
    }
}

