/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import org.drools.core.base.BaseClassFieldReader;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.TestBean;
import org.drools.core.util.asm.BeanInherit;
import org.drools.core.util.asm.TestAbstract;
import org.drools.core.util.asm.TestAbstractImpl;
import org.drools.core.util.asm.TestInterface;
import org.drools.core.util.asm.TestInterfaceImpl;
import org.drools.mvel.asm.ClassFieldAccessorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseClassFieldAccessorFactoryTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testIt() throws Exception {
        ClassFieldAccessorFactory factory = new ClassFieldAccessorFactory();
        ClassFieldAccessorCache.CacheEntry cachEntry = new ClassFieldAccessorCache.CacheEntry(Thread.currentThread().getContextClassLoader());
        BaseClassFieldReader ex = factory.getClassFieldReader(TestBean.class, "name", cachEntry);
        Assert.assertEquals((Object)"michael", (Object)ex.getValue(null, (Object)new TestBean()));
        ex = factory.getClassFieldReader(TestBean.class, "age", cachEntry);
        Assert.assertEquals((long)42L, (long)((Number)ex.getValue(null, (Object)new TestBean())).intValue());
    }

    @Test
    public void testInterface() throws Exception {
        ClassFieldReader ex = this.store.getReader(TestInterface.class, "something");
        Assert.assertEquals((long)1L, (long)ex.getIndex());
        Assert.assertEquals((Object)"foo", (Object)ex.getValue(null, (Object)new TestInterfaceImpl()));
    }

    @Test
    public void testAbstract() throws Exception {
        ClassFieldReader ex = this.store.getReader(TestAbstract.class, "something");
        Assert.assertEquals((long)2L, (long)ex.getIndex());
        Assert.assertEquals((Object)"foo", (Object)ex.getValue(null, (Object)new TestAbstractImpl()));
    }

    @Test
    public void testInherited() throws Exception {
        ClassFieldReader ex = this.store.getReader(BeanInherit.class, "text");
        Assert.assertEquals((Object)"hola", (Object)ex.getValue(null, (Object)new BeanInherit()));
    }

    @Test
    public void testSelfReference() throws Exception {
        ClassFieldReader ex = this.store.getReader(BeanInherit.class, "this");
        TestBean bean = new TestBean();
        Assert.assertEquals((Object)bean, (Object)ex.getValue(null, (Object)bean));
    }
}

