/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.rule.TypeDeclaration;
import org.drools.mvel.compiler.compiler.CImpl;
import org.drools.mvel.compiler.compiler.DImpl;
import org.drools.mvel.compiler.compiler.IA;
import org.drools.mvel.compiler.compiler.IB;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class TypeDeclarationMergingTest {
    @Test
    public void testMask() {
        TypeDeclaration tdeclr = new TypeDeclaration(CImpl.class.getName());
        Assert.assertEquals((long)0L, (long)tdeclr.getSetMask());
        tdeclr.setRole(Role.Type.EVENT);
        Assert.assertEquals((long)1L, (long)(tdeclr.getSetMask() & 1));
        Assert.assertFalse((2 == (tdeclr.getSetMask() & 2) ? 1 : 0) != 0);
        Assert.assertFalse((4 == (tdeclr.getSetMask() & 4) ? 1 : 0) != 0);
        tdeclr.setTypesafe(false);
        Assert.assertEquals((long)1L, (long)(tdeclr.getSetMask() & 1));
        Assert.assertEquals((long)2L, (long)(tdeclr.getSetMask() & 2));
        Assert.assertFalse((4 == (tdeclr.getSetMask() & 4) ? 1 : 0) != 0);
        tdeclr = new TypeDeclaration(CImpl.class.getName());
        tdeclr.setTypesafe(true);
        Assert.assertFalse((1 == (tdeclr.getSetMask() & 1) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)(tdeclr.getSetMask() & 2));
        Assert.assertFalse((4 == (tdeclr.getSetMask() & 4) ? 1 : 0) != 0);
        tdeclr.setFormat(TypeDeclaration.Format.POJO);
        Assert.assertFalse((1 == (tdeclr.getSetMask() & 1) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)(tdeclr.getSetMask() & 2));
        Assert.assertEquals((long)4L, (long)(tdeclr.getSetMask() & 4));
    }

    @Test
    public void testOverrideFromParentClass() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + CImpl.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\ndeclare " + DImpl.class.getCanonicalName() + "\n    @typesafe(false)\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)false, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritNoneExitenceFromParentClass() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + CImpl.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritExitenceFromParentClass() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + CImpl.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\ndeclare " + DImpl.class.getCanonicalName() + "\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromParentInterface() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + IB.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\ndeclare " + DImpl.class.getCanonicalName() + "\n    @typesafe(false)\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)false, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromDeeperParentInterface() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + IA.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\ndeclare " + DImpl.class.getCanonicalName() + "\n    @typesafe(false)\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)false, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromDeeperHierarchyParentInterface() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + IA.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\ndeclare " + IB.class.getCanonicalName() + "\n    @role(fact)\nend\ndeclare " + DImpl.class.getCanonicalName() + "\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.FACT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritNoneExitenceFromParentInterface() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + IB.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritExitenceFromParentInterface() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + IB.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\ndeclare " + DImpl.class.getCanonicalName() + "\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromMixedHierarchyParentInterface() {
        String str = "package org.drools.mvel.compiler.test \nglobal java.util.List list \ndeclare " + IA.class.getCanonicalName() + "\n    @typesafe(true)\n    @role(event)\nend\ndeclare " + CImpl.class.getCanonicalName() + "\n    @role(fact)\nend\ndeclare " + DImpl.class.getCanonicalName() + "\nend\n";
        KnowledgeBuilderImpl builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)Role.Type.FACT, (Object)tdecl.getRole());
    }

    private KnowledgeBuilderImpl getPackageBuilder(String str) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        return (KnowledgeBuilderImpl)kbuilder;
    }

    @Test
    public void testNotOverwritePOJOMetadata() {
        String eventClassName = PositionAnnotatedEvent.class.getCanonicalName();
        String str = "package org.drools.mvel.compiler.test \ndeclare " + eventClassName + "\n @role(event)\nend \nrule 'sample rule' \nwhen \n " + eventClassName + "( 'value1', 'value2'; ) \nthen \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        }
        catch (IndexOutOfBoundsException e) {
            String msg = e.getMessage();
            if ("Error trying to access field at position 0".equals(msg)) {
                Assert.fail((String)"@Position declared in POJO was ignored.");
            }
            Assert.fail((String)("Check the test, unexpected error message: " + msg));
        }
        Assert.assertFalse((String)("Check the test, unexpected error message: " + kbuilder.getErrors()), (boolean)kbuilder.hasErrors());
    }

    public static class PositionAnnotatedEvent {
        @Position(value=1)
        private String arg1;
        @Position(value=0)
        private String arg0;

        public String getArg1() {
            return this.arg1;
        }

        public String getArg0() {
            return this.arg0;
        }

        public void setArg1(String arg1) {
            this.arg1 = arg1;
        }

        public void setArg0(String arg0) {
            this.arg0 = arg0;
        }
    }
}

