/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler.xml.rules;

import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.dsl.AccumulateDescrBuilder;
import org.drools.drl.ast.dsl.CEDescrBuilder;
import org.drools.drl.ast.dsl.DescrFactory;
import org.drools.drl.ast.dsl.PackageDescrBuilder;
import org.drools.drl.ast.dsl.RuleDescrBuilder;
import org.drools.mvel.DrlDumper;
import org.drools.mvel.compiler.compiler.xml.rules.DumperTestHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DumperTest {
    @Test
    public void testRoundTripAccumulateXml() throws Exception {
        DumperTestHelper.XmlFile("test_ParseAccumulate.xml");
    }

    @Test
    public void testRoundTripCollectXml() throws Exception {
        DumperTestHelper.XmlFile("test_ParseCollect.xml");
    }

    @Test
    public void testRoundTripExistsXml() throws Exception {
        DumperTestHelper.XmlFile("test_ParseExists.xml");
    }

    @Test
    public void testRoundTripForallXml() throws Exception {
        DumperTestHelper.XmlFile("test_ParseForall.xml");
    }

    @Test
    public void testRoundTripFromXml() throws Exception {
        DumperTestHelper.XmlFile("test_ParseFrom.xml");
    }

    @Test
    public void testRoundTripComplexRuleXml() throws Exception {
        DumperTestHelper.XmlFile("test_RoundTrip.xml");
    }

    @Test
    public void testRoundTripComplexRuleDrl() throws Exception {
        DumperTestHelper.DrlFile("test_RoundTrip.drl");
    }

    @Test
    public void testRoundTripCollectDrl() throws Exception {
        DumperTestHelper.DrlFile("../../../../integrationtests/test_Collect.drl");
    }

    @Test
    public void testRoundTripAccumulateDrl() throws Exception {
        DumperTestHelper.DrlFile("test_accumulateall.drl");
    }

    @Test
    public void testRoundTripExistsDrl() throws Exception {
        DumperTestHelper.DrlFile("../../../../integrationtests/test_exists.drl");
    }

    @Test
    public void testRoundTripForallDrl() throws Exception {
        DumperTestHelper.DrlFile("../../../../integrationtests/test_Forall.drl");
    }

    @Test
    public void testRoundTripFromDrl() throws Exception {
        DumperTestHelper.DrlFile("test_from.drl");
    }

    @Test
    public void testRoundTripSimpleRuleDrl() throws Exception {
        DumperTestHelper.DrlFile("test_simplerule.drl");
    }

    @Test
    public void testRoundTripPComplexDrl() throws Exception {
        DumperTestHelper.DrlFile("test_complex.drl");
    }

    @Test
    public void testRoundTripDRLAnnotations() throws Exception {
        DumperTestHelper.DrlFile("test_DumpAnnotations.drl");
    }

    @Test
    public void testRoundTripDRLNamedConsequences() throws Exception {
        DumperTestHelper.DrlFile("test_NamedConsequences.drl");
    }

    @Test
    public void testRoundTripPComplexXml() throws Exception {
        DumperTestHelper.XmlFile("test_ParseComplex.xml");
    }

    @Test
    public void testRoundTripTraitDeclarations() throws Exception {
        DumperTestHelper.DrlFile("test_TraitDeclaration.drl");
        String out = DumperTestHelper.dump("test_TraitDeclaration.drl");
        Assert.assertTrue((boolean)out.contains("declare trait Foo"));
    }

    @Test
    public void testRoundTripEnumDeclarations() throws Exception {
        DumperTestHelper.DrlFile("test_EnumDeclaration.drl");
        String out = DumperTestHelper.dump("test_EnumDeclaration.drl");
        Assert.assertTrue((boolean)out.contains("declare enum Planets"));
        Assert.assertTrue((boolean)out.contains("MERCURY"));
        Assert.assertTrue((boolean)out.contains("7.1492e7"));
    }

    @Test
    public void testRoundTripAccumulate() throws Exception {
        String out = DumperTestHelper.dump("test_Accumulate.drl");
        Assert.assertTrue((boolean)out.contains("$sum : count( $s1 )"));
        Assert.assertFalse((boolean)out.contains("null : count( $s2 )"));
        Assert.assertTrue((boolean)out.contains("count( $s2 )"));
    }

    private void checkRoundtrip(String drl) throws DroolsParserException {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkgOriginal = parser.parse(false, drl);
        DrlDumper dumper = new DrlDumper();
        String out = dumper.dump(pkgOriginal);
        Assertions.assertThat((String)drl).isEqualToIgnoringWhitespace((CharSequence)out);
    }

    @Test
    public void testRoundTripDRLAccumulate() throws Exception {
        String drl = "package org.test\n\nrule \"last flown date\"\nwhen\n    $customer : Profile( $ceid : id )\n    accumulate(\n    Flight( status == \"Flown\", $dptDate: departureDate.time ) from $customer.flights,\n        $cnt : count( $dptDate );\n        $cnt > 0 )\nthen\nend";
        this.checkRoundtrip(drl);
    }

    @Test
    public void testRoundTripDRLAccumulateWith2Patterns() throws Exception {
        String drl = "package org.example\ndeclare  Flight \n    pnrRecordLocator : String  \n    flightSegmentDepartureIataCode : String  \n    flightSegmentArrivalIataCode : String  \n    id : int  \nend\n\nrule \"round trips accumulate\"\nwhen\n  $roundTripSet : java.util.Set( size >= 1 ) from accumulate (\n    $f1:Flight()\n    and\n    $f2:Flight(\n        id > $f1.id,\n        pnrRecordLocator==$f1.pnrRecordLocator,\n        flightSegmentDepartureIataCode==$f1.flightSegmentArrivalIataCode,\n        flightSegmentArrivalIataCode==$f1.flightSegmentDepartureIataCode\n    )  , collectSet($f1.getId()) )\nthen\n    System.out.println($roundTripSet);\nend";
        this.checkRoundtrip(drl);
    }

    @Test
    public void testAccumulateWithCustomImport() throws Exception {
        String drl = "package org.example\nimport org.drools.Adult\nimport org.drools.Child\nimport org.drools.Result\nimport accumulate org.drools.TestFunction accfunc\nrule \"R\" when\n  accumulate( $c : Child( age < 10 ) and $a : Adult( name == $c.parent ), $parentAge : accfunc($a.getAge()) )\nthen\n  insert(new Result($parentAge));\nend";
        this.checkRoundtrip(drl);
    }

    @Test
    public void testAccumulateWithoutConstraint() throws Exception {
        String expectedDrl = "package example \n\nimport java.math.BigDecimal\n\nrule \"Test Rule\"\nwhen\n    accumulate(     \n    $target : example.RuleTest.Fact(  )  ,\n        $cnt : count(  ) \n         ) \nthen\nSystem.out.println($cnt);\n\nend";
        PackageDescr packageDescr = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((AccumulateDescrBuilder)((CEDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("example").newImport().target("java.math.BigDecimal").end()).newRule().name("Test Rule").lhs().accumulate().source().pattern().type("example.RuleTest.Fact").id("$target", false).end()).end()).function("count", "$cnt", false, new String[0]).end()).end()).rhs("System.out.println($cnt);").end()).end().getDescr();
        String drl = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)drl).isEqualToIgnoringWhitespace((CharSequence)expectedDrl);
    }
}

