/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kproject.memory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.compiler.io.memory.MemoryFolder;
import org.junit.Assert;
import org.junit.Test;

public class MemoryFolderTest {
    @Test
    public void testGetParentWithLeadingAndTrailingSlash() {
        MemoryFileSystem mfs = new MemoryFileSystem();
        Assert.assertEquals((Object)"", (Object)new MemoryFolder(mfs, "/src").getParent().getPath().asString());
        Assert.assertEquals((Object)"", (Object)new MemoryFolder(mfs, "src/").getParent().getPath().asString());
        Assert.assertEquals((Object)"", (Object)new MemoryFolder(mfs, "/src/").getParent().getPath().asString());
        Assert.assertEquals((Object)"/src", (Object)new MemoryFolder(mfs, "/src/main").getParent().getPath().asString());
        Assert.assertEquals((Object)"src", (Object)new MemoryFolder(mfs, "src/main/").getParent().getPath().asString());
        Assert.assertEquals((Object)"/src", (Object)new MemoryFolder(mfs, "/src/main/").getParent().getPath().asString());
        Assert.assertEquals((Object)"/src/main", (Object)new MemoryFolder(mfs, "/src/main/java").getParent().getPath().asString());
        Assert.assertEquals((Object)"src/main", (Object)new MemoryFolder(mfs, "src/main/java/").getParent().getPath().asString());
        Assert.assertEquals((Object)"/src/main", (Object)new MemoryFolder(mfs, "/src/main/java/").getParent().getPath().asString());
    }

    @Test
    public void testRecursiveFolderCreation() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/resources");
        Assert.assertFalse((boolean)mres.exists());
        mres.create();
        Assert.assertTrue((boolean)mres.exists());
        Folder fld = fs.getFolder("src/main");
        Assert.assertTrue((boolean)fld.exists());
        Folder src = fs.getFolder("src");
        Assert.assertTrue((boolean)src.exists());
    }

    @Test
    public void testFolderGetParent() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/resources");
        mres.create();
        Assert.assertEquals((Object)"src/main", (Object)mres.getParent().getPath().asString());
        Assert.assertEquals((Object)"src", (Object)mres.getParent().getParent().getPath().asString());
    }

    @Test
    public void testFolderRemoval() throws IOException {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder fld = fs.getFolder("src/main/resources/org/domain");
        fld.create();
        fld = fs.getFolder("src/main");
        File file = fld.getFile("MyClass1.java");
        file.create((InputStream)new ByteArrayInputStream("ABC1".getBytes()));
        file = fld.getFile("MyClass2.java");
        file.create((InputStream)new ByteArrayInputStream("ABC2".getBytes()));
        fld = fs.getFolder("src/main/resources/org");
        file = fld.getFile("MyClass3.java");
        file.create((InputStream)new ByteArrayInputStream("ABC3".getBytes()));
        file = fld.getFile("MyClass4.java");
        file.create((InputStream)new ByteArrayInputStream("ABC4".getBytes()));
        fld = fs.getFolder("src/main/resources/org/domain");
        file = fld.getFile("MyClass4.java");
        file.create((InputStream)new ByteArrayInputStream("ABC5".getBytes()));
        Assert.assertTrue((boolean)fs.getFolder("src/main").exists());
        Assert.assertTrue((boolean)fs.getFile("src/main/MyClass1.java").exists());
        Assert.assertTrue((boolean)fs.getFile("src/main/MyClass2.java").exists());
        Assert.assertTrue((boolean)fs.getFile("src/main/resources/org/MyClass3.java").exists());
        Assert.assertTrue((boolean)fs.getFile("src/main/resources/org/MyClass4.java").exists());
        Assert.assertTrue((boolean)fs.getFile("src/main/resources/org/domain/MyClass4.java").exists());
        fs.remove(fs.getFolder("src/main"));
        Assert.assertFalse((boolean)fs.getFolder("src/main").exists());
        Assert.assertFalse((boolean)fs.getFile("src/main/MyClass1.java").exists());
        Assert.assertFalse((boolean)fs.getFile("src/main/MyClass2.java").exists());
        Assert.assertFalse((boolean)fs.getFile("src/main/resources/org/MyClass3.java").exists());
        Assert.assertFalse((boolean)fs.getFile("src/main/resources/org/MyClass4.java").exists());
        Assert.assertFalse((boolean)fs.getFile("src/main/resources/org/domain/MyClass4.java").exists());
    }

    @Test
    public void testCreateAndCopyFolder() {
        MemoryFileSystem memoryFileSystem = new MemoryFileSystem();
        Folder emptyFolder = memoryFileSystem.getFolder("emptyfolder");
        MemoryFolder destinationFolder = new MemoryFolder(memoryFileSystem, "destinationfolder");
        memoryFileSystem.createFolder(destinationFolder);
        memoryFileSystem.copyFolder(emptyFolder, memoryFileSystem, (Folder)destinationFolder, new String[0]);
    }
}

