/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang.dsl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLMappingFile;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.junit.Assert;
import org.junit.Test;

public class DSLTokenizedMappingFileTest {
    private static final String lookbehind = "(?:(?<=^)|(?<=\\W))";
    private static final String NL = System.getProperty("line.separator");
    private DSLMappingFile file = null;
    private final String filename = "test_metainfo.dsl";

    @Test
    public void testParseFile() {
        try {
            InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(this.filename));
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            Assert.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            Assert.assertTrue((boolean)this.file.getErrors().isEmpty());
            Assert.assertEquals((long)31L, (long)this.file.getMapping().getEntries().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithBrackets() {
        String file = "[when]ATTRIBUTE \"{attr}\" IS IN [{list}]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            Assert.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            Assert.assertTrue((boolean)this.file.getErrors().isEmpty());
            Assert.assertEquals((long)1L, (long)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            Assert.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            Assert.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            Assert.assertEquals((Object)"(?:(?<=^)|(?<=\\W))ATTRIBUTE\\s+\"(.*?)\"\\s+IS\\s+IN\\s+[(.*?)](?=\\W|$)", (Object)entry.getKeyPattern().toString());
            Assert.assertEquals((Object)"Attribute( {attr} in ({list}) )", (Object)entry.getValuePattern());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithEscaptedBrackets() {
        String file = "[when]ATTRIBUTE \"{attr}\" IS IN \\[{list}\\]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            Assert.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            Assert.assertTrue((boolean)this.file.getErrors().isEmpty());
            Assert.assertEquals((long)1L, (long)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            Assert.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            Assert.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            Assert.assertEquals((Object)"(?:(?<=^)|(?<=\\W))ATTRIBUTE\\s+\"(.*?)\"\\s+IS\\s+IN\\s+\\[(.*?)\\](?=\\W|$)", (Object)entry.getKeyPattern().toString());
            Assert.assertEquals((Object)"Attribute( {attr} in ({list}) )", (Object)entry.getValuePattern());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithEscapes() {
        String file = "[then]TEST=System.out.println(\"DO_SOMETHING\");" + NL + "[when]code {code1} occurs and sum of all digit not equal \\( {code2} \\+ {code3} \\)=AAAA( cd1 == {code1}, cd2 != ( {code2} + {code3} ))" + NL + "[when]code {code1} occurs=BBBB" + NL + "";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            Assert.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            Assert.assertTrue((boolean)this.file.getErrors().isEmpty());
            String LHS = "code 1041 occurs and sum of all digit not equal ( 1034 + 1035 )";
            String rule = "rule \"x\"" + NL + "when" + NL + "" + "code 1041 occurs and sum of all digit not equal ( 1034 + 1035 )" + "" + NL + "then" + NL + "TEST" + NL + "end";
            DefaultExpander de = new DefaultExpander();
            de.addDSLMapping(this.file.getMapping());
            String ruleAfterExpansion = de.expand(rule);
            String expected = "rule \"x\"" + NL + "when" + NL + "AAAA( cd1 == 1041, cd2 != ( 1034 + 1035 ))" + NL + "then" + NL + "System.out.println(\"DO_SOMETHING\");" + NL + "end";
            Assert.assertEquals((Object)expected, (Object)ruleAfterExpansion);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithEscaptedEquals() {
        String file = "[when]something:\\={value}=Attribute( something == \"{value}\" )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            Assert.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            Assert.assertTrue((boolean)this.file.getErrors().isEmpty());
            Assert.assertEquals((long)1L, (long)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            Assert.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            Assert.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            Assert.assertEquals((Object)"(?:(?<=^)|(?<=\\W))something:\\=(.*?)$", (Object)entry.getKeyPattern().toString());
            Assert.assertEquals((Object)"Attribute( something == \"{value}\" )", (Object)entry.getValuePattern());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise exception ");
        }
    }
}

