/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.Iterator;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.compiler.oopath.model.Adult;
import org.drools.mvel.compiler.oopath.model.BodyMeasurement;
import org.drools.mvel.compiler.oopath.model.Child;
import org.drools.mvel.compiler.oopath.model.Disease;
import org.drools.mvel.compiler.oopath.model.Group;
import org.drools.mvel.compiler.oopath.model.Man;
import org.drools.mvel.compiler.oopath.model.School;
import org.drools.mvel.compiler.oopath.model.Toy;
import org.drools.mvel.compiler.oopath.model.Woman;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class OOPathReactiveTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathReactiveTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testReactiveOnLia() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
        list.clear();
        debbie.setAge(11);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"doll"});
    }

    @Test
    public void testReactiveDeleteOnLia() {
        Object obj;
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        EntryPointNode epn = (EntryPointNode)((InternalKnowledgeBase)ksession.getKieBase()).getRete().getEntryPointNodes().values().iterator().next();
        ObjectTypeNode otn = (ObjectTypeNode)epn.getObjectTypeNodes().get(new ClassObjectType(Man.class));
        LeftInputAdapterNode lian = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        ReactiveFromNode from1 = (ReactiveFromNode)lian.getSinkPropagator().getSinks()[0];
        ReactiveFromNode from2 = (ReactiveFromNode)from1.getSinkPropagator().getSinks()[0];
        ReactiveFromNode from3 = (ReactiveFromNode)from2.getSinkPropagator().getSinks()[0];
        BetaMemory betaMemory = ((ReactiveFromNode.ReactiveFromMemory)((InternalWorkingMemory)ksession).getNodeMemory((MemoryFactory)from3)).getBetaMemory();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 11);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball", "doll"});
        TupleMemory tupleMemory = betaMemory.getLeftTupleMemory();
        Assertions.assertThat((int)betaMemory.getLeftTupleMemory().size()).isEqualTo(2);
        Iterator it = tupleMemory.iterator();
        LeftTuple next = (LeftTuple)it.next();
        while (next != null) {
            obj = next.getFactHandle().getObject();
            Assertions.assertThat((obj == charlie || obj == debbie ? 1 : 0) != 0).isTrue();
            next = (LeftTuple)it.next();
        }
        list.clear();
        debbie.setAge(10);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(0);
        Assertions.assertThat((int)betaMemory.getLeftTupleMemory().size()).isEqualTo(1);
        it = tupleMemory.iterator();
        next = (LeftTuple)it.next();
        while (next != null) {
            obj = next.getFactHandle().getObject();
            Assertions.assertThat((obj == charlie ? 1 : 0) != 0).isTrue();
            next = (LeftTuple)it.next();
        }
    }

    @Test
    public void testRemoveFromReactiveListBasic() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  School( $child: /children[age >= 13 && age < 20] )\nthen\n  System.out.println( $child );\n  insertLogical( $child );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  School( $child: /children[age >= 13 && age < 20] )\nthen\n  System.out.println( $child );\n  insertLogical( $child );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Child charlie = new Child("Charles", 15);
        Child debbie = new Child("Debbie", 19);
        School school = new School("Da Vinci");
        school.addChild(charlie);
        ksession.insert((Object)school);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)charlie));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)debbie));
        school.addChild(debbie);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)charlie));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)debbie));
        school.getChildren().remove((Object)debbie);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)charlie));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)debbie));
        school.addChild(debbie);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)charlie));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)debbie));
        debbie.setAge(20);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)charlie));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)debbie));
    }

    @Test
    public void testRemoveFromReactiveListExtended() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  System.out.println( $id + \".\" + $p.getName() );\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  System.out.println( $id + \".\" + $p.getName() );\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Adult ada = new Adult("Ada", 19);
        Adult bea = new Adult("Bea", 19);
        Group x = new Group("X");
        Group y = new Group("Y");
        x.addPerson(ada);
        x.addPerson(bea);
        y.addPerson(ada);
        y.addPerson(bea);
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        ada.setAge(20);
        ksession.fireAllRules();
        ksession.getObjects().forEach(System.out::println);
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        y.removePerson(bea);
        bea.setAge(20);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
    }

    @Test
    public void testRemoveFromAndAddToReactiveSet() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R when\n  School( $disease: /children/diseases )\nthen\n  insertLogical( $disease );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R when\n  School( $disease: /children/diseases )\nthen\n  insertLogical( $disease );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Disease flu = new Disease("flu");
        Disease asthma = new Disease("asthma");
        Disease diabetes = new Disease("diabetes");
        Child charlie = new Child("Charles", 15);
        charlie.addDisease(flu);
        charlie.addDisease(asthma);
        Child debbie = new Child("Debbie", 19);
        debbie.addDisease(diabetes);
        School school = new School("Da Vinci");
        school.addChild(charlie);
        school.addChild(debbie);
        ksession.insert((Object)school);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)flu));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)asthma));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)diabetes));
        charlie.getDiseases().remove((Object)flu);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)flu));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)asthma));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)diabetes));
        charlie.getDiseases().remove((Object)asthma);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)flu));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)asthma));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)diabetes));
        debbie.getDiseases().remove((Object)diabetes);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)flu));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)asthma));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)diabetes));
        charlie.addDisease(flu);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)flu));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)asthma));
        Assert.assertFalse((boolean)ksession.getObjects().contains((Object)diabetes));
        charlie.addDisease(asthma);
        debbie.addDisease(diabetes);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)flu));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)asthma));
        Assert.assertTrue((boolean)ksession.getObjects().contains((Object)diabetes));
    }

    @Test
    public void testRemoveFromReactiveListExtendedWithSerialization() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  System.out.println( $id + \".\" + $p.getName() );\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  System.out.println( $id + \".\" + $p.getName() );\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Adult ada = new Adult("Ada", 19);
        Adult bea = new Adult("Bea", 19);
        Group x = new Group("X");
        Group y = new Group("Y");
        x.addPerson(ada);
        x.addPerson(bea);
        y.addPerson(ada);
        y.addPerson(bea);
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        ada.setAge(20);
        ksession.fireAllRules();
        ksession.getObjects().forEach(System.out::println);
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        y.removePerson(bea);
        bea.setAge(20);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
    }

    @Test
    public void testReactiveOnBeta() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  $i : Integer()\n  Man( $toy: /wife/children[age > $i]?/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  $i : Integer()\n  Man( $toy: /wife/children[age > $i]?/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)10);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
        list.clear();
        debbie.setAge(11);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"doll"});
    }

    @Test
    public void testReactive2Rules() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List toyList\nglobal java.util.List teenagers\n\nrule R1 when\n  $i : Integer()\n  Man( $toy: /wife/children[age >= $i]/toys )\nthen\n  toyList.add( $toy.getName() );\nend\nrule R2 when\n  School( $child: /children[age >= 13] )\nthen\n  teenagers.add( $child.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List toyList\nglobal java.util.List teenagers\n\nrule R1 when\n  $i : Integer()\n  Man( $toy: /wife/children[age >= $i]/toys )\nthen\n  toyList.add( $toy.getName() );\nend\nrule R2 when\n  School( $child: /children[age >= 13] )\nthen\n  teenagers.add( $child.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList toyList = new ArrayList();
        ksession.setGlobal("toyList", toyList);
        ArrayList teenagers = new ArrayList();
        ksession.setGlobal("teenagers", teenagers);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 15);
        Child debbie = new Child("Debbie", 12);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        School school = new School("Da Vinci");
        school.addChild(charlie);
        school.addChild(debbie);
        ksession.insert((Object)13);
        ksession.insert((Object)bob);
        ksession.insert((Object)school);
        ksession.fireAllRules();
        Assertions.assertThat(toyList).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
        Assertions.assertThat(teenagers).containsExactlyInAnyOrder((Object[])new String[]{"Charles"});
        toyList.clear();
        debbie.setAge(13);
        ksession.fireAllRules();
        Assertions.assertThat(toyList).containsExactlyInAnyOrder((Object[])new String[]{"doll"});
        Assertions.assertThat(teenagers).containsExactlyInAnyOrder((Object[])new String[]{"Charles", "Debbie"});
    }

    @Test
    public void testReactiveList() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
        list.clear();
        charlie.addToy(new Toy("gun"));
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"gun"});
    }

    @Test
    public void testReactiveSet() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $disease: /wife/children[age > 10]/diseases )\nthen\n  list.add( $disease.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $disease: /wife/children[age > 10]/diseases )\nthen\n  list.add( $disease.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addDisease(new Disease("flu"));
        charlie.addDisease(new Disease("asthma"));
        debbie.addDisease(new Disease("diabetes"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"flu", "asthma"});
        list.clear();
        charlie.addDisease(new Disease("epilepsy"));
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"epilepsy"});
    }

    @Test
    public void testReactiveMap() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $bodyMeasurement: /wife/bodyMeasurementsMap/entrySet )\nthen\n  list.add( $bodyMeasurement.getValue() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $bodyMeasurement: /wife/bodyMeasurementsMap/entrySet )\nthen\n  list.add( $bodyMeasurement.getValue() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Man bob = new Man("Bob", 40);
        Woman alice = new Woman("Alice", 38);
        alice.putBodyMeasurement(BodyMeasurement.CHEST, 80);
        bob.setWife(alice);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new Integer[]{80});
        list.clear();
        alice.putBodyMeasurement(BodyMeasurement.RIGHT_FOREARM, 38);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new Integer[]{38, 80});
    }

    @Test
    public void testNonReactivePart() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]?/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]?/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
        list.clear();
        charlie.addToy(new Toy("robot"));
        ksession.fireAllRules();
        Assertions.assertThat(list).isEmpty();
    }

    @Test
    public void testAllNonReactiveAfterNonReactivePart() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: ?/wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: ?/wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
        list.clear();
        charlie.addToy(new Toy("robot"));
        ksession.fireAllRules();
        Assertions.assertThat(list).isEmpty();
    }

    @Test
    public void testInvalidDoubleNonReactivePart() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife?/children[age > 10]?/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife?/children[age > 10]?/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testSingleFireOnReactiveChange() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        list.clear();
        Child eleonor = new Child("Eleonor", 10);
        alice.addChild(eleonor);
        Toy toy = new Toy("eleonor toy 1");
        eleonor.addToy(toy);
        eleonor.setAge(11);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        list.clear();
        toy.setName("eleonor toy 2");
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
    }

    @Test
    public void testReactivitySettingAttributeInDrl() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R when\n  Man( $child: /wife/children[age >= 10] )\nthen\nend\nrule R2 when\n  Man( $child: /wife/children[age < 10] )\nthen\n$child.setAge(12);end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R when\n  Man( $child: /wife/children[age >= 10] )\nthen\nend\nrule R2 when\n  Man( $child: /wife/children[age < 10] )\nthen\n$child.setAge(12);end\n"});
        KieSession ksession = kbase.newKieSession();
        Man bob = new Man("Bob", 40);
        Woman alice = new Woman("Alice", 38);
        Child charlie = new Child("Charles", 9);
        Child debbie = new Child("Debbie", 8);
        bob.setWife(alice);
        alice.addChild(charlie);
        alice.addChild(debbie);
        ksession.insert((Object)bob);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(4);
    }

    private List<?> factsCollection(KieSession ksession) {
        ArrayList res = new ArrayList();
        res.addAll(ksession.getObjects());
        return res;
    }
}

