/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.reteoo;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.utll.xml.XStreamUtils;

public class ReteooBuilderTest {
    private final boolean writeTree = false;

    protected KieBase getKnowledgeBase() throws Exception {
        return KnowledgeBaseFactory.newKnowledgeBase();
    }

    @Test
    public void testThreePatternsWithConstraints() throws Exception {
    }

    @Test
    public void testOneAndTwoOrs() throws Exception {
    }

    @Test
    public void testOneAndTwoOrsPerson() throws Exception {
    }

    private void writeRuleBase(InternalKnowledgeBase kBase, String fileName) throws IOException {
        XStream xstream = XStreamUtils.createNonTrustingXStream();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("src/test/resources/org/drools/reteoo/" + fileName)));
        xstream.toXML((Object)kBase, (Writer)out);
    }

    private void checkRuleBase(String name) throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_" + name + ".drl")));
        InternalKnowledgePackage pkg = builder.getPackage("org.drools.mvel.compiler.test");
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackage((KiePackage)pkg);
        Objects.requireNonNull(this);
        XStream xstream = XStreamUtils.createNonTrustingXStream();
        InternalKnowledgeBase goodKBase = (InternalKnowledgeBase)xstream.fromXML(this.getClass().getResourceAsStream(name));
        this.nodesEquals(goodKBase.getRete(), kBase.getRete());
    }

    private void nodesEquals(Object object1, Object object2) {
        block3: {
            block2: {
                Assert.assertEquals((String)(object1 + " is not of the same type as " + object2), object1.getClass(), object2.getClass());
                Assert.assertEquals((String)(object1 + " is not equal to " + object2), (Object)object1, (Object)object2);
                if (!(object1 instanceof ObjectSource)) break block2;
                ObjectSource source1 = (ObjectSource)object1;
                ObjectSource source2 = (ObjectSource)object2;
                ObjectSink[] list1 = source1.getObjectSinkPropagator().getSinks();
                ObjectSink[] list2 = source2.getObjectSinkPropagator().getSinks();
                Assert.assertEquals((String)(object1.getClass() + " nodes have different number of sinks"), (long)list1.length, (long)list2.length);
                int size = list1.length;
                for (int i = 0; i < size; ++i) {
                    this.nodesEquals(list1[i], list2[i]);
                }
                break block3;
            }
            if (!(object1 instanceof LeftTupleSource)) break block3;
            LeftTupleSource source1 = (LeftTupleSource)object1;
            LeftTupleSource source2 = (LeftTupleSource)object2;
            LeftTupleSink[] list1 = source1.getSinkPropagator().getSinks();
            LeftTupleSink[] list2 = source2.getSinkPropagator().getSinks();
            Assert.assertEquals((String)(object1.getClass() + " nodes have different number of sinks"), (long)list1.length, (long)list2.length);
            int size = list1.length;
            for (int i = 0; i < size; ++i) {
                this.nodesEquals(list1[i], list2[i]);
            }
        }
    }
}

