/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.extractors;

import org.drools.core.base.ClassFieldAccessor;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ConcreteChild;
import org.drools.core.util.asm.BeanInherit;
import org.drools.core.util.asm.InterfaceChild;
import org.drools.core.util.asm.TestAbstract;
import org.drools.core.util.asm.TestAbstractImpl;
import org.drools.core.util.asm.TestBean;
import org.drools.core.util.asm.TestInterface;
import org.drools.core.util.asm.TestInterfaceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClassFieldAccessorTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testBasic() throws Exception {
        Object[] objArray = new Object[1];
        TestBean obj = new TestBean();
        obj.setBlah(false);
        obj.setSomething("no");
        obj.setObjArray(objArray);
        ClassFieldReader ext = this.store.getReader(TestBean.class, "blah");
        Assert.assertEquals((Object)false, (Object)((Boolean)ext.getValue(null, (Object)obj)));
        ClassFieldReader ext2 = this.store.getReader(TestBean.class, "fooBar");
        Assert.assertEquals((Object)"fooBar", (Object)ext2.getValue(null, (Object)obj));
        ClassFieldReader ext3 = this.store.getReader(TestBean.class, "objArray");
        Assert.assertEquals((Object)objArray, (Object)ext3.getValue(null, (Object)obj));
    }

    @Test
    public void testInterface() throws Exception {
        TestInterfaceImpl obj = new TestInterfaceImpl();
        ClassFieldReader ext = this.store.getReader(TestInterface.class, "something");
        Assert.assertEquals((Object)"foo", (Object)((String)ext.getValue(null, (Object)obj)));
    }

    @Test
    public void testAbstract() throws Exception {
        ClassFieldReader ext = this.store.getReader(TestAbstract.class, "something");
        TestAbstractImpl obj = new TestAbstractImpl();
        Assert.assertEquals((Object)"foo", (Object)((String)ext.getValue(null, (Object)obj)));
    }

    @Test
    public void testInherited() throws Exception {
        ClassFieldReader ext = this.store.getReader(BeanInherit.class, "text");
        BeanInherit obj = new BeanInherit();
        Assert.assertEquals((Object)"hola", (Object)((String)ext.getValue(null, (Object)obj)));
    }

    @Test
    public void testMultipleInterfaces() throws Exception {
        ConcreteChild obj = new ConcreteChild();
        ClassFieldReader ext = this.store.getReader(InterfaceChild.class, "foo");
        Assert.assertEquals((long)42L, (long)((Number)ext.getValue(null, (Object)obj)).intValue());
    }

    @Test
    public void testLong() throws Exception {
        ClassFieldReader ext = this.store.getReader(TestBean.class, "longField");
        TestBean bean = new TestBean();
        Assert.assertEquals((long)424242L, (long)((Number)ext.getValue(null, (Object)bean)).longValue());
    }

    @Test
    public void testNonExistentField() throws Exception {
        Object[] objArray = new Object[1];
        TestBean obj = new TestBean();
        obj.setBlah(false);
        obj.setSomething("no");
        obj.setObjArray(objArray);
        ClassFieldReader ext = this.store.getReader(TestBean.class, "xyz");
        Assert.assertNull((Object)ext);
    }

    @Test
    public void testBuildFieldAccessor() {
        try {
            ClassFieldAccessor intAccessor = this.store.getAccessor(TestClass.class, "intAttr");
            ClassFieldAccessor strAccessor = this.store.getAccessor(TestClass.class, "strAttr");
            String testString1 = "TestAttr1";
            String testString2 = "TestAttr2";
            TestClass instance = new TestClass();
            instance.setIntAttr(10);
            instance.setStrAttr(testString1);
            Assert.assertEquals((String)"Error reading int attr", (long)10L, (long)((Integer)intAccessor.getValue((Object)instance)).intValue());
            Assert.assertEquals((String)"Error reading String attr", (Object)testString1, (Object)strAccessor.getValue((Object)instance));
            intAccessor.setValue((Object)instance, (Object)new Integer(50));
            strAccessor.setValue((Object)instance, (Object)testString2);
            Assert.assertEquals((String)"Error setting int attr", (long)50L, (long)instance.getIntAttr());
            Assert.assertEquals((String)"Error setting String attr", (Object)testString2, (Object)instance.getStrAttr());
            Assert.assertEquals((String)"Error reading String attr", (Object)testString2, (Object)strAccessor.getValue((Object)instance));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("No exception is supposed to be generated when creating field accessor: " + e));
        }
    }

    @Test
    public void testNullOnPrimitives() {
        try {
            ClassFieldAccessor intAccessor = this.store.getAccessor(TestClass.class, "intAttr");
            ClassFieldAccessor strAccessor = this.store.getAccessor(TestClass.class, "strAttr");
            ClassFieldAccessor byteAccessor = this.store.getAccessor(TestClass.class, "byteAttr");
            ClassFieldAccessor booleanAccessor = this.store.getAccessor(TestClass.class, "booleanAttr");
            ClassFieldAccessor charAccessor = this.store.getAccessor(TestClass.class, "charAttr");
            ClassFieldAccessor doubleAccessor = this.store.getAccessor(TestClass.class, "doubleAttr");
            ClassFieldAccessor floatAccessor = this.store.getAccessor(TestClass.class, "floatAttr");
            ClassFieldAccessor longAccessor = this.store.getAccessor(TestClass.class, "longAttr");
            ClassFieldAccessor shortAccessor = this.store.getAccessor(TestClass.class, "shortAttr");
            String testString1 = "TestAttr1";
            TestClass instance = new TestClass();
            instance.setIntAttr(25);
            instance.setStrAttr(testString1);
            instance.setByteAttr((byte)10);
            instance.setBooleanAttr(true);
            instance.setCharAttr('x');
            instance.setDoubleAttr(10.5);
            instance.setFloatAttr(40.3f);
            instance.setLongAttr(43L);
            instance.setShortAttr((short)20);
            intAccessor.setValue((Object)instance, null);
            strAccessor.setValue((Object)instance, null);
            byteAccessor.setValue((Object)instance, null);
            booleanAccessor.setValue((Object)instance, null);
            charAccessor.setValue((Object)instance, null);
            doubleAccessor.setValue((Object)instance, null);
            floatAccessor.setValue((Object)instance, null);
            longAccessor.setValue((Object)instance, null);
            shortAccessor.setValue((Object)instance, null);
            Assert.assertEquals((String)"Error setting attr", (long)0L, (long)instance.getIntAttr());
            Assert.assertNull((String)"Error setting attr", (Object)instance.getStrAttr());
            Assert.assertEquals((String)"Error setting attr", (long)0L, (long)instance.getByteAttr());
            Assert.assertEquals((String)"Error setting attr", (Object)false, (Object)instance.isBooleanAttr());
            Assert.assertEquals((String)"Error setting attr", (long)0L, (long)instance.getCharAttr());
            Assert.assertEquals((String)"Error setting attr", (double)0.0, (double)instance.getDoubleAttr(), (double)0.1);
            Assert.assertEquals((String)"Error setting attr", (float)0.0f, (float)instance.getFloatAttr(), (float)0.1f);
            Assert.assertEquals((String)"Error setting attr", (long)0L, (long)instance.getLongAttr());
            Assert.assertEquals((String)"Error setting attr", (long)0L, (long)instance.getShortAttr());
            Assert.assertEquals((String)"Error reading int attr", (long)0L, (long)((Integer)intAccessor.getValue((Object)instance)).intValue());
            Assert.assertNull((String)"Error reading String attr", (Object)strAccessor.getValue((Object)instance));
            Assert.assertEquals((String)"Error reading attr", (long)0L, (long)((Byte)byteAccessor.getValue((Object)instance)).byteValue());
            Assert.assertEquals((String)"Error reading attr", (Object)false, (Object)((Boolean)booleanAccessor.getValue((Object)instance)));
            Assert.assertEquals((String)"Error reading attr", (long)0L, (long)((Character)charAccessor.getValue((Object)instance)).charValue());
            Assert.assertEquals((String)"Error reading attr", (double)0.0, (double)((Double)doubleAccessor.getValue((Object)instance)), (double)0.1);
            Assert.assertEquals((String)"Error reading attr", (float)0.0f, (float)((Float)floatAccessor.getValue((Object)instance)).floatValue(), (float)0.1f);
            Assert.assertEquals((String)"Error reading attr", (long)0L, (long)((Long)longAccessor.getValue((Object)instance)));
            Assert.assertEquals((String)"Error reading attr", (long)0L, (long)((Short)shortAccessor.getValue((Object)instance)).shortValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("No exception is supposed to be generated when creating field accessor: " + e));
        }
    }

    public static class TestClass {
        private int intAttr;
        private String strAttr;
        private byte byteAttr;
        private boolean booleanAttr;
        private char charAttr;
        private double doubleAttr;
        private float floatAttr;
        private long longAttr;
        private short shortAttr;

        public int getIntAttr() {
            return this.intAttr;
        }

        public void setIntAttr(int intAttr) {
            this.intAttr = intAttr;
        }

        public String getStrAttr() {
            return this.strAttr;
        }

        public void setStrAttr(String strAttr) {
            this.strAttr = strAttr;
        }

        public boolean isBooleanAttr() {
            return this.booleanAttr;
        }

        public void setBooleanAttr(boolean booleanAttr) {
            this.booleanAttr = booleanAttr;
        }

        public byte getByteAttr() {
            return this.byteAttr;
        }

        public void setByteAttr(byte byteAttr) {
            this.byteAttr = byteAttr;
        }

        public char getCharAttr() {
            return this.charAttr;
        }

        public void setCharAttr(char charAttr) {
            this.charAttr = charAttr;
        }

        public double getDoubleAttr() {
            return this.doubleAttr;
        }

        public void setDoubleAttr(double doubleAttr) {
            this.doubleAttr = doubleAttr;
        }

        public float getFloatAttr() {
            return this.floatAttr;
        }

        public void setFloatAttr(float floatAttr) {
            this.floatAttr = floatAttr;
        }

        public long getLongAttr() {
            return this.longAttr;
        }

        public void setLongAttr(long longAttr) {
            this.longAttr = longAttr;
        }

        public short getShortAttr() {
            return this.shortAttr;
        }

        public void setShortAttr(short shortAttr) {
            this.shortAttr = shortAttr;
        }
    }
}

