/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.mvel.compiler.Bar;
import org.drools.mvel.compiler.Foo;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MatchTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MatchTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testGetObjectsOnePattern() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  Foo(id == \"Lotus Elise\")\nthen\n  list.addAll(kcontext.getMatch().getObjects());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kieCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kieCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(lotusElise));
        ksession.dispose();
    }

    @Test
    public void testGetObjectsTwoPatterns() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b : Bar(id == \"minivan\")\n  Foo(bar == $b)\nthen\n  list.addAll(kcontext.getMatch().getObjects());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kieCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kieCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(miniVanType));
        Assert.assertTrue((boolean)list.contains(kieCarnival));
        Assert.assertTrue((boolean)list.contains(renaultEspace));
        ksession.dispose();
    }

    @Test
    public void testGetObjectsAccumulateWithNoMatchingFacts() {
        String drl = "global java.util.List list\nrule R when\n  accumulate(\n    Object(false);\n    $total : count()\n  )\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(0L));
        ksession.dispose();
    }

    @Test
    public void testGetObjectsExists() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b : Bar(id == \"roadster\")\n  exists Foo(bar == $b)\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kiaCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kiaCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(roadsterType));
        Assert.assertTrue((boolean)list.contains(bmwZ4));
        Assert.assertTrue((boolean)list.contains(lotusElise));
        Assert.assertTrue((boolean)list.contains(mazdaMx5));
        Assert.assertFalse((boolean)list.contains(miniVanType));
        Assert.assertFalse((boolean)list.contains(kiaCarnival));
        Assert.assertFalse((boolean)list.contains(renaultEspace));
        ksession.dispose();
    }

    @Test
    public void testObjectsDeepOnNestedAccumulate() {
        String drl = "package testpkg;\nglobal java.util.List list;\nrule fairAssignmentCountPerTeam\n    when\n        accumulate(\n            $s : String()\n            and accumulate(\n                Number(this != null);\n                $count : count()\n            );\n            $result : average($count)\n        )\n    then\n        list.addAll( ((org.drools.core.spi.Activation) kcontext.getMatch()).getObjectsDeep() );end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)0.0, list.get(0));
    }

    @Test
    public void testObjectsDeepOnAccumulateWithoutReverse() {
        String rule = "package testpkg;\nimport " + CloudComputer.class.getCanonicalName() + "\n;import " + CloudProcess.class.getCanonicalName() + "\n;global java.util.List list\nrule requiredCpuPowerTotal when\n        $computer : CloudComputer($cpuPower : cpuPower)\n        accumulate(\n            CloudProcess(\n                computer == $computer,\n                $requiredCpuPower : requiredCpuPower);\n            $requiredCpuPowerTotal : max($requiredCpuPower);\n            (Integer) $requiredCpuPowerTotal > $cpuPower\n        )\n    then\n        list.addAll(((org.drools.core.spi.Activation) kcontext.getMatch()).getObjectsDeep());end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        CloudProcess proc = new CloudProcess();
        proc.setRequiredCpuPower(5);
        CloudComputer comp = new CloudComputer();
        proc.setComputer(comp);
        kieSession.insert((Object)proc);
        kieSession.insert((Object)comp);
        kieSession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(comp));
        Assert.assertTrue((boolean)list.contains(5));
        kieSession.dispose();
    }

    @Test
    public void testGetObjectsAccumulate() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b : Bar(id == \"roadster\")\n  accumulate(\n    $f : Foo(bar == $b);\n    $t : count($f)\n  )\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kieCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kieCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(roadsterType));
        Assert.assertTrue((boolean)list.contains(bmwZ4));
        Assert.assertTrue((boolean)list.contains(lotusElise));
        Assert.assertTrue((boolean)list.contains(mazdaMx5));
        ksession.dispose();
    }

    @Test
    public void testGetObjectsAccumulateWithNestedExists() {
        String str = "import org.drools.mvel.compiler.Foo\nimport org.drools.mvel.compiler.Bar\nglobal java.util.List list\nrule R when\n  $b1 : Bar(id == \"roadster\")\n  accumulate(\n    $b2 : Bar(this != $b1) and exists Foo(bar == $b2);\n    $t : count($b2)\n  )\nthen\n  list.addAll(((org.drools.core.spi.Activation)kcontext.getMatch()).getObjectsDeep());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Bar roadsterType = new Bar("roadster");
        ksession.insert((Object)roadsterType);
        Foo bmwZ4 = new Foo("BMW Z4", roadsterType);
        ksession.insert((Object)bmwZ4);
        Foo lotusElise = new Foo("Lotus Elise", roadsterType);
        ksession.insert((Object)lotusElise);
        Foo mazdaMx5 = new Foo("Mazda MX-5", roadsterType);
        ksession.insert((Object)mazdaMx5);
        Bar miniVanType = new Bar("minivan");
        ksession.insert((Object)miniVanType);
        Foo kiaCarnival = new Foo("Kia Carnival", miniVanType);
        ksession.insert((Object)kiaCarnival);
        Foo renaultEspace = new Foo("Renault Espace", miniVanType);
        ksession.insert((Object)renaultEspace);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(roadsterType));
        Assert.assertFalse((boolean)list.contains(bmwZ4));
        Assert.assertFalse((boolean)list.contains(lotusElise));
        Assert.assertFalse((boolean)list.contains(mazdaMx5));
        Assert.assertTrue((boolean)list.contains(miniVanType));
        Assert.assertTrue((boolean)list.contains(kiaCarnival));
        Assert.assertTrue((boolean)list.contains(renaultEspace));
        ksession.dispose();
    }

    public static class CloudProcess {
        private int requiredCpuPower;
        private CloudComputer computer;

        public void setRequiredCpuPower(int requiredCpuPower) {
            this.requiredCpuPower = requiredCpuPower;
        }

        public int getRequiredCpuPower() {
            return this.requiredCpuPower;
        }

        public void setComputer(CloudComputer computer) {
            this.computer = computer;
        }

        public CloudComputer getComputer() {
            return this.computer;
        }
    }

    public static class CloudComputer {
        public int getCpuPower() {
            return 0;
        }
    }
}

