/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.FileWriter;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import org.drools.core.SessionConfiguration;
import org.drools.kiesession.debug.SessionInspector;
import org.drools.kiesession.debug.StatefulKnowledgeSessionInfo;
import org.drools.mvel.SessionReporter;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class OutOfMemoryTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static Logger logger = LoggerFactory.getLogger(OutOfMemoryTest.class);

    public OutOfMemoryTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    @Ignore
    public void testStatefulSessionsCreation() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_OutOfMemoryError.drl"});
        int i = 0;
        SessionConfiguration conf = SessionConfiguration.newInstance();
        conf.setKeepReference(true);
        try {
            for (i = 0; i < 300000; ++i) {
                KieSession ksession = kbase.newKieSession((KieSessionConfiguration)conf, null);
                ksession.dispose();
            }
        }
        catch (Throwable e) {
            logger.info("Error at: " + i);
            e.printStackTrace();
            Assert.fail((String)"Should not raise any error or exception.");
        }
    }

    @Test
    @Ignore
    public void testAgendaLoop() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_OutOfMemoryError.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Cheese("stilton", 1));
        ksession.fireAllRules(3000000);
    }

    @Test
    @Ignore(value="dump_tuples.mvel no longer seems to work")
    public void testMemoryLeak() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MemoryLeak.drl"});
        KieSession ksession = kbase.newKieSession();
        int pcount = 5;
        Person[] persons = new Person[5];
        FactHandle[] pHandles = new FactHandle[5];
        for (int i = 0; i < persons.length; ++i) {
            persons[i] = new Person("person-0-" + i);
            pHandles[i] = ksession.insert((Object)persons[i]);
        }
        Cheese[] cheeses = new Cheese[5];
        FactHandle[] cHandles = new FactHandle[5];
        for (int i = 0; i < cheeses.length; ++i) {
            cheeses[i] = new Cheese("cheese-0-" + i);
            cHandles[i] = ksession.insert((Object)cheeses[i]);
        }
        ksession.fireAllRules();
        for (int j = 1; j <= 5; ++j) {
            for (int i = 0; i < 5; ++i) {
                cheeses[i].setType("cheese-" + j + "-" + i);
                ksession.update(cHandles[i], (Object)cheeses[i]);
                persons[i].setName("person-" + j + "-" + i);
                ksession.update(pHandles[i], (Object)persons[i]);
            }
            ksession.fireAllRules();
            logger.info("DONE");
        }
        SessionInspector inspector = new SessionInspector(ksession);
        SessionReporter.addNamedTemplate((String)"dump_tuples", (InputStream)this.getClass().getResourceAsStream("/org/drools/core/util/debug/dump_tuples.mvel"));
        String report = SessionReporter.generateReport((String)"dump_tuples", (StatefulKnowledgeSessionInfo)inspector.getSessionInfo(), new HashMap());
        try {
            FileWriter out = new FileWriter("tupleDump.txt");
            out.write(report);
            out.close();
            logger.info(report);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

