/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class RuleExtensionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleExtensionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testRuleExtendsNonexistingRule() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n\nrule \"ExtYes\" extends \"Bas\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testRuleExtendsBetweenDRLs() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str, str2});
        KieSession knowledgeSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsOnIncrementalKB() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str, str2});
        KieSession knowledgeSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsMissingOnIncrementalKB() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Bse\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str, str2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testRuleExtendsWithCompositeKBuilder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str, str2});
        KieSession knowledgeSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsNonExistingWithCompositeKBuilder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"ase\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str, str2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testRuleExtendsNonExistingWithCompositeKBuilderOutOfOrder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"ase\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str, str2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
        System.out.println(errors);
        Assert.assertFalse((boolean)errors.toString().contains("Circular"));
        Assert.assertTrue((boolean)errors.toString().contains("Base"));
    }

    @Test
    public void testRuleExtendsWithCompositeKBuilderFreeOrder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str, str2});
        KieSession knowledgeSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsExtendsWithCompositeKBuilderFreeOrder() {
        String str1 = "package org.drools.test;\n\nrule \"Base\"\nwhen\n  $i : Integer( this < 5 )\nthen\nend\n";
        String str2 = "package org.drools.test;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\n  $j : Integer( this > 5 )\nthen\nend\n";
        String str3 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"FinalRule\" extends \"ExtYes\"\nwhen\nthen\n  list.add( $i + $j );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1, str2, str3});
        KieSession knowledgeSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)4);
        knowledgeSession.insert((Object)6);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)10L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testRuleCircularExtension() {
        String str1 = "package org.drools.test;\n\nrule \"Base\" extends \"FinalRule\"\nwhen\n  $i : Integer( this < 5 )\nthen\nend\n";
        String str2 = "package org.drools.test;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\n  $j : Integer( this > 5 )\nthen\nend\n";
        String str3 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"Dummy\"\nwhen\nthen\nend\nrule \"FinalRule\" extends \"ExtYes\"\nwhen\nthen\n  list.add( $i + $j );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str1, str2, str3});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertTrue((boolean)((Message)errors.iterator().next()).toString().contains("Circular"));
    }
}

