/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.mvel.integrationtests.LinkingTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class SegmentCreationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SegmentCreationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testSingleEmptyLhs() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" ");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, InitialFactImpl.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertEquals((Object)liaNode, (Object)smem.getRootNode());
        Assert.assertEquals((Object)rtn, (Object)smem.getTipNode());
        Assert.assertNull((Object)smem.getNext());
        Assert.assertNull((Object)smem.getFirst());
    }

    @Test
    public void testSingleSharedEmptyLhs() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" ", " ");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, InitialFactImpl.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[1];
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertEquals((Object)liaNode, (Object)smem.getRootNode());
        Assert.assertEquals((Object)liaNode, (Object)smem.getTipNode());
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getRootNode());
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getTipNode());
        SegmentMemory rtnSmem2 = rtnSmem1.getNext();
        Assert.assertEquals((Object)rtn2, (Object)rtnSmem2.getRootNode());
        Assert.assertEquals((Object)rtn2, (Object)rtnSmem2.getTipNode());
    }

    @Test
    public void testSinglePattern() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("   A() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertNull((Object)smem);
    }

    @Test
    public void testSingleSharedPattern() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("   A() B()\n", "   A() B()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode beta = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[1];
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.fireAllRules();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertEquals((Object)liaNode, (Object)smem.getRootNode());
        Assert.assertEquals((Object)beta, (Object)smem.getTipNode());
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getRootNode());
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getTipNode());
        SegmentMemory rtnSmem2 = rtnSmem1.getNext();
        Assert.assertEquals((Object)rtn2, (Object)rtnSmem2.getRootNode());
        Assert.assertEquals((Object)rtn2, (Object)rtnSmem2.getTipNode());
    }

    @Test
    public void testMultiSharedPattern() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" X() A() \n", "  X()  A() B() \n", "  X() A() B() C() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode dotn = this.getObjectTypeNode(kbase, LinkingTest.X.class);
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)dotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode beta = (JoinNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)beta.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn2 = (RuleTerminalNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn3 = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        BetaMemory betaMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)beta);
        SegmentMemory smem = betaMem.getSegmentMemory();
        Assert.assertEquals((Object)lian, (Object)smem.getRootNode());
        Assert.assertEquals((Object)beta, (Object)smem.getTipNode());
        Assert.assertNull((Object)smem.getFirst());
        Assert.assertNull((Object)smem.getNext());
        wm.fireAllRules();
        wm.flushPropagations();
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getRootNode());
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getTipNode());
        SegmentMemory bSmem = rtnSmem1.getNext();
        Assert.assertEquals((Object)bNode, (Object)bSmem.getRootNode());
        Assert.assertEquals((Object)bNode, (Object)bSmem.getTipNode());
        SegmentMemory rtnSmem2 = (SegmentMemory)bSmem.getFirst();
        Assert.assertEquals((Object)rtn2, (Object)rtnSmem2.getRootNode());
        Assert.assertEquals((Object)rtn2, (Object)rtnSmem2.getTipNode());
        SegmentMemory cSmem = rtnSmem2.getNext();
        Assert.assertEquals((Object)cNode, (Object)cSmem.getRootNode());
        Assert.assertEquals((Object)rtn3, (Object)cSmem.getTipNode());
    }

    @Test
    public void testSubnetworkNoSharing() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" A()  not ( B() and C() ) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode = (RightInputAdapterNode)cNode.getSinkPropagator().getSinks()[0];
        NotNode notNode = (NotNode)liaNode.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn1 = (RuleTerminalNode)notNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertEquals((Object)liaNode, (Object)smem.getRootNode());
        Assert.assertEquals((Object)liaNode, (Object)smem.getTipNode());
        Assert.assertNull((Object)smem.getNext());
        smem = (SegmentMemory)smem.getFirst();
        SegmentMemory bSmem = wm.getNodeMemory((MemoryFactory)bNode).getSegmentMemory();
        Assert.assertEquals((Object)smem, (Object)bSmem);
        Assert.assertEquals((Object)bNode, (Object)bSmem.getRootNode());
        Assert.assertEquals((Object)riaNode, (Object)bSmem.getTipNode());
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)notNode);
        Assert.assertEquals((Object)bm.getSegmentMemory(), (Object)smem.getNext());
        Assert.assertEquals((Object)bSmem, (Object)bm.getRiaRuleMemory().getSegmentMemory());
    }

    @Test
    public void tesSubnetworkAfterShare() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("  X() A() \n", "   X() A()  not ( B() and C() ) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        ObjectTypeNode dotn = this.getObjectTypeNode(kbase, LinkingTest.X.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)dotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode joinNode = (JoinNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)joinNode.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)joinNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode = (RightInputAdapterNode)cNode.getSinkPropagator().getSinks()[0];
        NotNode notNode = (NotNode)joinNode.getSinkPropagator().getSinks()[2];
        RuleTerminalNode rtn2 = (RuleTerminalNode)notNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.fireAllRules();
        BetaMemory liaMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertEquals((Object)lian, (Object)smem.getRootNode());
        Assert.assertEquals((Object)joinNode, (Object)smem.getTipNode());
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getRootNode());
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getTipNode());
        SegmentMemory bSmem = rtnSmem1.getNext();
        Assert.assertEquals((Object)bNode, (Object)bSmem.getRootNode());
        Assert.assertEquals((Object)riaNode, (Object)bSmem.getTipNode());
        SegmentMemory notSmem = bSmem.getNext();
        Assert.assertEquals((Object)notNode, (Object)notSmem.getRootNode());
        Assert.assertEquals((Object)rtn2, (Object)notSmem.getTipNode());
        Assert.assertNull((Object)bSmem.getFirst());
    }

    @Test
    public void tesShareInSubnetwork() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("  X() A() \n", "   X() A() B() C() \n", "   X() A()  not ( B() and C() ) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        ObjectTypeNode dotn = this.getObjectTypeNode(kbase, LinkingTest.X.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)dotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode beta = (JoinNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)beta.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode = (RightInputAdapterNode)cNode.getSinkPropagator().getSinks()[1];
        NotNode notNode = (NotNode)beta.getSinkPropagator().getSinks()[2];
        RuleTerminalNode rtn3 = (RuleTerminalNode)notNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)lian);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertEquals((Object)lian, (Object)smem.getRootNode());
        Assert.assertEquals((Object)beta, (Object)smem.getTipNode());
        Assert.assertNull((Object)smem.getFirst());
        wm.fireAllRules();
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getRootNode());
        Assert.assertEquals((Object)rtn1, (Object)rtnSmem1.getTipNode());
        SegmentMemory bSmem = rtnSmem1.getNext();
        Assert.assertEquals((Object)bNode, (Object)bSmem.getRootNode());
        Assert.assertEquals((Object)cNode, (Object)bSmem.getTipNode());
        SegmentMemory rtn2Smem = (SegmentMemory)bSmem.getFirst();
        Assert.assertEquals((Object)rtn2, (Object)rtn2Smem.getRootNode());
        Assert.assertEquals((Object)rtn2, (Object)rtn2Smem.getTipNode());
        SegmentMemory riaSmem = rtn2Smem.getNext();
        Assert.assertEquals((Object)riaNode, (Object)riaSmem.getRootNode());
        Assert.assertEquals((Object)riaNode, (Object)riaSmem.getTipNode());
        SegmentMemory notSmem = bSmem.getNext();
        Assert.assertEquals((Object)notNode, (Object)notSmem.getRootNode());
        Assert.assertEquals((Object)rtn3, (Object)notSmem.getTipNode());
    }

    @Test
    public void testBranchCESingleSegment() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("   $a : A() \n   if ( $a != null ) do[t1] \n   B() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        ConditionalBranchNode cen1Node = (ConditionalBranchNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)cen1Node.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)bNode.getSinkPropagator().getSinks()[0];
        FactHandle bFh = wm.insert((Object)new LinkingTest.B());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assert.assertEquals((long)1L, (long)smem.getAllLinkedMaskTest());
        Assert.assertEquals((long)4L, (long)smem.getLinkedNodeMask());
        Assert.assertFalse((boolean)smem.isSegmentLinked());
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        Assert.assertEquals((long)1L, (long)pmem.getAllLinkedMaskTest());
        Assert.assertEquals((long)0L, (long)pmem.getLinkedSegmentMask());
        Assert.assertFalse((boolean)pmem.isRuleLinked());
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        Assert.assertEquals((long)5L, (long)smem.getLinkedNodeMask());
        Assert.assertTrue((boolean)smem.isSegmentLinked());
        Assert.assertEquals((long)1L, (long)pmem.getLinkedSegmentMask());
        Assert.assertTrue((boolean)pmem.isRuleLinked());
        wm.delete(bFh);
        wm.flushPropagations();
        Assert.assertEquals((long)1L, (long)pmem.getLinkedSegmentMask());
        Assert.assertTrue((boolean)pmem.isRuleLinked());
    }

    @Test
    public void testBranchCEMultipleSegments() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("  X() $a : A() \n", "  X()  $a : A() \n   if ( $a != null ) do[t1] \n   B() \n", "  X() $a : A() \n   if ( $a != null ) do[t1] \n   B() \n   C() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftTupleSource liaNode = (LeftTupleSource)aotn.getObjectSinkPropagator().getSinks()[0];
        ConditionalBranchNode cen1Node = (ConditionalBranchNode)liaNode.getSinkPropagator().getSinks()[1];
        JoinNode bNode = (JoinNode)cen1Node.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn3 = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        FactHandle bFh = wm.insert((Object)new LinkingTest.B());
        FactHandle cFh = wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        BetaMemory bNodeBm = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode);
        SegmentMemory bNodeSmem = bNodeBm.getSegmentMemory();
        Assert.assertEquals((long)0L, (long)bNodeSmem.getAllLinkedMaskTest());
        Assert.assertEquals((long)2L, (long)bNodeSmem.getLinkedNodeMask());
        PathMemory pmemr2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        Assert.assertEquals((long)1L, (long)pmemr2.getAllLinkedMaskTest());
        Assert.assertEquals((long)2L, (long)pmemr2.getLinkedSegmentMask());
        Assert.assertEquals((long)3L, (long)pmemr2.getSegmentMemories().length);
        Assert.assertFalse((boolean)pmemr2.isRuleLinked());
        PathMemory pmemr3 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn3);
        Assert.assertEquals((long)1L, (long)pmemr3.getAllLinkedMaskTest());
        Assert.assertEquals((long)3L, (long)pmemr3.getSegmentMemories().length);
        Assert.assertFalse((boolean)pmemr3.isRuleLinked());
        BetaMemory cNodeBm = (BetaMemory)wm.getNodeMemory((MemoryFactory)cNode);
        SegmentMemory cNodeSmem = cNodeBm.getSegmentMemory();
        Assert.assertEquals((long)1L, (long)cNodeSmem.getAllLinkedMaskTest());
        Assert.assertEquals((long)1L, (long)cNodeSmem.getLinkedNodeMask());
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        Assert.assertTrue((boolean)pmemr2.isRuleLinked());
        Assert.assertTrue((boolean)pmemr3.isRuleLinked());
        wm.delete(bFh);
        wm.delete(cFh);
        wm.flushPropagations();
        Assert.assertEquals((long)3L, (long)pmemr2.getLinkedSegmentMask());
        Assert.assertTrue((boolean)pmemr2.isRuleLinked());
        Assert.assertEquals((long)3L, (long)pmemr3.getLinkedSegmentMask());
        Assert.assertTrue((boolean)pmemr3.isRuleLinked());
    }

    private KieBase buildKnowledgeBase(String ... rules) {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + LinkingTest.A.class.getCanonicalName() + "\n";
        str = str + "import " + LinkingTest.B.class.getCanonicalName() + "\n";
        str = str + "import " + LinkingTest.C.class.getCanonicalName() + "\n";
        str = str + "import " + LinkingTest.X.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        int i = 0;
        for (String lhs : rules) {
            str = str + "rule rule" + i++ + "  when \n";
            str = str + lhs;
            str = str + "then \n";
            str = str + "then[t1] \n";
            str = str + "end \n";
        }
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        return kbase;
    }

    public ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((RuleBase)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }
}

