/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class WindowTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession;
    private SessionPseudoClock clock;
    private String drl = "package org.drools.mvel.integrationtests;\n\nimport org.drools.mvel.integrationtests.WindowTest.TestEvent\n\nglobal java.util.List result\n\ndeclare TestEvent\n    @role( event )\nend\n\ndeclare window DeclaredTimeWindow\n    TestEvent ( name == \"timeDec\" ) over window:time( 50ms ) from entry-point EventStream\nend\n\ndeclare window DeclaredLengthWindow\n    TestEvent ( name == \"lengthDec\" ) over window:length( 5 ) from entry-point EventStream\nend\n\nquery \"TestTimeWindow\"\n    Number( $eventCount : longValue ) from\n        accumulate (\n            $event : TestEvent ( name == \"time\" ) over window:time( 300ms ) from entry-point EventStream,\n            count($event)\n        )\nend\n\nquery \"TestLengthWindow\"\n    Number( $eventCount : longValue ) from\n        accumulate (\n            $event : TestEvent ( name == \"length\" ) over window:length( 10 ) from entry-point EventStream,\n            count($event)\n        )\nend\n\nquery \"TestDeclaredTimeWindow\"\n    Number( $eventCount : longValue ) from\n        accumulate ( \n            $event : TestEvent () from window DeclaredTimeWindow,\n            count( $event )\n        )\nend\n\nquery \"TestDeclaredLengthWindow\"\n    Number( $eventCount : longValue ) from\n        accumulate ( \n            $event : TestEvent () from window DeclaredLengthWindow,\n            count( $event )\n        )\nend\n\nrule \"TestDeclaredTimeWindowRule\"\n    when\n        Number( $eventCount : longValue, longValue > 0 ) from \n            accumulate ( \n                $event : TestEvent () from window DeclaredTimeWindow,\n                count( $event )\n            )\n    then\n        result.add($eventCount);\nend\n\nrule \"TestDeclaredLengthWindowRule\"\n    when\n        Number( $eventCount : longValue, longValue > 0 ) from \n            accumulate ( \n                $event : TestEvent () from window DeclaredLengthWindow,\n                count( $event )\n            )\n    then\n        result.add($eventCount);\nend\n";

    public WindowTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Before
    public void initialization() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.drl});
        KieSessionConfiguration ksconfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconfig.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        this.ksession = kbase.newKieSession(ksconfig, null);
        this.clock = (SessionPseudoClock)this.ksession.getSessionClock();
    }

    @After
    public void clean() {
        this.ksession.dispose();
    }

    @Test
    public void testTimeWindow() throws InterruptedException {
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        long[] results = new long[]{1L, 2L, 3L, 3L, 3L};
        for (int i = 0; i < 5; ++i) {
            TestEvent event = new TestEvent(null, "time", null);
            entryPoint.insert((Object)event);
            Assert.assertEquals((Object)results[i], (Object)((QueryResultsRow)this.ksession.getQueryResults("TestTimeWindow", new Object[0]).iterator().next()).get("$eventCount"));
            this.clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void testLengthWindow() {
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        for (int i = 1; i <= 20; ++i) {
            TestEvent event = new TestEvent(null, "length", null);
            entryPoint.insert((Object)event);
            Assert.assertEquals((long)(i < 10 ? i : 10), (long)((Long)((QueryResultsRow)this.ksession.getQueryResults("TestLengthWindow", new Object[0]).iterator().next()).get("$eventCount")).intValue());
        }
    }

    @Test
    public void testDeclaredTimeWindowInQuery() throws InterruptedException {
        long[] results = new long[]{1L, 2L, 3L, 4L, 5L, 5L, 5L, 5L, 5L, 5L};
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        for (int i = 0; i < 10; ++i) {
            TestEvent event = new TestEvent(null, "timeDec", null);
            entryPoint.insert((Object)event);
            Assert.assertEquals((Object)results[i], (Object)((QueryResultsRow)this.ksession.getQueryResults("TestDeclaredTimeWindow", new Object[0]).iterator().next()).get("$eventCount"));
            this.clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void testDeclaredLengthWindowInQuery() {
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        for (int i = 1; i <= 10; ++i) {
            TestEvent event = new TestEvent(null, "lengthDec", null);
            entryPoint.insert((Object)event);
            Assert.assertEquals((long)(i < 5 ? i : 5), (long)((Long)((QueryResultsRow)this.ksession.getQueryResults("TestDeclaredLengthWindow", new Object[0]).iterator().next()).get("$eventCount")).intValue());
        }
    }

    @Test
    public void testDeclaredTimeWindowInRule() throws InterruptedException {
        long[] results = new long[]{1L, 2L, 3L, 4L, 5L, 5L, 5L, 5L, 5L, 5L};
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        ArrayList result = new ArrayList();
        this.ksession.setGlobal("result", result);
        for (int i = 0; i < 10; ++i) {
            TestEvent event = new TestEvent(null, "timeDec", null);
            entryPoint.insert((Object)event);
            this.ksession.fireAllRules();
            Assert.assertEquals((long)results[i], (long)((Long)result.get(result.size() - 1)));
            this.clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void testDeclaredLengthWindowInRule() {
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        ArrayList result = new ArrayList();
        this.ksession.setGlobal("result", result);
        for (int i = 1; i <= 10; ++i) {
            TestEvent event = new TestEvent(null, "lengthDec", null);
            entryPoint.insert((Object)event);
            this.ksession.fireAllRules();
            Assert.assertEquals((long)(i < 5 ? i : 5), (long)((Long)result.get(result.size() - 1)));
        }
    }

    public class TestEvent
    implements Serializable {
        private static final long serialVersionUID = -6985691286327371275L;
        private final Integer id;
        private final String name;
        private Serializable value;

        public TestEvent(Integer id, String name, Serializable value) {
            this.id = id;
            this.name = name;
            this.value = value;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Serializable getValue() {
            return this.value;
        }

        public void setValue(Serializable value) {
            this.value = value;
        }

        public String toString() {
            return String.format("TestEvent[id=%s, name=%s, value=%s]", this.id, this.name, this.value);
        }
    }
}

