/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentInsertionsTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class ConcurrentInsertionsToSubnetworksTest
extends AbstractConcurrentInsertionsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    protected final String drl;
    private static final String sharedSubnetworkAccumulateRule = "import " + AtomicInteger.class.getCanonicalName() + ";\nrule R1y when\n    Number() from accumulate ( AtomicInteger() and $s : String( this == \"test_1\" ) ; count($s) )    AtomicInteger() \n    Long()\nthen\n    System.out.println(\"R1y\");end\n\nrule R1x when\n    Number() from accumulate ( AtomicInteger() and $s : String( this == \"test_1\" ) ; count($s) )\n    AtomicInteger( get() == 1 ) \nthen\n    System.out.println(\"R1x\");end\nrule R2 when\n    $i : AtomicInteger( get() < 3 )\nthen\n    System.out.println(\"R2\");    $i.incrementAndGet();    update($i);end\n";
    private static final String noSharingSubnetworkAccumulateRule = "import " + AtomicInteger.class.getCanonicalName() + ";\nrule R1y when\n    AtomicInteger() \n    Number() from accumulate ( AtomicInteger() and $s : String( this == \"test_1\" ) ; count($s) )    Long()\nthen\n    System.out.println(\"R1y\");end\n\nrule R1x when\n    AtomicInteger() \n    Number() from accumulate ( $i : AtomicInteger( get() == 1) and String( this == \"test_2\" ) ; count($i) )\nthen\n    System.out.println(\"R1x\");end\nrule R2 when\n    $i : AtomicInteger( get() < 3 )\nthen\n    System.out.println(\"R2\");    $i.incrementAndGet();    update($i);end\n";
    private static final String sharedSubnetworkNotRule = "import " + AtomicInteger.class.getCanonicalName() + ";\nrule R1 when\n    AtomicInteger() \n    not(AtomicInteger( get() == 1 ) and String( this == \"test_1\" )) \nthen\n    System.out.println(\"R1\");end\n\nrule R2 when\n    AtomicInteger() \n    not(AtomicInteger( get() == 1 ) and String( this == \"test_1\" )) \n    String( this != \"test_2\" ) \nthen\n    System.out.println(\"R2\");end\n";
    private static final String sharedSubnetworkExistsRule = "import " + AtomicInteger.class.getCanonicalName() + ";\nrule R1 when\n    AtomicInteger() \n    exists(AtomicInteger( get() == 1 ) and String( this == \"test_1\" )) \nthen\n    System.out.println(\"R1\");end\n\nrule R2 when\n    AtomicInteger() \n    exists(AtomicInteger( get() == 1 ) and String( this == \"test_1\" )) \n    String( this != \"test_2\" ) \nthen\n    System.out.println(\"R2\");end\n";

    @Parameterized.Parameters(name="DRL={0}, KieBase type={2}")
    public static List<Object[]> getTestParameter() {
        List<Object[]> drlParams = Arrays.asList({"sharedSubnetworkAccumulateRule", sharedSubnetworkAccumulateRule}, {"noSharingSubnetworkAccumulateRule", noSharingSubnetworkAccumulateRule}, {"sharedSubnetworkNotRule", sharedSubnetworkNotRule}, {"sharedSubnetworkExistsRule", sharedSubnetworkExistsRule});
        Collection kbParams = TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Object[] drlParam : drlParams) {
            for (Object[] kbParam : kbParams) {
                params.add(new Object[]{drlParam[0], drlParam[1], kbParam[0]});
            }
        }
        return params;
    }

    public ConcurrentInsertionsToSubnetworksTest(String drlName, String drl, KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.drl = drl;
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Test(timeout=80000L)
    public void testConcurrentInsertionsFewObjectsManyThreads() throws InterruptedException {
        this.testConcurrentInsertions(this.drl, 1, 1000, false, false, this.kieBaseTestConfiguration);
    }

    @Test(timeout=80000L)
    public void testConcurrentInsertionsManyObjectsFewThreads() throws InterruptedException {
        this.testConcurrentInsertions(this.drl, 500, 4, false, false, this.kieBaseTestConfiguration);
    }

    @Test(timeout=80000L)
    public void testConcurrentInsertionsManyObjectsSingleThread() throws InterruptedException {
        this.testConcurrentInsertions(this.drl, 1000, 1, false, false, this.kieBaseTestConfiguration);
    }

    @Test(timeout=80000L)
    public void testConcurrentInsertionsNewSessionEachThread() throws InterruptedException {
        this.testConcurrentInsertions(this.drl, 10, 1000, true, false, this.kieBaseTestConfiguration);
    }

    @Test(timeout=80000L)
    public void testConcurrentInsertionsNewSessionEachThreadUpdate() throws InterruptedException {
        this.testConcurrentInsertions(this.drl, 10, 1000, true, true, this.kieBaseTestConfiguration);
    }

    @Override
    protected Callable<Boolean> getTask(int objectCount, KieSession ksession, boolean disposeSession, boolean updateFacts) {
        return () -> {
            try {
                for (int j = 0; j < 10; ++j) {
                    int i;
                    FactHandle[] facts = new FactHandle[objectCount];
                    FactHandle[] stringFacts = new FactHandle[objectCount];
                    for (i = 0; i < objectCount; ++i) {
                        facts[i] = ksession.insert((Object)new AtomicInteger(i));
                        stringFacts[i] = ksession.insert((Object)("test_" + i));
                    }
                    if (updateFacts) {
                        for (i = 0; i < objectCount; ++i) {
                            ksession.update(facts[i], (Object)new AtomicInteger(-i));
                            ksession.update(stringFacts[i], (Object)("updated_test_" + i));
                        }
                    }
                    for (i = 0; i < objectCount; ++i) {
                        ksession.delete(facts[i]);
                        ksession.delete(stringFacts[i]);
                    }
                    ksession.fireAllRules();
                }
                Boolean j = true;
                return j;
            }
            catch (Exception e) {
                e.printStackTrace();
                Boolean bl = false;
                return bl;
            }
            finally {
                if (disposeSession) {
                    ksession.dispose();
                }
            }
        };
    }
}

