/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.phreak.PhreakExistsNode;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.PhreakNotNode;
import org.drools.core.phreak.SegmentPropagator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.spi.Tuple;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.mvel.integrationtests.phreak.LeftBuilder;
import org.drools.mvel.integrationtests.phreak.RightBuilder;
import org.drools.mvel.integrationtests.phreak.StagedBuilder;
import org.junit.Assert;

public class Scenario {
    Class phreakNode;
    BetaNode betaNode;
    LeftTupleSink sinkNode;
    BetaMemory bm;
    InternalWorkingMemory wm;
    TupleSets<LeftTuple> leftTuples;
    TupleSets<RightTuple> rightRuples;
    StagedBuilder expectedResultBuilder;
    TupleSets<LeftTuple> actualResultLeftTuples;
    TupleSets<LeftTuple> previousResultTuples;
    List<StagedBuilder> preStagedBuilders;
    List<StagedBuilder> postStagedBuilders;
    List<LeftTuple> leftMemory;
    List<RightTuple> rightMemory;
    private boolean testLeftMemory;
    private boolean testRightMemory;

    public Scenario(Class phreakNode, BetaNode betaNode, LeftTupleSink sinkNode, BetaMemory bm, InternalWorkingMemory wm) {
        this.phreakNode = phreakNode;
        this.betaNode = betaNode;
        this.sinkNode = sinkNode;
        this.bm = bm;
        this.wm = wm;
        this.leftTuples = new TupleSetsImpl();
        this.rightRuples = new TupleSetsImpl();
        this.preStagedBuilders = new ArrayList<StagedBuilder>();
        this.postStagedBuilders = new ArrayList<StagedBuilder>();
        this.bm.setStagedRightTuples(this.rightRuples);
        this.leftMemory = new ArrayList<LeftTuple>();
        this.rightMemory = new ArrayList<RightTuple>();
    }

    public StagedBuilder getExpectedResultBuilder() {
        return this.expectedResultBuilder;
    }

    public void setExpectedResultBuilder(StagedBuilder stagedBuilder) {
        this.expectedResultBuilder = stagedBuilder;
    }

    public boolean isTestLeftMemory() {
        return this.testLeftMemory;
    }

    public void setTestLeftMemory(boolean testLeftMemory) {
        this.testLeftMemory = testLeftMemory;
    }

    public boolean isTestRightMemory() {
        return this.testRightMemory;
    }

    public void setTestRightMemory(boolean testRightMemory) {
        this.testRightMemory = testRightMemory;
    }

    public TupleSets<LeftTuple> getActualResultLeftTuples() {
        return this.actualResultLeftTuples;
    }

    public void addPreStagedBuilder(StagedBuilder stagedBuilder) {
        this.preStagedBuilders.add(stagedBuilder);
    }

    public void addPostStagedBuilder(StagedBuilder stagedBuilder) {
        this.postStagedBuilders.add(stagedBuilder);
    }

    public LeftBuilder left() {
        return new LeftBuilder(this);
    }

    public RightBuilder right() {
        return new RightBuilder(this);
    }

    public BetaNode getBetaNode() {
        return this.betaNode;
    }

    public LeftTupleSink getSinkNode() {
        return this.sinkNode;
    }

    public BetaMemory getBm() {
        return this.bm;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.wm;
    }

    public TupleSets<RightTuple> getRightRuples() {
        return this.rightRuples;
    }

    public TupleSets<LeftTuple> getLeftTuples() {
        return this.leftTuples;
    }

    public TupleSets<RightTuple> getRightTuples() {
        return this.rightRuples;
    }

    public List<LeftTuple> getLeftMemory() {
        return this.leftMemory;
    }

    public List<RightTuple> getRightMemory() {
        return this.rightMemory;
    }

    public Scenario run() {
        this.previousResultTuples = ((SegmentMemory)this.bm.getSegmentMemory().getFirst()).getStagedLeftTuples();
        this.actualResultLeftTuples = new TupleSetsImpl();
        if (this.phreakNode == PhreakJoinNode.class) {
            new PhreakJoinNode().doNode((JoinNode)this.betaNode, this.sinkNode, this.bm, (ReteEvaluator)this.wm, this.leftTuples, this.actualResultLeftTuples, this.previousResultTuples);
        } else if (this.phreakNode == PhreakNotNode.class) {
            new PhreakNotNode().doNode((NotNode)this.betaNode, this.sinkNode, this.bm, (ReteEvaluator)this.wm, this.leftTuples, this.actualResultLeftTuples, this.previousResultTuples);
        } else if (this.phreakNode == PhreakExistsNode.class) {
            new PhreakExistsNode().doNode((ExistsNode)this.betaNode, this.sinkNode, this.bm, (ReteEvaluator)this.wm, this.leftTuples, this.actualResultLeftTuples, this.previousResultTuples);
        }
        if (this.expectedResultBuilder != null) {
            this.assertEquals(this.expectedResultBuilder.get(), this.actualResultLeftTuples, this.expectedResultBuilder.isTestStagedInsert(), this.expectedResultBuilder.isTestStagedDelete(), this.expectedResultBuilder.isTestStagedUpdate());
        }
        if (!this.preStagedBuilders.isEmpty()) {
            for (StagedBuilder stagedBuilder : this.preStagedBuilders) {
                TupleSets<LeftTuple> expected = stagedBuilder.get();
                TupleSets actual = stagedBuilder.getSegmentMemory().getStagedLeftTuples();
                this.assertEquals(expected, (TupleSets<LeftTuple>)actual, stagedBuilder.isTestStagedInsert(), stagedBuilder.isTestStagedDelete(), stagedBuilder.isTestStagedUpdate());
            }
        }
        SegmentMemory smem = this.bm.getSegmentMemory();
        SegmentPropagator.propagate((SegmentMemory)smem, this.actualResultLeftTuples, (ReteEvaluator)this.wm);
        if (this.testLeftMemory) {
            this.equalsLeftMemory(this.leftMemory);
        }
        if (this.testRightMemory) {
            this.equalsRightMemory(this.rightMemory);
        }
        if (!this.postStagedBuilders.isEmpty()) {
            for (StagedBuilder stagedBuilder : this.postStagedBuilders) {
                TupleSets<LeftTuple> expected = stagedBuilder.get();
                TupleSets actual = stagedBuilder.getSegmentMemory().getStagedLeftTuples();
                this.assertEquals(expected, (TupleSets<LeftTuple>)actual, stagedBuilder.isTestStagedInsert(), stagedBuilder.isTestStagedDelete(), stagedBuilder.isTestStagedUpdate());
            }
        }
        return this;
    }

    public StagedBuilder result() {
        StagedBuilder stagedBuilder = new StagedBuilder(this, null);
        this.setExpectedResultBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder preStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this, sm);
        this.addPreStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder postStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this, sm);
        this.addPostStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public void assertEquals(TupleSets<LeftTuple> expected, TupleSets<LeftTuple> actual, boolean testInsert, boolean testDelete, boolean testUpdate) {
        Tuple expectedTuple;
        int i;
        Tuple actualTuple;
        if (testInsert) {
            if (expected.getInsertFirst() != null) {
                actualTuple = actual.getInsertFirst();
                i = 0;
                for (expectedTuple = expected.getInsertFirst(); expectedTuple != null; expectedTuple = expectedTuple.getStagedNext()) {
                    Assert.assertTrue((String)("insert " + i + ":\n" + actualTuple + "\nis not the expected\n" + expectedTuple), (boolean)this.equals(expectedTuple, actualTuple));
                    actualTuple = actualTuple.getStagedNext();
                    ++i;
                }
                Assert.assertNull((String)"Insert excpected more", (Object)actualTuple);
            } else if (actual.getInsertFirst() != null) {
                Assert.fail((String)"Expected nothing, but insert existed");
            }
        }
        if (testDelete) {
            if (expected.getDeleteFirst() != null) {
                actualTuple = actual.getDeleteFirst();
                i = 0;
                for (expectedTuple = expected.getDeleteFirst(); expectedTuple != null; expectedTuple = expectedTuple.getStagedNext()) {
                    Assert.assertTrue((String)("delete " + i + ":\n" + actualTuple + "\nis not the expected\n" + expectedTuple), (boolean)this.equals(expectedTuple, actualTuple));
                    actualTuple = actualTuple.getStagedNext();
                    ++i;
                }
                Assert.assertNull((String)"Delete excpected more", (Object)actualTuple);
            } else if (actual.getDeleteFirst() != null) {
                Assert.fail((String)"Expected nothing, but delete existed");
            }
        }
        if (testUpdate) {
            if (expected.getUpdateFirst() != null) {
                actualTuple = actual.getUpdateFirst();
                i = 0;
                for (expectedTuple = expected.getUpdateFirst(); expectedTuple != null; expectedTuple = expectedTuple.getStagedNext()) {
                    Assert.assertTrue((String)("update " + i + ":\n" + actualTuple + "\nis not the expected\n" + expectedTuple), (boolean)this.equals(expectedTuple, actualTuple));
                    actualTuple = actualTuple.getStagedNext();
                    ++i;
                }
                Assert.assertNull((String)"Update excpected more", (Object)actualTuple);
            } else if (actual.getUpdateFirst() != null) {
                Assert.fail((String)"Expected nothing, but update existed");
            }
        }
    }

    public boolean equals(Tuple expected, Tuple actual) {
        if (expected == actual) {
            return true;
        }
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return expected == null;
        }
        while (actual.getFactHandle() == null) {
            actual = actual.getParent();
        }
        return expected.hashCode() == actual.hashCode() && expected.getFactHandle() == actual.getFactHandle() && this.equals(expected.getParent(), actual.getParent());
    }

    public void equalsLeftMemory(List<LeftTuple> leftTuples) {
        TupleMemory ltm = this.bm.getLeftTupleMemory();
        int length = 0;
        for (LeftTuple expectedLeftTuple : leftTuples) {
            FastIterator it = this.betaNode.getLeftIterator(ltm);
            Tuple actualLeftTuple = null;
            actualLeftTuple = BetaNode.getFirstTuple((TupleMemory)ltm, (FastIterator)it);
            while (actualLeftTuple != null) {
                if (expectedLeftTuple.equals(actualLeftTuple)) {
                    ++length;
                    break;
                }
                actualLeftTuple = (LeftTuple)it.next((Entry)actualLeftTuple);
            }
            if (actualLeftTuple != null) continue;
            Assert.fail((String)("Could not find LeftTuple: " + expectedLeftTuple));
        }
        if (leftTuples.size() != ltm.size()) {
            Assert.fail((String)("LeftTuple memory size did not match: " + length));
        }
    }

    public void equalsRightMemory(List<RightTuple> rightTuples) {
        TupleMemory rtm = this.bm.getRightTupleMemory();
        int length = 0;
        for (RightTuple expectedRightTuple : rightTuples) {
            FastIterator it = this.betaNode.getRightIterator(rtm);
            Tuple actualRightTuple = null;
            actualRightTuple = BetaNode.getFirstTuple((TupleMemory)rtm, (FastIterator)it);
            while (actualRightTuple != null) {
                if (expectedRightTuple.equals(actualRightTuple)) {
                    ++length;
                    break;
                }
                actualRightTuple = (RightTuple)it.next((Entry)actualRightTuple);
            }
            if (actualRightTuple != null) continue;
            Assert.fail((String)("Could not find RightTuple: " + expectedRightTuple));
        }
        if (rightTuples.size() != rtm.size()) {
            Assert.fail((String)("RightTuple memory size did not match: " + length));
        }
    }
}

