/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.base.SalienceInteger;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.spi.Salience;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.expr.MVELSalienceExpression;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSessionConfiguration;

public class RuleTest {
    @Test
    public void testDateEffective() {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", null).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateEffective(earlier);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        Assert.assertTrue((boolean)later.after(Calendar.getInstance()));
        rule.setDateEffective(later);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
    }

    @Test
    public void testDateExpires() throws Exception {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", null).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateExpires(earlier);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        rule.setDateExpires(later);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
    }

    @Test
    public void testDateEffectiveExpires() {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", null).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        Calendar future = Calendar.getInstance();
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(past);
        rule.setDateExpires(future);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        rule.setDateExpires(past);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        rule.setDateExpires(future);
        rule.setDateEffective(future);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
    }

    @Test
    public void testRuleEnabled() {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", null).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_FALSE);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        rule.setDateEffective(past);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
    }

    @Test
    public void testTimeMachine() {
        SessionConfiguration conf = SessionConfiguration.newInstance();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", null).newKieSession((KieSessionConfiguration)conf, null);
        Calendar future = Calendar.getInstance();
        ((PseudoClockScheduler)wm.getSessionClock()).setStartupTime(future.getTimeInMillis());
        RuleImpl rule = new RuleImpl("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(future);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
        ((PseudoClockScheduler)wm.getSessionClock()).advanceTime(1000000000000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (ReteEvaluator)wm));
    }

    @Test
    public void testGetSalienceValue() {
        RuleImpl rule = new RuleImpl("myrule");
        int salienceValue = 100;
        SalienceInteger salience = new SalienceInteger(100);
        rule.setSalience((Salience)salience);
        Assert.assertEquals((long)100L, (long)rule.getSalienceValue());
        Assert.assertFalse((boolean)rule.isSalienceDynamic());
    }

    @Test
    public void testIsSalienceDynamic() {
        RuleImpl rule = new RuleImpl("myrule");
        MVELSalienceExpression salience = new MVELSalienceExpression();
        rule.setSalience((Salience)salience);
        Assert.assertTrue((boolean)rule.isSalienceDynamic());
    }
}

