/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.beliefsystem.jtms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.core.BeliefSystemType;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.util.ObjectHashMap;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.drools.tms.TruthMaintenanceSystemEqualityKey;
import org.drools.tms.TruthMaintenanceSystemImpl;
import org.drools.tms.beliefsystem.jtms.JTMSBeliefSystem;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;

@RunWith(value=Parameterized.class)
public class JTMSTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public JTMSTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false, (boolean)true);
    }

    protected KieSession getSessionFromString(String drlString) {
        KieBase kBase;
        try {
            System.setProperty("drools.negatable", "on");
            kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlString});
        }
        finally {
            System.setProperty("drools.negatable", "off");
        }
        KieSessionConfiguration ksConf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ((SessionConfiguration)ksConf).setBeliefSystemType(BeliefSystemType.JTMS);
        KieSession kSession = kBase.newKieSession(ksConf, null);
        return kSession;
    }

    protected KieSession getSessionFromFile(String ruleFile) {
        KieBase kBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{ruleFile});
        KieSessionConfiguration ksConf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ((SessionConfiguration)ksConf).setBeliefSystemType(BeliefSystemType.JTMS);
        KieSession kSession = kBase.newKieSession(ksConf, null);
        return kSession;
    }

    @Test(timeout=10000L)
    public void testPosNegNonConflictingInsertions() {
        String s = "package org.drools.core.beliefsystem.jtms;\n\nimport java.util.List \nimport org.drools.core.common.AgendaItem;global java.util.List list;\n\nrule \"go1\"\nwhen\n    String( this == 'go1' )\nthen\n    insertLogical( 'neg', 'neg' );\nend\n\nrule \"go2\"\nwhen\n    String( this == 'go2' )\nthen\n    insertLogical( 'pos' );\nend\n\nrule \"Positive\"\nwhen\n    $n : String( this != 'go1' || == 'go2' ) \nthen\n    final String s = '+' + $n;    final List l = list;    l.add( s );\nend\nrule \"Negative\"\nwhen\n    $n : String(   _.neg, this != 'go1' || == 'go2' ) \nthen\n    final String s = '-' + $n; \n    final List l = list; \n    l.add( s ); \nend\n";
        KieSession kSession = this.getSessionFromString(s);
        final ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        ((RuleEventManager)kSession).addEventListener(new RuleEventListener(){

            public void onDeleteMatch(Match match) {
                String rule = match.getRule().getName();
                if (rule.equals("Positive")) {
                    list.remove("+" + match.getDeclarationValue("$n"));
                } else if (rule.equals("Negative")) {
                    list.remove("-" + match.getDeclarationValue("$n"));
                }
            }
        });
        FactHandle fhGo1 = kSession.insert((Object)"go1");
        kSession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("-neg"));
        Assert.assertEquals((long)1L, (long)kSession.getEntryPoint("DEFAULT").getObjects().size());
        Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
        FactHandle fhGo2 = kSession.insert((Object)"go2");
        kSession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("-neg"));
        Assert.assertTrue((boolean)list.contains("+pos"));
        Assert.assertEquals((long)3L, (long)kSession.getEntryPoint("DEFAULT").getObjects().size());
        Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
        kSession.retract(fhGo1);
        kSession.fireAllRules();
        Assert.assertFalse((boolean)list.contains("-neg"));
        Assert.assertTrue((boolean)list.contains("+pos"));
        Assert.assertEquals((long)2L, (long)kSession.getEntryPoint("DEFAULT").getObjects().size());
        Assert.assertEquals((long)0L, (long)this.getNegativeObjects(kSession).size());
        kSession.retract(fhGo2);
        kSession.fireAllRules();
        Assert.assertFalse((boolean)list.contains("-neg"));
        Assert.assertFalse((boolean)list.contains("+pos"));
        Assert.assertEquals((long)0L, (long)kSession.getEntryPoint("DEFAULT").getObjects().size());
        Assert.assertEquals((long)0L, (long)this.getNegativeObjects(kSession).size());
    }

    @Test(timeout=10000L)
    public void testConflictToggleWithoutGoingEmpty() {
        String s = "package org.drools.core.beliefsystem.jtms;\n\nimport java.util.List \nimport org.drools.core.common.AgendaItem;global java.util.List list;\n\nrule \"go1\"\nwhen\n    String( this == 'go1' )\nthen\n    insertLogical( 'xxx' );\nend\nrule \"go2\"\nwhen\n    String( this == 'go2' )\nthen\n    insertLogical( 'xxx');\nend\nrule \"go3\"\nwhen\n    String( this == 'go3' )\nthen\n    insertLogical( 'xxx');\nend\n\nrule \"go4\"\nwhen\n    String( this == 'go4' )\nthen\n    insertLogical( 'xxx', 'neg' );\nend\n\nrule \"Positive\"\nwhen\n    $n : String( this == 'xxx' ) \nthen\n    final String s = '+' + $n;    final List l = list;    l.add( s );\nend\nrule \"Negative\"\nwhen\n    $n : String( _.neg, this == 'xxx' )\nthen\n    final String s = '-' + $n; \n    final List l = list; \n    l.add( s ); \nend\n";
        KieSession kSession = this.getSessionFromString(s);
        final ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        ((RuleEventManager)kSession).addEventListener(new RuleEventListener(){

            public void onDeleteMatch(Match match) {
                String rule = match.getRule().getName();
                if (rule.equals("Positive")) {
                    list.remove("+" + match.getDeclarationValue("$n"));
                } else if (rule.equals("Negative")) {
                    list.remove("-" + match.getDeclarationValue("$n"));
                }
            }
        });
        FactHandle fhGo1 = kSession.insert((Object)"go1");
        FactHandle fhGo2 = kSession.insert((Object)"go2");
        FactHandle fhGo3 = kSession.insert((Object)"go3");
        kSession.fireAllRules();
        System.out.println(list);
        Assert.assertTrue((boolean)list.contains("+xxx"));
        FactHandle fhGo4 = kSession.insert((Object)"go4");
        kSession.fireAllRules();
        Assert.assertTrue((boolean)list.isEmpty());
        kSession.delete(fhGo4);
        kSession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("+xxx"));
    }

    @Test(timeout=10000L)
    @Ignore(value="Currently cannot support updates")
    public void testChangeInPositivePrime() {
        String s = "package org.drools.core.beliefsystem.jtms;\n\nimport org.kie.internal.event.rule.ActivationUnMatchListener;\nimport java.util.List \nimport org.drools.core.common.AgendaItem;import org.drools.mvel.compiler.Person;global java.util.List list;\n\nrule \"go1\"\nwhen\n    String( this == 'go1' )\nthen\n    Person p = new Person( 'darth' ); \n    p.setNotInEqualTestObject(1); \n    insertLogical( p );\nend\nrule \"go2\"\nwhen\n    String( this == 'go2' )\nthen\n    Person p = new Person( 'darth' ); \n    p.setNotInEqualTestObject(2); \n    insertLogical( p );\nend\nrule \"go3\"\nwhen\n    String( this == 'go3' )\nthen\n    Person p = new Person( 'darth' ); \n    p.setNotInEqualTestObject(3); \n    insertLogical( p );\nend\n\n";
        KieSession kSession = this.getSessionFromString(s);
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        FactHandle fhGo1 = kSession.insert((Object)"go1");
        kSession.fireAllRules();
        FactHandle fhGo2 = kSession.insert((Object)"go2");
        kSession.fireAllRules();
        FactHandle fhGo3 = kSession.insert((Object)"go3");
        kSession.fireAllRules();
        NamedEntryPoint ep = (NamedEntryPoint)((StatefulKnowledgeSessionImpl)kSession).getEntryPoint("DEFAULT");
        Assert.assertEquals((long)4L, (long)ep.getObjects().size());
        int count = 0;
        for (Object object : ep.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertEquals((Object)new Integer(1), (Object)((Person)object).getNotInEqualTestObject());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        ObjectHashMap equalityMap = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)ep).getEqualityKeyMap();
        Assert.assertEquals((long)1L, (long)equalityMap.size());
        org.drools.core.util.Iterator it = equalityMap.iterator();
        TruthMaintenanceSystemEqualityKey key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        while (!key.getFactHandle().getObject().equals(new Person("darth"))) {
            key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        }
        Assert.assertEquals((long)3L, (long)key.getBeliefSet().size());
        Assert.assertEquals((Object)new Integer(1), (Object)((Person)key.getBeliefSet().getFactHandle().getObject()).getNotInEqualTestObject());
        kSession.retract(fhGo1);
        kSession.fireAllRules();
        it = equalityMap.iterator();
        key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        while (!key.getFactHandle().getObject().equals(new Person("darth"))) {
            key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        }
        Assert.assertEquals((long)2L, (long)key.getBeliefSet().size());
        Assert.assertEquals((Object)new Integer(3), (Object)((Person)key.getBeliefSet().getFactHandle().getObject()).getNotInEqualTestObject());
        kSession.retract(fhGo3);
        kSession.fireAllRules();
        it = equalityMap.iterator();
        key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        while (!key.getFactHandle().getObject().equals(new Person("darth"))) {
            key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        }
        Assert.assertEquals((long)1L, (long)key.getBeliefSet().size());
        Assert.assertEquals((Object)new Integer(2), (Object)((Person)key.getBeliefSet().getFactHandle().getObject()).getNotInEqualTestObject());
    }

    @Test(timeout=10000L)
    @Ignore(value="Currently cannot support updates")
    public void testChangeInNegativePrime() {
        String s = "package org.drools.core.beliefsystem.jtms;\n\nimport org.kie.internal.event.rule.ActivationUnMatchListener;\nimport java.util.List \nimport org.drools.core.common.AgendaItem;import org.drools.mvel.compiler.Person;global java.util.List list;\n\ndeclare entry-point 'neg' end \nrule \"go1\"\nwhen\n    String( this == 'go1' )\nthen\n    Person p = new Person( 'darth' ); \n    p.setNotInEqualTestObject(1); \n    insertLogical( p, 'neg' );\nend\nrule \"go2\"\nwhen\n    String( this == 'go2' )\nthen\n    Person p = new Person( 'darth' ); \n    p.setNotInEqualTestObject(2); \n    insertLogical( p, 'neg' );\nend\nrule \"go3\"\nwhen\n    String( this == 'go3' )\nthen\n    Person p = new Person( 'darth' ); \n    p.setNotInEqualTestObject(3); \n    insertLogical( p, 'neg' );\nend\n\n";
        KieSession kSession = this.getSessionFromString(s);
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        FactHandle fhGo1 = kSession.insert((Object)"go1");
        kSession.fireAllRules();
        FactHandle fhGo2 = kSession.insert((Object)"go2");
        kSession.fireAllRules();
        FactHandle fhGo3 = kSession.insert((Object)"go3");
        kSession.fireAllRules();
        NamedEntryPoint ep = (NamedEntryPoint)((StatefulKnowledgeSessionImpl)kSession).getEntryPoint("DEFAULT");
        Assert.assertEquals((long)3L, (long)ep.getObjects().size());
        Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
        int count = 0;
        for (Object object : this.getNegativeObjects(kSession)) {
            if (!(object instanceof Person)) continue;
            Assert.assertEquals((Object)new Integer(1), (Object)((Person)object).getNotInEqualTestObject());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        ObjectHashMap equalityMap = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)ep).getEqualityKeyMap();
        Assert.assertEquals((long)1L, (long)equalityMap.size());
        org.drools.core.util.Iterator it = equalityMap.iterator();
        TruthMaintenanceSystemEqualityKey key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        while (!key.getFactHandle().getObject().equals(new Person("darth"))) {
            key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        }
        Assert.assertEquals((long)3L, (long)key.getBeliefSet().size());
        Assert.assertEquals((Object)new Integer(1), (Object)((Person)key.getBeliefSet().getFactHandle().getObject()).getNotInEqualTestObject());
        kSession.retract(fhGo1);
        kSession.fireAllRules();
        it = equalityMap.iterator();
        key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        while (!key.getFactHandle().getObject().equals(new Person("darth"))) {
            key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        }
        Assert.assertEquals((long)2L, (long)key.getBeliefSet().size());
        Assert.assertEquals((Object)new Integer(3), (Object)((Person)key.getBeliefSet().getFactHandle().getObject()).getNotInEqualTestObject());
        kSession.retract(fhGo3);
        kSession.fireAllRules();
        it = equalityMap.iterator();
        key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        while (!key.getFactHandle().getObject().equals(new Person("darth"))) {
            key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        }
        Assert.assertEquals((long)1L, (long)key.getBeliefSet().size());
        Assert.assertEquals((Object)new Integer(2), (Object)((Person)key.getBeliefSet().getFactHandle().getObject()).getNotInEqualTestObject());
    }

    @Test(timeout=10000L)
    @Ignore(value="Currently cannot support updates")
    public void testRetractHandleWhenOnlyNeg() {
        String s = "package org.drools.core.beliefsystem.jtms;\n\nimport java.util.List \nimport org.drools.core.common.AgendaItem;global java.util.List list;\n\nrule \"go1_1\"\nwhen\n    String( this == 'go1' )\nthen\n    insertLogical( new String( 'neg' ), 'neg' );\nend\nrule \"go1_2\"\nwhen\n    String( this == 'go1' )\nthen\n    insertLogical( new String( 'neg' ), 'neg' );\nend\nrule \"go1_3\"\nwhen\n    String( this == 'go1' )\nthen\n    insertLogical( new String( 'neg' ), 'neg' );\nend\n\nrule \"Negative\"\nwhen\n    $n : String(  _.neg, this != 'go1' || == 'go2' ) \nthen\n    final String s = '-' + $n; \n    final List l = list; \n    l.add( s ); \nend\n";
        KieSession kSession = this.getSessionFromString(s);
        final ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        ((RuleEventManager)kSession).addEventListener(new RuleEventListener(){

            public void onDeleteMatch(Match match) {
                String rule = match.getRule().getName();
                if (rule.equals("Negative")) {
                    list.remove("-" + match.getDeclarationValue("$n"));
                }
            }
        });
        FactHandle fhGo1 = kSession.insert((Object)"go1");
        kSession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("-neg"));
        Assert.assertEquals((long)1L, (long)kSession.getEntryPoint("DEFAULT").getObjects().size());
        Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
        NamedEntryPoint ep = (NamedEntryPoint)((StatefulKnowledgeSessionImpl)kSession).getEntryPoint("DEFAULT");
        TruthMaintenanceSystem tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)ep);
        ObjectHashMap equalityMap = tms.getEqualityKeyMap();
        Assert.assertEquals((long)2L, (long)equalityMap.size());
        org.drools.core.util.Iterator it = equalityMap.iterator();
        TruthMaintenanceSystemEqualityKey key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        while (!key.getFactHandle().getObject().equals("neg")) {
            key = (TruthMaintenanceSystemEqualityKey)((ObjectHashMap.ObjectEntry)it.next()).getValue();
        }
        Assert.assertEquals((long)3L, (long)key.getBeliefSet().size());
        tms.delete((FactHandle)key.getLogicalFactHandle());
        Assert.assertEquals((long)0L, (long)key.getBeliefSet().size());
        Assert.assertEquals((long)1L, (long)kSession.getEntryPoint("DEFAULT").getObjects().size());
        Assert.assertEquals((long)0L, (long)this.getNegativeObjects(kSession).size());
        Assert.assertEquals((long)0L, (long)key.getBeliefSet().size());
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testConflictStrict() {
        KieSession kSession = this.getSessionFromFile("posNegConflict.drl");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        NamedEntryPoint ep = (NamedEntryPoint)((StatefulKnowledgeSessionImpl)kSession).getEntryPoint("DEFAULT");
        JTMSBeliefSystem bs = (JTMSBeliefSystem)((TruthMaintenanceSystemImpl)TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)ep)).getBeliefSystem();
        JTMSBeliefSystem.STRICT = true;
        try {
            kSession.fireAllRules();
            Assert.fail((String)"A fact and its negation should have been asserted, but no exception was trhown in strict mode");
        }
        catch (Exception exception) {
        }
        finally {
            JTMSBeliefSystem.STRICT = false;
        }
    }

    @Test(timeout=10000L)
    @Ignore(value="Currently cannot support updates")
    public void testConflictTMS() {
        KieSession kSession = this.getSessionFromFile("posNegTms.drl");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        FactHandle a = kSession.insert((Object)"a");
        FactHandle b = kSession.insert((Object)"b");
        FactHandle c = kSession.insert((Object)"c");
        FactHandle d = kSession.insert((Object)"d");
        try {
            kSession.fireAllRules();
            Assert.assertEquals((long)4L, (long)kSession.getFactCount());
            Assert.assertEquals((long)0L, (long)list.size());
            kSession.retract(a);
            kSession.fireAllRules();
            Assert.assertEquals((long)3L, (long)kSession.getFactCount());
            Assert.assertEquals((long)0L, (long)list.size());
            kSession.retract(b);
            kSession.fireAllRules();
            Assert.assertEquals((long)2L, (long)kSession.getFactCount());
            Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
            Assert.assertEquals((long)1L, (long)list.size());
            a = kSession.insert((Object)"a");
            kSession.fireAllRules();
            Assert.assertEquals((long)3L, (long)kSession.getFactCount());
            Assert.assertEquals((long)0L, (long)this.getNegativeObjects(kSession).size());
            Assert.assertEquals((long)1L, (long)list.size());
            kSession.retract(c);
            kSession.fireAllRules();
            Assert.assertEquals((long)2L, (long)kSession.getFactCount());
            Assert.assertEquals((long)0L, (long)this.getNegativeObjects(kSession).size());
            Assert.assertEquals((long)1L, (long)list.size());
            kSession.retract(d);
            kSession.fireAllRules();
            Assert.assertEquals((long)2L, (long)kSession.getFactCount());
            Assert.assertEquals((long)0L, (long)this.getNegativeObjects(kSession).size());
            Assert.assertEquals((long)2L, (long)list.size());
            kSession.retract(a);
            kSession.fireAllRules();
            Assert.assertEquals((long)0L, (long)kSession.getFactCount());
            Assert.assertEquals((long)0L, (long)this.getNegativeObjects(kSession).size());
            Assert.assertEquals((long)2L, (long)list.size());
            c = kSession.insert((Object)"c");
            kSession.fireAllRules();
            Assert.assertEquals((long)1L, (long)kSession.getFactCount());
            Assert.assertEquals((long)1L, (long)this.getNegativeObjects(kSession).size());
            Assert.assertEquals((long)3L, (long)list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"No exception should have been thrown");
        }
    }

    public List getNegativeObjects(KieSession kSession) {
        ArrayList list = new ArrayList();
        Iterator it = ((StatefulKnowledgeSessionImpl)kSession).getObjectStore().iterateNegObjects(null);
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Test
    public void testPrimeJustificationWithEqualityMode() {
        String droolsSource = "package org.drools.tms.test; \ndeclare Bar end \ndeclare Holder x : Bar end \nrule Init \nwhen \nthen \n   insert( new Holder( new Bar() ) ); \nend \nrule Justify \nwhen \n $s : Integer() \n $h : Holder( $b : x ) \nthen \n insertLogical( $b ); \nend \nrule React \nwhen \n $b : Bar(  ) \nthen \n System.out.println( $b );  \nend \n";
        KieSession session = this.getSessionFromString(droolsSource);
        FactHandle handle1 = session.insert((Object)10);
        FactHandle handle2 = session.insert((Object)20);
        Assert.assertEquals((long)4L, (long)session.fireAllRules());
        session.delete(handle1);
        Assert.assertEquals((long)0L, (long)session.fireAllRules());
    }
}

