/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.common.ActivationIterator;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.util.Iterator;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.runtime.conf.ForceEagerActivationFilter;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;

@RunWith(value=Parameterized.class)
public class ActivationIteratorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ActivationIteratorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testSingleLian() {
        String str = "package org.kie.test \n\nrule rule1 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\nthen\nend\nrule rule6 @Propagation(EAGER) when\n     java.util.Map()\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        this.evaluateEagerList(ksession);
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:true", "rule1:1:true", "rule1:2:true", "rule1:3:true", "rule1:4:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:false", "rule1:1:false", "rule1:2:false", "rule1:3:false", "rule1:4:false"}, list);
    }

    private void evaluateEagerList(KieSession ksession) {
        ((InternalWorkingMemory)ksession).flushPropagations();
        ((InternalAgenda)ksession.getAgenda()).evaluateEagerList();
    }

    @Test
    public void testLianPlusEvaln() {
        String str = "package org.kie.test \n\nrule rule1 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\n    eval( 1 == 1 ) \nthen\nend\nrule rule6 @Propagation(EAGER) when\n     java.util.Map()\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        this.evaluateEagerList(ksession);
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:true", "rule1:1:true", "rule1:2:true", "rule1:3:true", "rule1:4:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:false", "rule1:1:false", "rule1:2:false", "rule1:3:false", "rule1:4:false"}, list);
    }

    @Test
    public void testLianPlusEvalnWithSharing() {
        String str = "package org.kie.test \n\nrule rule0 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\nthen\nend\nrule rule1 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\nend\nrule rule2 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\nend\nrule rule3 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \nthen\nend\nrule rule4 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \n    eval( Integer.parseInt( $s ) > 3 ) \nthen\nend\nrule rule5 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \n    eval( Integer.parseInt( $s ) > 3 ) \nthen\nend\nrule rule6 @Propagation(EAGER) when\n     java.util.Map()\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        this.evaluateEagerList(ksession);
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule0:0:true", "rule0:1:true", "rule0:2:true", "rule0:3:true", "rule0:4:true", "rule1:0:true", "rule1:1:true", "rule1:2:true", "rule2:0:true", "rule2:1:true", "rule2:2:true", "rule3:3:true", "rule3:4:true", "rule4:4:true", "rule5:4:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule0:0:false", "rule0:1:false", "rule0:2:false", "rule0:3:false", "rule0:4:false", "rule1:0:false", "rule1:1:false", "rule1:2:false", "rule2:0:false", "rule2:1:false", "rule2:2:false", "rule3:3:false", "rule3:4:false", "rule4:4:false", "rule5:4:false"}, list);
    }

    @Test
    public void testLianPlusEvalnWithSharingWithMixedDormantAndActive() {
        String str = "package org.kie.test \n\nrule rule2 salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\n    kcontext.getKieRuntime().halt();\nend\nrule rule0 salience ( Integer.parseInt('1'+$s) ) when\n    $s : String( this != 'xx' )\nthen\nend\nrule rule1 salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\nend\nrule rule3 salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \nthen\nend\nrule rule4 salience ( Integer.parseInt('1'+$s) ) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \n    eval( Integer.parseInt( $s ) > 3 ) \nthen\nend\n\nrule rule6 when\n     java.util.Map()\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ksession.fireAllRules();
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule0:0:true", "rule0:1:true", "rule0:2:true", "rule0:3:false", "rule0:4:false", "rule1:0:true", "rule1:1:true", "rule1:2:true", "rule2:0:true", "rule2:1:true", "rule2:2:false", "rule3:3:false", "rule3:4:false", "rule3:4:false"}, list);
    }

    @Test
    public void testSingleJoinNode() {
        String str = "package org.kie.test \n\nrule rule1  @Propagation(EAGER)  when\n    $s1 : String( )\n    $s2 : String( )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        this.evaluateEagerList(ksession);
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:true", "rule1:1:0:true", "rule1:1:1:true", "rule1:0:0:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:false", "rule1:1:0:false", "rule1:1:1:false", "rule1:0:0:false"}, list);
    }

    @Test
    public void testSingleJoinNodePlusEvaln() {
        String str = "package org.kie.test \n\nrule rule1 @Propagation(EAGER) when\n    $s1 : String( )\n    $s2 : String( )\n    eval( 1 == 1 ) \nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        this.evaluateEagerList(ksession);
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:true", "rule1:1:0:true", "rule1:1:1:true", "rule1:0:0:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:false", "rule1:1:0:false", "rule1:1:1:false", "rule1:0:0:false"}, list);
    }

    @Test
    public void testSingleJoinNodePlusEvalnWithSharing() {
        String str = "package org.kie.test \n\nrule rule1  @Propagation(EAGER)  when\n    $s1 : String( )\n    $s2 : String( )\n    eval( 1 == 1 ) \nthen\nend\nrule rule2  @Propagation(EAGER)  when\n    $s1 : String( )\nthen\nend\nrule rule3  @Propagation(EAGER)  when\n    $s1 : String( )\n    $s2 : String( )\n    $s3 : String( )\n    eval( 1 == 1 ) \nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        this.evaluateEagerList(ksession);
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.getDeclarationValue("$s3") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            }
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:0:true", "rule1:0:1:true", "rule1:1:0:true", "rule1:1:1:true", "rule2:1:true", "rule2:0:true", "rule3:0:0:0:true", "rule3:0:0:1:true", "rule3:1:0:0:true", "rule3:1:0:1:true", "rule3:0:1:0:true", "rule3:0:1:1:true", "rule3:1:1:0:true", "rule3:1:1:1:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        act = (AgendaItem)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.getDeclarationValue("$s3") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            }
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:0:false", "rule1:0:1:false", "rule1:1:0:false", "rule1:1:1:false", "rule2:1:false", "rule2:0:false", "rule3:0:0:0:false", "rule3:0:0:1:false", "rule3:1:0:0:false", "rule3:1:0:1:false", "rule3:0:1:0:false", "rule3:0:1:1:false", "rule3:1:1:0:false", "rule3:1:1:1:false"}, list);
    }

    @Test
    public void testSingleJoinNodePlusEvalnWithSharingWithMixedDormantAndActive() {
        String str = "package org.kie.test \n\nrule rule1  salience ( Integer.parseInt( '1'+$s1+'0'+$s2 ) ) when\n    $s1 : String( )\n    $s2 : String( )\n    eval( 1 == 1 ) \nthen\nend\nrule rule2 salience (1020 + Integer.parseInt( $s1 ) ) when\n    $s1 : String( )\nthen\n    kcontext.getKieRuntime().halt();\nend\nrule rule3  salience ( Integer.parseInt( '1'+$s1+'1'+$s2  ) ) when\n    $s1 : String( )\n    $s2 : String( )\n    $s3 : String( )\n    eval( 1 == 1 ) \nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ksession.fireAllRules();
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.getDeclarationValue("$s3") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            }
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:0:0:true", "rule1:0:1:true", "rule1:1:0:false", "rule1:1:1:false", "rule2:1:false", "rule2:0:true", "rule3:0:0:0:true", "rule3:0:0:1:true", "rule3:1:0:0:false", "rule3:1:0:1:false", "rule3:0:1:0:true", "rule3:0:1:1:true", "rule3:1:1:0:false", "rule3:1:1:1:false"}, list);
    }

    @Test
    public void testNotSharingWithMixedDormantAndActive() {
        String str = "package org.kie.test \n\nrule rule1  @Propagation(EAGER)  salience 10 when\n    not String( this == '1' )\nthen\nend\nrule rule2   @Propagation(EAGER)  salience ( Integer.parseInt( $s1+'1' ) ) when\n    not String( this == '1' )\n    $s1 : String( )\n    eval( 1 == 1 ) \nthen\nend\nrule rule3  @Propagation(EAGER)  salience ( Integer.parseInt( $s1+'2' ) ) when\n    $s1 : String( )\n    not String( this == '1' )\n    eval( 1 == 1 ) \n    eval( 1 == 1 ) \nthen\n    kcontext.getKieRuntime().halt();\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"0");
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            }
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:true", "rule2:0:true", "rule2:2:true", "rule3:0:true", "rule3:2:false"}, list);
    }

    @Test
    public void testExistsSharingWithMixedDormantAndActive() {
        String str = "package org.kie.test \n\nrule rule3  @Propagation(EAGER)  salience ( Integer.parseInt( $s1+'1' ) ) when\n    $s1 : String( )\n    exists String( this == '1' )\n    eval( 1 == 1 ) \n    eval( 1 == 1 ) \nthen\n    kcontext.getKieRuntime().halt();\nend\nrule rule1  @Propagation(EAGER)  salience 100 when\n    exists String( this == '1' )\nthen\nend\nrule rule2   @Propagation(EAGER)  salience ( Integer.parseInt( $s1+'1' ) ) when\n    exists String( this == '1' )\n    $s1 : String( )\n    eval( 1 == 1 ) \nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"0");
        ksession.insert((Object)"1");
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.isQueued());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            }
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:false", "rule2:0:true", "rule2:1:true", "rule2:2:true", "rule3:2:false"}, list);
    }

    @Test
    public void testFromnSharingWithMixedDormantAndActive() {
        String str = "package org.kie.test \nglobal java.util.List list \n\nrule rule3 salience ( Integer.parseInt( $s1+'1' ) ) when\n    $s1 : String( ) from list  \n    eval( 1 == 1 ) \n    eval( 1 == 1 ) \nthen\n    kcontext.getKieRuntime().halt();\nend\nrule rule1 salience ( Integer.parseInt( $s1+'1' ) )  when\n    $s1 : String( this == '1' )  from list\nthen\nend\nrule rule2  salience ( Integer.parseInt( $s1+'1' ) ) when\n    $s1 : String( )  from list \n    eval( 1 == 1 ) \nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:1:true", "rule2:0:true", "rule2:1:true", "rule2:2:true", "rule3:0:true", "rule3:1:true", "rule3:2:false"}, list);
    }

    @Test
    public void testAccnSharingWithMixedDormantAndActive() {
        String str = "package org.kie.test \n\nrule rule1 @Propagation(EAGER) when\n    $s1 : Integer() from accumulate( $i : Integer(), sum ( $i ) )    then\nend\nrule rule2 @Propagation(EAGER) when\n    $s1 : Integer() from accumulate( $i : Integer(), sum ( $i ) )        eval( 1 == 1 ) \nthen\nend\nrule rule3  salience 10 when\n    eval( 1 == 1 ) \n    $s1 : Integer() from accumulate( $i : Integer(), sum ( $i ) )        eval( 1 == 1 ) \nthen\n    kcontext.getKieRuntime().halt();\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Integer(1));
        ksession.insert((Object)new Integer(2));
        ksession.insert((Object)new Integer(3));
        ksession.fireAllRules();
        Iterator it = ActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        list = new ArrayList();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule1:6:true", "rule2:6:true", "rule3:6:false"}, list);
    }

    public void assertContains(Object[] objects, List list) {
        for (Object object : objects) {
            if (list.contains(object)) continue;
            Assert.fail((String)("does not contain:" + object));
        }
    }

    @Test(timeout=10000L)
    public void testEagerEvaluation() throws Exception {
        String str = "package org.simple \nrule xxx @Propagation(EAGER) \nwhen \n  $s : String()\nthen \nend  \nrule yyy @Propagation(EAGER) \nwhen \n  $s : String()\nthen \nend  \n";
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession(conf, null);
        final ArrayList list = new ArrayList();
        DefaultAgendaEventListener agendaEventListener = new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                list.add("activated");
            }
        };
        ksession.addEventListener((AgendaEventListener)agendaEventListener);
        ksession.insert((Object)"test");
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testFilteredEagerEvaluation() throws Exception {
        String str = "package org.simple \nrule xxx @Propagation(EAGER) \nwhen \n  $s : String()\nthen \nend  \nrule yyy @Propagation(EAGER) \nwhen \n  $s : String()\nthen \nend  \n";
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)new ForceEagerActivationOption.FILTERED(new ForceEagerActivationFilter(){

            public boolean accept(Rule rule) {
                return rule.getName().equals("xxx");
            }
        }));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession(conf, null);
        final ArrayList list = new ArrayList();
        DefaultAgendaEventListener agendaEventListener = new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                list.add("activated");
            }
        };
        ksession.addEventListener((AgendaEventListener)agendaEventListener);
        ksession.insert((Object)"test");
        ((InternalWorkingMemory)ksession).flushPropagations();
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

