/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class WireChannelTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final List<Object> channelMessages = new ArrayList<Object>();

    public WireChannelTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testWireChannel() throws Exception {
        channelMessages.clear();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "listener-test", "1.0");
        this.build(ks, releaseId);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieSession ksession = kieContainer.newKieSession();
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)channelMessages.size());
        Assert.assertEquals((Object)"Test Message", (Object)channelMessages.get(0));
    }

    private void build(KieServices ks, ReleaseId releaseId) throws IOException {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieSessionModel ksession1 = kproj.newKieBaseModel("KBase1").newKieSessionModel("KSession1").setDefault(true);
        ksession1.newChannelModel("testChannel", RecordingChannel.class.getName());
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML()).writePomXML(KieBuilderImpl.generatePomXml((ReleaseId)releaseId)).write("src/main/resources/KBase1/rules.drl", this.createDRL());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
    }

    private String createDRL() {
        return "package org.kie.test\nrule SendMessage when\nthen\n    channels[\"testChannel\"].send(\"Test Message\");\nend\n";
    }

    public static class RecordingChannel
    implements Channel {
        public void send(Object object) {
            channelMessages.add(object);
        }
    }
}

