/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kproject;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.ReleaseIdComparator;
import org.kie.util.maven.support.ReleaseIdImpl;

public class ReleaseIdTest {
    private static final ReleaseId gav0 = ReleaseIdTest.newReleaseId("abc.def:ghi:9.0.1.GA");
    private static final ReleaseId gav1 = ReleaseIdTest.newReleaseId("com.test:foo:1.0.0-SNAPSHOT");
    private static final ReleaseId gav2 = ReleaseIdTest.newReleaseId("com.test:foo:1.0.0.Final");
    private static final ReleaseId gav3 = ReleaseIdTest.newReleaseId("com.test:foo:2.0.0-SNAPSHOT");
    private static final ReleaseId gav4 = ReleaseIdTest.newReleaseId("com.test:foo:2.0.0.Alpha1");
    private static final ReleaseId gav5 = ReleaseIdTest.newReleaseId("com.test:foo:2.0.0.Beta2");
    private static final ReleaseId gav6 = ReleaseIdTest.newReleaseId("org.example:test:0.0.1-SNAPSHOT");
    private static final ReleaseId gav7 = ReleaseIdTest.newReleaseId("org.example:test:1.0");

    private static final ReleaseId newReleaseId(String releaseId) {
        String[] gav = releaseId.split(":");
        return KieServices.Factory.get().newReleaseId(gav[0], gav[1], gav[2]);
    }

    private List<ReleaseId> newUnsortedList() {
        ArrayList<ReleaseId> list = new ArrayList<ReleaseId>();
        list.add(gav4);
        list.add(gav2);
        list.add(gav6);
        list.add(gav3);
        list.add(gav7);
        list.add(gav1);
        list.add(gav0);
        list.add(gav5);
        return list;
    }

    @Test
    public void testDefaultSort() {
        List<ReleaseId> list = this.newUnsortedList();
        list.sort((Comparator<ReleaseId>)new ReleaseIdComparator());
        Assert.assertSame((Object)gav0, (Object)list.get(0));
        Assert.assertSame((Object)gav1, (Object)list.get(1));
        Assert.assertSame((Object)gav2, (Object)list.get(2));
        Assert.assertSame((Object)gav3, (Object)list.get(3));
        Assert.assertSame((Object)gav4, (Object)list.get(4));
        Assert.assertSame((Object)gav5, (Object)list.get(5));
        Assert.assertSame((Object)gav6, (Object)list.get(6));
        Assert.assertSame((Object)gav7, (Object)list.get(7));
    }

    @Test
    public void testAscendingSort() {
        List<ReleaseId> list = this.newUnsortedList();
        list.sort((Comparator<ReleaseId>)new ReleaseIdComparator(ReleaseIdComparator.SortDirection.ASCENDING));
        Assert.assertSame((Object)gav0, (Object)list.get(0));
        Assert.assertSame((Object)gav1, (Object)list.get(1));
        Assert.assertSame((Object)gav2, (Object)list.get(2));
        Assert.assertSame((Object)gav3, (Object)list.get(3));
        Assert.assertSame((Object)gav4, (Object)list.get(4));
        Assert.assertSame((Object)gav5, (Object)list.get(5));
        Assert.assertSame((Object)gav6, (Object)list.get(6));
        Assert.assertSame((Object)gav7, (Object)list.get(7));
    }

    @Test
    public void testDecendingSort() {
        List<ReleaseId> list = this.newUnsortedList();
        list.sort((Comparator<ReleaseId>)new ReleaseIdComparator(ReleaseIdComparator.SortDirection.DESCENDING));
        Assert.assertSame((Object)gav7, (Object)list.get(0));
        Assert.assertSame((Object)gav6, (Object)list.get(1));
        Assert.assertSame((Object)gav5, (Object)list.get(2));
        Assert.assertSame((Object)gav4, (Object)list.get(3));
        Assert.assertSame((Object)gav3, (Object)list.get(4));
        Assert.assertSame((Object)gav2, (Object)list.get(5));
        Assert.assertSame((Object)gav1, (Object)list.get(6));
        Assert.assertSame((Object)gav0, (Object)list.get(7));
    }

    @Test
    public void testGetEarliest() {
        List<ReleaseId> list = this.newUnsortedList();
        Assert.assertSame((Object)gav0, (Object)ReleaseIdComparator.getEarliest(list));
    }

    @Test
    public void testGetLatest() {
        List<ReleaseId> list = this.newUnsortedList();
        Assert.assertSame((Object)gav7, (Object)ReleaseIdComparator.getLatest(list));
    }

    @Test
    public void testResolveVersionPomModelNull() {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("groupId", "artifactId", "${project.version}");
        Assertions.assertThat((String)releaseId.getVersion()).isEqualTo("${project.version}");
    }

    @Test
    public void testResolveVersionNoProperty() {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("groupId", "artifactId", "1.0.0");
        Assertions.assertThat((String)releaseId.getVersion()).isEqualTo("1.0.0");
    }
}

