/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.integrationtests.CustomOperatorTest;
import org.drools.core.ClassObjectFilter;
import org.drools.core.InitialFact;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.facttemplates.FactTemplateImpl;
import org.drools.core.facttemplates.FieldTemplate;
import org.drools.core.facttemplates.FieldTemplateImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.spi.Activation;
import org.drools.core.spi.Salience;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.builder.MVELDialectConfiguration;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.PersonHolder;
import org.drools.mvel.compiler.TestUtil;
import org.drools.mvel.integrationtests.Misc2Test$$X$;
import org.drools.mvel.integrationtests.facts.FactWithList;
import org.drools.mvel.integrationtests.facts.FactWithString;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.event.kiebase.DefaultKieBaseEventListener;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.Agenda;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.internal.utils.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class Misc2Test {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(Misc2Test.class);

    public Misc2Test(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testUpdateWithNonEffectiveActivations() throws Exception {
        String str = "package inheritance\n\nimport " + Address.class.getCanonicalName() + "\n\nrule \"Parent\"\n    enabled false\n    when \n        $a : Address(suburb == \"xyz\")\n    then \n        System.out.println( $a ); \nend \nrule \"Child\" extends \"Parent\" \n    when \n        $b : Address( this == $a, street == \"123\")\n    then \n        System.out.println( $b ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Address address = new Address();
        address.setSuburb("xyz");
        FactHandle addressHandle = ksession.insert((Object)address);
        int rulesFired = ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)rulesFired);
        address.setStreet("123");
        ksession.update(addressHandle, (Object)address);
        rulesFired = ksession.fireAllRules();
        System.out.println(rulesFired);
        Assert.assertEquals((long)1L, (long)rulesFired);
        ksession.dispose();
    }

    @Test
    public void testNPEOnMutableGlobal() throws Exception {
        String str = "package org.drools.mvel.compiler\nglobal java.util.List context\nrule B\n  when\n    Message( message == \"b\" )\n    $s : String() from context\n  then\n    System.out.println($s);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList context = new ArrayList();
        ksession.setGlobal("context", context);
        FactHandle b = ksession.insert((Object)new Message("b"));
        ksession.delete(b);
        int fired = ksession.fireAllRules(1);
        Assert.assertEquals((long)0L, (long)fired);
        ksession.dispose();
    }

    @Test
    public void testAnalyzeConditionWithVariableRegExp() throws Exception {
        String str = "dialect \"mvel\"\n\ndeclare Person\n   name : String\nend\ndeclare Stuff\n   regexp : String\nend\n\nrule \"Test Regex\"\n   salience 100\n    when\n    then\n       insert (new Stuff(\"Test\"));\n       insert (new Person(\"Test\"));\nend\n\nrule \"Test Equality\"\n   salience 10\n    when\n       Stuff( $regexp : regexp )\n        Person( name matches $regexp )\n        //Person( name matches \"Test\" )\n    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testShareAlphaNodesRegardlessDoubleOrSingleQuotes() {
        String str = "declare RecordA\n   id : long\nend\n\ndeclare RecordB\n   id : long\nrole : String\nend\n\nrule \"insert data 1\"\n   salience 10\n   when\n   then\n       insert (new RecordA(100));\n       insert (new RecordB(100, \"1\"));\n       insert (new RecordB(100, \"2\"));\nend\n\nrule \"test 1\"\n   when\n       a : RecordA( )\n       b : RecordB( id == b.id, role == '1' )\n   then\nend\n\nrule \"test 2\"\n   when\n       a : RecordA( )\n       b : RecordB( id == b.id, role == \"1\" )\n   then\nend\n\nrule \"test 3\"\n   when\n       a : RecordA( )\n       b : RecordB( id == b.id, role == \"2\" )\n   then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)4L, (long)ksession.fireAllRules());
    }

    @Test
    public void testCorrectDeclarationsInConsequence() {
        Address barcelonaCityCenter = new Address("City Center", 1, "Barcelona");
        Address cottageInMountains = new Address("Mountains", 999, "Small Village");
        Address cottageInDesert = new Address("Sand Street", 1, "Desert Town");
        Person johnFromBarcelona = new Person("John", 18);
        Person peter70Years = new Person("Peter", 70);
        Person mary33Years = new Person("Mary", 33);
        johnFromBarcelona.setAddress(barcelonaCityCenter);
        Person elizabeth35Years = new Person("Elizabeth", 35);
        Person william25Years = new Person("William", 25);
        String str = "package org.drools.testcoverage.functional;\n\nimport " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + "\nimport java.lang.Integer;rule \"Row 1 moveToBiggerCities\"\ndialect \"mvel\"\n  when\n    $address : Address( $city : city)\n    $inhabitantsCount : Integer( intValue() > 50000 , intValue() <= 100000 )            from accumulate ( $person : Person( address.city == $city ),\n                             count($person)) \n    $otherAddress : Address( $otherCity : city, this != $address )\n    $person : Person( address == $otherAddress , likes == \"big city\" )\nthen\n    $person.setAddress( $address );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Address brno = this.producePeopleInCity(ksession, "Brno", 7000);
        Address prague = this.producePeopleInCity(ksession, "Prague", 30000);
        Address london = this.producePeopleInCity(ksession, "London", 60000);
        Address smallCity = new Address();
        smallCity.setCity("city with just one person");
        peter70Years.setAddress(smallCity);
        peter70Years.setLikes("big city");
        william25Years.setAddress(brno);
        william25Years.setLikes("big city");
        mary33Years.setAddress(prague);
        mary33Years.setLikes("big city");
        elizabeth35Years.setAddress(london);
        elizabeth35Years.setLikes("big city");
        ksession.insert((Object)smallCity);
        FactHandle peter = ksession.insert((Object)peter70Years);
        FactHandle wiliam = ksession.insert((Object)william25Years);
        FactHandle mary = ksession.insert((Object)mary33Years);
        FactHandle elizabeth = ksession.insert((Object)elizabeth35Years);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
    }

    private Address producePeopleInCity(KieSession ksession, String city, int countOfPeople) {
        Address address = new Address();
        address.setCity(city);
        ksession.insert((Object)address);
        for (int i = 0; i < countOfPeople; ++i) {
            Person person = new Person();
            person.setName("Inhabitant " + i);
            person.setAddress(address);
            ksession.insert((Object)person);
        }
        return address;
    }

    @Test
    public void testEvalBeforeNot() {
        String str = "package org.drools.mvel.compiler.integration; \nimport " + A.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule r1\n   salience 10\n   when\n      eval( list.size() == 0 ) \n      not  A( ) \n      a1 : A( f1 == 1 ) \n      not  A( f1 == 10 ) \n      a2 : A( f1 == 2 ) \n   then\n       System.out.println('xxx' + a1.getF1() + \":\" + a2.getF2()); \nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new A(1));
        ksession.insert((Object)new A(2));
        ksession.fireAllRules();
    }

    @Test
    public void testKnowledgeBaseEventSupportLeak() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        DefaultKieBaseEventListener listener = new DefaultKieBaseEventListener();
        kbase.addEventListener((KieBaseEventListener)listener);
        kbase.addEventListener((KieBaseEventListener)listener);
        Assert.assertEquals((long)1L, (long)kbase.getKieBaseEventListeners().size());
        kbase.removeEventListener((KieBaseEventListener)listener);
        Assert.assertEquals((long)0L, (long)kbase.getKieBaseEventListeners().size());
    }

    @Test
    public void testReuseAgendaAfterException() throws Exception {
        String str = "import org.drools.mvel.compiler.Person;\nglobal java.util.List results;rule R1\nruleflow-group \"test\"\nwhen\n   Person( $age : age ) \nthen\n   if ($age > 40) throw new RuntimeException(\"Too old\");\n   results.add(\"OK\");end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        final KieSession ksession = kbase.newKieSession();
        ArrayList res = new ArrayList();
        ksession.setGlobal("results", res);
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
            }

            public void matchCancelled(MatchCancelledEvent event) {
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                ksession.fireAllRules();
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }
        };
        ksession.addEventListener(agendaEventListener);
        FactHandle fact1 = ksession.insert((Object)new Person("Mario", 38));
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("test");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)res.size());
        res.clear();
        ksession.delete(fact1);
        FactHandle fact2 = ksession.insert((Object)new Person("Mario", 48));
        try {
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("test");
            ksession.fireAllRules();
            Assert.fail((String)"should throw an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ksession.delete(fact2);
        Assert.assertEquals((long)0L, (long)res.size());
        FactHandle fact3 = ksession.insert((Object)new Person("Mario", 38));
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("test");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)res.size());
        ksession.delete(fact3);
        ksession.dispose();
    }

    @Test
    public void testBooleanPropertyStartingWithEmpty() {
        String str = "declare Fact\n   emptyx : boolean\nend\n\nrule \"R1\"\n   when\n   Fact(emptyx == false)   then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
    }

    @Test
    public void testMVELForLoop() throws Exception {
        String str = "rule demo\ndialect \"mvel\"\nwhen\nthen\n   for ( int i = 1; i <= 3; i++ ) {\n       insert( \"foo\" + i );\n   }\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testBigDecimalComparison() throws Exception {
        String str = "import org.drools.mvel.compiler.Person;\nrule \"Big Decimal Comparison\"\n    dialect \"mvel\"\nwhen\n    Person( bigDecimal == 0.0B )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("Mario", 38);
        p.setBigDecimal(new BigDecimal("0"));
        ksession.insert((Object)p);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test(timeout=5000L)
    public void testInfiniteLoopCausedByInheritance() throws Exception {
        String str = "declare Parent\n    active : boolean\nend\n \ndeclare Child extends Parent\nend\n \nrule \"Init\"\nwhen\nthen\n    insert( new Child( false ) );\nend\n \nrule \"Print\"\nwhen\n    $g : Child( active == true )\nthen\nend\n \n \nrule \"Switch\"\nwhen\n    $item : Parent( active == false )\nthen\n    modify ( $item ) {\n            setActive( true );\n    }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testIntSorting() {
        String str = "global java.util.List list\nrule R\ndialect \"mvel\"\nwhen\n   $number : Number()\n   not Number(intValue < $number.intValue)\nthen\n   list.add($number);\n   delete($number);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ksession.insert((Object)4);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(1, 2, 4, 5, 6), list);
    }

    @Test
    public void testIntSorting2() {
        String str = "global java.util.List list\nrule R\ndialect \"mvel\"\nwhen\n   $number : Number()\n   not Number(intValue > $number.intValue)\nthen\n   list.add($number);\n   delete($number);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)3);
        ksession.insert((Object)7);
        ksession.insert((Object)4);
        ksession.insert((Object)5);
        ksession.insert((Object)2);
        ksession.insert((Object)1);
        ksession.insert((Object)6);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(7, 6, 5, 4, 3, 2, 1), list);
    }

    @Test(timeout=10000L)
    public void testPropertyReactiveOnAlphaNodeFollowedByAccumulate() {
        String str = "package org.kie.pmml.pmml_4_1.test;\n\ndeclare Charge\n    context     : String\n    index       : String = \"-1\"\n    source      : String = \"-1\"\n    value       : double\nend\n\ndeclare Neuron\n@propertyReactive\n    context     : String            @key\n    index       : String            @key\n    layerIndex  : int\n    bias        : double\n    fanIn       : int\n    value       : double\n    dvalue      : double\n    normalized  : boolean\nend\n\nrule \"LinkSynapses\"\nwhen\nthen\n    Charge c = new Charge();\n    c.setContext( \"MockCold\" );\n    c.setSource( \"0\" );\n    c.setIndex( \"1\" );\n    c.setValue( 0.43 );\n    insert(c);\nend\n\nrule \"NeuralFire_MockCold_Layer0\"\nwhen\n    $neur : Neuron( context == \"MockCold\",\n                    layerIndex == 0\n                  )\n    accumulate( $c : Charge( context == \"MockCold\", index == $neur.index, $in : value ),\n                $list : collectList( $c ),\n                $val : sum( $in );\n                $list.size() == $neur.fanIn )\nthen\n    double x = 1.0; // $neur.getBias() + $val.doubleValue();\n    modify ( $neur ) {\n        setValue( x );\n    }\nend\n\nrule \"BuildNeurons_MockCold_Layer0\"\nwhen\nthen\n    insert( new Neuron( \"MockCold\",\n                               \"1\",\n                               0,\n                               1.0,\n                               1,\n                               0.0,\n                               0.0,\n                               true\n                             ) );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPropertyReactiveAccumulateModification() {
        String str = "package org.drools.mvel.compiler.test;\n\ndeclare Neuron\n@propertyReactive\n  id : int\n  value : double\nend\n\ndeclare Charge\n  nId : int\n  val : double\nend\n\nrule \"Log 2\"\nsalience 9999\nwhen\n  $n : Object();\nthen\nend\nrule \"Update\"\nsalience -9999\nwhen\n  $c : Charge( val == 1.0 );\nthen\n  modify ( $c ) {     setVal( 2.0 ); \n } \nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new Neuron( 0, 0.0 ) );\n  insert( new Charge( 0, 1.0 ) );\nend\n\nrule \"Modify\"\nsalience -100\nwhen\n  $n : Neuron( )\n  accumulate( Charge( $v : val ), $x : sum( $v ) )\nthen\n  modify ( $n ) {\n    setValue( $x.doubleValue() );\n  }\nend\n\nrule \"Watch\"\nwhen\n   $n : Neuron() @watch( value )then\nend\n\nquery getNeuron\n  Neuron( $value : value )\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        Assert.assertEquals((Object)2.0, (Object)((QueryResultsRow)ksession.getQueryResults("getNeuron", new Object[0]).iterator().next()).get("$value"));
    }

    @Test
    public void testMvelAssignmentToPublicField() {
        String str = "import " + Foo.class.getCanonicalName() + "\nrule R\ndialect \"mvel\"\nwhen\n   $foo : Foo()\nthen\n   $foo.x = 1;\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Foo foo1 = new Foo();
        Foo foo2 = new Foo();
        ksession.insert((Object)foo1);
        ksession.insert((Object)foo2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)foo1.x);
        Assert.assertEquals((long)1L, (long)foo2.x);
    }

    @Test
    public void testMvelInvokeAsList() {
        String str = "import java.util.List;\nimport java.util.Arrays;\nimport java.util.ArrayList;\n\ndeclare Project\n@typesafe (false)\n        list1 : List\n        list2 : List\nend\n\nrule kickoff\nsalience 999999\nwhen\nthen\n    insert( new Project() );\n    insert( new Project() );   // necessary to trigger the exception\nend\n\nrule \" Config rule \"\ndialect \"mvel\"\nno-loop true\nwhen\n    P : Project()\nthen\n    modify(P) {\n       list1 = Arrays.asList(10, 15, 20, 25),\n       list2 = Arrays.asList(11, 2, 3, 4, 5, 10, 9, 8, 7)\n    };\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testDynamicAddRule() {
        String str = "import " + A.class.getCanonicalName() + "\nrule r1 when\n    $a : A( f1 == 1 )\nthen\nend\n\nrule r2 when\n    $a : A( f2 == 1 )\nthen\nend\n\nrule r3 when\n    $a : A( f3 == 1 )then\nend";
        String str2 = "import " + A.class.getCanonicalName() + "\nrule r4 when\n    $a : A( f2 == 1, f4 == 1 )then\nend";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        FactHandle fh = ksession.insert((Object)new A(1, 1, 1, 1));
        ksession.fireAllRules();
        Collection kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str2}).getKiePackages();
        kbase.addPackages(kpkgs);
        ksession.fireAllRules();
        ksession.insert((Object)new A(2, 2, 2, 2));
        LeftTuple leftTuple = ((DefaultFactHandle)fh).getFirstLeftTuple();
        ObjectTypeNode.Id letTupleOtnId = leftTuple.getInputOtnId();
        for (leftTuple = (LeftTuple)leftTuple.getHandleNext(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getHandleNext()) {
            Assert.assertTrue((boolean)letTupleOtnId.before(leftTuple.getInputOtnId()));
            letTupleOtnId = leftTuple.getInputOtnId();
        }
    }

    @Test
    public void testNumberCoercionOnNonGenericMap() {
        String str = "package com.ilesteban.jit;\n\nimport java.util.Map;\nimport java.util.EnumMap;\nimport " + Parameter.class.getCanonicalName() + "\nimport " + DataSample.class.getCanonicalName() + "\nimport " + DataSample.class.getCanonicalName() + "\n\ndeclare TestObject\n    data    :   java.util.Map\nend\n\nrule \"Rule 1\"\nwhen\n    $d: DataSample()\nthen\n    //create a new object copying the Map<Parameter, Double> to a Map<Object, Object>\n    insert( new TestObject($d.getValues()));\nend\n\nrule \"Rule 2\"\nwhen\n    TestObject(data[Parameter.PARAM_A] > 3)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        EnumMap<Parameter, Double> values = new EnumMap<Parameter, Double>(Parameter.class);
        values.put(Parameter.PARAM_A, 4.0);
        DataSample data = new DataSample();
        data.setValues(values);
        ksession.insert((Object)data);
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPropertyReactivityWithNestedAccessorsInModify() {
        String str = "package com.ilesteban.rulenotbeingfired;\n\nimport java.util.Map;\nimport java.util.EnumMap;\nimport " + Parameter.class.getCanonicalName() + "\nimport " + DataSample.class.getCanonicalName() + "\n\ndeclare Recommendation\n    parameter : Parameter\n    value : double\nend\n\nrule \"Init\" salience 100\nwhen\nthen\n    insert(new Recommendation(Parameter.PARAM_A, 1.0));end\nrule \"Rule 1\"\nwhen\n    $d: DataSample()\n    $re: Recommendation ($p: parameter, $v: value)\nthen\n    System.out.println(drools.getRule().getName());\n    modify($d){\n        addValue($re.getParameter(), $re.getValue())\n    }\nend\n\nrule \"Data with messages\"\nsalience -100\nwhen\n    $d: DataSample(notEmpty == true)\nthen\n    System.out.println(drools.getRule().getName());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new DataSample());
        Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testMvelResolvingGenericVariableDeclaredInParentClass() {
        String str = "import " + AbstractBase.class.getCanonicalName() + "\nimport " + StringConcrete.class.getCanonicalName() + "\nrule \"test\"\ndialect \"mvel\"\nwhen\n$S : StringConcrete()\nthen\n$S.getFoo().concat(\"this works with java dialect\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
    }

    @Test
    public void testMvelParsingParenthesisInString() {
        String str = "rule \"Test Rule\"\ndialect \"mvel\"\nwhen\nthen\nString s = new String(\"write something with ) a paren\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
    }

    @Test
    public void testCompilationMustFailComparingAClassLiteral() {
        String str = "import Misc2Test.Answer\nimport Misc2Test.AnswerGiver\nrule \"Test Rule\"\nwhen\n   AnswerGiver(Answer == Answer.YES)\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testDeclaredTypeExtendingInnerClass() {
        String str = "import " + StaticPerson.class.getCanonicalName() + "\ndeclare StaticPerson end\ndeclare Student extends StaticPerson end\nrule Init when\nthen\n    Student s = new Student();\n    s.setName( \"Mark\" );\n    insert( s );\nend\nrule Check when\n    StaticPerson( name == \"Mark\")\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAllowEqualityBetweenObjectAndPrimitiveInt() {
        String str = "declare Bean\n  items : int\nend\n\nrule \"O\"\nwhen\nthen\n  insert( new Bean( 2 ) );\nend\n\nrule \"X\"\nwhen\n   Bean( $num : items ) \n   accumulate( $o : Object(),\n     $list : collectList( $o );\n     $list.size == $num   )\nthen\n   System.out.println( \"Success!\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testJitConstraintWithOperationOnBigDecimal() {
        String str = "import " + Model.class.getCanonicalName() + "\nimport java.math.BigDecimal;\n\nrule \"minCost\" dialect \"mvel\" \nwhen\n    $product : Model(price < (cost + 0.10B))\nthen\n    modify ($product) { price = $product.cost + 0.10B }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Model model = new Model();
        model.setCost(new BigDecimal("2.43"));
        model.setPrice(new BigDecimal("2.43"));
        ksession.insert((Object)model);
        int fired = ksession.fireAllRules(2);
        if (fired > 1) {
            throw new RuntimeException("loop");
        }
    }

    @Test
    public void testJitComparable() {
        String str = "import " + IntegerWrapperImpl.class.getCanonicalName() + "\n\nrule \"minCost\"\nwhen\n    $a : IntegerWrapperImpl()\n    IntegerWrapperImpl( this < $a )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new IntegerWrapperImpl(2));
        ksession.insert((Object)new IntegerWrapperImpl(3));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testJitComparableNoGeneric() {
        String str = "import " + ComparableInteger.class.getCanonicalName() + "\n\nrule \"minCost\"\nwhen\n    $a : ComparableInteger()\n    ComparableInteger( this < $a )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new ComparableInteger(2));
        ksession.insert((Object)new ComparableInteger(3));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testJitComparable2() {
        String str = "import " + IntegerWrapperImpl2.class.getCanonicalName() + "\n\nrule \"minCost\"\nwhen\n    $a : IntegerWrapperImpl2()\n    IntegerWrapperImpl2( this < $a )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new IntegerWrapperImpl2(2));
        ksession.insert((Object)new IntegerWrapperImpl2(3));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testEqualityOfDifferentTypes() {
        String str = "declare Person\n  name: String\nend\ndeclare Customer\nextends Person\n  rating: int\nend\ndeclare Employee\nextends Person\n  wage: int\nend\n\nrule initphone\nsalience 100\nwhen\nthen\n    insert( new Customer( \"Joe\", 100 ) );\n    insert( new Employee( \"Paul\", 2100 ) );\nend\n\nrule match\nwhen\n    $c: Customer()\n    $e: Employee( this != $c )\nthen\n    System.out.println( \"c/e \" + $c + \" \" + $e );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testUnificationInRule() {
        String str = "declare A\nend\n\ndeclare B\n inner : A\nend\n\nrule \"Init\"\nwhen\nthen\n  A a = new A();\n  insert( a );\n  insert( new B( a ) );\nend\n\nrule \"Check\"\nwhen\n  B( $in := inner )\n  $in := A()\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"A\" ) );\n    insert( new B( null ) );\nend\n\nrule R when \n    A ( $a1 : a1 != null )\n    (or\n        (and\n            B( $b1 : b1 != null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n        (and\n            B( b1 == null )\n            eval( $a1.compareTo(\"B\") < 0 )\n        )\n    )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR2() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"A\" ) );\n    insert( new B( \"B\" ) );\nend\n\nrule R when \n    A ( $a1 : a1 != null )\n    (or\n        B( $b1 : b1 != null )\n        B( $b1 : b1 == null )\n    )\n    eval( $a1.compareTo( $b1 ) < 0 )\nthen\n    System.out.println( $b1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR3() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"A\" ) );\n    insert( new B( null ) );\nend\n\nrule R when \n    (or \n        A ( $a1 : a1 != null )\n        A ( $a1 : a1 != null ) ) \n    (or\n        (and\n            B( $b1 : b1 != null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n        (and\n            B( b1 == null )\n            eval( $a1.compareTo(\"B\") < 0 )\n        )\n    )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR4() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule R when \n    A ( $a1 : a1 != null )\n    (or\n        (and\n            B( $b1 : b1 != null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n        (and\n            B( b1 == null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n    )\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testQueryAfterEvalInsideOR() {
        String str = "package pakko\n\ndeclare Holder\n  str : String\nend\n\ndeclare Bean\n  val : String\nend\n\ndeclare Mock end \n\nrule \"Init\"\nwhen\nthen\n  insert( new Bean( \"xyz\" ) );\n  insert( new Holder( \"xyz\" ) );\n  insert( new Mock() );\nend\n\nquery mock( Mock $m ) $m := Mock() end\n\nrule \"Check\"\nwhen\n  $b : Bean( $t : val )\n  ( Holder( $t ; ) or eval( $t.startsWith( \"abc\" ) ) )\n  mock( $m ; ) \nthen\n  System.out.println( $m );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPackageVisibility() {
        String str = "package org.drools.integrationtests;\nrule \"getX\"\nwhen\n    $x: PackageProtected( )\nthen\n    System.out.println( $x );\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testNullValueInFrom() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList<Integer> list = new ArrayList<Integer>();
        ksession.setGlobal("list", list);
        list.add(1);
        list.add(null);
        list.add(2);
        ksession.fireAllRules();
    }

    @Test
    public void testNumberInQuotes() throws Exception {
        String str = "declare A\n    a1 : String\nend\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"40\" ) );\n    insert( new A( \"2abc\" ) );\n    insert( new B( \"300\" ) );\nend\n\nrule R1 when\n   A( $a1 : a1 ) \n   B( b1 > $a1 ) \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testStringCoercionComparison() {
        String str = "import " + Person.class.getName() + ";\nrule R1 when\n $p : Person( name < \"90201304122000000000000017\" )\nthen end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("90201304122000000000000015", 38));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAvoidUnwantedSemicolonWhenDelimitingExpression() {
        String str = "global java.util.List l\nrule rule1 \n    dialect \"mvel\" \nwhen \nthen \n    String s = \"http://onefineday.123\";\n    l.add(s);\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList l = new ArrayList();
        ksession.setGlobal("l", l);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"http://onefineday.123", l.get(0));
    }

    @Test
    public void testJitCastOfPrimitiveType() {
        String str = "rule R when\n Number(longValue < (Long)7)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Long(6L));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testSelfChangingRuleSet() {
        String str = "package org.drools.mvel.integrationtests;\nimport org.drools.mvel.integrationtests.Misc2Test.Foo2; \nglobal java.util.List list; \n\nrule \"Prep\" \nwhen \n  $packs : java.util.Collection() \nthen \n   ((org.drools.core.impl.RuleBase)drools.getKieRuntime().getKieBase()).addPackages( $packs );end \nrule \"Self-change\"\nwhen\n  String( this == \"go\" )\nthen\n   ((org.drools.core.impl.RuleBase)drools.getKieRuntime().getKieBase()).removeRule( \"org.drools.mvel.integrationtests\", \"React\" ); \nend\n\n\nrule \"Insert\"\nwhen\n  $i : Integer()\nthen\n  Foo2 foo = new Foo2();\n   foo.setX( $i ); \n  insert( foo );\nend\n";
        String str2 = "package org.drools.mvel.integrationtests;\nimport org.drools.mvel.integrationtests.Misc2Test.Foo2; \nglobal java.util.List list;\n rule \"React\"\nwhen\n  $b : Foo2( x < 10 )\nthen\n  System.out.println( \" Foo2 is in \" + $b.getX() );  list.add( $b ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Collection kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str2}).getKiePackages();
        ksession.insert((Object)kpkgs);
        ksession.insert((Object)new Integer(1));
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        ksession.insert((Object)new Integer(2));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testMatchIntegers() {
        String str = "global java.util.List list; \nrule R when\n $i : Integer( this == 1 )\nthen\n list.add( $i );\nend\nrule S when\n $i : Integer( this == 2 )\nthen\n list.add( $i );\nend\nrule T when\n $i : Integer( this == 3 )\nthen\n list.add( $i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Integer(1));
        ksession.fireAllRules();
    }

    @Test
    public void testDurationAnnotation() {
        String str = "package org.drools.mvel.integrationtests;\nimport org.drools.mvel.integrationtests.Misc2Test.SimpleEvent\ndeclare SimpleEvent\n    @role(event)\n    @duration(duration)\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
    }

    @Test
    public void testDurationAnnotationOnKie() {
        String str = "package org.drools.mvel.integrationtests;\nimport org.drools.mvel.integrationtests.Misc2Test.SimpleEvent\ndeclare SimpleEvent\n    @role(event)\n    @duration(duration)\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
    }

    @Test
    public void testDurationAnnotationWithError() {
        String str = "package org.drools.mvel.integrationtests;\nimport org.drools.mvel.integrationtests.Misc2Test.SimpleEvent\ndeclare SimpleEvent\n    @role(event)\n    @duration(duratio)\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testPhreakWithConcurrentUpdates() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R when\n  $s : String()\n  $i : Integer()\n  not Person( age == $i, name.startsWith($s) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)30);
        ksession.insert((Object)31);
        ksession.insert((Object)"B");
        ksession.insert((Object)"D");
        Person pA = new Person("AAA", 30);
        Person pB = new Person("BBB", 30);
        Person pC = new Person("CCC", 31);
        Person pD = new Person("DDD", 31);
        FactHandle fhB = ksession.insert((Object)pB);
        FactHandle fhD = ksession.insert((Object)pD);
        FactHandle fhA = ksession.insert((Object)pA);
        FactHandle fhC = ksession.insert((Object)pC);
        ksession.fireAllRules();
        pB.setAge(31);
        pB.setName("DBB");
        ksession.update(fhB, (Object)pB);
        pD.setAge(30);
        pD.setName("BDD");
        ksession.update(fhD, (Object)pD);
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        pB.setAge(30);
        pB.setName("BBB");
        ksession.update(fhB, (Object)pB);
        pD.setAge(31);
        pD.setName("DDD");
        ksession.update(fhD, (Object)pD);
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPhreakWith2Nots() {
        String str = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n  Person( $age : age, $name : name )\n  not Person( name == $name, age == $age + 1 )\n  not Person( name == $name, age == $age - 1 )\nthen\n  list.add($age);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("AAA", 31);
        Person p2 = new Person("AAA", 34);
        Person p3 = new Person("AAA", 33);
        FactHandle fh1 = ksession.insert((Object)p1);
        FactHandle fh3 = ksession.insert((Object)p3);
        FactHandle fh2 = ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)31L, (long)((Integer)list.get(0)).intValue());
        list.clear();
        p1.setAge(35);
        ksession.update(fh1, (Object)p1);
        p3.setAge(31);
        ksession.update(fh3, (Object)p3);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)31L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testPhreakTMS() {
        String str = "import " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nrule R when\n  Person( $age : age, $name : name == \"A\" )\n  not Person( age == $age + 1 )\nthen\n  insertLogical(new Cheese(\"gorgonzola\", 10));\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p1 = new Person("A", 31);
        FactHandle fh1 = ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)).size());
        Person p2 = new Person("A", 32);
        FactHandle fh2 = ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)).size());
    }

    @Test
    public void testHelloWorld() throws Exception {
        String drl = "package org.drools.test\ndeclare Message\n   message : String\nend\nrule R1 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs);
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        FactType messageType = ksession.getKieBase().getFactType("org.drools.test", "Message");
        Object message = messageType.newInstance();
        messageType.set(message, "message", (Object)"Hello World");
        ksession.insert(message);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        KieSession ksession2 = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        FactType messageType2 = ksession2.getKieBase().getFactType("org.drools.test", "Message");
        Object message2 = messageType2.newInstance();
        messageType2.set(message2, "message", (Object)"Hello World");
        ksession2.insert(message2);
        Assert.assertEquals((long)1L, (long)ksession2.fireAllRules());
    }

    @Test
    public void testPhreakInnerJoinNot() {
        String str = "import org.drools.mvel.integrationtests.Misc2Test.Lecture\nglobal java.util.List list;\nrule \"curriculumCompactness\"\n    when\n        $lecture : Lecture(\n            $day : day, $index : index\n        )\n        not Lecture(\n            day == $day, index == ($index + 1)\n        )\n    then\n        list.add($lecture.getId());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Lecture lA = new Lecture("A", 0, 4);
        Lecture lB = new Lecture("B", 2, 2);
        Lecture lC = new Lecture("C", 2, 1);
        FactHandle fhA = ksession.insert((Object)lA);
        FactHandle fhB = ksession.insert((Object)lB);
        FactHandle fhC = ksession.insert((Object)lC);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("A", "B")));
        list.clear();
        ksession.update(fhB, (Object)lB.setDay(0).setIndex(4));
        ksession.update(fhC, (Object)lC.setDay(0).setIndex(3));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("B"));
        list.clear();
        ksession.update(fhB, (Object)lB.setDay(2).setIndex(2));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("B"));
    }

    @Test
    public void testPhreakAccumulate() {
        String str = "import org.drools.mvel.integrationtests.Misc2Test.Lecture\nglobal java.util.List list;\nrule \"R1\"\n    when\n        $lecture : Lecture(\n            $day : day, $index : index\n        )\n        not Lecture(\n            day == $day, index == ($index + 1)\n        )\n    then\n        list.add($lecture.getId());\nend\nrule \"R2\"\n    when\n        $availableLectures : Number(intValue > 0) from accumulate(\n            $lecture : Lecture(\n                available == true\n            ),\n            count($lecture)\n        )\n\n    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Lecture lA = new Lecture("A", 0, 4, true);
        Lecture lB = new Lecture("B", 2, 2, true);
        Lecture lC = new Lecture("C", 2, 1, true);
        FactHandle fhA = ksession.insert((Object)lA);
        FactHandle fhB = ksession.insert((Object)lB);
        FactHandle fhC = ksession.insert((Object)lC);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("A", "B")));
        list.clear();
        ksession.update(fhB, (Object)lB.setAvailable(false));
        ksession.fireAllRules();
        ksession.update(fhB, (Object)lB.setDay(0).setIndex(3));
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("B", "C")));
        list.clear();
    }

    @Test
    public void testQueryAndRetract() {
        String str = "global java.util.List list\n\nquery q (String $s)\n    String( this == $s )\nend\nrule R1 when\n    $x : String( this == \"x\" )\n    ?q( \"x\"; )\nthen\n    delete( \"x\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        final ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((RuleEventManager)ksession).addEventListener(new RuleEventListener(){

            public void onDeleteMatch(Match match) {
                list.add("test");
            }
        });
        ksession.insert((Object)"x");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test(timeout=5000L)
    public void testPhreakNoLoop() {
        String str = "declare Person \n    name : String\n    age : int\nend\n\nrule Init when \nthen\n    insert( new Person( \"Mario\", 39 ) );\nend\n\nrule R no-loop when\n    $p: Person( name == \"Mario\" )\n    not String( this == \"go\" )\nthen\n    modify( $p ) { setAge( 40 ) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAddSameResourceTwice() {
        String str = "rule R when\n  $s : String()\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str, str});
        List messages = kieBuilder.getResults().getMessages();
        Assert.assertFalse((String)"Should have any message", (boolean)messages.isEmpty());
    }

    @Test
    public void testTwoTimers() {
        String str = "import java.util.Date\nimport java.util.List\n\nglobal List dates\n\nrule \"intervalRule\"\n  timer(int: 200ms 100ms)\nwhen\n  String(this == \"intervalRule\")\nthen\n  Date date = new Date();\n  dates.add(date);\nend\n\n\n// this rule stops timer\nrule \"stopIntervalRule\"\n  timer(int: 320ms)\nwhen\n  $s : String(this == \"intervalRule\")\nthen\n  delete($s);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @Test
    public void testUnsupportedPolymorphicDeclaration() {
        String drl = "package org.drools.test; \ndeclare Foo end \ndeclare Bar end \nrule X when\n $x : Foo()  or  $x : Bar() \nthen\n System.out.println( $x ); \nend\nrule Init\nwhen\nthen\n insert( new Foo() ); \n insert( new Bar() ); \nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testUnaryNegation() {
        String str = "rule R when\n    Integer( $a: intValue )\n    Integer( intValue > $a, intValue == -$a )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)3);
        ksession.insert((Object)-3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testNotNodeUpdateBlocker() {
        String str = "import org.drools.mvel.integrationtests.Misc2Test.Conversation;\nglobal java.util.List list;\nrule \"familyEnd\" when\n   $conversation : Conversation(\n       family != null, $family: family, \n       $timeslot: timeslot)\n\n   not Conversation(\n       family == $family, \n       timeslot > $timeslot);\nthen\n   list.add($conversation);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList conversations = new ArrayList();
        ksession.setGlobal("list", conversations);
        Conversation c0 = new Conversation(0, "Fusco", 2);
        Conversation c1 = new Conversation(1, "Fusco", 3);
        Conversation c2 = new Conversation(2, "Fusco", 4);
        FactHandle fh0 = ksession.insert((Object)c0);
        FactHandle fh1 = ksession.insert((Object)c1);
        FactHandle fh2 = ksession.insert((Object)c2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)conversations.size());
        conversations.clear();
        c2.setTimeslot(0);
        ksession.update(fh2, (Object)c2);
        ksession.fireAllRules();
        c2.setTimeslot(4);
        ksession.update(fh2, (Object)c2);
        ksession.fireAllRules();
        conversations.clear();
        c0.setTimeslot(3);
        ksession.update(fh0, (Object)c0);
        ksession.fireAllRules();
        c0.setTimeslot(2);
        ksession.update(fh0, (Object)c0);
        ksession.fireAllRules();
        conversations.clear();
        c2.setTimeslot(1);
        ksession.update(fh2, (Object)c2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)conversations.size());
    }

    @Test
    public void testFailedStaticImport() {
        String drl = "package org.drools.test; \nimport function org.does.not.exist.Foo; \nrule X when\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testNamedConsequence() {
        ArrayList firedRules = new ArrayList();
        String str = "import " + Foo.class.getCanonicalName() + "\nimport " + Foo2.class.getCanonicalName() + "\nglobal java.util.List fired;\nrule \"weird foo\"\n    when\n        \n        $foo: Foo($x: x)\n        if( $foo.getX() != 1 )  break[needThis]\n        $foo2: Foo2(x == $x);\n    then\n        fired.add(\"We made it!\");\n    then[needThis]\n        modify($foo){\n            setX(1)\n        };\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("fired", firedRules);
        ksession.insert((Object)new Foo());
        ksession.insert((Object)new Foo2(1));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)firedRules.size());
    }

    @Test
    public void testNamedConsequenceWithNot() {
        ArrayList firedRules = new ArrayList();
        String str = "import " + Foo.class.getCanonicalName() + "\nimport " + Foo2.class.getCanonicalName() + "\nglobal java.util.List fired;\nrule \"weird foo\"\n    when\n        $foo: Foo($x: x)\n        if( $foo.getX() != 1 ) break[needThis] \n        not( Foo(x == 2) ) \n        $foo2: Foo2(x == $x)\n    then\n        fired.add(\"We made it!\");\n    then[needThis]\n        modify($foo){\n            setX(1)\n        };\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("fired", firedRules);
        ksession.insert((Object)new Foo());
        ksession.insert((Object)new Foo2(1));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)firedRules.size());
    }

    @Test
    public void testBetaNodeInSubnetworkInStreamMode() {
        String str = "import " + Foo.class.getCanonicalName() + "\n\nglobal java.util.List context;\n\ndeclare Foo\n    @role( event )\nend\n\nrule \"Rule A\"\nwhen\n    $f : Foo( )\n    not ( Integer() from context )\nthen\n    $f.setX( 2 );\nend";
        KieBaseTestConfiguration streamConfig = TestParametersUtil.getStreamInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)streamConfig, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("context", (Object)new ArrayList(){
            {
                this.add(new Long(0L));
            }
        });
        Foo foo = new Foo();
        foo.setX(1);
        ksession.insert((Object)foo);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)foo.getX());
    }

    @Test
    public void testAutomaticallySwitchFromReteOOToPhreak() {
        String str = "rule R when then end\n";
        KieServices ks = KieServices.Factory.get();
        KieBuilder kbuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
        KieBase kbase = ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).getKieBase();
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testListnersOnStatlessKieSession() {
        String str = "rule R when\n  String()\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        final ArrayList firings = new ArrayList();
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
            }

            public void matchCancelled(MatchCancelledEvent event) {
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
                firings.add("Fired!");
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }
        };
        ksession.addEventListener(agendaEventListener);
        ksession.execute((Object)"1");
        ksession.execute((Object)"2");
        Assert.assertEquals((long)2L, (long)firings.size());
        ksession.removeEventListener(agendaEventListener);
        ksession.execute((Object)"3");
        Assert.assertEquals((long)2L, (long)firings.size());
    }

    @Test
    public void testImportExceptional() throws Exception {
        String str = "import org.acme.healthcare.Exception;\nglobal java.util.List list;\nrule \"Init\" when\nthen\n list.add( 1 ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(1), list);
    }

    @Test
    public void testMapAccessorWithCustomOp() {
        String str = "import java.util.Map;\nglobal java.util.List list;\nrule R when\n  Map( this[\"x\"] str[startsWith] \"T\" )\n  Map( this[\"x\"] soundslike \"Test\" )\nthen\n  list.add( 1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", "Test");
        ksession.insert(map);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(1), list);
    }

    @Test
    public void testMapAccessorWithBoundVar() {
        String str = "import java.util.Map;\nglobal java.util.List list;\nrule R when\n  Map( $val1 : this[\"x\"], $val1 str[startsWith] \"T\" )\n  Map( $val2 : this[\"x\"], $val2 soundslike \"Test\" )\nthen\n  list.add( 1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", "Test");
        ksession.insert(map);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(1), list);
    }

    @Test(timeout=10000L)
    public void testAgendaGroupSalience() {
        String str = "global java.util.List ruleList\n\nrule first\nsalience 2\nwhen\nthen\n    ruleList.add(\"first\");\n    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup(\"agenda\").setFocus();\nend\n\nrule second\nagenda-group \"agenda\"\nwhen\n    $s : String( this == 'fireRules' )\nthen\n    ruleList.add(\"second\");\nend\n\nrule third\nsalience 1\nwhen\n    $s : String( this == 'fireRules' )\nthen\n    ruleList.add(\"third\");\nend\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList ruleList = new ArrayList();
        ksession.setGlobal("ruleList", ruleList);
        ksession.insert((Object)"fireRules");
        ksession.fireAllRules();
        Assert.assertEquals(ruleList.get(0), (Object)"first");
        Assert.assertEquals(ruleList.get(1), (Object)"second");
        Assert.assertEquals(ruleList.get(2), (Object)"third");
    }

    @Test
    public void test3IdenticalForall() {
        String str = "rule \"Rule with forall_1\"\nwhen\n    forall ($obj : Object()\n            Object(this == $obj)\n    )\nthen\nend\n\nrule \"Rule with forall_2\"\nwhen\n    forall ($obj : Object()\n            Object(this == $obj)\n    )\nthen\nend\n\nrule \"Rule with forall_3\"\nwhen\n    forall ($obj : Object()\n            Object(this == $obj)\n    )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testSegmentInitialization() {
        String str = "import " + Resource.class.getCanonicalName() + "\nimport " + ResourceRequirement.class.getCanonicalName() + "\nimport " + Allocation.class.getCanonicalName() + "\nrule R    when\n        $resource : Resource($capacity : capacity)\n        $used : Number(intValue > $capacity) from accumulate(\n            ResourceRequirement(resource == $resource,\n                    $executionMode : executionMode)\n            and Allocation(executionMode == $executionMode),\n            sum($executionMode)\n        )\n    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new ResourceRequirement(new Resource(2), 3));
        ksession.insert((Object)new Allocation(3));
        ksession.fireAllRules();
    }

    @Test
    public void testReportErrorOnWrongDateEffective() {
        String drl = "rule X date-effective \"9-asbrdfh-1974\" when\n    $s : String() then\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testDeleteInFromNode() {
        String drl = "global java.util.Map context\n\nrule A\n  when\n     $i : Integer()\n  then\n     context.remove(\"key\");\nend\n\nrule B\n  when\n    $s : String() from context.get(\"key\")\n  then\n    System.out.println($s);end\n";
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kb.newKieSession();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("key", "value");
        ks.setGlobal("context", context);
        ks.insert((Object)1);
        ks.fireAllRules();
        context.put("key", "value");
        ks.fireAllRules();
    }

    @Test
    public void testSortWithNot() {
        String str = "import java.util.*; \nglobal java.util.List list;\ndeclare Bean \n value : Integer @key \n mark : boolean = false \nend \ndeclare Holder\n map : Map \nend \nrule \"Init\" when\nthen\n insert( new Holder( new HashMap() ) ); \n insert( new Bean( 10 ) );\n insert( new Bean( 30 ) );\n insert( new Bean( 20 ) );\n insert( new Bean( 50 ) );\n insert( new Bean( 40 ) );\nend\nrule Sort when \n $h : Holder( $map : map ) \n $b : Bean( ! $map.containsKey( value ), $v : value ) \n not Bean( ! $map.containsKey( value ), value > $v ) \nthen \n list.add( $v ); \n System.out.println( \"Marking \" + $v ); \n modify ( $h ) { getMap().put( $v, $b ); } \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(50, 40, 30, 20, 10), list);
    }

    @Test
    public void testExistsOr() {
        String drl = "package org.drools.test;\n\nglobal java.util.List list;\n\ndeclare Foo val : String end \nrule Init when $s : String() then delete( $s ); insert( new Foo( $s ) ); end \nrule \"Check Pos\"\nwhen\n exists ( Foo( val == \"1\" ) or Foo( val == \"2\" ) )\nthen\n list.add( \"+\" );\nend\n\nrule \"Check Neg\"\nwhen\n not ( not Foo( val == \"1\" ) and not Foo( val == \"2\" ) )\nthen\n list.add( \"-\" );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"2");
        ksession.insert((Object)"3");
        ksession.insert((Object)"1");
        ksession.insert((Object)"4");
        ksession.insert((Object)"5");
        ksession.insert((Object)"7");
        ksession.fireAllRules();
        ksession.insert((Object)"1");
        ksession.insert((Object)"5");
        ksession.insert((Object)"7");
        ksession.fireAllRules();
        ksession.insert((Object)"6");
        ksession.insert((Object)"2");
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)11L, (long)ksession.getObjects().size());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("+"));
        Assert.assertTrue((boolean)list.contains("-"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFactLeak() throws InterruptedException {
        String drl = "package org.drools.test; \nglobal java.util.List list; \nrule Intx when\n  $x : Integer() from entry-point \"x\" \nthen\n  list.add( $x ); \nend";
        int N = 1100;
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kb.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        new Thread(() -> ((KieSession)ks).fireUntilHalt()).start();
        try {
            for (int j = 0; j < N; ++j) {
                ks.getEntryPoint("x").insert((Object)new Integer(j));
            }
            Thread.sleep(1000L);
        }
        finally {
            ks.halt();
            ks.dispose();
            Assert.assertEquals((long)N, (long)list.size());
        }
    }

    @Test
    public void testFactStealing() throws Exception {
        String drl = "package org.drools.test; \nimport org.drools.mvel.compiler.Person; \n global java.util.List list; \n\n\nrule Sleep \n salience 1000 \nwhen then \n  System.out.println( Thread.currentThread().getName() + \"Zlip\" ); \n  Thread.sleep( 100 ); \nend \nrule FireAtWill\nwhen  \n  $p : Person( $n : name ) \nthen \n  System.out.println( Thread.currentThread().getName() + \" Ill continue later \" ); \n  Thread.sleep( 100 ); \n  System.out.println( Thread.currentThread().getName() + \" Hello >> \" + $n );\n  list.add( $n ); \nend\n\nrule ImDone\ntimer( expr:0 )\nwhen\n  $p : Person()\nthen\n  System.out.println( Thread.currentThread().getName() + \"Take out \" + $p ); \n  delete( $p );\n  System.out.println( Thread.currentThread().getName() + \"Taken out \" + $p ); \n  if ( list.isEmpty() ) { list.add( $p.getName() ); } \nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession knowledgeSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)new Person("mark", 67));
        knowledgeSession.fireAllRules();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("mark"));
    }

    @Test
    public void testEventWithSQLTimestamp() throws InterruptedException {
        String str = "import org.drools.mvel.integrationtests.Misc2Test.SQLTimestamped;\nglobal java.util.List list;\ndeclare SQLTimestamped @role(event) @timestamp(start) end \nrule \"Init\" when\n   $s1 : SQLTimestamped() \n   $s2 : SQLTimestamped( this != $s1, this after $s1 ) \nthen\n   list.add( \"ok\" ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new SQLTimestamped());
        Thread.sleep(100L);
        ksession.insert((Object)new SQLTimestamped());
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList("ok"), list);
    }

    @Test
    public void testIsGetClash() {
        String str = "import org.drools.mvel.integrationtests.Misc2Test.Foo3;\nglobal java.util.List list;\nrule \"Init\" when\n   $x : Foo3( x == true, y == true, z == \"ok\", isZ() == true ) \nthen\n   list.add( \"ok\" ); \nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Results results = kieBuilder.getResults();
        List errors = results.getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)2L, (long)errors.size());
    }

    @Test
    public void testCollectAccumulate() {
        String drl = "import java.util.ArrayList\n\nglobal java.util.Map map; \n declare Item\n     code: int\n     price: int\n     present: boolean\n end\n\n rule \"Init\"\n when\n then\n     insert(new Item(1,40,false));\n     insert(new Item(2,40,false));\n     insert(new Item(3,40,false));\n     insert(new Item(4,40,false));\n end\n\n rule \"CollectAndAccumulateRule\"\n when\n     //At least two items that aren't presents\n     objList: ArrayList(size>=2) from collect( Item(present==false))\n     //Total price bigger than 100\n     price: Number(intValue>=100) from accumulate( Item($w:price, present==false), sum($w))\n then\n\n     System.out.println(\"Sum: \"+price);\n     System.out.println(\"Items size: \"+objList.size());\n       map.put( objList.size(), price ); \n     \n     //Look for the minor price item\n     Item min = null;\n     for(Object obj: objList){\n         if (min!=null){\n             min = (min.getPrice()>((Item)obj).getPrice())?(Item)obj:min;\n         }\n         else {\n             min = (Item)obj;\n         }\n     }\n     \n     //And make it a present\n     if (min!=null){\n         modify(min){setPresent(true)};\n     }\n end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        HashMap map = new HashMap();
        ksession.setGlobal("map", map);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)160, map.get(4));
        Assert.assertEquals((Object)120, map.get(3));
    }

    @Test
    public void testLockOnActive1() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.integrationtests.Misc2Test.TradeBooking;\nimport org.drools.mvel.integrationtests.Misc2Test.TradeHeader;\nrule \"Rule1\" \nsalience 1 \nwhen\n  $booking: TradeBooking()\n  $trade: TradeHeader() @watch(*) from $booking.getTrade()\n  not String()\nthen\n  $trade.setAction(\"New\");\n  modify($booking) {}\n  insert (\"run\");\nend;\n\nrule \"Rule2\"\nlock-on-active true\nwhen\n  $booking: TradeBooking( )\n  $trade: Object( ) @watch(*) from $booking.getTrade()\nthen\nend";
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kb.newKieSession();
        final ArrayList created = new ArrayList();
        final ArrayList cancelled = new ArrayList();
        final ArrayList fired = new ArrayList();
        ks.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                created.add(event.getMatch().getRule().getName());
            }

            public void matchCancelled(MatchCancelledEvent event) {
                cancelled.add(event.getMatch().getRule().getName());
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
                fired.add(event.getMatch().getRule().getName());
            }
        });
        ks.fireAllRules();
        TradeBookingImpl tb = new TradeBookingImpl(new TradeHeaderImpl());
        ks.insert((Object)tb);
        Assert.assertEquals((long)1L, (long)ks.fireAllRules());
        Assert.assertEquals((long)3L, (long)created.size());
        Assert.assertEquals((long)2L, (long)cancelled.size());
        Assert.assertEquals((long)1L, (long)fired.size());
        Assert.assertEquals((Object)"Rule2", created.get(0));
        Assert.assertEquals((Object)"Rule1", created.get(1));
        Assert.assertEquals((Object)"Rule2", created.get(2));
        Assert.assertEquals((Object)"Rule2", cancelled.get(0));
        Assert.assertEquals((Object)"Rule2", cancelled.get(1));
        Assert.assertEquals((Object)"Rule1", fired.get(0));
    }

    @Test
    public void testLockOnActive2() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.integrationtests.Misc2Test.TradeBooking;\nimport org.drools.mvel.integrationtests.Misc2Test.TradeHeader;\nrule \"Rule1\" \nlock-on-active true\nsalience 1 \nwhen\n  $booking: TradeBooking()\n  $trade: TradeHeader() @watch(*) from $booking.getTrade()\nthen\n  $trade.setAction(\"New\");\n  modify($booking) {}\nend;\n\nrule \"Rule2\"\nwhen\n  $booking: TradeBooking( )\n  $trade: Object( ) @watch(*) from $booking.getTrade()\nthen\nend";
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kb.newKieSession();
        final ArrayList created = new ArrayList();
        final ArrayList cancelled = new ArrayList();
        final ArrayList fired = new ArrayList();
        ks.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                created.add(event.getMatch().getRule().getName());
            }

            public void matchCancelled(MatchCancelledEvent event) {
                cancelled.add(event.getMatch().getRule().getName());
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
                fired.add(event.getMatch().getRule().getName());
            }
        });
        ks.fireAllRules();
        TradeBookingImpl tb = new TradeBookingImpl(new TradeHeaderImpl());
        ks.insert((Object)tb);
        Assert.assertEquals((long)2L, (long)ks.fireAllRules());
        Assert.assertEquals((long)3L, (long)created.size());
        Assert.assertEquals((long)1L, (long)cancelled.size());
        Assert.assertEquals((long)2L, (long)fired.size());
        Assert.assertEquals((Object)"Rule1", created.get(0));
        Assert.assertEquals((Object)"Rule1", created.get(1));
        Assert.assertEquals((Object)"Rule2", created.get(2));
        Assert.assertEquals((Object)"Rule1", cancelled.get(0));
        Assert.assertEquals((Object)"Rule1", fired.get(0));
        Assert.assertEquals((Object)"Rule2", fired.get(1));
    }

    @Test
    public void testLockOnActiveWithModify() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.compiler.Person; \nrule \"Rule1\" \n@Propagation(EAGER) \nsalience 1 \nlock-on-active true\nwhen\n  $p: Person()\nthen\n  System.out.println( \"Rule1\" ); \n  modify( $p ) { setAge( 44 ); }\nend;\n\nrule \"Rule2\"\n@Propagation(EAGER) \nlock-on-active true\nwhen\n  $p: Person() \n  String() from $p.getName() \nthen\n  System.out.println( \"Rule2\" + $p );   modify ( $p ) { setName( \"john\" ); } \nend";
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kb.newKieSession();
        ks.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ks.fireAllRules();
        Person p = new Person("mark", 76);
        ks.insert((Object)p);
        ks.fireAllRules();
        Assert.assertEquals((long)44L, (long)p.getAge());
        Assert.assertEquals((Object)"john", (Object)p.getName());
    }

    @Test
    public void testLockOnActiveWithModifyNoEager() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.compiler.Person; \nrule \"Rule1\" \nsalience 1 \nlock-on-active true\nwhen\n  $p: Person()\nthen\n  System.out.println( \"Rule1\" ); \n  modify( $p ) { setAge( 44 ); }\nend;\n\nrule \"Rule2\"\nlock-on-active true\nwhen\n  $p: Person() \n  String() from $p.getName() \nthen\n  System.out.println( \"Rule2\" + $p );   modify ( $p ) { setName( \"john\" ); } \nend";
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kb.newKieSession();
        ks.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ks.fireAllRules();
        Person p = new Person("mark", 76);
        ks.insert((Object)p);
        ks.fireAllRules();
        Assert.assertEquals((long)44L, (long)p.getAge());
        Assert.assertEquals((Object)"john", (Object)p.getName());
    }

    @Test
    public void testPrimitiveGlobals() {
        String drl = "package org.drools.mvel.integrationtests\n\nglobal int foo;\n\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testClashingRules() {
        String drl = "package org.drools.test; \nrule \"Rule_>_all\"when then end \nrule \"Rule_<_all\"when then end \n";
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
    }

    @Test
    public void testDontFailOnDuplicatedRuleWithDeclaredTypeError() {
        String rule1 = "rule \"Some Rule\"\nwhen\n   $s: String()\nthen\nend";
        String rule2 = "declare DClass\n  prop : String\nend\nrule \"Some Rule\"\nwhen\n   $d: DClass()\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{rule1, rule2});
        Results results = kieBuilder.getResults();
        List errors = results.getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testBindingComplexExpression() {
        String drl = "package org.drools.test;\n\nglobal java.util.List list;\n\ndeclare Foo \n  a : int \n  b : int \nend \nrule Init when then insert( new Foo( 3, 4 ) ); end \nrule \"Expr\"\nwhen\n  $c := Integer() from new Integer( 4 ) \n  Foo(  $a : a + b == 7 && a == 3 && $b : b > 0, $c := b - a == 1 ) \nthen\n  list.add( $a );\n  list.add( $b );\n  list.add( $c );\nend\n\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.lang.level", LanguageLevelOption.DRL6.name());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertTrue((!list.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)3, list.get(0));
        Assert.assertEquals((Object)4, list.get(1));
        Assert.assertEquals((Object)4, list.get(2));
    }

    @Test
    public void testBindingComplexExpressionWithDRL5() {
        String drl = "package org.drools.test;\n\nglobal java.util.List list;\n\ndeclare Foo \n  a : int \n  b : int \nend \nrule Init when then insert( new Foo( 3, 4 ) ); end \nrule \"Expr\"\nwhen\n  $c := Integer() from new Integer( 4 ) \n  Foo(  $a : a + b == 7 && a == 3 && $b : b > 0, $c := b - a == 1 ) \nthen\n  list.add( $a );\n  list.add( $b );\n  list.add( $c );\nend\n\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.lang.level", LanguageLevelOption.DRL5.name());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertTrue((!list.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)3, list.get(0));
        Assert.assertEquals((Object)4, list.get(1));
        Assert.assertEquals((Object)4, list.get(2));
    }

    @Test
    public void testEvalConstraintWithMvelOperator() {
        PackageDescr packageDescr;
        String drl = "rule \"yeah\" \tdialect \"mvel\"\n when Foo( eval( field soundslike \"water\" ) ) then end";
        DrlParser drlParser = new DrlParser();
        try {
            packageDescr = drlParser.parse(true, drl);
        }
        catch (DroolsParserException e) {
            throw new RuntimeException(e);
        }
        RuleDescr r = (RuleDescr)packageDescr.getRules().get(0);
        PatternDescr pd = (PatternDescr)r.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pd.getConstraint().getDescrs().size());
    }

    @Test
    public void testManyAccumulatesWithSubnetworks() {
        String drl = "package org.drools.mvel.compiler.tests; \ndeclare FunctionResult\n    father  : Applied\nend\n\ndeclare Field\n    applied : Applied\nend\n\ndeclare Applied\nend\n\n\nrule \"Seed\"\nwhen\nthen\n    Applied app = new Applied();\n    Field fld = new Field();\n\n    insert( app );\n    insert( fld );\nend\n\n\n\n\nrule \"complexSubNetworks\"\nwhen\n    $fld : Field( $app : applied )\n    $a : Applied( this == $app )\n    accumulate (\n        $res : FunctionResult( father == $a ),\n        $args : collectList( $res )\n    )\n    accumulate (\n        $res : FunctionResult( father == $a ),\n        $deps : collectList( $res )\n    )\n    accumulate (\n        $x : String()\n        and\n        not String( this == $x ),\n        $exprFieldList : collectList( $x )\n    )\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        int num = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)num);
    }

    @Test
    public void testLinkRiaNodesWithSubSubNetworks() {
        String drl = "package org.drools.mvel.compiler.tests; \nimport java.util.*; \nglobal List list; \ndeclare MyNode\nend\nrule Init\nwhen\nthen\n    insert( new MyNode() );\n    insert( new MyNode() );\nend\nrule \"Init tree nodes\"\nsalience -10\nwhen\n    accumulate (\n                 MyNode(),\n                 $x : count( 1 )\n               )\n    accumulate (\n                 $n : MyNode()\n                 and\n                 accumulate (\n                    $val : Double( ) from Arrays.asList( 1.0, 2.0, 3.0 ),\n                    $rc : count( $val );\n                    $rc == 3 \n                 ),\n                 $y : count( $n )\n               )\nthen\n  list.add( $x ); \n  list.add( $y ); \n  System.out.println( $x ); \n  System.out.println( $y ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Long)list.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Long)list.get(1)).intValue());
    }

    @Test
    public void testDynamicSalienceUpdate() {
        String drl = "package org.drools.mvel.compiler.tests; \nimport java.util.*; \nglobal List list; \ndeclare Foo value : long end \nrule Nop \n salience( $l ) \nwhen\n  Foo( $l : value ) \nthen\n  System.out.println( \"Never Foo \" + $l );   list.add( $l ); \nend\nrule Insert \n salience 100 \nwhen \n  $l : Long() \nthen \n  System.out.println( \"Insert Foo \" + $l );   insertLogical( new Foo( $l ) ); \nend \nrule Clean \n salience 50 \nwhen \n  $s : String() \n  $l : Long() \nthen \n  System.out.println( \"delete \" + $l );   delete( $l ); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1L);
        ksession.insert((Object)2L);
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.isEmpty());
        ksession.dispose();
    }

    @Test
    public void testInitialFactLeaking() {
        String drl = "global java.util.List list;\nrule R when\n    $o : Object()\nthen\n    list.add(1);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.insert((Object)1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession.dispose();
    }

    @Test
    public void testNoLoopWithNamedConsequences() {
        String drl = "import " + Message.class.getCanonicalName() + "\nrule \"Hello World\" no-loop\n    when\n        m : Message( myMessage : message )\n        if (status == 0) do[sayHello]\n    then\n        System.out.println( myMessage );\n        m.setMessage( \"Goodbye cruel world\" );\n        m.setStatus( Message.GOODBYE );\n        update( m );\n    then[sayHello]\n        System.out.println(\"Hello, I'm here!\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        ksession.fireAllRules();
    }

    @Test
    public void testInsertModifyInteractionsWithLockOnActive() {
        String drl = "package org.drools.mvel.integrationtests;\nimport org.drools.mvel.compiler.Message;\nglobal Message m2;\nrule r1 lock-on-active\n    when\n        m: Message()\n    then\n        modify( m ){ setMessage2( 'msg2' ) };\n        m2 =  new Message( 'msg1' );\n        kcontext.getKnowledgeRuntime().setGlobal( 'm2', m2 ); \n        insert( m2 );\nend\nrule r2 lock-on-active salience 1000\n    when\n        m : Message()\n    then\n        modify( m ){ setMessage3( 'msg3' ) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        Message m1 = new Message("msg1");
        ksession.insert((Object)m1);
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
        Message m2 = (Message)ksession.getGlobal("m2");
        Assert.assertEquals((Object)"msg1", (Object)m1.getMessage());
        Assert.assertEquals((Object)"msg2", (Object)m1.getMessage2());
        Assert.assertEquals((Object)"msg3", (Object)m1.getMessage3());
        Assert.assertEquals((Object)"msg1", (Object)m2.getMessage());
        Assert.assertEquals((Object)"Two", (Object)m2.getMessage2());
        Assert.assertEquals((Object)"Three", (Object)m2.getMessage3());
    }

    @Test(timeout=10000L)
    public void testWumpus1() {
        String drl = "import org.drools.mvel.integrationtests.Misc2Test.Hero;\nimport org.drools.mvel.integrationtests.Misc2Test.StepForwardCommand;\nglobal java.util.List list; \n \n\nrule StepLeft when\n    $h  : Hero( goingRight == false )\n    $sc : StepForwardCommand()\nthen\n    modify ( $h ) { setPos( $h.getPos()-1 ) };\n    list.add( 'StepLeft' );\nend\n\nrule StepRight when\n    $h  : Hero( goingRight == true )\n    $sc : StepForwardCommand()\nthen\n    modify ( $h ) { setPos( $h.getPos()+1 ) };\n    list.add( 'StepRight' );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Hero hero = new Hero(1);
        ksession.insert((Object)hero);
        ksession.fireAllRules();
        ksession.insert((Object)new StepForwardCommand());
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)2L, (long)hero.getPos());
    }

    @Test(timeout=10000L)
    public void testWumpus2() {
        String drl = "import org.drools.mvel.integrationtests.Misc2Test.Hero;\nimport org.drools.mvel.integrationtests.Misc2Test.StepForwardCommand;\nimport org.drools.mvel.integrationtests.Misc2Test.ChangeDirectionCommand;\nglobal java.util.List list; \n \n\nrule StepLeft when\n    $sc : StepForwardCommand()\n    $h  : Hero( goingRight == false )\nthen\n    modify ( $h ) { setPos( $h.getPos()-1 ) };\n    list.add( 'StepLeft' );\nend\n\nrule StepRight when\n    $sc : StepForwardCommand()\n    $h  : Hero( goingRight == true )\nthen\n    modify ( $h ) { setPos( $h.getPos()+1 ) };\n    list.add( 'StepRight' );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Hero hero = new Hero(1);
        ksession.insert((Object)hero);
        ksession.fireAllRules();
        ksession.insert((Object)new StepForwardCommand());
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)2L, (long)hero.getPos());
    }

    @Test(timeout=10000L)
    public void testWumpus3() {
        String drl = "import org.drools.mvel.integrationtests.Misc2Test.Hero;\nimport org.drools.mvel.integrationtests.Misc2Test.StepForwardCommand;\nimport org.drools.mvel.integrationtests.Misc2Test.ChangeDirectionCommand;\nglobal java.util.List list; \n \nrule RotateLeft when\n    $h  : Hero( goingRight == true )\n    $dc : ChangeDirectionCommand()\nthen\n    retract ( $dc );   \n    modify ( $h ) { setGoingRight( false ) };\n    list.add( 'RotateLeft' );\nend\n\n\nrule StepLeft when\n    $h  : Hero( goingRight == false )\n    $sc : StepForwardCommand()\nthen\n    retract ( $sc );   \n    modify ( $h ) { setPos( $h.getPos()-1 ) };\n    list.add( 'StepLeft' );\nend\n\nrule StepRight when\n    $h  : Hero( goingRight == true )\n    $sc : StepForwardCommand()\nthen\n    retract ( $sc );\n    modify ( $h ) { setPos( $h.getPos()+1 ) };\n    list.add( 'StepRight' );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Hero hero = new Hero(1);
        ksession.insert((Object)hero);
        ksession.fireAllRules();
        ksession.insert((Object)new StepForwardCommand());
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)hero.getPos());
        ksession.insert((Object)new ChangeDirectionCommand());
        ksession.fireAllRules();
        ksession.insert((Object)new StepForwardCommand());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)hero.getPos());
    }

    @Test(timeout=10000L)
    public void testWumpus4() {
        String drl = "import org.drools.mvel.integrationtests.Misc2Test.Hero;\nimport org.drools.mvel.integrationtests.Misc2Test.StepForwardCommand;\nimport org.drools.mvel.integrationtests.Misc2Test.ChangeDirectionCommand;\nglobal java.util.List list; \n \nrule RotateLeft when\n    $dc : ChangeDirectionCommand()\n    $h  : Hero( goingRight == true )\nthen\n    retract ( $dc );   \n    modify ( $h ) { setGoingRight( false ) };\n    list.add( 'RotateLeft' );\nend\n\n\nrule StepLeft when\n    $sc : StepForwardCommand()\n    $h  : Hero( goingRight == false )\nthen\n    retract ( $sc );   \n    modify ( $h ) { setPos( $h.getPos()-1 ) };\n    list.add( 'StepLeft' );\nend\n\nrule StepRight when\n    $sc : StepForwardCommand()\n    $h  : Hero( goingRight == true )\nthen\n    retract ( $sc );\n    modify ( $h ) { setPos( $h.getPos()+1 ) };\n    list.add( 'StepRight' );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Hero hero = new Hero(1);
        ksession.insert((Object)hero);
        ksession.fireAllRules();
        ksession.insert((Object)new StepForwardCommand());
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)hero.getPos());
        ksession.insert((Object)new ChangeDirectionCommand());
        ksession.fireAllRules();
        ksession.insert((Object)new StepForwardCommand());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)hero.getPos());
    }

    @Test
    public void testDynamicSalience() {
        SimpleMessage[] msgs;
        String drl = "import org.drools.mvel.integrationtests.Misc2Test.SimpleMessage\n\nrule R1\n    salience ( $index )\n    when\n        $m : SimpleMessage( status == SimpleMessage.Status.ENRICHED, $index : index)\n        Number() from accumulate ( SimpleMessage(), count(1) )\n    then\n        System.out.println(\"R1: \" + $m);\n        modify($m) { setStatus(SimpleMessage.Status.FILTERED) }\nend\n\nrule R2\n    salience( -$index )    when        $m : SimpleMessage( status == SimpleMessage.Status.FILTERED, $index : index)\n    then        delete( $m );end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        for (SimpleMessage msg : msgs = new SimpleMessage[]{new SimpleMessage(0), new SimpleMessage(1), new SimpleMessage(2), new SimpleMessage(3)}) {
            ksession.insert((Object)msg);
        }
        ksession.fireAllRules();
        for (SimpleMessage msg : msgs) {
            Assert.assertEquals((Object)((Object)SimpleMessage.Status.FILTERED), (Object)((Object)msg.getStatus()));
        }
        Assert.assertEquals((long)0L, (long)ksession.getFactCount());
    }

    @Test
    public void testCollectAndAccumulate() {
        String drl = "import java.util.List\n\nglobal List list\n\n declare Item\n     code: int\n     price: int\n     present: boolean\n end\n\n rule \"Init\"\n when\n then\n     insert(new Item(1,40,false));\n     insert(new Item(2,40,false));\n     insert(new Item(3,40,false));\n     insert(new Item(4,40,false));\n end\n\n rule \"CollectAndAccumulateRule\"\n when\n     //At least two items that aren't presents\n     objList: List(size>=2) from collect( Item(present==false))\n     //Total price bigger than 100\n     price: Number(intValue>=100) from accumulate( Item($w:price, present==false), sum($w))\n then\n\n     list.add(price);\n     list.add(objList.size());\n     \n     //Look for the minor price item\n     Item min = null;\n     for(Object obj: objList){\n         if (min!=null){\n             min = (min.getPrice()>((Item)obj).getPrice())?(Item)obj:min;\n         }\n         else {\n             min = (Item)obj;\n         }\n     }\n     \n     //And make it a present\n     if (min!=null){\n         modify(min){setPresent(true)};\n     }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)160, list.get(0));
        Assert.assertEquals((Object)4, list.get(1));
        Assert.assertEquals((Object)120, list.get(2));
        Assert.assertEquals((Object)3, list.get(3));
    }

    @Test
    public void testMatchingEventsInStreamMode() {
        String drl = "import org.drools.mvel.integrationtests.Misc2Test.SimpleEvent\ndeclare SimpleEvent\n    @role(event)\nend\n\nrule \"RuleA\"\nsalience 5\nwhen\n    $f : SimpleEvent( )\nthen\n    delete ($f);\nend\n\nrule \"RuleB\"\nwhen\n    $f : SimpleEvent( )\nthen\nend\n";
        KieBaseTestConfiguration streamConfig = TestParametersUtil.getStreamInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)streamConfig, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        final AtomicInteger i = new AtomicInteger(0);
        ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                i.incrementAndGet();
            }

            public void matchCancelled(MatchCancelledEvent event) {
                i.decrementAndGet();
            }
        });
        ksession.insert((Object)new SimpleEvent());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)i.get());
    }

    @Test
    public void testRuleDoesNotRefireOnNewSession() {
        String drl = "\nglobal java.util.List list\nrule \"Insert Info\"\nwhen\nthen\n    insert( \"aaa\" );\n    insert( new Integer( 12 ) );\n    insert( new Double( 4.0 ) );\nend\n\n\nrule \"React\"\nwhen\n    Integer()\n    accumulate (\n                 $n : Double( ) and\n                      Double(  ),\n                 $x : count( $n )\n               )\n    String( )\nthen\n    list.add(\"working\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"working", list.get(0));
        ksession.dispose();
        ksession = kbase.newKieSession();
        list.clear();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"working", list.get(0));
        ksession.dispose();
    }

    @Test
    public void testWildcardImportForTypeField() throws Exception {
        String drl = "import java.util.*\ndeclare MyType\n    l : List\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @Test
    public void testWildcardImportForTypeFieldOldApi() {
        String drl = "import java.util.*\ndeclare MyType\n    l : List\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
    }

    @Test
    public void testTypeCheckInOr() {
        String str = "import org.drools.mvel.compiler.*;\nimport java.util.*;\n\nrule \"rule test\"\n    dialect \"java\"\n    \n    when\n        scenario: ScenarioType( this == ScenarioType.Set.ADD || this == ScenarioType.Set.EDIT  );\n        \n    then    \n        System.out.println(\"Test\");\n\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testDynamicNegativeSalienceWithSpace() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R\nsalience - $age\nwhen\n  Person( $age : age )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p1 = new Person("A", 31);
        FactHandle fh1 = ksession.insert((Object)p1);
        ksession.fireAllRules();
    }

    @Test
    public void testJoinNoLoop() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R no-loop\nwhen\n  String()\n  $p : Person( $age : age )\nthen\n    modify($p) { setAge( $age + 1 ) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person mario = new Person("Mario", 38);
        ksession.insert((Object)"a");
        ksession.insert((Object)"b");
        ksession.insert((Object)mario);
        ksession.fireAllRules();
        Assert.assertEquals((long)40L, (long)mario.getAge());
    }

    @Test
    public void testConstraintOnSerializable() {
        String str = "import org.drools.mvel.integrationtests.Misc2Test.SerializableValue\nrule R\nwhen\n  SerializableValue( value == \"1\" )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new SerializableValue((Serializable)((Object)"0")));
        ksession.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testInfiniteLoopUpdatingWithRBTreeIndexing() {
        String drl = "import " + Person.class.getCanonicalName() + "\nrule R when\n    $p : Person()\n    exists Person( age > $p.age, name.contains($p.name.substring(0, 1)) )\nthen\nend";
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kb.newKieSession();
        Person[] ps = new Person[4];
        FactHandle[] fhs = new FactHandle[4];
        ps[0] = new Person("a", 5);
        ps[1] = new Person("b", 5);
        ps[2] = new Person("d", 10);
        ps[3] = new Person("a", 15);
        fhs[0] = ks.insert((Object)ps[0]);
        fhs[1] = ks.insert((Object)ps[1]);
        fhs[2] = ks.insert((Object)ps[2]);
        fhs[3] = ks.insert((Object)ps[3]);
        ps[0].setName("c");
        ks.update(fhs[0], (Object)ps[0]);
        ks.fireAllRules();
        ps[2].setName("b");
        ks.update(fhs[2], (Object)ps[2]);
        ks.fireAllRules();
        ps[2].setName("d");
        ks.update(fhs[2], (Object)ps[2]);
        ks.fireAllRules();
        ps[1].setName("c");
        ks.update(fhs[1], (Object)ps[1]);
        ks.fireAllRules();
        ps[3].setName("d");
        ks.update(fhs[3], (Object)ps[3]);
        ks.fireAllRules();
    }

    @Test
    @Ignore
    public void testJitting() {
        String str = " import org.drools.mvel.integrationtests.Misc2Test.AA;  import org.drools.mvel.integrationtests.Misc2Test.BB;  global java.util.List list; \n  rule R \n  when \n    BB( $v : value ) \n    $a : AA( match( $v ) ) \n then \n   list.add( $a ); \n end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new BB());
        for (int j = 0; j < 100; ++j) {
            ksession.insert((Object)new AA(j));
            ksession.fireAllRules();
        }
        Assert.assertEquals((long)100L, (long)list.size());
    }

    @Test
    public void testQueryCorruption() {
        String drl = "package drl;\ndeclare Anon     cld : String @key     sup : String @key end rule Init when then     insert( 'aa' );     insert( 'bb' );     insert( 'cc' );     insertLogical( new Anon( 'aa', 'bb' ) );     insertLogical( new Anon( 'cc', 'aa' ) ); end query unravel( String $g, String $c )     (         ( Anon( $g, $c ; ) and String( $c := this, this.contains( \"b\" ) ) )         or         ( Anon( $g, $x ; ) and unravel( $x, $c ; ) )     ) end rule Check when     Anon( $e, $par ; )     unravel( $par, $comp ; )     ( Double() or eval( 1 == 1  ) ) then\nend\nrule Mod no-loop when\n    $a : Anon( )     ( Double() or eval( 1 == 1 ) ) then     modify ( $a ) { } end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testPackagingJarWithTypeDeclarations() throws Exception {
        String drl1 = "package org.drools.compiler\nimport org.drools.compiler.Message\ndeclare Message\n   @role (event)\nend\nrule R1 when\n   $m : Message()\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieModule km = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(km.getReleaseId());
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        ksession.fireAllRules();
    }

    @Test
    public void testJittingConstraintWithArrayParams() throws Exception {
        String str = "import org.drools.mvel.integrationtests.Misc2Test.Strings\n\nglobal java.util.List allList;\nglobal java.util.List anyList;\n\nrule R_all when\n    Strings( containsAll(\"1\", \"2\") )\nthen\n    allList.add(\"1\");\nend\n\nrule R_any when\n    Strings( containsAny(new String[] {\"1\", \"2\"}) )\nthen\n    anyList.add(\"1\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList allList = new ArrayList();
        ksession.setGlobal("allList", allList);
        ArrayList anyList = new ArrayList();
        ksession.setGlobal("anyList", anyList);
        ksession.insert((Object)new Strings("1", "2", "3"));
        ksession.insert((Object)new Strings("2", "3"));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)allList.size());
        Assert.assertEquals((long)2L, (long)anyList.size());
    }

    @Test
    public void testJittingConstraintInvokingStaticMethod() throws Exception {
        String str = "dialect \"mvel\"\nimport org.drools.mvel.integrationtests.Misc2Test.ARef\nimport org.drools.mvel.integrationtests.Misc2Test.BRef\n\nglobal java.util.List list;\n\nrule R when\n    $s : String( length == BRef.getSize(this) )\nthen\n    list.add($s);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"1234");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testGlobalInConstraint() throws Exception {
        String str = "global " + Evaller.class.getCanonicalName() + " evaller;\nglobal java.util.List list;\ndeclare Foo end\nrule Init when then insert( new Foo() ); end\nrule R1 when\n    $s : Foo( evaller.check( this ) == true )\nthen\n    list.add( 42 );\nend\nrule R2 when\n    $s : Foo( evaller.check( this ) == false )\nthen\n    list.add( 43 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("evaller", (Object)new Evaller());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)42L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testStaticInConstraint() throws Exception {
        String str = "import " + Evaller.class.getCanonicalName() + ";\nglobal java.util.List list;\ndeclare Foo end\nrule Init when then insert( new Foo() ); end\nrule R1 when\n    $s : Foo( Evaller.checkStatic( this ) == true )\nthen\n    list.add( 42 );\nend\nrule R2 when\n    $s : Foo( Evaller.checkStatic( this ) == false )\nthen\n    list.add( 43 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)42L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testFieldPrecedenceOverGlobal() throws Exception {
        String str = "import " + EvallerBean.class.getCanonicalName() + ";\nglobal " + Evaller.class.getCanonicalName() + " evaller;\nglobal java.util.List list;\nrule R1 when\n    $s : EvallerBean( evaller.size() == 1 )\nthen\n    list.add( 42 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("evaller", (Object)new Evaller());
        ksession.insert((Object)new EvallerBean());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)42L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testFieldPrecedenceOverDeclaration() throws Exception {
        String str = "import " + Evaller.class.getCanonicalName() + ";\nimport " + EvallerBean.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R1 when\n    evaller : Evaller()\n    $s : EvallerBean( evaller.size() == 1 )\nthen\n    list.add( 42 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Evaller());
        ksession.insert((Object)new EvallerBean());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)42L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testContainsOnString() {
        String str = "global java.util.List list;\nrule R1 when\n    $s : String( this contains 'bcd' )\nthen\n    list.add( $s );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"abcde");
        ksession.insert((Object)"bcdef");
        ksession.insert((Object)"cdefg");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("abcde", "bcdef")));
    }

    @Test
    public void testFunctionJitting() {
        String str = "global java.util.List list;\ndeclare Pippo end;\nfunction boolean alwaysTrue() { return true; }rule R1 when\n    $s : String( alwaysTrue() )\nthen\n    list.add( $s );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"abcde");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testGlobalExtractor() {
        String str = "package org.test; import java.util.*; global java.util.List list; global java.util.Date tat; declare Foo @role(event) @timestamp( ts )   tis : Date = new Date( 1000 )   ts  : Date = new Date( 0 ) end rule Init when then insert( new Foo() ); end rule R1 when\n    $s : Foo( tis before tat )\nthen\n    list.add( $s );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("tat", (Object)new Date(2000L));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSharedNotWithLeftUpdateAndRightInsert() throws Exception {
        String str = "import " + Foo.class.getCanonicalName() + ";\nimport " + Foo2.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R1 when\n    f1 : Foo( )\n    Foo2( )\n    Person( age == f1.x )\nthen\nend\nrule R2 when\n    Foo(  )\n    f2 : Foo2( )\n    not Person()\nthen\n    modify( f2 ) { x = 3 };\n    insert( new Person() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Foo f1 = new Foo();
        Foo2 f2 = new Foo2();
        ksession.insert((Object)f1);
        ksession.insert((Object)f2);
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)3L, (long)f2.getX());
    }

    @Test
    public void testNestedNots1() {
        String str = "package org.test; rule negation_over_nested when  not ( (String() and Integer())  or  (String() and Integer())) then  System.out.println(\"negation_over_nested\"); end  rule negation_distributed_partially_no_sharing when  (not (String() and Long()))  and  (not (String() and Long())) then  System.out.println(\"negation_distributed_partially_no_sharing\"); end  rule negation_distributed_partially_sharing when  (not (String() and Integer()))  and  (not (String() and Integer())) then  System.out.println(\"negation_distributed_partially_sharing\"); end  rule negation_distributed_fully when  ((not String()) or (not Integer()))  and  ((not String()) or (not Integer())) then  System.out.println(\"negation_distributed_fully\"); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        int n = ksession.fireAllRules();
        Assert.assertEquals((long)7L, (long)n);
    }

    @Test
    public void testNestedNots2() {
        String str = "package org.test; rule shared_conjunct when  (not (String() and Integer())) then  System.out.println(\"shared_conjunct\"); end rule negation_over_nested when  not ( (String() and Integer())  or  (String() and Integer())) then  System.out.println(\"negation_over_nested\"); end  rule negation_distributed_partially_no_sharing when  (not (String() and Long()))  and  (not (String() and Long())) then  System.out.println(\"negation_distributed_partially_no_sharing\"); end  rule negation_distributed_partially_sharing when  (not (String() and Integer()))  and  (not (String() and Integer())) then  System.out.println(\"negation_distributed_partially_sharing\"); end  rule negation_distributed_fully when  ((not String()) or (not Integer()))  and  ((not String()) or (not Integer())) then  System.out.println(\"negation_distributed_fully\"); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        int n = ksession.fireAllRules();
        Assert.assertEquals((long)8L, (long)n);
    }

    @Test
    public void testNestedNots3() {
        String str = "package org.test; rule negation_distributed_partially_no_sharing when  (not String())  and  (not (Double() and Integer())) then  System.out.println(\"firing\"); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        int n = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)n);
    }

    @Test
    public void testExtendingDate() {
        String str = "import " + MyDate.class.getCanonicalName() + " \nrule 'sample rule' \nwhen \n  $date: MyDate() \nthen \n$date.setDescription(\"test\"); \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List messages = kieBuilder.getResults().getMessages();
        Assert.assertTrue((String)messages.toString(), (boolean)messages.isEmpty());
    }

    @Test
    public void testEvalInSubnetwork() {
        String str = "global java.util.List list;\n\ndeclare StatusEvent\n@role(event)\ntimestamp : int\nend\n\nrule R when\n$i : Integer()\neval(true)\nexists(\nInteger(intValue > $i.intValue)\nand eval(true)\n)\nthen\nlist.add($i.intValue());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)0);
        ksession.fireAllRules();
        ksession.insert((Object)1);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)0L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testRedeclaringRuleAttribute() {
        String str = "rule R salience 10 salience 100 when then end\n";
        TestUtil.assertDrlHasCompilationError(str, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testMultilineStatement() {
        String str = "rule \"test\"\ndialect \"mvel\"\nwhen\nthen\nSystem  \n  .out  \n  .println(\"hello\");\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List messages = kieBuilder.getResults().getMessages();
        Assert.assertTrue((String)messages.toString(), (boolean)messages.isEmpty());
    }

    @Test
    public void testExtendsWithStrictModeOff() {
        String str = "import java.util.HashMap;\ndialect \"mvel\"\ndeclare HashMap end\n\ndeclare Test extends HashMap end\n\nrule \"Insert\" salience 0\nwhen\nthen\nTest t = new Test();\nt.Price = 10;\nt.put(\"A\", \"a\");\nt.OtherPrices = new HashMap();\nt.OtherPrices.OldPrice = 8;\nSystem.out.println(\"Inserting t=\"+t);\ninsert(t);\nend\n\nrule \"Test HashMap\" salience -1\nwhen\nt: HashMap( Price < 11 )\nthen\nt.Price = 11;\nSystem.out.println(\"In Test HashMap\");\nend\n\nrule \"Test Inherited\" salience -1\nwhen\nt: Test( Price < 100 )\nthen\nt.Price = 12;\nSystem.out.println(\"In Test Inherited!\");\nend\n\nrule \"Print Result\" salience -5\nwhen\nt: Test()\nthen\nSystem.out.println(\"Finally Price is =\"+t.Price);\n//This as well doesn't print content as per toString() of HashMap is there a way to do that?\nSystem.out.println(\"Finally t=\"+t);\nend\n";
        KnowledgeBuilderConfigurationImpl pkgBuilderCfg = new KnowledgeBuilderConfigurationImpl();
        MVELDialectConfiguration mvelConf = (MVELDialectConfiguration)pkgBuilderCfg.getDialectConfiguration("mvel");
        mvelConf.setStrict(false);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pkgBuilderCfg);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testCompilationFailureWithDuplicatedAnnotation() {
        String str = "declare EventA\n @role(fact)\n @role(event)\nend\n";
        TestUtil.assertDrlHasCompilationError(str, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testCrossNoLoopWithNodeSharing() throws Exception {
        String drl = "package org.drools.mvel.compiler.loop rule 'Rule 1'   agenda-group 'Start'   no-loop   when       $thing1 : String()       $thing2 : Integer()   then\n      System.out.println( 'At 1' );       update( $thing2 ); end rule 'Rule 2'   agenda-group 'End'   no-loop   when       $thing1 : String()       $thing2 : Integer()   then       System.out.println( 'At 2' );       update( $thing2 ); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        session.insert((Object)"hello");
        session.insert((Object)new Integer(42));
        session.getAgenda().getAgendaGroup("End").setFocus();
        session.getAgenda().getAgendaGroup("Start").setFocus();
        int x = session.fireAllRules(10);
        Assert.assertEquals((long)2L, (long)x);
        session.dispose();
    }

    @Test
    public void testNotNodesUnlinking() throws Exception {
        String drl = "import " + Trailer.class.getCanonicalName() + ";global java.util.List trailerList;rule R1\nagenda-group 'Start'\n    when\n$trailer : Trailer(status == Trailer.TypeStatus.WAITING);\nnot Trailer(status == Trailer.TypeStatus.LOADING); \nnot Trailer(status == Trailer.TypeStatus.SHIPPING);\n    then\n        System.out.println( \"[rfgroup1] find waiting trailer : \" + $trailer);\n        $trailer.setStatus(Trailer.TypeStatus.LOADING); \n        update($trailer);\nend\n\nrule R2\nagenda-group 'Start'\n    when\n$trailer : Trailer(status == Trailer.TypeStatus.LOADING);\n    then\n        System.out.println( \"[rfgroup1] ship : \" + $trailer);\n        $trailer.setStatus(Trailer.TypeStatus.SHIPPING);\n        update($trailer);\nend\n\nrule R3\nagenda-group 'Start'\n    when\n$trailer : Trailer(status == Trailer.TypeStatus.SHIPPING);\n    then\n        System.out.println( \"[rfgroup1] shipping done : \" + $trailer);\n        trailerList.add($trailer);\n        retract($trailer);\nend\n\nrule R4\nno-loop\nagenda-group 'End'\n    when\n    then\n        System.out.println( \"[rfgroup2] insert new trailers\");\n        insert(new Trailer(Trailer.TypeStatus.WAITING));\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList trailerList = new ArrayList();
        ksession.setGlobal("trailerList", trailerList);
        Trailer trailer1 = new Trailer(Trailer.TypeStatus.WAITING);
        ksession.insert((Object)trailer1);
        ksession.getAgenda().getAgendaGroup("Start").setFocus();
        ksession.getAgenda().getAgendaGroup("End").setFocus();
        ksession.getAgenda().getAgendaGroup("Start").setFocus();
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)trailerList.size());
    }

    @Test
    public void testJITIncompatibleTypes() throws Exception {
        String drl = "import " + Host.class.getCanonicalName() + ";\nrule R when\n    $s: String()    Host($s == this)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Host());
        ksession.insert((Object)"host");
        ksession.fireAllRules();
    }

    @Test
    public void testAccumulateWithNodeSharing() throws Exception {
        String drl = "import " + TypeA.class.getCanonicalName() + ";\nimport " + TypeB.class.getCanonicalName() + ";\nimport " + TypeC.class.getCanonicalName() + ";\nimport " + TypeD.class.getCanonicalName() + ";\nrule R1 when\n    $a : TypeA()\n    $b : TypeB( parentId == $a.id )\n    $d : TypeD( parentId == $b.id, value == 1 )\nthen\nend\n\nrule R2 no-loop when\n    $a : TypeA()\n    $b : TypeB( parentId == $a.id )\nthen\n    update($b);end\n\nrule R3 when\n    $a : TypeA()\n    $b : TypeB( parentId == $a.id )\n    $d : TypeD( parentId == $b.id )\n    $result : Number() from accumulate(\n        $b_acc : TypeB()\n        and\n        $c : TypeC( parentId == $b_acc.id, $value : value );\n        sum($value)\n    )\nthen\n    $d.setValue($result.intValue());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new TypeA());
        ksession.insert((Object)new TypeB());
        ksession.insert((Object)new TypeC());
        TypeD d = new TypeD();
        ksession.insert((Object)d);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)d.getValue());
    }

    @Test
    public void testDeletedEvalLeftTuple() throws Exception {
        String drl = "import " + Reading.class.getCanonicalName() + ";\nimport " + Alarm.class.getCanonicalName() + ";\nrule Normal when\n    Number( intValue <= 5) from accumulate( reading : Reading(), average( reading.getValue() ) )\n    alarm : Alarm ()\nthen\n    System.out.println(kcontext.getRule().getName());    delete( alarm );\nend\n    \nrule Abnormal when\n    Number( intValue > 5, intValue <= 10 ) from accumulate( reading : Reading(), average( reading.getValue() ) )\n    not Alarm ()\nthen\n    System.out.println(kcontext.getRule().getName());    Alarm alarm = new Alarm();\n    alarm.setType(\"t1\");\n    alarm.setLevel( \"ABNORMAL\" );\n    insert(alarm);\nend\n\nrule Severe when\n    Number( intValue > 10) from accumulate( reading : Reading(), average( reading.getValue() ) )\n    not Alarm ()\nthen\n    System.out.println(kcontext.getRule().getName());    Alarm alarm = new Alarm();\n    alarm.setType(\"t1\");\n    alarm.setLevel( \"SEVERE\" );\n    insert(alarm);\nend\n\nrule AbnormalToSevere when\n    Number( intValue > 10) from accumulate( reading : Reading(), average( reading.getValue() ) )\n    alarm : Alarm (level == \"ABNORMAL\")\nthen\n    System.out.println(kcontext.getRule().getName());    alarm.setLevel( \"SEVERE\" );\n    update(alarm);\nend\n\nrule SevereToAbnormal when\n    $type : String()\n    accumulate( reading : Reading( type == $type ), $avg : average( reading.getValue() ) )\n    eval( $avg.intValue() > 5 && $avg.intValue() <= 10 )\n    alarm : Alarm (type == $type, level == \"SEVERE\")\nthen\n    System.out.println(kcontext.getRule().getName());    alarm.setLevel( \"ABNORMAL\" );\n    update(alarm);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"t1");
        ksession.insert((Object)new Reading("t1", 12));
        ksession.fireAllRules();
        ksession.insert((Object)new Reading("t1", 0));
        ksession.fireAllRules();
        ksession.insert((Object)new Reading("t1", 0));
        ksession.fireAllRules();
        ksession.insert((Object)new Reading("t1", 16));
        ksession.fireAllRules();
        ksession.insert((Object)new Reading("t1", 32));
        ksession.fireAllRules();
        ksession.insert((Object)new Reading("t1", -6));
        ksession.fireAllRules();
    }

    @Test
    public void testDeleteFromLeftTuple() throws Exception {
        String drl = "import " + C1.class.getCanonicalName() + ";\nimport " + C2.class.getCanonicalName() + ";\nimport " + C3.class.getCanonicalName() + ";\nrule R when\n    $c1 : C1 ( $c2s : c2s, $c2 : c2s.get(counter), counter < size )\n    C2 ( $c3s : c3s, this == $c2 ) from $c2s\n    accumulate( C3 ( $value : value ) from $c3s;\n                $sum : sum($value)\n              )\nthen\n    $c1.setCounter($c1.getCounter() + 1);\n    update( $c1 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new C1());
        ksession.fireAllRules();
    }

    @Test
    public void testMethodResolution() throws Exception {
        String drl = "import " + I1.class.getCanonicalName() + ";\nrule R1 when\n    I1 ( value == \"x\" )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Y());
        ksession.fireAllRules();
        ksession.insert((Object)new Z());
        ksession.fireAllRules();
    }

    @Test
    public void testCorrectErrorMessageOnDeclaredTypeCompilation() throws Exception {
        String str = "rule R\nsalience 10\nwhen\n String()\nthen\nSystem.out.println(\"Hi\");\nend\ndeclare A\n a : SomeNonexistenClass @key\n b : int @key\nend\n\ndeclare C\n d : int @key\n e : int[]\nend\n";
        TestUtil.assertDrlHasCompilationError(str, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testFieldNameStartingWithUnderscore() throws Exception {
        String str = "import " + Underscore.class.getCanonicalName() + ";\nrule R when\n    Underscore( _id == \"test\" )\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List messages = kieBuilder.getResults().getMessages();
        Assert.assertTrue((String)messages.toString(), (boolean)messages.isEmpty());
    }

    @Test
    public void testSharedQueryNode() throws Exception {
        String drl = "query find( Integer $i, String $s )\n    $i := Integer( toString() == $s )\nend\n\nrule R2 salience -1 when\n    $s : String()\n    ?find( i, $s; )\nthen\nend\nrule R1 when\n    $s : String()\n    ?find( i, $s; )\n    $i : Integer( this == 1 ) from i\nthen\n    delete( $s );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"1");
        ksession.insert((Object)1);
        ksession.fireAllRules();
    }

    @Test
    public void testLeftTupleGetIndex() throws Exception {
        String drl = "rule R1 when\n    $s : String()\n    (or Long(this == 1) Long(this == 2) )\nthen\nend\nrule R2 extends R1 when\n    $n : Number() from accumulate( Integer($value : this); sum($value) )\nthen\n    System.out.println($n);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"1");
        ksession.insert((Object)1L);
        ksession.insert((Object)1);
        ksession.fireAllRules();
    }

    @Test
    public void testStrOperatorInAccumulate() throws Exception {
        String drl = "declare Message\n    text : String\nend\n\ndeclare GroupByString\n    groupId : String\n    groups : String[]\nend\n\nglobal java.util.List list\n\nrule \"init words of my interest\"\nno-loop\nwhen\nthen\n    GroupByString grp = new GroupByString();\n    grp.setGroupId(\"wordGroup\");\n    grp.setGroups(new String[]{\"hi\", \"hello\"});\n    insert(grp);\n    insert(new Message(\"hi all\"));\n    insert(new Message(\"hello world\"));\n    insert(new Message(\"bye\"));\n    insert(new Message(\"hello everybody\"));\nend\n\nrule \"group by word and count if >=2 then \"\nno-loop\nwhen\n    $group : GroupByString( groupId == \"wordGroup\")\n    $word : String() from $group.groups\n    acc ( $msg : Message( text str[startsWith] $word );\n        $list : collectList( $msg ),\n        $count : count( $msg );\n        $count >= 1\n        )\nthen\n    list.add(\"group by \" + $word + \" count is \"+ $count);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("group by hello count is 2"));
        Assert.assertTrue((boolean)list.contains("group by hi count is 1"));
    }

    @Test
    public void testKeywordAsAttribute() throws Exception {
        String drl = "package foo.bar;\ndeclare Fired\n        rule: String\nend\nglobal java.util.List list\nrule \"F060\" dialect \"mvel\"\nwhen\nthen\n    Fired f = new Fired();\n    f.rule = \"F060\";\n    insert(f);\nend\n \nrule \"F060b\"  //this prints F060b: Fired( rule=F060 )\n    dialect \"mvel\"\nwhen\n        $rule: Fired()\nthen\n    list.add( drools.getRule().getName() )\nend\n \nrule \"F060c\"  //doesn't work\n    dialect \"mvel\"\nwhen\n        $rule: Fired( rule==\"F060\" )\nthen\n    list.add( drools.getRule().getName() )\nend\n \nrule \"F060d\"  //this prints F060d: Fired( rule=F060 )\n    dialect \"mvel\"\nwhen\n        $rule: Fired()\n        eval( $rule.rule == \"F060\")\nthen\n    list.add( drools.getRule().getName() )\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("F060b"));
        Assert.assertTrue((boolean)list.contains("F060c"));
        Assert.assertTrue((boolean)list.contains("F060d"));
    }

    @Test
    public void testRuleExtendsWithNamedConsequence() {
        String drl = "package org.drools.test;\nglobal java.util.List list;\nrule Base\nwhen\n  $i : Integer( ) do[x]\nthen\nthen[x]\n   list.add( $i );\nend\nrule Ext extends Base\nwhen\n  $d : String()\nthen\n   list.add( $d );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        kieSession.insert((Object)10);
        kieSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)10L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)list.get(1)).intValue());
    }

    @Test
    public void testRuleExtendsWithOverriddenNamedConsequence() {
        String drl = "package org.drools.test;\nglobal java.util.List list;\nrule Base\nwhen\n  $i : Integer( ) do[x]\nthen\nthen[x]    list.add( $i );\nend\nrule Ext extends Base\nwhen\n  $d : String()\nthen\n   list.add( $d );\nthen[x]\n   list.add( \"\" + $i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        kieSession.insert((Object)10);
        kieSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)10, list.get(0));
        Assert.assertEquals((Object)"10", list.get(1));
    }

    @Test
    public void testCustomDynamicSalience() {
        String drl = "package org.drools.test; import " + Person.class.getName() + "; global java.util.List list; rule A when      $person : Person( name == 'a' ) then     list.add( $person.getAge() ); end rule B when      $person : Person( name == 'b' ) then     list.add( $person.getAge() ); end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        for (Rule r : session.getKieBase().getKiePackage("org.drools.test").getRules()) {
            ((RuleImpl)r).setSalience(new Salience(){

                public int getValue(Activation activation, Rule rule, ReteEvaluator reteEvaluator) {
                    if (activation == null) {
                        return 0;
                    }
                    InternalFactHandle h = (InternalFactHandle)activation.getFactHandles().get(0);
                    return ((Person)h.getObject()).getAge();
                }

                public int getValue() {
                    throw new IllegalStateException("Should not have been called...");
                }

                public boolean isDynamic() {
                    return true;
                }
            });
        }
        session.insert((Object)new Person("a", 1));
        session.insert((Object)new Person("a", 5));
        session.insert((Object)new Person("a", 3));
        session.insert((Object)new Person("b", 4));
        session.insert((Object)new Person("b", 2));
        session.insert((Object)new Person("b", 6));
        session.fireAllRules();
        Assert.assertEquals(Arrays.asList(6, 5, 4, 3, 2, 1), list);
    }

    @Test
    public void testNotWithSubNetwork() {
        String drl = "rule R when\n    $s : String( )\n    not (\n        Long( toString() == $s )\n    and\n        Integer( toString() == $s )\n    )\nthen\n    delete( $s );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"1");
        FactHandle iFH = ksession.insert((Object)1);
        FactHandle lFH = ksession.insert((Object)1L);
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        ksession.delete(iFH);
        ksession.delete(lFH);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)0L, (long)ksession.getFactCount());
    }

    @Test
    public void testGenericsInRHSWithModify() {
        String drl = "import java.util.Map;\nimport java.util.HashMap;\nrule R no-loop when\n    $s : String( )\nthen\n    Map<String,String> a = new HashMap<String,String>();\n    modify( $s ) { };end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"1");
        ksession.fireAllRules();
    }

    @Test
    public void testQueryWithAgendaGroup() {
        String drl = "package org.drools.test; global java.util.List list; query foo( Integer $i )    $i := Integer() end rule Detect agenda-group 'one' when    foo( $i ; ) then    list.add( $i ); end rule OnceMore agenda-group 'two' no-loop when    $i : Integer() then    update( $i );end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        FactHandle handle = kieSession.insert((Object)42);
        Agenda agenda = kieSession.getAgenda();
        agenda.getAgendaGroup("two").setFocus();
        agenda.getAgendaGroup("one").setFocus();
        kieSession.fireAllRules();
        Assert.assertEquals(Arrays.asList(42), list);
        kieSession.delete(handle);
        kieSession.insert((Object)99);
        agenda.getAgendaGroup("two").setFocus();
        agenda.getAgendaGroup("one").setFocus();
        kieSession.fireAllRules();
        Assert.assertEquals(Arrays.asList(42, 99), list);
    }

    @Test
    public void testQueryUsingQueryWithAgendaGroup() {
        String drl = "package org.drools.test; global java.util.List list; query bar( String $s )    $s := String() end query foo( Integer $i, String $s )    bar( $s ; )    $i := Integer( toString() == $s ) end rule Detect agenda-group 'one' when    foo( $i, $s ; ) then    list.add( $i ); end rule UpdateInt agenda-group 'two' no-loop when    $i : Integer() then    update( $i );end rule UpdateString agenda-group 'three' no-loop when    $s : String() then    update( $s );end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        FactHandle iFH = kieSession.insert((Object)42);
        FactHandle sFH = kieSession.insert((Object)"42");
        Agenda agenda = kieSession.getAgenda();
        agenda.getAgendaGroup("three").setFocus();
        agenda.getAgendaGroup("two").setFocus();
        agenda.getAgendaGroup("one").setFocus();
        kieSession.fireAllRules();
        Assert.assertEquals(Arrays.asList(42), list);
        kieSession.delete(sFH);
        kieSession.insert((Object)99);
        kieSession.insert((Object)"99");
        agenda.getAgendaGroup("three").setFocus();
        agenda.getAgendaGroup("two").setFocus();
        agenda.getAgendaGroup("one").setFocus();
        kieSession.fireAllRules();
        Assert.assertEquals(Arrays.asList(42, 99), list);
    }

    @Test
    public void testFactTemplates() {
        String drl = "package com.testfacttemplate; rule \"test rule\"  dialect \"mvel\"  when  $test : TestFactTemplate( status == 1 )  then  System.out.println( \"Hello World\" );  end ";
        InternalKnowledgePackage kPackage = CoreComponentFactory.get().createKnowledgePackage("com.testfacttemplate");
        FieldTemplateImpl fieldTemplate = new FieldTemplateImpl("status", 0, Integer.class);
        FactTemplateImpl factTemplate = new FactTemplateImpl(kPackage, "TestFactTemplate", new FieldTemplate[]{fieldTemplate});
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl(kPackage);
        StringReader rule = new StringReader(drl);
        try {
            kBuilder.addPackageFromDrl((Reader)rule);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testBitwiseOperator() {
        String drl = "global java.util.List list;\n\nrule R when\n    $i : Integer( (intValue() & 5) != 0 )\nthen\n    list.add($i);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        kieSession.insert((Object)3);
        kieSession.insert((Object)2);
        kieSession.insert((Object)6);
        kieSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(3, 6)));
    }

    @Test
    public void testNotSubnetwork() {
        String drl = "import " + TypeCC.class.getCanonicalName() + ";\nimport " + TypeDD.class.getCanonicalName() + ";\n  \nrule R1 \nwhen  \n   $dd : TypeDD( value < 1 )\nthen  \n\tSystem.out.println(\"Rule R1 Fired\");\n\tmodify($dd) { setValue(1); }\nend  \n  \nrule R2 when  \n   String( )  \n   $cc : TypeCC( value < 1 )\n   not(  \n\t   $cc_not : TypeCC( )  \n\t   and  \n\t   $dd_not : TypeDD( value==0 )  \n   )  \nthen  \n   System.out.println(\"Rule R2 Fired\");\n   modify($cc) { setValue($cc.getValue()+1); }\nend; ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"1");
        ksession.insert((Object)"2");
        TypeCC cc = new TypeCC();
        ksession.insert((Object)cc);
        ksession.insert((Object)new TypeDD());
        ksession.fireAllRules();
        System.out.println("Rule R2 is fired count - " + cc.getValue());
        Assert.assertEquals((String)"Rule 2 should be fired once as we have firing rule as one of criteria checking rule only fire once", (long)1L, (long)cc.getValue());
    }

    @Test
    public void testClassAccumulator() {
        String drl = "global java.util.List list\ndeclare InitClass\n  clazz: Class\nend\n\nrule \"init\" when\nthen\n  insert( new InitClass( String.class ) );\n  insert( new InitClass( Integer.class ) );\nend\n\nrule \"make init classes\"\nwhen\n  accumulate( InitClass( $clazz; ), $classes: collectList( $clazz ) )\nthen\n  list.addAll($classes);\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println(list);
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(String.class, Integer.class)));
    }

    @Test
    public void testSubnetworkAccumulate() {
        String drl = "import " + StringWrapper.class.getCanonicalName() + ";\nglobal StringBuilder sb;rule R when\n  $s : String()\n  Number( $i : intValue ) from accumulate ($sw : StringWrapper( $value : value )                                        and eval( $sw.contains($s) ),                                  sum($value) )\nthen\n  sb.append($i);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        StringBuilder sb = new StringBuilder();
        ksession.setGlobal("sb", (Object)sb);
        ksession.insert((Object)"test");
        StringWrapper sw = new StringWrapper();
        FactHandle swFH = ksession.insert((Object)sw);
        ksession.fireAllRules();
        sw.setWrapped("test");
        ksession.update(swFH, (Object)sw);
        ksession.fireAllRules();
        sw.setWrapped(null);
        ksession.update(swFH, (Object)sw);
        ksession.fireAllRules();
        sw.setWrapped("test");
        ksession.update(swFH, (Object)sw);
        ksession.fireAllRules();
        sw.setWrapped(null);
        ksession.update(swFH, (Object)sw);
        ksession.fireAllRules();
        sw.setWrapped("test");
        ksession.update(swFH, (Object)sw);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"040404", (Object)sb.toString());
    }

    @Test
    public void testImportInner() throws Exception {
        String drl = "package org.drools.test; import " + Misc2Test.class.getName() + "; declare Foo    bar : Misc2Test.AA end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testAlphaIndexing() throws Exception {
        String drl = "    package org.drools.test;     declare ObjectB        name : String        intValue : Integer     end     rule 'insert object'        when        then            insert( new ObjectB( null, 0 ) );     end     rule 'rule 1'        when            ObjectB( intValue == 1 )        then     end     rule 'rule 2'        when            ObjectB( intValue == 2 )        then     end     rule 'rule 3'        when            $b : ObjectB( intValue == null )        then\n           System.out.println( $b );     end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        Assert.assertEquals((long)1L, (long)ks.fireAllRules());
    }

    @Test
    public void testMvelConstraintErrorMessageOnAlpha() throws Exception {
        String drl = " import org.drools.mvel.compiler.Person;  import org.drools.mvel.compiler.Address;  rule 'hello person'  when  Person( address.street == 'abbey' )  then  end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        Person john = new Person("John");
        try {
            ks.insert((Object)john);
            ks.fireAllRules();
            Assert.fail((String)"Should throw an exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("hello person"));
        }
    }

    @Test
    public void testMvelConstraintErrorMessageOnBeta() throws Exception {
        String drl = " import org.drools.mvel.compiler.Person;  import org.drools.mvel.compiler.Address;  rule 'hello person'  when  $s : String( )  Person( address.street == $s )  then  end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        Person john = new Person("John");
        try {
            ks.insert((Object)"abbey");
            ks.insert((Object)john);
            ks.fireAllRules();
            Assert.fail((String)"Should throw an exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("hello person"));
        }
    }

    @Test
    public void testPassiveExists() {
        String drl2 = "import " + List.class.getCanonicalName() + ";\n\n\nrule \"NotExists\"\nwhen\n$l1: List() \n$l2: List() \nexists( String() from $l1 ) \nnot( exists( String() ) )\nthen end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession = kbase.newKieSession();
        ksession.insert(Arrays.asList("Mario", "Mark"));
        ksession.insert(Arrays.asList("Julie", "Leiti"));
        Assert.assertEquals((long)4L, (long)ksession.fireAllRules());
    }

    @Test
    public void testFromAfterOr() {
        String drl2 = "rule \"Disaster Rule\"\n    when\n        eval(true) or ( eval(false) and Integer() )\n        $a : Integer()\n        Integer() from $a\n    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)1);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testMalformedAccumulate() {
        String str = "rule R when\n    Number() from accumulate(not Number(),\n        init( double total = 0; ),\n        action( ),\n        reverse( ),\n        result( new Double( total ) )\n    )\nthen end\n";
        TestUtil.assertDrlHasCompilationError(str, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testDuplicateDeclarationInAccumulate1() {
        String drl1 = "import java.util.*\nrule \"Version 1 - crash\"\n when\n accumulate( Integer($int: intValue), $list: collectSet($int) )\n List() from collect( Integer($list not contains intValue) )\n\n accumulate( Integer($int: intValue), $list: collectSet($int) )\n then\nend\n";
        TestUtil.assertDrlHasCompilationError(drl1, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testDuplicateDeclarationInAccumulate2() {
        String drl1 = "import java.util.*\nrule \"Version 2 - pass\"\nwhen\n $list: List() from collect( Integer() )\n\n accumulate( Integer($int: intValue), $list: collectSet($int) )\n List() from collect( Integer($list not contains intValue) )\nthen\nend;\n";
        TestUtil.assertDrlHasCompilationError(drl1, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testCompilationFailureOnNonExistingVariable() {
        String drl1 = "import java.util.*\nrule R\nwhen\n  String(this after $event)\nthen\nend;\n";
        TestUtil.assertDrlHasCompilationError(drl1, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testJittedConstraintStringAndLong() {
        String drl = " import org.drools.mvel.compiler.Person;  rule 'hello person'  when  Person( name == \"Elizabeth\" + new Long(2L) )  then  end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Elizabeth2", 88));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testKieBuilderWithClassLoader() {
        String drl = "import com.billasurf.Person\n\nglobal java.util.List list\n\nrule R1 when\n    $i : Integer()\nthen\n    Person p = new Person();\n    p.setAge($i);\n    insert(p);\nend\n\nrule R2 when\n    $p : Person()\nthen\n    list.add($p.getAge());\nend\n";
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.getClass().getResource("/billasurf.jar")});
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromDrlWithClassLoaderForKieBuilder((String)"test", (ClassLoader)urlClassLoader, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)18);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)18L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testInsertAndDelete() {
        String drl = "global java.util.List list\n\nrule R when\n    $i : Integer()\n    $s : String()\nthen\n    delete($i);\n    list.add($s);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)"a");
        ksession.insert((Object)"b");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testClearActivationGroupCommand() {
        String drl = "package org.kie.test\nglobal java.util.List list\nrule \"Rule in first agenda group\" @Propagation(IMMEDIATE)\nagenda-group \"first-agenda\"\nsalience 10\nwhen\nthen\nlist.add(\"Rule in first agenda group executed\");\nend\nrule \"Rule without agenda group\" @Propagation(IMMEDIATE)\nsalience 100\nwhen\nthen\nlist.add(\"Rule without agenda group executed\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", new ArrayList());
        ksession.getAgenda().getAgendaGroup("first-agenda").setFocus();
        ksession.getAgenda().getAgendaGroup("first-agenda").clear();
        ksession.fireAllRules();
        ArrayList list = (ArrayList)ksession.getGlobal("list");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Rule without agenda group executed", list.get(0));
    }

    @Test
    public void testClearActivationGroupCommandNoImmediatePropagation() {
        String drl = "package org.kie.test\nglobal java.util.List list\nrule \"Rule in first agenda group\"\nagenda-group \"first-agenda\"\nsalience 10\nwhen\nthen\nlist.add(\"Rule in first agenda group executed\");\nend\nrule \"Rule without agenda group\"\nsalience 100\nwhen\nthen\nlist.add(\"Rule without agenda group executed\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", new ArrayList());
        ksession.getAgenda().getAgendaGroup("first-agenda").setFocus();
        ksession.getAgenda().getAgendaGroup("first-agenda").clear();
        ksession.fireAllRules();
        ArrayList list = (ArrayList)ksession.getGlobal("list");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Rule without agenda group executed", list.get(0));
    }

    @Test
    public void testDoubleNestedClass() {
        String drl = "import " + $X$$Y.class.getCanonicalName() + ";\nglobal java.util.List list\nrule R when\n    $X.$Y($v : value)\nthen\n    list.add($v);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new $X$$Y(42));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)42, list.get(0));
    }

    @Test
    public void testWrongNodeSharing() {
        String drl1 = "package test1\nimport static " + Misc2Test.class.getCanonicalName() + ".parseInt;\nglobal java.util.List list;\nrule R when\n    String( parseInt(this) == 0 )\nthen\n    list.add(\"OK\");\nend";
        String drl2 = "package test2\nimport static java.lang.Integer.parseInt;\nglobal java.util.List list;\nrule R when\n    String( parseInt(this) == 0 )\nthen\n    list.add(\"NOT OK\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        KieSession kieSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        kieSession.insert((Object)"3");
        kieSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"OK", list.get(0));
    }

    public static int parseInt(String s) {
        return 0;
    }

    @Test
    public void testJittedConstraintComparisonWithIncompatibleObjects() {
        String drl = "package org.drools.mvel.integrationtests\nimport java.util.Map.Entry\nimport java.util.Map\nimport " + NonStringConstructorClass.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"FailOnNonStringConstructor\"\n    when \n        $map : Map()\n        $simpleTestObject : NonStringConstructorClass (something==\"simpleTestObject\")\n        Entry (\n            getKey() == $simpleTestObject\n        ) from $map.entrySet()\n    then\n        list.add(\"Fired\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList globalList = new ArrayList();
        ksession.setGlobal("list", globalList);
        NonStringConstructorClass simpleTestObject = new NonStringConstructorClass();
        simpleTestObject.setSomething("simpleTestObject");
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("someOtherValue", "someOtherValue");
        map.put(simpleTestObject, "someValue");
        ArrayList list = new ArrayList();
        ksession.insert(map);
        ksession.insert((Object)simpleTestObject);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)globalList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFireUntilHaltWithForceEagerActivation() throws InterruptedException {
        String drl = "global java.util.List list\nrule \"String detector\"\n    when\n        $s : String( )\n    then\n        list.add($s);\nend";
        KieSessionConfiguration config = KieServices.Factory.get().newKieSessionConfiguration();
        config.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(config, null);
        final Integer monitor = 42;
        int factsNr = 5;
        NotifyingList list = new NotifyingList(factsNr, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Integer n = monitor;
                synchronized (n) {
                    monitor.notifyAll();
                }
            }
        });
        ksession.setGlobal("list", list);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> ((KieSession)ksession).fireUntilHalt());
        try {
            for (int i = 0; i < factsNr; ++i) {
                ksession.insert((Object)("" + i));
            }
            Integer n = monitor;
            synchronized (n) {
                if (list.size() < factsNr) {
                    monitor.wait();
                }
            }
            Assert.assertEquals((long)factsNr, (long)list.size());
        }
        finally {
            ksession.halt();
            ksession.dispose();
            executorService.shutdownNow();
        }
    }

    @Test
    public void testSkipHashingOfNestedProperties() {
        String drl = "import " + A1.class.getCanonicalName() + "\nglobal java.util.List list\nrule One when\n  A1(b.b1 == 1)\nthen\n  list.add(\"1\");\nend\n\nrule \"Two\" when\n  A1(b.b2 == 2)\nthen\n  list.add(\"2\");\nend\n\nrule \"Three\" when\n  A1(b.b3 == 3)\nthen\n  list.add(\"3\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new A1());
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("1", "2", "3")));
    }

    @Test
    public void testErrorReportWithWrongAccumulateFunction() {
        String drl = "import " + Cheese.class.getCanonicalName() + "\nrule R when\n  Cheese( $type : typo )\n  accumulate(\n    $c : Cheese( type == $type ),\n    $cheeses : collectList( $c ) );\nthen\nend\n";
        TestUtil.assertDrlHasCompilationError(drl, -1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testVariableMatchesField() throws Exception {
        String drl = "declare RegEx\n    pattern : String\nend\ndeclare Fact\n    field : String\nend\nrule \"Variable matches field\"\n    when\n        Fact( $field : field )\n        RegEx( $field matches pattern )\n    then\n        insert(\"Matched \" + $field);\nend\nrule \"Boot\"\n    when\n    then\n        insert( new RegEx(\"foo.*\") );\n        insert( new Fact(\"foobar\") );\n        insert( new Fact(\"bar\") );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testEndMethod() throws Exception {
        String drl = "import " + Pattern.class.getCanonicalName() + "\nimport " + Matcher.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"Variable matches field\" when\n    $emailAddress :String(this matches \"^.*[_A-Za-z0-9-\\\\+]+(\\\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\\\.[A-Za-z0-9]+)*(\\\\.[A-Za-z]{2,}).*$\")\nthen\n    Pattern pattern=Pattern.compile(\"[_A-Za-z0-9-\\\\+]+(\\\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\\\.[A-Za-z0-9]+)*(\\\\.[A-Za-z]{2,})\");\n    Matcher matcher=pattern.matcher($emailAddress);\n    while(matcher.find()){\n        list.add($emailAddress.substring(matcher.start(),matcher.end()));\n    }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"mario.fusco@test.org");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"mario.fusco@test.org", list.get(0));
    }

    @Test
    public void testDifferentClassesWithOR() throws Exception {
        String drl = "import " + ChildA.class.getCanonicalName() + "\nimport " + ChildB.class.getCanonicalName() + "\nrule R when\n    (\n    ChildA(value == null, $entity : this) or \n    ChildB(value == null, $entity : this)\n    )\nthen\n    modify( $entity ) { setValue(\"Done!\"); }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ChildA childA = new ChildA();
        ChildB childB = new ChildB();
        ksession.insert((Object)childA);
        ksession.insert((Object)childB);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"Done!", (Object)childA.getValue());
        Assert.assertEquals((Object)"Done!", (Object)childB.getValue());
    }

    @Test
    public void testJittingCollectionCreation() {
        String drl = "import " + Arrays.class.getCanonicalName() + "\nglobal java.util.List list\nrule R when\n    $s : String( Arrays.asList(\"a\", \"b\", \"c\").contains(this) )\nthen\n    list.add($s);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"a");
        ksession.insert((Object)"d");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"a", list.get(0));
    }

    @Test
    public void testJittingCollectionCreationInParenthesis() {
        String drl = "import " + Arrays.class.getCanonicalName() + "\nglobal java.util.List list\nrule R when\n    $s : String( (Arrays.asList(\"a\", \"b\", \"c\")).contains(this) )\nthen\n    list.add($s);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"a");
        ksession.insert((Object)"d");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"a", list.get(0));
    }

    @Test
    @Ignore
    public void testBetaMemoryLeakOnSegmentUnlinking() {
        String drl = "rule R1 when\n    $a : Integer(this == 1)\n    $b : String()\n    $c : Integer(this == 2)\n    $d : Integer(this == 3)\nthen \nend\nrule R2 when\n    $a : Integer(this == 1)\n    $b : String()\nthen \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        FactHandle fh1 = ksession.insert((Object)1);
        FactHandle fh2 = ksession.insert((Object)2);
        FactHandle fh3 = ksession.insert((Object)3);
        FactHandle fhtest = ksession.insert((Object)"test");
        ksession.fireAllRules();
        ksession.delete(fh3);
        ksession.fireAllRules();
        ksession.delete(fh1);
        ksession.delete(fh2);
        ksession.delete(fhtest);
        ksession.fireAllRules();
        NodeMemories nodeMemories = ((InternalWorkingMemory)ksession).getNodeMemories();
        for (int i = 0; i < nodeMemories.length(); ++i) {
            Memory memory = nodeMemories.peekNodeMemory(i);
            if (memory == null || memory.getSegmentMemory() == null) continue;
            SegmentMemory segmentMemory = memory.getSegmentMemory();
            System.out.println(memory);
            LeftTuple deleteFirst = (LeftTuple)memory.getSegmentMemory().getStagedLeftTuples().getDeleteFirst();
            System.out.println(deleteFirst);
            Assert.assertNull((Object)deleteFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFunctionInvokingFunction() throws Exception {
        String drl = "function boolean isOdd(int i) {\n    return i % 2 == 1;\n}\n\nfunction boolean isEven(int i) {\n    return !isOdd(i);\n}\n\nglobal java.util.List list;\n\nrule R when\n    $i : Integer( isEven( this ) ) \nthen\n    list.add($i);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"function boolean isOdd(int i) {\n    return i % 2 == 1;\n}\n\nfunction boolean isEven(int i) {\n    return !isOdd(i);\n}\n\nglobal java.util.List list;\n\nrule R when\n    $i : Integer( isEven( this ) ) \nthen\n    list.add($i);\nend\n"});
        int parallelThreads = 10;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            ArrayList<Callable<Boolean>> solvers = new ArrayList<Callable<Boolean>>();
            for (int i = 0; i < 10; ++i) {
                solvers.add(() -> {
                    KieSession ksession = kbase.newKieSession();
                    try {
                        ArrayList list = new ArrayList();
                        ksession.setGlobal("list", list);
                        for (int i1 = 0; i1 < 100; ++i1) {
                            ksession.insert((Object)i1);
                        }
                        ksession.fireAllRules();
                        Boolean bl = list.size() == 50;
                        return bl;
                    }
                    finally {
                        ksession.dispose();
                    }
                });
            }
            ExecutorCompletionService ecs = new ExecutorCompletionService(executor);
            for (Callable callable : solvers) {
                ecs.submit(callable);
            }
            for (int i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)((Boolean)ecs.take().get()));
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testCompilationFailureWithNonExistingField() {
        String drl = "rule R when\n  String( $var : lenght )\nthen\nend\n";
        TestUtil.assertDrlHasCompilationError(drl, 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testPatternMatchingWithFakeImplicitCast() {
        String drl = "rule R1 when\n    String( this == \"\\\"#\")\nthen \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"\"#");
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPatternMatchingWithFakeNullSafe() {
        String drl = "rule R1 when\n    String( this == \"\\\"!.\")\nthen \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"\"!.");
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testLambdaInRHS() {
        this.checkJava8InRhs("i -> list.add(i)");
    }

    @Test
    public void testMethodReferenceInRHS() {
        this.checkJava8InRhs("list::add");
    }

    private void checkJava8InRhs(String expr) {
        Assume.assumeTrue((boolean)System.getProperty("java.version").startsWith("1.8"));
        String drl = "global java.util.List list;\nrule \"Example with Lambda expression\"\n    when\n    then\n        java.util.List<Integer> $list = java.util.Arrays.asList(1, 2, 3, 4);\n        $list.forEach(" + expr + ");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    public void testCompareToOnInterface() {
        String drl = "import " + StringWrapper.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n    $s1 : StringWrapper()\n    $s2 : StringWrapper( this > $s1 )\nthen\n    list.add($s2.getWrapped());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new StringWrapper("aaa"));
        ksession.insert((Object)new StringWrapper("bbb"));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"bbb", list.get(0));
    }

    @Test
    public void testFromEPDontRequireLeftInput() {
        String drl = "rule R when\n    $s1 : String() from entry-point \"xxx\"\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Rete rete = ((RuleBase)kbase).getRete();
        Object liaNode = null;
        for (ObjectTypeNode otn : rete.getObjectTypeNodes()) {
            Class otnType = ((ClassObjectType)otn.getObjectType()).getClassType();
            if (String.class == otnType) {
                Assert.assertEquals((long)1L, (long)otn.getObjectSinkPropagator().size());
                continue;
            }
            if (InitialFact.class.isAssignableFrom(otnType)) {
                Assert.assertEquals((long)0L, (long)otn.getObjectSinkPropagator().size());
                continue;
            }
            Assert.fail((String)"There shouldn't be other OTNs");
        }
    }

    @Test
    public void testIn() {
        String drl = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n    $p : Person( name == null || (name in (\"Alice\", \"Charlie\", \"David\"))==false )\nthen\n    list.add($p.getName());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("Bob"));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Bob", list.get(0));
    }

    @Test
    public void testNonSerializableInEvaluatorWrapper() throws Exception {
        String str = "package org.drools.mvel.compiler\nrule B\n  when\n    $m1 : Message( $message1 : message, $date1 : birthday )\n    $m2 : Message( this != $m1, message != $message1, birthday after $date1 )\n  then\nend";
        KieServices ks = KieServices.Factory.get();
        KieBuilder kbuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
        KieSession ksession1 = ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).newKieSession();
        Message message1 = new Message();
        message1.setMessage("Hello World");
        message1.setBirthday(new SimpleDateFormat("yyyy-MM-dd").parse("2015-12-15"));
        Message message2 = new Message();
        message2.setMessage("Goodbye World");
        message2.setBirthday(new SimpleDateFormat("yyyy-MM-dd").parse("2015-12-16"));
        ksession1.insert((Object)message1);
        ksession1.insert((Object)message2);
        int fired1 = ksession1.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired1);
        ksession1.dispose();
        KieSession ksession2 = ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).newKieSession();
        Message message3 = new Message();
        message3.setMessage("Hello World");
        message3.setBirthday(new SimpleDateFormat("yyyy-MM-dd").parse("2015-12-15"));
        Message message4 = new Message();
        message4.setMessage("Goodbye World");
        message4.setBirthday(new SimpleDateFormat("yyyy-MM-dd").parse("2015-12-16"));
        ksession2.insert((Object)message3);
        ksession2.insert((Object)message4);
        int fired2 = ksession2.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired2);
        ksession2.dispose();
    }

    @Test
    public void testWrongNodeSharingWithSameHashCode() throws IllegalAccessException, InstantiationException {
        String drl = "import " + Person.class.getCanonicalName() + ";\nrule R1 when\n    String()\n    $p: Person( name == \"ATL\", name != null)\nthen \n    $p.setHappy(true);\nend\nrule R2 when\n    String()\n    $p: Person( name == \"B5L\", name != null)\nthen \n    $p.setHappy(true);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)"test");
        Person b5L = new Person("B5L");
        kieSession.insert((Object)b5L);
        Assert.assertFalse((boolean)b5L.isHappy());
        kieSession.fireAllRules();
        Assert.assertTrue((boolean)b5L.isHappy());
    }

    @Test
    public void testWrongVariableNameWithSameDeclarationName() {
        String str = "declare Parameter end\nrule R when\n    Parameter($b : $b == 0 )\nthen\nend\n";
        TestUtil.assertDrlHasCompilationError(str, -1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testComplexEvals() {
        String drl = "rule R1 when\n    $s : String()\n    Integer()\n    not( ( eval($s.length() < 2) and (eval(true) or eval(false))))\nthen \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)42);
        kieSession.insert((Object)"test");
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testComplexEvals2() {
        String drl = "rule R1 when\n    $s : String()\n    Boolean()\n    $i : Integer()    and (eval($s.length() > 2)\n        or (eval(true) and eval(true)))\n    and (eval(true)\n         or ( eval($i > 2) and (eval(true))))\n\nthen \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)42);
        kieSession.insert((Object)"test");
        kieSession.insert((Object)true);
        Assert.assertEquals((long)4L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testDeletedRightTupleInChangedBucket() {
        String drl = "import " + Person.class.getCanonicalName() + "\nrule R when\n    Person( $name: name, $age: age )\n    not Person( happy, name == $name, age == $age-1 )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        Person p1 = new Person("C", 1, true);
        Person p2 = new Person("B", 1, true);
        Person p3 = new Person("B", 2, true);
        Person p4 = new Person("A", 2);
        FactHandle fh1 = kieSession.insert((Object)p1);
        FactHandle fh2 = kieSession.insert((Object)p2);
        FactHandle fh3 = kieSession.insert((Object)p3);
        FactHandle fh4 = kieSession.insert((Object)p4);
        kieSession.fireAllRules();
        p4.setName("B");
        p4.setHappy(true);
        kieSession.update(fh4, (Object)p4);
        kieSession.fireAllRules();
        p3.setName("A");
        p3.setHappy(false);
        kieSession.update(fh3, (Object)p3);
        p1.setName("B");
        kieSession.update(fh1, (Object)p1);
        p2.setName("C");
        kieSession.update(fh2, (Object)p2);
        kieSession.fireAllRules();
    }

    @Test
    public void testJittingFunctionReturningAnInnerClass() {
        String drl = "import " + Function.class.getCanonicalName() + "\nfunction Function<String, Integer> f() {\n    return new Function<String, Integer>() {\n        public Integer apply(String s) {\n            return s.length();\n        }\n    };\n}\n\nrule R when\n    $s : String( f().apply(this) > 3 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)"test");
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testQueryWithEnum() {
        String drl = "import " + AnswerGiver.class.getCanonicalName() + "\nimport " + Answer.class.getCanonicalName() + "\n\ndeclare TestThing end\n\nquery TestQuery(Answer enumVal)\n  AnswerGiver( answer == enumVal )\nend\n\nquery MyQuery()\n  TestQuery(Answer.NO;)\nend\n\nrule R when MyQuery() then end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)new AnswerGiver());
        Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testOrQueryWithEnum() {
        String drl = "import " + AnswerGiver.class.getCanonicalName() + "\nimport " + Answer.class.getCanonicalName() + "\n\ndeclare TestThing end\n\nquery TestQuery(Answer enumVal)\n  AnswerGiver( answer == enumVal )\nend\n\nquery ORQuery()\n  (\n    TestQuery(Answer.YES;)\n  ) or (\n    TestQuery(Answer.YES;)\n  )\nend\n\nrule R when ORQuery() then end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)new AnswerGiver());
        Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testModifyWithOr() {
        String drl = "import " + List.class.getCanonicalName() + "\nimport " + AtomicBoolean.class.getCanonicalName() + "\n\nrule R when\n  $l : List()\n  ( String() from $l\n  or\n  String() from $l )\n  $b : AtomicBoolean( get() )\nthen  modify($b) { set(false) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert(Arrays.asList("test"));
        kieSession.insert((Object)new AtomicBoolean(true));
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testNormalizeRuleName() {
        String drl = "rule \"rule\uff08hello\uff09\" when\n  Integer()\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)1);
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testWiringClassOnPackageMerge() throws Exception {
        String drl_init = "package init;\nimport org.kie.test.TestObject\nrule RInit when\nthen\n    TestObject obj1 = new TestObject();\n    TestObject obj2 = new TestObject();    obj1.add(obj2);    insert(obj1);\nend";
        String drl1 = "package p1;\nimport org.kie.test.TestObject\nglobal java.util.List list;\nrule R1 when\n    $obj : TestObject( $objs : objects )\n    $s : Object() from $objs\nthen\n    list.add(\"R1\");\nend";
        String drl2 = "package p2;\nimport org.kie.test.TestObject\nglobal java.util.List list;\nrule R2 when\n    $obj : TestObject( $objs : objects )\n    $s : TestObject() from $objs\nthen\n    list.add(\"R2\");\nend";
        String javaSrc = "package org.kie.test;\nimport java.util.*;\n\npublic class TestObject {\n    private final List<TestObject> objects = new ArrayList<TestObject>();\n\n    public List<TestObject> getObjects() {\n        return objects;\n    }\n    public void add(TestObject obj) {\n        objects.add(obj);    }}\n";
        String path = "org/kie/test/MyRuleUnit";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(ks.newKieModuleModel().toXML()).write("src/main/resources/a.drl", drl_init).write("src/main/resources/b.drl", drl1).write("src/main/resources/c.drl", drl2).write("src/main/java/org/kie/test/TestObject.java", javaSrc);
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs);
        KieContainer kcontainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        KieSession kSession = kcontainer.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("R1"));
        Assert.assertTrue((boolean)list.contains("R2"));
    }

    @Test
    public void testReorderRightMemoryOnIndexedField() {
        String rule = "import " + Seat.class.getCanonicalName() + ";\n\nrule twoSameJobTypePerTable when\n    $job: String()\n    $table : Long()\n    not (\n        Seat( guestJob == $job, table == $table, $leftId : id )\n        and Seat( guestJob == $job, table == $table, id > $leftId )\n    )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession kieSession = kbase.newKieSession();
        String doctor = "D";
        String politician = "P";
        Long table1 = 1L;
        Long table2 = 2L;
        Seat seat0 = new Seat(0, politician, table2);
        Seat seat1 = new Seat(1, politician, null);
        Seat seat2 = new Seat(2, politician, table2);
        Seat seat3 = new Seat(3, doctor, table1);
        Seat seat4 = new Seat(4, doctor, table1);
        kieSession.insert((Object)seat0);
        FactHandle fh1 = kieSession.insert((Object)seat1);
        FactHandle fh2 = kieSession.insert((Object)seat2);
        FactHandle fh3 = kieSession.insert((Object)seat3);
        kieSession.insert((Object)seat4);
        kieSession.insert((Object)politician);
        kieSession.insert((Object)doctor);
        kieSession.insert((Object)table1);
        kieSession.insert((Object)table2);
        Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
        kieSession.update(fh3, (Object)seat3);
        kieSession.update(fh2, (Object)seat2.setTable(null));
        kieSession.update(fh1, (Object)seat1.setTable(table2));
        Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testChildLeftTuplesIterationOnLeftUpdate() {
        String drl = "import " + Shift.class.getCanonicalName() + "\nrule R when\n    Shift( $end1: end, $employee: employee )\n    Shift( employee == $employee, start > $end1 )\n    not Shift( employee == $employee, start > $end1 )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        String o = "o";
        String x = "x";
        Shift shift1 = new Shift(10, 11, o);
        Shift shift2 = new Shift(20, 21, o);
        Shift shift3 = new Shift(30, 31, x);
        Shift shift4 = new Shift(40, 41, o);
        Shift shift5 = new Shift(50, 51, o);
        Shift shift6 = new Shift(60, 61, o);
        Shift shift7 = new Shift(70, 71, o);
        Shift shift8 = new Shift(80, 81, o);
        FactHandle fh1 = kieSession.insert((Object)shift1);
        FactHandle fh2 = kieSession.insert((Object)shift2);
        FactHandle fh3 = kieSession.insert((Object)shift3);
        FactHandle fh4 = kieSession.insert((Object)shift4);
        FactHandle fh5 = kieSession.insert((Object)shift5);
        FactHandle fh6 = kieSession.insert((Object)shift6);
        FactHandle fh7 = kieSession.insert((Object)shift7);
        FactHandle fh8 = kieSession.insert((Object)shift8);
        Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
        kieSession.update(fh1, (Object)shift1.setEmployee(x));
        kieSession.update(fh4, (Object)shift4);
        kieSession.update(fh8, (Object)shift8);
        kieSession.update(fh5, (Object)shift5.setEmployee(x));
        kieSession.update(fh7, (Object)shift7);
        kieSession.update(fh2, (Object)shift2.setEmployee(x));
        kieSession.update(fh6, (Object)shift6);
        kieSession.update(fh3, (Object)shift3.setEmployee(o));
        Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
        kieSession.update(fh8, (Object)shift8.setEmployee(x));
        kieSession.update(fh4, (Object)shift4.setEmployee(x));
        kieSession.update(fh7, (Object)shift7.setEmployee(x));
        kieSession.update(fh6, (Object)shift6.setEmployee(x));
        Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
    }

    @Test
    public void test1187() {
        String drl = "import " + Shift1187.class.getCanonicalName() + "\nrule insertEmployeeConsecutiveWeekendAssignmentStart when\n    Shift1187(\n        weekend == true,\n        $employee : employee, employee != null,\n        $week : week\n    )\n    // The first working weekend has no working weekend before it\n    not Shift1187(\n        weekend == true,\n        employee == $employee,\n        week == ($week - 1)\n    )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        Shift1187 shift1 = new Shift1187(0, 4);
        Shift1187 shift2 = new Shift1187(1, 5);
        Shift1187 shift3 = new Shift1187(2, 6);
        Shift1187 shift4 = new Shift1187(2, 6);
        Shift1187 shift5 = new Shift1187(2, 0);
        Shift1187 shift6 = new Shift1187(3, 0);
        String employeeA = "Sarah";
        String employeeB = "Susan";
        String employeeC = "Fred";
        shift4.setEmployee(employeeB);
        shift5.setEmployee(employeeA);
        FactHandle fh1 = kieSession.insert((Object)shift1);
        FactHandle fh2 = kieSession.insert((Object)shift2);
        FactHandle fh3 = kieSession.insert((Object)shift3);
        FactHandle fh4 = kieSession.insert((Object)shift4);
        FactHandle fh5 = kieSession.insert((Object)shift5);
        FactHandle fh6 = kieSession.insert((Object)shift6);
        Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
        kieSession.update(fh6, (Object)shift6.setEmployee(employeeA));
        kieSession.update(fh1, (Object)shift1.setEmployee(employeeA));
        kieSession.update(fh2, (Object)shift2.setEmployee(employeeC));
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        kieSession.update(fh4, (Object)shift4.setEmployee(employeeB));
        kieSession.update(fh3, (Object)shift3.setEmployee(employeeB));
        kieSession.update(fh5, (Object)shift5.setEmployee(employeeB));
        kieSession.update(fh2, (Object)shift2.setEmployee(employeeA));
        kieSession.update(fh4, (Object)shift4.setEmployee(employeeA));
        kieSession.fireAllRules();
    }

    @Test
    public void testReportFailingConstraintOnError() {
        String drl = "import " + Person.class.getCanonicalName() + "\nrule R when\n    Person( name.startsWith(\"A\") )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        for (int i = 0; i < 100; ++i) {
            kieSession.insert((Object)new Person("A" + i));
        }
        kieSession.fireAllRules();
        kieSession.insert((Object)new Person(null));
        try {
            kieSession.fireAllRules();
            Assert.fail((String)"Evaluation with null must throw a NPE");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("name.startsWith(\"A\")"));
        }
    }

    @Test
    public void testNpeInLessThanComparison() {
        String drl = "package com.sample\nimport " + TestObject.class.getCanonicalName() + ";\nglobal java.util.List list\nrule LessThanCompare when\n    TestObject( $value : value )    TestObject( value < $value )then\n    list.add(drools.getRule().getName() + \":\" + $value);\nend\n\nrule GreaterThanCompare when\n    TestObject( $value : value )\n    TestObject( $value > value )\nthen\n    list.add(drools.getRule().getName() + \":\" + $value);\nend\n\nrule NotLessThanCompare when\n    TestObject( $value : value )    not ( TestObject( value < $value ) )then\n    list.add(drools.getRule().getName() + \":\" + $value);\nend\n\nrule NotGreaterThanCompare when\n    TestObject( $value : value )\n    not ( TestObject( $value > value ) )\nthen\n    list.add(drools.getRule().getName() + \":\" + $value);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.insert((Object)new TestObject(null));
        kSession.insert((Object)new TestObject(5));
        kSession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("NotLessThanCompare:5"));
        Assert.assertTrue((boolean)list.contains("NotLessThanCompare:null"));
        Assert.assertTrue((boolean)list.contains("NotGreaterThanCompare:5"));
        Assert.assertTrue((boolean)list.contains("NotGreaterThanCompare:null"));
        Assert.assertFalse((boolean)list.contains("LessThanCompare:5"));
        Assert.assertFalse((boolean)list.contains("LessThanCompare:null"));
        Assert.assertFalse((boolean)list.contains("GreaterThanCompare:5"));
        Assert.assertFalse((boolean)list.contains("GreaterThanCompare:null"));
    }

    @Test
    public void testUnderscoreDoubleMultiplicationCastedToInt() {
        String str = "import " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list\nrule R when\n  Cheese( $p : price)\nthen\n  int b = (int) ($p * 1_000.0);\n  list.add(\"\" + b);end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("gauda", 42));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"42000", list.get(0));
    }

    @Ignore(value="This test deliberately creates a deadlock, failing the test with a timeout.\nHelpful to test thread dump when a timeout occur on the JUnit listener.\nSee org.kie.test.util.TestStatusListener#testFailure()")
    @Test(timeout=5000L)
    public void testDeadlock() {
        Long lock1 = 1L;
        Long lock2 = 2L;
        Runnable task1 = () -> {
            Object object = lock1;
            synchronized (object) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object2 = lock2;
                synchronized (object2) {
                }
            }
        };
        Runnable task2 = () -> {
            Object object = lock2;
            synchronized (object) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object2 = lock1;
                synchronized (object2) {
                }
            }
        };
        new Thread(task1).start();
        task2.run();
    }

    @Test
    public void test01841522() {
        String str = "package com.sample\nimport " + ElementOperation.class.getCanonicalName() + ";\nimport " + AbstractElement.class.getCanonicalName() + ";\nimport " + MyInterface.class.getCanonicalName() + ";\nglobal java.util.List list\nrule R when\n  ElementOperation( $e : element )      \n  $my: MyInterface( ) from $e           \nthen\n  list.add(\"\" );end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new ElementOperation(new MyElement()));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    @Ignore(value="This test is supposed to cause a StackOverflow inside mvel but this not always happens")
    public void testStackOverflowInMvel() {
        String str1 = "import " + Person.class.getName() + ";\nrule R1 when\n $p : Person( ";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            sb.append("name == \"John-" + i + "\" || ");
        }
        String str2 = " age == 20 )\nthen end\n";
        String drl = str1 + sb.toString() + str2;
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.getErrors().toString().contains("StackOverflowError"));
    }

    @Test
    public void testMergeMVELDialect() {
        String drl1 = "package com.sample\nimport org.drools.mvel.compiler.*;\nrule rule1 \n    when\n        (PersonHolder($addresses : person.addresses))\n            &&\n        (Address (street == \"AAA\") from $addresses)\n    then\nend";
        Collection knowledgePackages1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1}).getKiePackages();
        String drl2 = "package com.sample\nimport org.drools.mvel.compiler.*;\nrule rule2 \n    when\n        PersonHolder()\n    then\nend";
        Collection knowledgePackages2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2}).getKiePackages();
        InternalKnowledgeBase kbase1 = KnowledgeBaseFactory.newKnowledgeBase();
        ArrayList combinedPackages1 = new ArrayList();
        combinedPackages1.addAll(knowledgePackages1);
        combinedPackages1.addAll(knowledgePackages2);
        kbase1.addPackages(combinedPackages1);
        InternalKnowledgeBase kbase2 = KnowledgeBaseFactory.newKnowledgeBase();
        ArrayList combinedPackages2 = new ArrayList();
        combinedPackages2.addAll(knowledgePackages1);
        combinedPackages2.addAll(knowledgePackages2);
        kbase2.addPackages(combinedPackages2);
        KieSession ksession = kbase2.newKieSession();
        PersonHolder personHolder = new PersonHolder();
        Person person = new Person("John");
        Address address = new Address("AAA", "BBB", "111");
        person.addAddress(address);
        personHolder.setPerson(person);
        ksession.insert((Object)personHolder);
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)fired);
    }

    @Test
    public void testCollectWithEagerActivation() {
        String drl = "import java.util.ArrayList\nimport " + FactWithList.class.getCanonicalName() + "\nimport " + FactWithString.class.getCanonicalName() + "\n\ndialect \"mvel\"\nglobal java.util.List list; \n\n rule \"Init\"\n when\n     $fl: FactWithList(items.size()==0)\n then\n     $fl.getItems().add(\"A\");\n     $fl.getItems().add(\"B\");\n     update($fl);\n end\n\n rule \"R1\"\n when\n     $fl: FactWithList($itemList : items)\n     $l: java.util.List(size > 0) from collect(FactWithString($itemList contains stringValue));\n then\n      list.add(\"R1\"); \n end\n\n rule \"R2\"\n when\n     $fl: FactWithList($itemList : items)\n     not( FactWithString($itemList contains stringValue) )\n then\n      list.add(\"R2\"); \n end";
        KieSessionConfiguration config = KieServices.Factory.get().newKieSessionConfiguration(null);
        config.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(config, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new FactWithString("A"));
        ksession.insert((Object)new FactWithList());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("R1"));
    }

    @Test
    public void testModifyAddToList() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule addAddress\ndialect \"mvel\"\nwhen\n  $p : Person()\n  not(Address(street==\"Main Street\") from $p.addresses)then\n    Address address = new Address(\"Main Street\");\n    modify($p) { addresses.add(address) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person martin = new Person("Martin");
        ksession.insert((Object)martin);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)martin.getAddresses().size());
    }

    @Test
    public void testKieHelperReleaseId() throws Exception {
        String drl = "rule R when\n    $s: String()then\nend";
        ReleaseId releaseId = KieServices.get().newReleaseId("org.sample", "test", "1.0.0");
        KieContainer kieContainer = new KieHelper().addContent(drl, ResourceType.DRL).setReleaseId(releaseId).getKieContainer(null);
        Assert.assertEquals((Object)releaseId, (Object)kieContainer.getReleaseId());
        KieSession ksession = kieContainer.newKieSession();
        ksession.insert((Object)"Hello");
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testKieHelperKieModuleModel() throws Exception {
        String drl = "import " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    $alice : Person(name == \"Alice\")\n    $bob : Person(name == \"Bob\", addresses supersetOf $alice.addresses)\nthen\nend\n";
        KieModuleModel kModuleModel = KieServices.get().newKieModuleModel();
        kModuleModel.setConfigurationProperty("drools.evaluator.supersetOf", CustomOperatorTest.SupersetOfEvaluatorDefinition.class.getName());
        KieHelper kHelper = new KieHelper();
        Results results = kHelper.setKieModuleModel(kModuleModel).addContent(drl, ResourceType.DRL).verify();
        List errors = results.getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    public static class MyElement
    extends AbstractElement
    implements MyInterface {
        @Override
        public void nothing() {
        }
    }

    public static interface MyInterface {
        public void nothing();
    }

    public static abstract class AbstractElement {
    }

    public static class ElementOperation {
        private AbstractElement element;

        public ElementOperation(AbstractElement element) {
            this.element = element;
        }

        public AbstractElement getElement() {
            return this.element;
        }
    }

    public static class TestObject {
        private final Integer value;

        public TestObject(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }

    public class Shift1187 {
        private final int week;
        private final int dayOfWeek;
        private String employee;

        public Shift1187(int week, int dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.week = week;
        }

        public String getEmployee() {
            return this.employee;
        }

        public Shift1187 setEmployee(String employee) {
            this.employee = employee;
            return this;
        }

        public int getWeek() {
            return this.week;
        }

        public boolean isWeekend() {
            if (this.employee == null) {
                return false;
            }
            return this.dayOfWeek == 6 || this.dayOfWeek == 0 || this.dayOfWeek == 5 && this.hasWeekendOnFriday(this.employee);
        }

        private boolean hasWeekendOnFriday(String employee) {
            return employee.startsWith("F");
        }
    }

    public static class Shift {
        private final int start;
        private final int end;
        private String employee;

        public Shift(int start, int end, String employee) {
            this.start = start;
            this.end = end;
            this.employee = employee;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getEmployee() {
            return this.employee;
        }

        public Shift setEmployee(String employee) {
            this.employee = employee;
            return this;
        }

        public String toString() {
            return "Shift " + this.employee + " from " + this.start + " to " + this.end;
        }
    }

    public static class Seat {
        private final int id;
        private final String guestJob;
        private Long table;

        public Seat(int id, String guestJob, Long table) {
            this.id = id;
            this.guestJob = guestJob;
            this.table = table;
        }

        public String getGuestJob() {
            return this.guestJob;
        }

        public int getId() {
            return this.id;
        }

        public Long getTable() {
            return this.table;
        }

        public Seat setTable(Long table) {
            this.table = table;
            return this;
        }
    }

    public static class ChildB
    extends Parent {
    }

    public static class ChildA
    extends Parent {
    }

    public static class Parent {
        public String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class B1 {
        public int b1 = 1;
        public int b2 = 2;
        public int b3 = 3;
    }

    public class A1 {
        public B1 b;

        public A1() {
            this.b = new B1();
        }
    }

    public static class NotifyingList<T>
    extends ArrayList<T> {
        private final int limit;
        private final Runnable listener;

        public NotifyingList(int limit, Runnable listener) {
            this.limit = limit;
            this.listener = listener;
        }

        @Override
        public boolean add(T t) {
            boolean result = super.add(t);
            if (this.size() == this.limit) {
                this.listener.run();
            }
            return result;
        }
    }

    public static class NonStringConstructorClass {
        private String something;

        public String getSomething() {
            return this.something;
        }

        public void setSomething(String something) {
            this.something = something;
        }

        public String toString() {
            return "NonStringConstructorClass [something=" + this.something + "]";
        }
    }

    public static class StringWrapper
    implements TestString<StringWrapper> {
        private String wrapped;

        public StringWrapper() {
        }

        public StringWrapper(String wrapped) {
            this.wrapped = wrapped;
        }

        public String getWrapped() {
            return this.wrapped;
        }

        public void setWrapped(String wrapped) {
            this.wrapped = wrapped;
        }

        public boolean contains(String s) {
            return this.wrapped != null && this.wrapped.equals(s);
        }

        public int getValue() {
            return this.wrapped != null ? this.wrapped.length() : 0;
        }

        @Override
        public int compareTo(TestString o) {
            return this.wrapped.compareTo(((StringWrapper)o).wrapped);
        }
    }

    public static interface TestString<T extends TestString>
    extends Comparable<TestString<?>> {
    }

    public static class TypeDD
    extends ValueContainer {
    }

    public static class TypeCC
    extends ValueContainer {
    }

    public static class ValueContainer {
        private int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class Underscore {
        private String _id;

        public String get_id() {
            return this._id;
        }

        public void set_id(String _id) {
            this._id = _id;
        }
    }

    public static class Z
    implements I1 {
        @Override
        public String getValue() {
            return "x";
        }
    }

    public static class Y
    extends X
    implements I1 {
    }

    public static class X
    implements I0 {
        @Override
        public String getValue() {
            return "x";
        }
    }

    public static interface I1
    extends I0 {
    }

    public static interface I0 {
        public String getValue();
    }

    public static class C3 {
        public final int value;

        public C3(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class C2 {
        private final List<C3> c3s = Arrays.asList(new C3(1), new C3(2));

        public List<C3> getC3s() {
            return this.c3s;
        }
    }

    public static class C1 {
        private int counter = 0;
        private final List<C2> c2s = Arrays.asList(new C2(), new C2());

        public List<C2> getC2s() {
            return this.c2s;
        }

        public int getSize() {
            return this.getC2s().size();
        }

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }
    }

    public static class Alarm {
        private String type;
        private String level;

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class Reading {
        private final String type;
        private final int value;

        public Reading(String type, int value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class TypeD {
        private int parentId = 2;
        private int value;

        public int getParentId() {
            return this.parentId;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class TypeC {
        private int parentId = 2;

        public int getParentId() {
            return this.parentId;
        }

        public int getValue() {
            return 1;
        }
    }

    public static class TypeB {
        private int parentId = 1;
        private int id = 2;

        public int getParentId() {
            return this.parentId;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class TypeA {
        private int id = 1;

        public int getId() {
            return this.id;
        }
    }

    public static class Host {
    }

    public static class Trailer {
        private TypeStatus status;

        public Trailer(TypeStatus status) {
            this.status = status;
        }

        public TypeStatus getStatus() {
            return this.status;
        }

        public void setStatus(TypeStatus status) {
            this.status = status;
        }

        public static enum TypeStatus {
            WAITING,
            LOADING,
            SHIPPING;

        }
    }

    public static class MyDate
    extends Date {
        private String description;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String desc) {
            this.description = desc;
        }
    }

    public static class Evaller {
        private final int size;

        public Evaller() {
            this(0);
        }

        public Evaller(int size) {
            this.size = size;
        }

        public boolean check(Object o) {
            return true;
        }

        public static boolean checkStatic(Object o) {
            return true;
        }

        public int size() {
            return this.size;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class EvallerBean {
        private final Evaller evaller = new Evaller(1);

        public Evaller getEvaller() {
            return this.evaller;
        }
    }

    public static class BRef
    extends ARef {
        public static int getSize(String s) {
            return s.length();
        }
    }

    public static class ARef {
        public static int getSize(String s) {
            return 0;
        }
    }

    public static class Strings {
        private final String[] strings;

        public Strings(String ... strings) {
            this.strings = strings;
        }

        public boolean containsAny(String[] array) {
            for (String candidate : array) {
                for (String s : this.strings) {
                    if (!candidate.equals(s)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean containsAll(String ... array) {
            int counter = 0;
            block0: for (String candidate : array) {
                for (String s : this.strings) {
                    if (!candidate.equals(s)) continue;
                    ++counter;
                    continue block0;
                }
            }
            return counter == array.length;
        }
    }

    public static class BB {
        public Integer getValue() {
            return 42;
        }
    }

    public static class AA {
        int id;

        public AA(int i) {
            this.id = i;
        }

        public boolean match(Long value) {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AA aa = (AA)o;
            return this.id == aa.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class SerializableValue {
        private final Serializable value;

        public SerializableValue(Serializable value) {
            this.value = value;
        }

        public Serializable getValue() {
            return this.value;
        }
    }

    public static class SimpleMessage {
        private final int index;
        private Status status = Status.ENRICHED;

        public SimpleMessage(int index) {
            this.index = index;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "SimpleMessage(" + this.index + "): " + (Object)((Object)this.status);
        }

        public static enum Status {
            ENRICHED,
            TO_SEND,
            SENT,
            FILTERED;

        }
    }

    public static class StepForwardCommand {
    }

    public static class ChangeDirectionCommand {
    }

    @PropertyReactive
    public static class Hero {
        private int pos = 1;
        private boolean goingRight = true;

        public Hero(int pos) {
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public boolean isGoingRight() {
            return this.goingRight;
        }

        public void setGoingRight(boolean goingRight) {
            this.goingRight = goingRight;
        }
    }

    public static class TradeBookingImpl
    implements TradeBooking {
        private TradeHeader header;

        public TradeBookingImpl(TradeHeader h) {
            this.header = h;
        }

        @Override
        public TradeHeader getTrade() {
            return this.header;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TradeBookingImpl that = (TradeBookingImpl)o;
            return !(this.header != null ? !this.header.equals(that.header) : that.header != null);
        }

        public int hashCode() {
            return this.header != null ? this.header.hashCode() : 0;
        }
    }

    public static class TradeHeaderImpl
    implements TradeHeader {
        private String action;

        @Override
        public String getAction() {
            return this.action;
        }

        @Override
        public void setAction(String action) {
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TradeHeaderImpl that = (TradeHeaderImpl)o;
            return !(this.action != null ? !this.action.equals(that.action) : that.action != null);
        }

        public int hashCode() {
            return this.action != null ? this.action.hashCode() : 0;
        }
    }

    public static interface TradeHeader {
        public void setAction(String var1);

        public String getAction();
    }

    public static interface TradeBooking {
        public TradeHeader getTrade();
    }

    public static class Foo3 {
        public boolean getX() {
            return true;
        }

        public String isX() {
            return "x";
        }

        public boolean isY() {
            return true;
        }

        public String getZ() {
            return "ok";
        }

        public boolean isZ() {
            return true;
        }
    }

    public static class SQLTimestamped {
        private Timestamp start = new Timestamp(new Date().getTime());

        public Timestamp getStart() {
            return this.start;
        }

        public void setStart(Timestamp start) {
            this.start = start;
        }
    }

    public static class Allocation {
        private final int executionMode;

        public Allocation(int executionMode) {
            this.executionMode = executionMode;
        }

        public int getExecutionMode() {
            return this.executionMode;
        }
    }

    public static class ResourceRequirement {
        private final Resource resource;
        private final int executionMode;

        public ResourceRequirement(Resource resource, int executionMode) {
            this.resource = resource;
            this.executionMode = executionMode;
        }

        public Resource getResource() {
            return this.resource;
        }

        public int getExecutionMode() {
            return this.executionMode;
        }
    }

    public static class Resource {
        private final int capacity;

        public Resource(int capacity) {
            this.capacity = capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }

    public static class Foo2 {
        @Position(value=0)
        public int x;

        public Foo2() {
        }

        public Foo2(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    public static class Foo {
        public int x;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    public static class Conversation {
        private final int id;
        private String family;
        private int timeslot;

        public Conversation(int id) {
            this.id = id;
        }

        public Conversation(int id, String family, int timeslot) {
            this.id = id;
            this.family = family;
            this.timeslot = timeslot;
        }

        public int getId() {
            return this.id;
        }

        public String getFamily() {
            return this.family;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        public int getTimeslot() {
            return this.timeslot;
        }

        public void setTimeslot(int timeslot) {
            this.timeslot = timeslot;
        }

        public String toString() {
            return "Conversation #" + this.getId() + " with " + this.getFamily() + " @ " + this.getTimeslot();
        }
    }

    public static class Lecture {
        private final String id;
        private int day;
        private int index;
        private boolean available;

        public Lecture(String id, int day, int index) {
            this(id, day, index, true);
        }

        public Lecture(String id, int day, int index, boolean available) {
            this.id = id;
            this.day = day;
            this.index = index;
            this.available = available;
        }

        public String getId() {
            return this.id;
        }

        public int getDay() {
            return this.day;
        }

        public Lecture setDay(int day) {
            this.day = day;
            return this;
        }

        public int getIndex() {
            return this.index;
        }

        public Lecture setIndex(int index) {
            this.index = index;
            return this;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public Lecture setAvailable(boolean available) {
            this.available = available;
            return this;
        }

        public String toString() {
            return this.id + " - day = " + this.getDay() + "; index = " + this.getIndex();
        }
    }

    public static class SimpleEvent {
        private long duration;

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }
    }

    public static class IntegerWrapperImpl2
    extends AbstractIntegerWrapper2 {
        private final int i;

        public IntegerWrapperImpl2(int i) {
            this.i = i;
        }

        @Override
        public int compareTo(IntegerWraper2 o) {
            return this.getInt() - o.getInt();
        }

        @Override
        public int getInt() {
            return this.i;
        }
    }

    public static abstract class AbstractIntegerWrapper2
    implements IntegerWraper2 {
    }

    static interface IntegerWraper2
    extends Comparable<IntegerWraper2> {
        public int getInt();
    }

    public static class ComparableInteger
    implements Comparable {
        private final int i;

        public ComparableInteger(int i) {
            this.i = i;
        }

        public int compareTo(Object o) {
            return this.getInt() - ((ComparableInteger)o).getInt();
        }

        public int getInt() {
            return this.i;
        }
    }

    public static class IntegerWrapperImpl
    extends AbstractIntegerWrapper {
        private final int i;

        public IntegerWrapperImpl(int i) {
            this.i = i;
        }

        @Override
        public int compareTo(IntegerWraper o) {
            return this.getInt() - o.getInt();
        }

        @Override
        public int getInt() {
            return this.i;
        }
    }

    public static abstract class AbstractIntegerWrapper
    implements IntegerWraper,
    Comparable<IntegerWraper> {
    }

    static interface IntegerWraper {
        public int getInt();
    }

    public static class Model {
        private BigDecimal cost;
        private BigDecimal price;

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }
    }

    public static class StaticPerson {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class AnswerGiver {
        public Answer getAnswer() {
            return Answer.YES;
        }
    }

    public static enum Answer {
        YES,
        NO;

    }

    public static class StringConcrete
    extends AbstractBase<String> {
        public StringConcrete() {
            this.foo = new String();
        }
    }

    public static abstract class AbstractBase<T> {
        protected T foo;

        public T getFoo() {
            return this.foo;
        }
    }

    @PropertyReactive
    public static class DataSample {
        private Map<Parameter, Double> values = new EnumMap<Parameter, Double>(Parameter.class);

        public Map<Parameter, Double> getValues() {
            return this.values;
        }

        public void setValues(Map<Parameter, Double> values) {
            this.values = values;
        }

        @Modifies(value={"values", "notEmpty"})
        public void addValue(Parameter p, double value) {
            this.values.put(p, value);
        }

        public boolean isNotEmpty() {
            return !this.values.isEmpty();
        }
    }

    public static enum Parameter {
        PARAM_A,
        PARAM_B;

    }

    @PropertyReactive
    public static class A {
        private int f1;
        private int f2;
        private int f3;
        private int f4;

        public A() {
        }

        public A(int f1) {
            this.f1 = f1;
        }

        public A(int f1, int f2, int f3, int f4) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = f4;
        }

        public int getF1() {
            return this.f1;
        }

        public void setF1(int f1) {
            this.f1 = f1;
        }

        public int getF2() {
            return this.f2;
        }

        public void setF2(int f2) {
            this.f2 = f2;
        }

        public int getF3() {
            return this.f3;
        }

        public void setF3(int f3) {
            this.f3 = f3;
        }

        public int getF4() {
            return this.f4;
        }

        public void setF4(int f4) {
            this.f4 = f4;
        }

        public String toString() {
            return "A[f1=" + this.f1 + ", f2=" + this.f2 + ", f3=" + this.f3 + ", f4=" + this.f4 + "]";
        }
    }
}

