/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.core.InitialFact;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TerminalNode;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.internal.conf.MultithreadEvaluationOption;

@RunWith(value=Parameterized.class)
public class NodesPartitioningTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NodesPartitioningTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void test2Partitions() {
        String drl = this.ruleA(1) + this.ruleB(2) + this.ruleC(2) + this.ruleD(1) + this.ruleD(2) + this.ruleC(1) + this.ruleA(2) + this.ruleB(1);
        this.checkDrl(drl);
    }

    @Test
    public void testPartitioningWithSharedNodes() {
        int i;
        StringBuilder sb = new StringBuilder(400);
        for (i = 1; i < 4; ++i) {
            sb.append(this.getRule(i));
        }
        for (i = 1; i < 4; ++i) {
            sb.append(this.getNotRule(i));
        }
        this.checkDrl(sb.toString());
    }

    private void checkDrl(String drl) {
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        Rete rete = kbase.getRete();
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            this.traverse((BaseNode)entryPointNode);
        }
    }

    private void traverse(BaseNode node) {
        this.checkNode((NetworkNode)node);
        Sink[] sinks = node.getSinks();
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (!(sink instanceof BaseNode)) continue;
                this.traverse((BaseNode)sink);
            }
        }
    }

    private void checkNode(NetworkNode node) {
        if (node instanceof EntryPointNode) {
            Assert.assertSame((Object)RuleBasePartitionId.MAIN_PARTITION, (Object)node.getPartitionId());
        } else if (node instanceof ObjectTypeNode) {
            Assert.assertSame((Object)RuleBasePartitionId.MAIN_PARTITION, (Object)node.getPartitionId());
            this.checkPartitionedSinks((ObjectTypeNode)node);
        } else if (node instanceof ObjectSource) {
            ObjectSource source = ((ObjectSource)node).getParentObjectSource();
            if (!(source instanceof ObjectTypeNode)) {
                Assert.assertSame((Object)source.getPartitionId(), (Object)node.getPartitionId());
            }
        } else if (node instanceof BetaNode) {
            ObjectSource rightInput = ((BetaNode)node).getRightInput();
            if (!(rightInput instanceof ObjectTypeNode)) {
                Assert.assertSame((Object)rightInput.getPartitionId(), (Object)node.getPartitionId());
            }
            LeftTupleSource leftInput = ((BetaNode)node).getLeftTupleSource();
            Assert.assertSame((Object)leftInput.getPartitionId(), (Object)node.getPartitionId());
        } else if (node instanceof TerminalNode) {
            LeftTupleSource leftInput = ((TerminalNode)node).getLeftTupleSource();
            Assert.assertSame((Object)leftInput.getPartitionId(), (Object)node.getPartitionId());
        }
    }

    private void checkPartitionedSinks(ObjectTypeNode otn) {
        ObjectSinkPropagator[] objectSinkPropagatorArray;
        if (InitialFact.class.isAssignableFrom(((ClassObjectType)otn.getObjectType()).getClassType())) {
            return;
        }
        ObjectSinkPropagator sinkPropagator = otn.getObjectSinkPropagator();
        if (sinkPropagator instanceof CompositePartitionAwareObjectSinkAdapter) {
            objectSinkPropagatorArray = ((CompositePartitionAwareObjectSinkAdapter)sinkPropagator).getPartitionedPropagators();
        } else {
            ObjectSinkPropagator[] objectSinkPropagatorArray2 = new ObjectSinkPropagator[1];
            objectSinkPropagatorArray = objectSinkPropagatorArray2;
            objectSinkPropagatorArray2[0] = sinkPropagator;
        }
        ObjectSinkPropagator[] propagators = objectSinkPropagatorArray;
        for (int i = 0; i < propagators.length; ++i) {
            for (ObjectSink sink : propagators[i].getSinks()) {
                Assert.assertEquals((String)(sink + " on " + sink.getPartitionId() + " is expcted to be on propagator " + i), (long)i, (long)(sink.getPartitionId().getId() % propagators.length));
            }
        }
    }

    private String ruleA(int i) {
        return "rule Ra" + i + " when\n    $i : Integer( this == " + i + " )\n    $s : String( length == $i )\n    Integer( this == $s.length )\nthen end\n";
    }

    private String ruleB(int i) {
        return "rule Rb" + i + " when\n    $i : Integer( this == " + i + " )\n    $s : String( this == $i.toString )\n    Integer( this == $s.length )\nthen end\n";
    }

    private String ruleC(int i) {
        return "rule Rc" + i + " when\n    $i : Integer( this == " + i + " )\n    $s : String( length == $i )\n    Integer( this == $i+1 )\nthen end\n";
    }

    private String ruleD(int i) {
        return "rule Rd" + i + " when\n    $i : Integer( this == " + i + " )\n    $s : String( length == $i )\nthen end\n";
    }

    private String getRule(int i) {
        return "rule R" + i + " when\n    $i : Integer( this == " + i + " )    String( this == $i.toString )\nthen end\n";
    }

    private String getNotRule(int i) {
        return "rule Rnot" + i + " when\n    String( this == \"" + i + "\" )\n    not Integer( this == " + i + " )then end\n";
    }

    @Test
    public void testChangePartitionOfAlphaSourceOfAlpha() {
        String drl = "import " + Account.class.getCanonicalName() + ";\nimport " + Customer.class.getCanonicalName() + ";\nrule \"customerDoesNotHaveSpecifiedAccount_2\"\nwhen\n    $account : Account (number == 1, uuid == \"customerDoesNotHaveSpecifiedAccount\")\n    Customer (uuid == \"customerDoesNotHaveSpecifiedAccount\")\nthen\nend\n\nrule \"customerDoesNotHaveSpecifiedAccount_1\"\nwhen\n    $account : Account (number == 2, uuid == \"customerDoesNotHaveSpecifiedAccount\")\n    Customer (uuid == \"customerDoesNotHaveSpecifiedAccount\")\nthen\nend";
        this.checkDrl(drl);
    }

    public static class Customer {
        private final String uuid;

        public Customer(String uuid) {
            this.uuid = uuid;
        }

        public String getUuid() {
            return this.uuid;
        }
    }

    public static class Account {
        private final int number;
        private final String uuid;
        private final Customer owner;

        public Account(int number, String uuid, Customer owner) {
            this.number = number;
            this.uuid = uuid;
            this.owner = owner;
        }

        public int getNumber() {
            return this.number;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Customer getOwner() {
            return this.owner;
        }
    }
}

