/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.security.Policy;
import java.util.Collection;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.ConsequenceException;
import org.kie.internal.io.ResourceFactory;
import org.mvel2.PropertyAccessException;

@Ignore(value="This test causes problems to surefire, so it will be disabled for now. It works when executed by itself.")
@RunWith(value=Parameterized.class)
public class SecurityPolicyTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SecurityPolicyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Before
    public void init() {
        String enginePolicy = SecurityPolicyTest.class.getResource("engine.policy").getFile();
        String kiePolicy = SecurityPolicyTest.class.getResource("rules.policy").getFile();
        System.setProperty("java.security.policy", enginePolicy);
        System.setProperty("kie.security.policy", kiePolicy);
        Policy.getPolicy().refresh();
        System.setSecurityManager(new TestSecurityManager());
    }

    @After
    public void close() {
        System.setSecurityManager(null);
        System.setProperty("java.security.policy", "");
        System.setProperty("kie.security.policy", "");
    }

    @Test
    public void testUntrustedJavaConsequence() {
        String drl = "package org.foo.bar\nrule R1 when\nthen\n    System.exit(0);end\n";
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            ksession.fireAllRules();
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (ShouldHavePrevented e) {
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (ConsequenceException consequenceException) {
            // empty catch block
        }
    }

    @Test
    public void testUntrustedMvelConsequence() {
        String drl = "package org.foo.bar\nrule R1 dialect \"mvel\" when\nthen\n    System.exit(0);end\n";
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            ksession.fireAllRules();
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (ShouldHavePrevented e) {
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (ConsequenceException consequenceException) {
            // empty catch block
        }
    }

    @Test
    public void testSerializationUntrustedMvelConsequence() {
        String drl = "package org.foo.bar\nrule R1 dialect \"mvel\" when\nthen\n    System.exit(0);end\n";
        try {
            KieServices ks = KieServices.Factory.get();
            KieFileSystem kfs = ks.newKieFileSystem().write(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setSourcePath("org/foo/bar/r1.drl"));
            ks.newKieBuilder(kfs).buildAll();
            ReleaseId releaseId = ks.getRepository().getDefaultReleaseId();
            KieContainer kc = ks.newKieContainer(releaseId);
            KieBase kbase = kc.getKieBase();
            kbase = SerializationHelper.serializeObject(kbase);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUntrustedJavaSalience() {
        String drl = "package org.foo.bar\nimport " + MaliciousExitHelper.class.getName().replace('$', '.') + " \nrule R1 dialect \"java\" salience( MaliciousExitHelper.exit() ) \nwhen\nthen\nend\n";
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            ksession.fireAllRules();
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (ShouldHavePrevented e) {
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUntrustedMVELSalience() {
        block2: {
            String drl = "package org.foo.bar\nimport " + MaliciousExitHelper.class.getName().replace('$', '.') + " \nrule R1 dialect \"mvel\" salience( MaliciousExitHelper.exit() ) \nwhen\nthen\nend\n";
            try {
                KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                KieSession ksession = kbase.newKieSession();
                ksession.fireAllRules();
                Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
            }
            catch (PropertyAccessException e) {
                if (!e.toString().contains("The security policy should have prevented")) break block2;
                Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
            }
        }
    }

    @Test
    public void testCustomAccumulate() {
        String drl = "package org.foo.bar\nrule testRule\n    when\n        Number() from accumulate(Object(),                init(System.exit(-1);),                action(System.exit(-1);),                reverse(System.exit(-1);),                result(0))\n    then\nend";
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            ksession.fireAllRules();
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (ShouldHavePrevented e) {
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCustomAccumulateMVEL() {
        block4: {
            String drl = "package org.foo.bar\nrule testRule dialect \"mvel\" \n    when\n        Number() from accumulate(Object(),                init(System.exit(-1);),                action(System.exit(-1);),                reverse(System.exit(-1);),                result(0))\n    then\nend";
            try {
                KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                KieSession ksession = kbase.newKieSession();
                ksession.fireAllRules();
                Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
            }
            catch (PropertyAccessException e) {
                if (e.toString().contains("The security policy should have prevented")) {
                    Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
                }
            }
            catch (Exception e) {
                if (e.toString().contains("access denied (\"java.lang.RuntimePermission\" \"exitVM.-1\")")) break block4;
                throw e;
            }
        }
    }

    @Test
    public void testAccumulateFunctionMVEL() {
        block4: {
            String drl = "package org.foo.bar\nimport " + MaliciousExitHelper.class.getName().replace('$', '.') + " \nrule testRule dialect \"mvel\" \n    when\n        Number() from accumulate(Object(),                sum(MaliciousExitHelper.exit()))\n    then\nend";
            try {
                KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                KieSession ksession = kbase.newKieSession();
                ksession.insert((Object)"foo");
                ksession.fireAllRules();
                Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
            }
            catch (PropertyAccessException e) {
                if (e.toString().contains("The security policy should have prevented")) {
                    Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
                }
            }
            catch (Exception e) {
                if (e.toString().contains("access denied (\"java.lang.RuntimePermission\" \"exitVM.0\")")) break block4;
                throw e;
            }
        }
    }

    @Test
    public void testAccumulateFunctionJava() {
        block4: {
            String drl = "package org.foo.bar\nimport " + MaliciousExitHelper.class.getName().replace('$', '.') + " \nrule testRule dialect \"java\" \n    when\n        Number() from accumulate(Object(),                sum(MaliciousExitHelper.exit()))\n    then\nend";
            try {
                KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                KieSession ksession = kbase.newKieSession();
                ksession.insert((Object)"foo");
                ksession.fireAllRules();
                Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
            }
            catch (PropertyAccessException e) {
                if (e.toString().contains("The security policy should have prevented")) {
                    Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
                }
            }
            catch (Exception e) {
                if (e.toString().contains("access denied (\"java.lang.RuntimePermission\" \"exitVM.0\")")) break block4;
                throw e;
            }
        }
    }

    @Test
    public void testUntrustedEnabled() {
        String drl = "package org.foo.bar\nimport " + MaliciousExitHelper.class.getName().replace('$', '.') + " \nrule R1 enabled( MaliciousExitHelper.isEnabled() ) \nwhen\nthen\nend\n";
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            ksession.fireAllRules();
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (ShouldHavePrevented e) {
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUntrustedMVELEnabled() {
        block2: {
            String drl = "package org.foo.bar\nimport " + MaliciousExitHelper.class.getName().replace('$', '.') + " \nrule R1 dialect \"mvel\" enabled( MaliciousExitHelper.isEnabled() ) \nwhen\nthen\nend\n";
            try {
                KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                KieSession ksession = kbase.newKieSession();
                ksession.fireAllRules();
                Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
            }
            catch (PropertyAccessException e) {
                if (!e.toString().contains("The security policy should have prevented")) break block2;
                Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
            }
        }
    }

    public static class ShouldHavePrevented
    extends SecurityException {
        public ShouldHavePrevented(String message) {
            super(message);
        }
    }

    public static class TestSecurityManager
    extends SecurityManager {
        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new ShouldHavePrevented("The security policy should have prevented the call to System.exit()");
        }
    }

    public static class MaliciousExitHelper {
        public static int exit() {
            System.exit(0);
            return 0;
        }

        public static boolean isEnabled() {
            System.exit(0);
            return true;
        }
    }
}

