/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentTest;
import org.drools.mvel.integrationtests.facts.BeanA;
import org.drools.mvel.integrationtests.facts.BeanB;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

@RunWith(value=Parameterized.class)
public class ConcurrentBasesParallelTest
extends AbstractConcurrentTest {
    private static final Integer NUMBER_OF_THREADS = 10;

    @Parameterized.Parameters(name="Enforced jitting={0}, KieBase type={1}")
    public static List<Object[]> getTestParameters() {
        List<Boolean[]> baseParams = Arrays.asList({false}, {true});
        Collection kbParams = TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Boolean[] baseParam : baseParams) {
            for (Object[] kbParam : kbParams) {
                if (baseParam[0].booleanValue() && ((KieBaseTestConfiguration)kbParam[0]).isExecutableModel()) continue;
                params.add(new Object[]{baseParam[0], kbParam[0]});
            }
        }
        return params;
    }

    public ConcurrentBasesParallelTest(boolean enforcedJitting, KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(enforcedJitting, false, false, false, kieBaseTestConfiguration);
    }

    @Test(timeout=40000L)
    public void testOneOfAllFactsMatches() throws InterruptedException {
        int numberOfObjects = 100;
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String rule = "import " + BeanA.class.getCanonicalName() + ";\nrule Rule_" + counter + " when     BeanA( seed == " + counter + ") then end";
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                for (int i = 0; i < 100; ++i) {
                    session.insert((Object)new BeanA(i));
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testNoFactMatches() throws InterruptedException {
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String rule = "import " + BeanA.class.getCanonicalName() + ";\nrule Rule_" + counter + " when     BeanA( seed == " + counter + ") then end";
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                for (int i = 0; i < NUMBER_OF_THREADS; ++i) {
                    if (i == counter) continue;
                    session.insert((Object)new BeanA(i));
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(0);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testFireAndGlobalSeparation() throws InterruptedException {
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String rule = "import " + BeanA.class.getCanonicalName() + ";\nglobal " + AtomicInteger.class.getCanonicalName() + " result;\nrule Rule_" + counter + " when     BeanA()then     result.set(" + counter + ");end";
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                session.insert((Object)new BeanA());
                AtomicInteger r = new AtomicInteger(0);
                session.setGlobal("result", (Object)r);
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                Assertions.assertThat((int)r.get()).isEqualTo(counter);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testFireAndGlobalSeparation2() throws InterruptedException {
        String ruleTemplate = "import " + BeanA.class.getCanonicalName() + ";\nimport " + BeanB.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule ${ruleName} when ${className}()then     list.add(\"${className}\");end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String className = counter % 2 == 0 ? "BeanA" : "BeanB";
            String ruleName = "Rule_" + className + "_" + counter;
            String rule = ruleTemplate.replace("${ruleName}", ruleName).replace("${className}", className);
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                session.insert((Object)new BeanA());
                session.insert((Object)new BeanB());
                ArrayList list = new ArrayList();
                session.setGlobal("list", list);
                int rulesFired = session.fireAllRules();
                Assertions.assertThat(list).hasSize(1);
                Assertions.assertThat((String)((String)list.get(0))).isEqualTo(className);
                Assertions.assertThat((int)rulesFired).isEqualTo(1);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testNonMatchingFact() throws InterruptedException {
        String ruleTemplate = "import " + BeanA.class.getCanonicalName() + ";\nimport " + BeanB.class.getCanonicalName() + ";\nrule ${ruleName} when ${className}()then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String className = counter % 2 == 0 ? "BeanA" : "BeanB";
            String ruleName = "Rule_" + className + "_" + counter;
            String rule = ruleTemplate.replace("${ruleName}", ruleName).replace("${className}", className);
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanB());
                } else {
                    session.insert((Object)new BeanA());
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(0);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testMatchingFact() throws InterruptedException {
        String ruleTemplate = "import " + BeanA.class.getCanonicalName() + ";\nimport " + BeanB.class.getCanonicalName() + ";\nrule ${ruleName} when ${className}()then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String className = counter % 2 == 0 ? "BeanA" : "BeanB";
            String ruleName = "Rule_" + className + "_" + counter;
            String rule = ruleTemplate.replace("${ruleName}", ruleName).replace("${className}", className);
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA());
                } else {
                    session.insert((Object)new BeanB());
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testNot() throws InterruptedException {
        String ruleTemplate = "import " + BeanA.class.getCanonicalName() + ";\nimport " + BeanB.class.getCanonicalName() + ";\nrule ${ruleName} when     not ${className}()then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String className = counter % 2 == 0 ? "BeanA" : "BeanB";
            String ruleName = "Rule_" + className + "_" + counter;
            String rule = ruleTemplate.replace("${ruleName}", ruleName).replace("${className}", className);
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA());
                } else {
                    session.insert((Object)new BeanB());
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(0);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testExists() throws InterruptedException {
        String ruleTemplate = "import " + BeanA.class.getCanonicalName() + ";\nimport " + BeanB.class.getCanonicalName() + ";\nrule ${ruleName} when     exists ${className}()then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String className = counter % 2 == 0 ? "BeanA" : "BeanB";
            String ruleName = "Rule_" + className + "_" + counter;
            String rule = ruleTemplate.replace("${ruleName}", ruleName).replace("${className}", className);
            KieBase base = this.getKieBase(rule);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA());
                } else {
                    session.insert((Object)new BeanB());
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testSubnetwork() throws InterruptedException {
        String ruleTemplate = "import " + BeanA.class.getCanonicalName() + ";\nimport " + BeanB.class.getCanonicalName() + ";\nrule ${ruleName} when     $bean : ${className}() \nthen end";
        String subnetworkRuleTemplate = "rule Rule_subnetwork when     $bean : ${className}() \n    Number( doubleValue > 0) from       accumulate ( BeanA() and $s : String(), count($s) )then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String className = counter % 2 == 0 ? "BeanA" : "BeanB";
            String ruleName = "Rule_" + className + "_" + counter;
            String rule = ruleTemplate.replace("${ruleName}", ruleName).replace("${className}", className);
            String subnetworkRule = "rule Rule_subnetwork when     $bean : ${className}() \n    Number( doubleValue > 0) from       accumulate ( BeanA() and $s : String(), count($s) )then end".replace("${className}", className);
            KieBase base = this.getKieBase(rule, subnetworkRule);
            KieSession session = base.newKieSession();
            try {
                session.insert((Object)"test");
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA());
                    Assertions.assertThat((int)session.fireAllRules()).isEqualTo(2);
                } else {
                    session.insert((Object)new BeanB());
                    Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testAccumulatesMatchOnlyBeanA() throws InterruptedException {
        String ruleA = "import " + BeanA.class.getCanonicalName() + ";\nrule RuleA when     $n : Number( doubleValue == 1 ) from accumulate($bean : BeanA(), count($bean)) then end";
        String ruleB = "import " + BeanB.class.getCanonicalName() + ";\nrule RuleB when     $n : Number( doubleValue == 1 ) from accumulate($bean : BeanB(), count($bean)) then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            KieBase base = this.getKieBase(ruleA, ruleB);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA(counter));
                    Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                } else {
                    Assertions.assertThat((int)session.fireAllRules()).isEqualTo(0);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testAccumulatesMatchBoth() throws InterruptedException {
        String ruleA = "import " + BeanA.class.getCanonicalName() + ";\nrule RuleA when     $n : Number( doubleValue == 1 ) from accumulate($bean : BeanA(), count($bean)) then end";
        String ruleB = "import " + BeanB.class.getCanonicalName() + ";\nrule RuleB when     $n : Number( doubleValue == 1 ) from accumulate($bean : BeanB(), count($bean)) then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            KieBase base = this.getKieBase(ruleA, ruleB);
            KieSession session = base.newKieSession();
            try {
                session.insert((Object)new BeanA());
                session.insert((Object)new BeanB());
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(2);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testAccumulatesMatchOnlyOne() throws InterruptedException {
        String ruleA = "import " + BeanA.class.getCanonicalName() + ";\nrule RuleA when     $n : Number( doubleValue == 1 ) from accumulate($bean : BeanA(), count($bean)) then end";
        String ruleB = "import " + BeanB.class.getCanonicalName() + ";\nrule RuleB when     $n : Number( doubleValue == 1 ) from accumulate($bean : BeanB(), count($bean)) then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            KieBase base = this.getKieBase(ruleA, ruleB);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA(counter));
                } else {
                    session.insert((Object)new BeanB(counter));
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testNotsMatchOnlyOne() throws InterruptedException {
        String ruleA = "import " + BeanA.class.getCanonicalName() + ";\nrule RuleNotA when     not BeanA() then end";
        String ruleB = "import " + BeanB.class.getCanonicalName() + ";\nrule RuleNotB when     not BeanB() then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            KieBase base = this.getKieBase(ruleA, ruleB);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA(counter));
                } else {
                    session.insert((Object)new BeanB(counter));
                }
                Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testNotsMatchBoth() throws InterruptedException {
        String ruleA = "import " + BeanA.class.getCanonicalName() + ";\nrule RuleNotA when     not BeanA() then end";
        String ruleB = "import " + BeanB.class.getCanonicalName() + ";\nrule RuleNotB when     not BeanB() then end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            KieBase base = this.getKieBase(ruleA, ruleB);
            KieSession session = base.newKieSession();
            try {
                if (counter % 2 == 0) {
                    session.insert((Object)new BeanA(counter));
                    session.insert((Object)new BeanB(counter));
                    Assertions.assertThat((int)session.fireAllRules()).isEqualTo(0);
                } else {
                    Assertions.assertThat((int)session.fireAllRules()).isEqualTo(2);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testFunctions() throws InterruptedException {
        String rule = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;rule Rule when     BeanA() then     addToList(list);end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String function = "import java.util.List;\nfunction void addToList(List list) { \n    list.add( \"" + counter + "\" );\n}\n";
            KieBase base = this.getKieBase(rule, function);
            KieSession session = base.newKieSession();
            try {
                session.insert((Object)new BeanA());
                ArrayList list = new ArrayList();
                session.setGlobal("list", list);
                int rulesFired = session.fireAllRules();
                Assertions.assertThat(list).hasSize(1);
                Assertions.assertThat((String)((String)list.get(0))).isEqualTo("" + counter);
                Assertions.assertThat((int)rulesFired).isEqualTo(1);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testFunctions2() throws InterruptedException {
        int objectCount = 100;
        String rule = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;rule Rule when     BeanA() then     addToList(list);end";
        String functionTemplate = "import java.util.List;\nfunction void addToList(List list) { \n    list.add( \"${identifier}\" );\n}\n";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String identifier = counter % 2 == 0 ? "even" : "odd";
            String otherIdentifier = counter % 2 == 0 ? "odd" : "even";
            String functionRule = "import java.util.List;\nfunction void addToList(List list) { \n    list.add( \"${identifier}\" );\n}\n".replace("${identifier}", identifier);
            KieBase base = this.getKieBase(rule, functionRule);
            KieSession session = base.newKieSession();
            try {
                ArrayList list = new ArrayList();
                session.setGlobal("list", list);
                int rulesFired = 0;
                for (int i = 0; i < 100; ++i) {
                    session.insert((Object)new BeanA(i));
                    rulesFired += session.fireAllRules();
                }
                Assertions.assertThat(list).hasSize(100);
                Assertions.assertThat(list).contains((Object[])new String[]{identifier});
                Assertions.assertThat(list).doesNotContain((Object[])new String[]{otherIdentifier});
                Assertions.assertThat((int)rulesFired).isEqualTo(100);
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testQueries() throws InterruptedException {
        int numberOfObjects = 100;
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            String query = "import " + BeanA.class.getCanonicalName() + ";\nquery Query     bean : BeanA( seed == " + counter + " ) end";
            KieBase base = this.getKieBase(query);
            KieSession session = base.newKieSession();
            try {
                BeanA bean = new BeanA(counter);
                session.insert((Object)bean);
                for (int i = 0; i < 100; ++i) {
                    if (i == counter) continue;
                    session.insert((Object)new BeanA(i));
                }
                QueryResults results = session.getQueryResults("Query", new Object[0]);
                Assertions.assertThat((Iterable)results).hasSize(1);
                for (QueryResultsRow row : results) {
                    Assertions.assertThat((Object)row.get("bean")).isEqualTo((Object)bean);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }

    @Test(timeout=40000L)
    public void testQueries2() throws InterruptedException {
        int numberOfObjects = 100;
        String queryTemplate = "import " + BeanA.class.getCanonicalName() + ";\nquery Query     bean : BeanA( seed == ${seed} ) end";
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            int seed = counter % 2;
            String seedString = "" + seed;
            String queryDrl = queryTemplate.replace("${seed}", seedString);
            KieBase base = this.getKieBase(queryDrl);
            KieSession session = base.newKieSession();
            try {
                for (int i = 0; i < 100; ++i) {
                    session.insert((Object)new BeanA(seed));
                }
                QueryResults results = session.getQueryResults("Query", new Object[0]);
                Assertions.assertThat((Iterable)results).hasSize(100);
                for (QueryResultsRow row : results) {
                    BeanA bean = (BeanA)row.get("bean");
                    Assertions.assertThat((int)bean.getSeed()).isEqualTo(seed);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                session.dispose();
            }
        };
        this.parallelTest(NUMBER_OF_THREADS, exec);
    }
}

