/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteevaluator;

import java.util.List;
import java.util.UUID;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleUnitExecutorImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.ExecutableModelProject;
import org.drools.mvel.compiler.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;

public class ReteEvaluatorTest {
    @Test
    public void testPropertyReactivity() {
        String str = "import " + Person.class.getCanonicalName() + ";rule R when\n  $s : String()\n  $p : Person(name == $s)\nthen\n  modify($p) { setAge($p.getAge()+1) }\nend";
        RuleUnitExecutorImpl reteEvaluator = new RuleUnitExecutorImpl((RuleBase)this.getKBase(str));
        Person me = new Person("Mario", 40);
        reteEvaluator.insert((Object)"Mario");
        reteEvaluator.insert((Object)me);
        Assert.assertEquals((long)1L, (long)reteEvaluator.fireAllRules());
        Assert.assertEquals((long)41L, (long)me.getAge());
    }

    private InternalKnowledgeBase getKBase(String ... stringRules) {
        KieServices ks = KieServices.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "kjar-test-" + UUID.randomUUID(), "1.0");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writePomXML(ReteEvaluatorTest.getPom(releaseId));
        for (int i = 0; i < stringRules.length; ++i) {
            kfs.write(String.format("src/main/resources/r%d.drl", i), stringRules[i]);
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(ExecutableModelProject.class);
        List messages = kieBuilder.getResults().getMessages();
        if (!messages.isEmpty()) {
            Assert.fail((String)messages.toString());
        }
        return (InternalKnowledgeBase)ks.newKieContainer(releaseId).getKieBase();
    }

    private static String getPom(ReleaseId releaseId) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n</project>";
        return pom;
    }
}

