/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Serializable;
import org.drools.core.base.ClassObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PatternExtractor;
import org.drools.model.Index;
import org.drools.model.SingleConstraint;
import org.drools.model.Variable;
import org.drools.model.constraints.SingleConstraint1;
import org.drools.model.constraints.SingleConstraint2;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.impl.DeclarationImpl;
import org.drools.model.index.AlphaIndexImpl;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.modelcompiler.util.EvaluationUtil;
import org.drools.mvel.model.Cheese;

public class LambdaConstraintTestUtil {
    private LambdaConstraintTestUtil() {
    }

    public static <T> LambdaConstraint createLambdaConstraint1(Class<T> patternClass, Predicate1<T> predicate) {
        return LambdaConstraintTestUtil.createLambdaConstraint1(patternClass, null, predicate, null);
    }

    public static <T> LambdaConstraint createLambdaConstraint1(Class<T> patternClass, Pattern pattern, Predicate1<T> predicate, Index<T, ?> index) {
        String patternName = "GENERATED_$pattern_" + patternClass.getSimpleName();
        DeclarationImpl decl = new DeclarationImpl(patternClass, patternName);
        SingleConstraint1 singleConstraint = new SingleConstraint1((Variable)decl, predicate);
        singleConstraint.setIndex(index);
        Declaration coreDecl = new Declaration(patternName, null, pattern, false);
        ConstraintEvaluator constraintEvaluator = new ConstraintEvaluator(new Declaration[]{coreDecl}, (SingleConstraint)singleConstraint);
        return new LambdaConstraint(constraintEvaluator);
    }

    public static <T, A, B> LambdaConstraint createLambdaConstraint2(Class<A> patternClass, Class<B> rightClass, Pattern pattern, Pattern varPattern, String varName, Predicate2<A, B> predicate, Index<T, ?> index) {
        String patternName = "GENERATED_$pattern_" + patternClass.getSimpleName();
        DeclarationImpl declA = new DeclarationImpl(patternClass, patternName);
        DeclarationImpl declB = new DeclarationImpl(rightClass, varName);
        SingleConstraint2 singleConstraint = new SingleConstraint2((Variable)declA, (Variable)declB, predicate);
        singleConstraint.setIndex(index);
        Declaration patternDecl = new Declaration(patternName, (InternalReadAccessor)new PatternExtractor((ObjectType)new ClassObjectType(patternClass, false)), pattern, false);
        Declaration varDecl = new Declaration(varName, (InternalReadAccessor)new PatternExtractor((ObjectType)new ClassObjectType(rightClass, false)), varPattern, false);
        ConstraintEvaluator constraintEvaluator = new ConstraintEvaluator(new Declaration[]{patternDecl, varDecl}, (SingleConstraint)singleConstraint);
        return new LambdaConstraint(constraintEvaluator);
    }

    public static LambdaConstraint createCheeseTypeEqualsConstraint(String rightValue, int indexId) {
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Predicate1.Impl predicate = new Predicate1.Impl((Predicate1 & Serializable)_this -> EvaluationUtil.areNullSafeEquals((Object)_this.getType(), (Object)rightValue));
        AlphaIndexImpl index = new AlphaIndexImpl(String.class, Index.ConstraintType.EQUAL, indexId, (Function1 & Serializable)_this -> _this.getType(), (Object)rightValue);
        return LambdaConstraintTestUtil.createLambdaConstraint1(Cheese.class, pattern, predicate, index);
    }

    public static LambdaConstraint createCheesePriceEqualsConstraint(int rightValue, int indexId) {
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Predicate1.Impl predicate = new Predicate1.Impl((Predicate1 & Serializable)_this -> EvaluationUtil.areNullSafeEquals((Object)_this.getPrice(), (Object)rightValue));
        AlphaIndexImpl index = new AlphaIndexImpl(Integer.class, Index.ConstraintType.EQUAL, indexId, (Function1 & Serializable)_this -> _this.getPrice(), (Object)rightValue);
        return LambdaConstraintTestUtil.createLambdaConstraint1(Cheese.class, pattern, predicate, index);
    }

    public static LambdaConstraint createCheesePriceGreaterConstraint(int rightValue, int indexId) {
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Predicate1.Impl predicate = new Predicate1.Impl((Predicate1 & Serializable)_this -> EvaluationUtil.greaterThan((Comparable)Integer.valueOf(_this.getPrice()), (Comparable)Integer.valueOf(rightValue)));
        AlphaIndexImpl index = new AlphaIndexImpl(Integer.class, Index.ConstraintType.GREATER_THAN, indexId, (Function1 & Serializable)_this -> _this.getPrice(), (Object)rightValue);
        return LambdaConstraintTestUtil.createLambdaConstraint1(Cheese.class, pattern, predicate, index);
    }

    public static LambdaConstraint createCheeseCharTypeEqualsConstraint(char rightValue, int indexId) {
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Predicate1.Impl predicate = new Predicate1.Impl((Predicate1 & Serializable)_this -> EvaluationUtil.areNullSafeEquals((Object)Character.valueOf(_this.getCharType()), (Object)Character.valueOf(rightValue)));
        AlphaIndexImpl index = new AlphaIndexImpl(Character.class, Index.ConstraintType.EQUAL, indexId, (Function1 & Serializable)_this -> Character.valueOf(_this.getCharType()), (Object)Character.valueOf(rightValue));
        return LambdaConstraintTestUtil.createLambdaConstraint1(Cheese.class, pattern, predicate, index);
    }

    public static LambdaConstraint createCheeseCharObjectTypeEqualsConstraint(char rightValue, int indexId) {
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Predicate1.Impl predicate = new Predicate1.Impl((Predicate1 & Serializable)_this -> EvaluationUtil.areNullSafeEquals((Object)_this.getCharObjectType(), (Object)Character.valueOf(rightValue)));
        AlphaIndexImpl index = new AlphaIndexImpl(Character.class, Index.ConstraintType.EQUAL, indexId, (Function1 & Serializable)_this -> _this.getCharObjectType(), (Object)Character.valueOf(rightValue));
        return LambdaConstraintTestUtil.createLambdaConstraint1(Cheese.class, pattern, predicate, index);
    }
}

