/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import org.drools.drl.ast.descr.AccessorDescr;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AccumulateImportDescr;
import org.drools.drl.ast.descr.ActionDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.drl.ast.descr.AtomicExprDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BehaviorDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.CollectDescr;
import org.drools.drl.ast.descr.ConstraintConnectiveDescr;
import org.drools.drl.ast.descr.DeclarativeInvokerDescr;
import org.drools.drl.ast.descr.EntryPointDeclarationDescr;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.EvalDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.FactTemplateDescr;
import org.drools.drl.ast.descr.FieldConstraintDescr;
import org.drools.drl.ast.descr.FieldTemplateDescr;
import org.drools.drl.ast.descr.ForallDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.LiteralRestrictionDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.NamedConsequenceDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.OrDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.PredicateDescr;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.RelationalExprDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.drools.drl.ast.descr.WindowDeclarationDescr;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageDescrResourceVisitor {
    private static final Logger logger = LoggerFactory.getLogger(PackageDescrResourceVisitor.class);

    private static void checkResource(BaseDescr descr) {
        if (descr != null) {
            Assert.assertNotNull((String)(descr.getClass().getSimpleName() + ".resource is null!"), (Object)descr.getResource());
        }
    }

    private void visit(Object descr) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String lastMethodName = null;
        for (int i = 0; i < 5; ++i) {
            String thisMethodName = stack[i].getMethodName() + ":" + stack[i].getLineNumber();
            if (thisMethodName.equals(lastMethodName)) {
                Assert.fail((String)"Infinite loop detected!");
            }
            lastMethodName = thisMethodName;
        }
        if (descr instanceof AccessorDescr) {
            this.visit((AccessorDescr)descr);
        } else if (descr instanceof AccumulateDescr) {
            this.visit((AccumulateDescr)descr);
        } else if (descr instanceof ActionDescr) {
            this.visit((ActionDescr)descr);
        } else if (descr instanceof AndDescr) {
            this.visit((AndDescr)descr);
        } else if (descr instanceof AnnotationDescr) {
            this.visit((AnnotatedBaseDescr)((AnnotationDescr)descr));
        } else if (descr instanceof AtomicExprDescr) {
            this.visit((AtomicExprDescr)descr);
        } else if (descr instanceof AttributeDescr) {
            this.visit((AttributeDescr)descr);
        } else if (descr instanceof BindingDescr) {
            this.visit((BindingDescr)descr);
        } else if (descr instanceof CollectDescr) {
            this.visit((CollectDescr)descr);
        } else if (descr instanceof ConstraintConnectiveDescr) {
            this.visit((ConstraintConnectiveDescr)descr);
        } else if (descr instanceof ExistsDescr) {
            this.visit((ExistsDescr)descr);
        } else if (descr instanceof ExprConstraintDescr) {
            this.visit((ExprConstraintDescr)descr);
        } else if (descr instanceof FactTemplateDescr) {
            this.visit((FactTemplateDescr)descr);
        } else if (descr instanceof FieldConstraintDescr) {
            this.visit((FieldConstraintDescr)descr);
        } else if (descr instanceof FieldTemplateDescr) {
            this.visit((FieldTemplateDescr)descr);
        } else if (descr instanceof ForallDescr) {
            this.visit((ForallDescr)descr);
        } else if (descr instanceof FromDescr) {
            this.visit((FromDescr)descr);
        } else if (descr instanceof FunctionDescr) {
            this.visit((FunctionDescr)descr);
        } else if (descr instanceof FunctionImportDescr) {
            this.visit((FunctionImportDescr)descr);
        } else if (descr instanceof GlobalDescr) {
            this.visit((GlobalDescr)descr);
        } else if (descr instanceof ImportDescr) {
            this.visit((ImportDescr)descr);
        } else if (descr instanceof LiteralRestrictionDescr) {
            this.visit((LiteralRestrictionDescr)descr);
        } else if (descr instanceof MVELExprDescr) {
            this.visit((MVELExprDescr)descr);
        } else if (descr instanceof NotDescr) {
            this.visit((NotDescr)descr);
        } else if (descr instanceof OrDescr) {
            this.visit((OrDescr)descr);
        } else if (descr instanceof PackageDescr) {
            this.visit((PackageDescr)descr);
        } else if (descr instanceof PatternDescr) {
            this.visit((PatternDescr)descr);
        } else if (descr instanceof PredicateDescr) {
            this.visit((PredicateDescr)descr);
        } else if (descr instanceof QueryDescr) {
            this.visit((QueryDescr)descr);
        } else if (descr instanceof RelationalExprDescr) {
            this.visit((RelationalExprDescr)descr);
        } else if (descr instanceof RuleDescr) {
            this.visit((RuleDescr)descr);
        } else if (descr instanceof TypeDeclarationDescr) {
            this.visit((TypeDeclarationDescr)descr);
        } else if (descr instanceof TypeFieldDescr) {
            this.visit((TypeFieldDescr)descr);
        } else if (descr instanceof WindowDeclarationDescr) {
            this.visit((WindowDeclarationDescr)descr);
        } else if (descr instanceof NamedConsequenceDescr) {
            this.visit((NamedConsequenceDescr)descr);
        } else if (descr instanceof EvalDescr) {
            this.visit((EvalDescr)descr);
        } else if (descr instanceof BehaviorDescr) {
            this.visit((BehaviorDescr)descr);
        } else {
            throw new RuntimeException("xx DID NOT VISIT: " + descr.getClass().getName());
        }
    }

    protected void visit(AccessorDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (DeclarativeInvokerDescr d : descr.getInvokersAsArray()) {
            this.visit(d);
        }
    }

    protected void visit(AccumulateDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getInputPattern());
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(ActionDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(AndDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (BaseDescr baseDescr : descr.getDescrs()) {
            this.visit(baseDescr);
        }
    }

    protected void visit(AnnotatedBaseDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (BaseDescr annoDescr : descr.getAnnotations()) {
            this.visit(annoDescr);
        }
    }

    protected void visit(AtomicExprDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(AttributeDescr descr) {
    }

    protected void visit(BindingDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(CollectDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getInputPattern());
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(ConstraintConnectiveDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(ExistsDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (Object o : descr.getDescrs()) {
            this.visit(o);
        }
    }

    protected void visit(ExprConstraintDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(FactTemplateDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (FieldTemplateDescr d : descr.getFields()) {
            this.visit(d);
        }
    }

    protected void visit(FieldConstraintDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (Object o : descr.getRestrictions()) {
            this.visit(o);
        }
    }

    protected void visit(FieldTemplateDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(ForallDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getBasePattern());
        for (BaseDescr o : descr.getDescrs()) {
            this.visit(o);
        }
    }

    protected void visit(FromDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(FunctionDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(FunctionImportDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(GlobalDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(ImportDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(LiteralRestrictionDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(MVELExprDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(NotDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (Object o : descr.getDescrs()) {
            this.visit(o);
        }
    }

    protected void visit(OrDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(PackageDescr descr) {
        if (descr == null) {
            return;
        }
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (ImportDescr importDescr : descr.getImports()) {
            this.visit(importDescr);
        }
        for (FunctionImportDescr funcImportDescr : descr.getFunctionImports()) {
            this.visit(funcImportDescr);
        }
        for (AccumulateImportDescr accImportDescr : descr.getAccumulateImports()) {
            this.visit((ImportDescr)accImportDescr);
        }
        for (AttributeDescr attrDescr : descr.getAttributes()) {
            this.visit(attrDescr);
        }
        for (GlobalDescr globDesc : descr.getGlobals()) {
            this.visit(globDesc);
        }
        for (FunctionDescr funcDescr : descr.getFunctions()) {
            this.visit(funcDescr);
        }
        for (RuleDescr ruleDescr : descr.getRules()) {
            this.visit(ruleDescr);
        }
        for (TypeDeclarationDescr typeDescr : descr.getTypeDeclarations()) {
            this.visit(typeDescr);
        }
        for (EntryPointDeclarationDescr entryDescr : descr.getEntryPointDeclarations()) {
            this.visit((AnnotatedBaseDescr)entryDescr);
        }
        for (WindowDeclarationDescr windowDescr : descr.getWindowDeclarations()) {
            this.visit(windowDescr);
        }
        for (EnumDeclarationDescr enumDescr : descr.getEnumDeclarations()) {
            this.visit((AnnotatedBaseDescr)enumDescr);
        }
    }

    protected void visit(PatternDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getConstraint());
        for (BaseDescr behaDescr : descr.getBehaviors()) {
            this.visit(behaDescr);
        }
    }

    protected void visit(PredicateDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(QueryDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getLhs());
        for (AttributeDescr attrDescr : descr.getAttributes().values()) {
            this.visit(attrDescr);
        }
    }

    protected void visit(RelationalExprDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getLeft());
        this.visit(descr.getRight());
    }

    protected void visit(RuleDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (AttributeDescr d : descr.getAttributes().values()) {
            this.visit(d);
        }
        this.visit(descr.getLhs());
        this.visitConsequence(descr.getConsequence());
        for (Object o : descr.getNamedConsequences().values()) {
            this.visitConsequence(o);
        }
    }

    protected void visitConsequence(Object consequence) {
        if (consequence instanceof BaseDescr) {
            this.visit(consequence);
        }
    }

    protected void visit(TypeDeclarationDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        for (TypeFieldDescr fieldDescr : descr.getFields().values()) {
            this.visit(fieldDescr);
        }
    }

    protected void visit(TypeFieldDescr descr) {
        if (descr == null) {
            return;
        }
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getOverriding());
    }

    protected void visit(WindowDeclarationDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
        this.visit(descr.getPattern());
    }

    protected void visit(NamedConsequenceDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(EvalDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }

    protected void visit(BehaviorDescr descr) {
        PackageDescrResourceVisitor.checkResource((BaseDescr)descr);
    }
}

