/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import junit.framework.TestCase;
import org.drools.compiler.builder.impl.EvaluatorRegistry;
import org.drools.drl.ast.descr.AtomicExprDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.ConnectiveType;
import org.drools.drl.ast.descr.ConstraintConnectiveDescr;
import org.drools.drl.ast.descr.RelationalExprDescr;
import org.drools.drl.parser.DrlExprParser;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRLExprParserTest
extends TestCase {
    DrlExprParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        new EvaluatorRegistry();
        this.parser = new DrlExprParser(LanguageLevelOption.DRL6);
    }

    protected void tearDown() throws Exception {
        this.parser = null;
        super.tearDown();
    }

    @Test
    public void testSimpleExpression() throws Exception {
        String source = "a > b";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)1, (int)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)">", (String)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"a", (String)left.getExpression());
        DRLExprParserTest.assertEquals((String)"b", (String)right.getExpression());
    }

    @Test
    public void testAndConnective() throws Exception {
        String source = "a > b && 10 != 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)2, (int)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)">", (String)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"a", (String)left.getExpression());
        DRLExprParserTest.assertEquals((String)"b", (String)right.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        DRLExprParserTest.assertEquals((String)"!=", (String)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"10", (String)left.getExpression());
        DRLExprParserTest.assertEquals((String)"20", (String)right.getExpression());
    }

    @Test
    public void testConnective2() throws Exception {
        String source = "(a > b || 10 != 20) && someMethod(10) == 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)2, (int)result.getDescrs().size());
        ConstraintConnectiveDescr or = (ConstraintConnectiveDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((Object)ConnectiveType.OR, (Object)or.getConnective());
        DRLExprParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)or.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)">", (String)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"a", (String)left.getExpression());
        DRLExprParserTest.assertEquals((String)"b", (String)right.getExpression());
        expr = (RelationalExprDescr)or.getDescrs().get(1);
        DRLExprParserTest.assertEquals((String)"!=", (String)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"10", (String)left.getExpression());
        DRLExprParserTest.assertEquals((String)"20", (String)right.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        DRLExprParserTest.assertEquals((String)"==", (String)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"someMethod(10)", (String)left.getExpression());
        DRLExprParserTest.assertEquals((String)"20", (String)right.getExpression());
    }

    @Test
    public void testBinding() throws Exception {
        String source = "$x : property";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)1, (int)result.getDescrs().size());
        BindingDescr bind = (BindingDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)"$x", (String)bind.getVariable());
        DRLExprParserTest.assertEquals((String)"property", (String)bind.getExpression());
    }

    @Test
    public void testBindingConstraint() throws Exception {
        String source = "$x : property > value";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)1, (int)result.getDescrs().size());
        RelationalExprDescr rel = (RelationalExprDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)">", (String)rel.getOperator());
        BindingDescr bind = (BindingDescr)rel.getLeft();
        DRLExprParserTest.assertEquals((String)"$x", (String)bind.getVariable());
        DRLExprParserTest.assertEquals((String)"property", (String)bind.getExpression());
        AtomicExprDescr right = (AtomicExprDescr)rel.getRight();
        DRLExprParserTest.assertEquals((String)"value", (String)right.getExpression());
    }

    @Test
    public void testBindingWithRestrictions() throws Exception {
        String source = "$x : property > value && < 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)2, (int)result.getDescrs().size());
        RelationalExprDescr rel = (RelationalExprDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)">", (String)rel.getOperator());
        BindingDescr bind = (BindingDescr)rel.getLeft();
        DRLExprParserTest.assertEquals((String)"$x", (String)bind.getVariable());
        DRLExprParserTest.assertEquals((String)"property", (String)bind.getExpression());
        AtomicExprDescr right = (AtomicExprDescr)rel.getRight();
        DRLExprParserTest.assertEquals((String)"value", (String)right.getExpression());
        rel = (RelationalExprDescr)result.getDescrs().get(1);
        DRLExprParserTest.assertEquals((String)"<", (String)rel.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)rel.getLeft();
        DRLExprParserTest.assertEquals((String)"property", (String)left.getExpression());
        right = (AtomicExprDescr)rel.getRight();
        DRLExprParserTest.assertEquals((String)"20", (String)right.getExpression());
    }

    @Test
    public void testDoubleBinding() throws Exception {
        String source = "$x : x.m( 1, a ) && $y : y[z].foo";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)2, (int)result.getDescrs().size());
        BindingDescr bind = (BindingDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)"$x", (String)bind.getVariable());
        DRLExprParserTest.assertEquals((String)"x.m( 1, a )", (String)bind.getExpression());
        bind = (BindingDescr)result.getDescrs().get(1);
        DRLExprParserTest.assertEquals((String)"$y", (String)bind.getVariable());
        DRLExprParserTest.assertEquals((String)"y[z].foo", (String)bind.getExpression());
    }

    @Test
    public void testDeepBinding() throws Exception {
        String source = "($a : a > $b : b[10].prop || 10 != 20) && $x : someMethod(10) == 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)2, (int)result.getDescrs().size());
        ConstraintConnectiveDescr or = (ConstraintConnectiveDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((Object)ConnectiveType.OR, (Object)or.getConnective());
        DRLExprParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)or.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)">", (String)expr.getOperator());
        BindingDescr leftBind = (BindingDescr)expr.getLeft();
        BindingDescr rightBind = (BindingDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"$a", (String)leftBind.getVariable());
        DRLExprParserTest.assertEquals((String)"a", (String)leftBind.getExpression());
        DRLExprParserTest.assertEquals((String)"$b", (String)rightBind.getVariable());
        DRLExprParserTest.assertEquals((String)"b[10].prop", (String)rightBind.getExpression());
        expr = (RelationalExprDescr)or.getDescrs().get(1);
        DRLExprParserTest.assertEquals((String)"!=", (String)expr.getOperator());
        AtomicExprDescr leftExpr = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr rightExpr = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"10", (String)leftExpr.getExpression());
        DRLExprParserTest.assertEquals((String)"20", (String)rightExpr.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        DRLExprParserTest.assertEquals((String)"==", (String)expr.getOperator());
        leftBind = (BindingDescr)expr.getLeft();
        rightExpr = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"$x", (String)leftBind.getVariable());
        DRLExprParserTest.assertEquals((String)"someMethod(10)", (String)leftBind.getExpression());
        DRLExprParserTest.assertEquals((String)"20", (String)rightExpr.getExpression());
    }

    @Test(timeout=10000L)
    public void testNestedExpression() throws Exception {
        String source = "(((((((((((((((((((((((((((((((((((((((((((((((((( a > b ))))))))))))))))))))))))))))))))))))))))))))))))))";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprParserTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprParserTest.assertEquals((int)1, (int)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        DRLExprParserTest.assertEquals((String)">", (String)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        DRLExprParserTest.assertEquals((String)"a", (String)left.getExpression());
        DRLExprParserTest.assertEquals((String)"b", (String)right.getExpression());
    }
}

